/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin.operation;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.CEProjectModel;
import com.avaya.eclipse.plugin.CEProjectUtils;
import com.avaya.eclipse.plugin.model.ElementInfo;
import com.avaya.eclipse.plugin.operation.CEOperation;
import com.avaya.eclipse.plugin.util.SelectedProjectFinder;
import com.avaya.ssh.SSHConnection;
import com.avaya.ssh.SSHConnectionGroup;
import com.avaya.ssh.SSHConnector;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CEWatchServiceLogOperation
extends CEOperation {
    private boolean isServiceSpecific;

    public CEWatchServiceLogOperation(IProject project) {
        this.project = project;
    }

    public CEWatchServiceLogOperation() {
        this(null);
    }

    public CEWatchServiceLogOperation(boolean b) {
        this.isServiceSpecific = b;
    }

    @Override
    public IStatus execute(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        CEProjectModel ceModelP = null;
        if (this.project != null) {
            ceModelP = CEProjectUtils.evaluateAsCEProject(this.project.getLocation().toFile());
        } else {
            ceModelP = new CEProjectModel();
            CEProjectUtils.setAssociatedElements(ceModelP);
        }
        if (this.isServiceSpecific) {
            this.setMessageConsoleStream("ServiceLogs");
            this.startOperation(ceModelP);
        } else {
            this.setMessageConsoleStream();
            this.startOperationLoggingAll(ceModelP);
        }
        return status;
    }

    public void startOperation(CEProjectModel cep) {
        try {
            List<ElementInfo> smgrList = cep.getAssociatedElements();
            if (smgrList != null && smgrList.size() == 0) {
                CEOperation.openErrorDialog("Log Watch Selected Service Operation Failure", "Please select at least one Avaya Breeze\u00ae node to proceed with Avaya Breeze\u00ae Eclipse plug-in action.");
                return;
            }
            if (smgrList != null && smgrList.size() > 0) {
                for (ElementInfo elem : smgrList) {
                    SSHConnection sshc = SSHConnector.getInstance().getSSHConnection(elem);
                    String services = sshc.execute("sudo /opt/Avaya/AUS/install/service_util.sh -p");
                    String[] servDetails = SelectedProjectFinder.getServiceStatus(services, cep);
                    if (servDetails == null) continue;
                    SSHConnectionGroup sshce = new SSHConnectionGroup(elem.getAssociatedElements());
                    sshce.startUpdating(this);
                    sshce.executeAsync("ce dlogw " + cep.getServiceName());
                }
            }
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error watching service logs", e);
            CEOperation.openDialog("Watch Service Log Execution Failure", e.getMessage());
        }
    }

    public void startOperationLoggingAll(CEProjectModel cep) {
        try {
            List<ElementInfo> smgrList = cep.getAssociatedElements();
            if (smgrList != null && smgrList.size() == 0) {
                CEOperation.openErrorDialog("Log Watch All Operation Failure", "Please select at least one Avaya Breeze\u00ae node to proceed with Avaya Breeze\u00ae Eclipse plug-in action.");
                return;
            }
            if (smgrList != null && smgrList.size() > 0) {
                for (ElementInfo elem : smgrList) {
                    SSHConnectionGroup sshcg = new SSHConnectionGroup(elem.getAssociatedElements());
                    sshcg.startUpdating(this);
                    sshcg.executeAsync("ce dlogw");
                }
            }
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error watching log", e);
            CEOperation.openDialog("Watch Log Execution Failure", e.getMessage());
        }
    }
}

