/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin.util;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.PropertyWindowEditor;
import com.avaya.eclipse.plugin.operation.CEOperation;
import com.avaya.eclipse.plugin.util.CEPluginHelper;
import com.avaya.ssh.MavenCommandline;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class CEMavenOperations {
    public static final String MAVEN_INSTALL = "install";
    public static final String MAVEN_CLEAN = "clean";
    public static final String MAVEN_PACKAGE = "package";
    private static String mavenHome = "c:/apache-maven-3.0.4/";
    private static CEMavenOperations instance = null;
    private static StringBuffer tempLogBuffer = new StringBuffer();
    private static char lastChar;

    public static CEMavenOperations getInstance() {
        if (instance == null) {
            instance = new CEMavenOperations();
        }
        return instance;
    }

    public static void setInstance(CEMavenOperations instance) {
        CEMavenOperations.instance = instance;
    }

    CEMavenOperations() {
    }

    public int mpackage(String pathtoPomXmlFile, PrintWriter pr) {
        return this.mavenAction(pathtoPomXmlFile, MAVEN_PACKAGE, pr, false);
    }

    public int clean(String pathtoPomXmlFile, PrintWriter pr) {
        return this.mavenAction(pathtoPomXmlFile, MAVEN_CLEAN, pr, false);
    }

    public int install(String pathtoPomXmlFile, PrintWriter pr) {
        return this.mavenAction(pathtoPomXmlFile, MAVEN_INSTALL, pr, false);
    }

    public int mavenAction(String pathtoPomXmlFile, String action, PrintWriter writer, boolean isMavenCli) {
        if (isMavenCli) {
            writer.println("Embedded maven...");
            return this.mavenAction(pathtoPomXmlFile, action, writer, null);
        }
        writer.println("External maven...");
        if (action != null) {
            action = action.replace(",", " ");
        }
        return this.oldMavenAction(pathtoPomXmlFile, action, writer, null);
    }

    public int version(String pathtoPomXmlFile, String action, PrintWriter writer, boolean isMavenCli, CEPluginHelper mvnHelper) {
        int i = -1;
        i = isMavenCli ? this.mavenAction(pathtoPomXmlFile, action, writer, mvnHelper) : this.oldMavenAction(pathtoPomXmlFile, action, writer, mvnHelper);
        return i;
    }

    public int mavenAction(String pathtoPomXmlFile, String action, PrintWriter pr, CEPluginHelper mvnHelper) {
        try {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.m2e.maven.runtime");
            Path path = new Path("jars/");
            File baseFolder = new File(ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toString());
            MavenCommandline mc = new MavenCommandline(new File(FileLocator.toFileURL((URL)FileLocator.find((Bundle)bundle, (IPath)path, null)).toURI()).getAbsolutePath(), baseFolder.getAbsolutePath());
            return mc.mvn(new File(pathtoPomXmlFile).getParent(), action, pr, mvnHelper);
        }
        catch (Exception e) {
            try {
                Activator.log(4, 0, "Error getting maven action", e);
            }
            catch (Exception e2) {
                Activator.log(4, 0, "Error in maven action", e2);
            }
            return -1;
        }
    }

    private int oldMavenAction(String pathtoPomXmlFile, String action, PrintWriter pr, CEPluginHelper mvnHelper) {
        mavenHome = PropertyWindowEditor.getMavenHome();
        String command = null;
        String mvncmd = "/bin/mvn";
        StringBuffer sb = new StringBuffer("\"");
        sb.append(mavenHome);
        sb.append(mvncmd);
        sb.append("\"");
        command = sb.toString();
        try {
            Process p = CEMavenOperations.isWindows() ? (System.getenv("JAVA_HOME") != null ? Runtime.getRuntime().exec(new String[]{"cmd.exe", "/C", command + " -f " + pathtoPomXmlFile + "  " + action}) : Runtime.getRuntime().exec(new String[]{"cmd.exe", "/C", command + " -f " + pathtoPomXmlFile + "  " + action}, new String[]{"JAVA_HOME=" + PropertyWindowEditor.getServerConfProperties().getProperty("JAVA_HOME"), "M2_HOME=" + PropertyWindowEditor.getMavenHome()})) : Runtime.getRuntime().exec("sh " + mavenHome + "/bin/mvn -f " + pathtoPomXmlFile + " " + action);
            if (mvnHelper != null) {
                mvnHelper.readVersion(p, pr);
            } else {
                CEMavenOperations.startOutStreams(p, pr);
            }
            int v = p.waitFor();
            return v;
        }
        catch (InterruptedException e) {
            Activator.log(4, 0, "Error in maven operation", e);
        }
        catch (Exception e) {
            CEOperation.openDialog("Maven Operation Failure", e.getMessage());
        }
        return -1;
    }

    private static void startOutStreams(Process p, PrintWriter pr) {
        InputStream ins1 = p.getInputStream();
        InputStream ins2 = p.getErrorStream();
        CEMavenOperations.startStreamReader(ins1, pr);
        CEMavenOperations.startStreamReader(ins2, pr);
    }

    private static void startStreamReader(final InputStream ins, final PrintWriter pr) {
        new Thread(){

            @Override
            public void run() {
                int i = -1;
                try {
                    while ((i = ins.read()) != -1) {
                        CEMavenOperations.logConsole((char)i, pr);
                    }
                }
                catch (IOException e) {
                    Activator.log(4, 0, "Error ", e);
                }
            }
        }.start();
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static boolean isWindows() {
        return CEMavenOperations.getOsName().toLowerCase().contains("windows");
    }

    public static void logConsole(char c, PrintWriter writer) {
        if (c == '\r' && lastChar == '\n' || c == '\n' && lastChar == '\r') {
            lastChar = c;
            return;
        }
        lastChar = c;
        if (c == '\n' || c == '\r') {
            writer.println(tempLogBuffer.toString());
            tempLogBuffer = new StringBuffer();
        } else {
            tempLogBuffer.append(c);
        }
    }
}

