/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin.util;

import com.avaya.eclipse.plugin.Activator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;

public class CEPluginHelper
implements Runnable {
    public static final CEPluginHelper INSTANCE = new CEPluginHelper();
    private volatile String version;
    private boolean messageDialogReturn = true;

    private CEPluginHelper() {
    }

    public IEclipsePreferences getInstanceScope() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.m2e.core");
    }

    public IEclipsePreferences getConfigurationScope() {
        return ConfigurationScope.INSTANCE.getNode("org.eclipse.m2e.core");
    }

    public IPreferencesService getPreferencesService() {
        return Platform.getPreferencesService();
    }

    public void reset() {
        this.version = null;
        this.messageDialogReturn = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readVersion(Process process, PrintWriter pr) {
        InputStream inputStream = null;
        InputStreamReader inputSteamReader = null;
        BufferedReader bufferReader = null;
        try {
            Pattern pattern;
            Matcher matcher;
            inputStream = process.getInputStream();
            inputSteamReader = new InputStreamReader(inputStream);
            bufferReader = new BufferedReader(inputSteamReader);
            String line = bufferReader.readLine();
            if (line != null && (matcher = (pattern = Pattern.compile("(\\d+([.]\\d+)+)")).matcher(line)).find()) {
                this.version = matcher.group(1);
            }
        }
        catch (IOException e) {
            pr.println("Error on reading maven version: " + e.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (inputSteamReader != null) {
                    inputSteamReader.close();
                }
                if (bufferReader != null) {
                    bufferReader.close();
                }
            }
            catch (IOException e) {
                Activator.log(4, 0, "Error getting version", e);
            }
        }
    }

    public boolean checkMinMvnVersion(String version, PrintWriter pr) {
        double minVersionInt;
        double versionInt = this.getIntVersion(version, 1.0, 3.0);
        return versionInt >= (minVersionInt = this.getIntVersion("3.2.1", 1.0, 3.0));
    }

    public double getIntVersion(String version, double maxVersionDigit, double versionDigitCount) {
        double versionInt = 0.0;
        StringTokenizer tonizer = new StringTokenizer(version, ".");
        double power = maxVersionDigit - 1.0;
        versionDigitCount = versionDigitCount * maxVersionDigit - 1.0;
        while (tonizer.hasMoreTokens()) {
            versionInt += Double.valueOf(tonizer.nextToken()) * Math.pow(10.0, power) * Math.pow(10.0, versionDigitCount);
            versionDigitCount -= maxVersionDigit;
        }
        return versionInt;
    }

    public String getMvnVersion() {
        return this.version;
    }

    public boolean isVersionInfoAvail() {
        return this.version != null;
    }

    @Override
    public void run() {
        this.messageDialogReturn = MessageDialog.openConfirm(null, (String)"Un-supported Maven Version", (String)String.format("Current maven version %s is lower than minimal maven version %s supported \n Do you want to continue?", this.version, "3.2.1"));
    }

    public boolean isConfirm() {
        return this.messageDialogReturn;
    }
}

