/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ssh;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.PluginUtilities;
import com.avaya.eclipse.plugin.model.ElementInfo;
import com.avaya.eclipse.plugin.operation.CEOperation;
import com.avaya.ssh.CharBuffer;
import com.sshtools.net.SocketTransport;
import com.sshtools.sftp.SftpClient;
import com.sshtools.sftp.SftpStatusException;
import com.sshtools.sftp.TransferCancelledException;
import com.sshtools.ssh.ChannelOpenException;
import com.sshtools.ssh.HostKeyVerification;
import com.sshtools.ssh.SshAuthentication;
import com.sshtools.ssh.SshClient;
import com.sshtools.ssh.SshConnector;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.SshSession;
import com.sshtools.ssh.SshTransport;
import com.sshtools.ssh.components.SshPublicKey;
import com.sshtools.ssh2.KBIAuthentication;
import com.sshtools.ssh2.KBIPrompt;
import com.sshtools.ssh2.KBIRequestHandler;
import com.sshtools.ssh2.Ssh2Client;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class SSHConnection {
    public static final ThreadLocal<String> context = new ThreadLocal();
    public static final int COLUMNS = 80;
    public static final int ROWS = 24;
    public static final int WIDTH = 0;
    public static final int HEIGHT = 0;
    private ElementInfo ei;
    private String terminal = "PS1=COMMAND#";
    private static final String PROMPT_SPLIT = "<>";
    private String expect = "COMMAND#";
    private boolean isCompleted = false;
    private List<String> promptList;
    private CharBuffer tempChar = new CharBuffer();
    private CharBuffer sb = new CharBuffer();
    private String termOut = null;
    private SshSession session;
    private Ssh2Client ssh2 = null;
    private SshClient ssh = null;
    private boolean isConnected;
    private SftpClient sftp = null;
    private CEOperation operationObj;

    public final SshSession getSession() {
        return this.session;
    }

    public final void setSession(SshSession session) {
        this.session = session;
    }

    public SSHConnection() {
    }

    public SSHConnection(ElementInfo ei) throws IOException, SshException, ChannelOpenException {
        this.ei = ei;
        this.init();
    }

    public void stopUpdating(CEOperation ceop) {
        if (ceop != null && ceop.equals(this.operationObj)) {
            this.operationObj = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAndCheckCommand(char c) {
        try {
            if (this.operationObj != null) {
                this.operationObj.update(c);
            }
            this.sb.append(c);
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error ", e);
            this.sb = new CharBuffer();
            this.sb.append(c);
        }
        String co = new String(this.sb.getChars());
        if (!co.endsWith(this.terminal) && co.endsWith(this.expect)) {
            CharBuffer charBuffer = this.sb;
            synchronized (charBuffer) {
                if (!this.isCompleted) {
                    this.isCompleted = true;
                }
                this.termOut = co;
                this.sb.notify();
            }
        }
        if (this.promptList != null && !this.promptList.isEmpty()) {
            List<String> list = this.promptList;
            synchronized (list) {
                for (String prompt : this.promptList) {
                    String[] pp = prompt.split(PROMPT_SPLIT);
                    if (!co.contains(pp[0])) continue;
                    SSHConnection sSHConnection = this;
                    synchronized (sSHConnection) {
                        this.tempChar.append(this.sb.getChars());
                    }
                    this.sb.clear(0, this.sb.getChars().length);
                    try {
                        this.session.getOutputStream().write((pp[1] + "\n").getBytes());
                    }
                    catch (Exception e) {
                        Activator.log(4, 0, "Error ", e);
                    }
                }
            }
        }
    }

    public synchronized String execute(String command) {
        return this.execute(command, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String execute(String command, String prompt) {
        if (this.session == null) {
            return command + "\nError while executing command on the device.Check the network connectivity before you retry";
        }
        try {
            if (prompt != null) {
                String[] p = prompt.split(",");
                this.promptList = new ArrayList<String>();
                for (String s : p) {
                    this.promptList.add(s);
                }
            } else {
                this.promptList = null;
            }
            this.tempChar = new CharBuffer();
            this.sb.clear(0, this.sb.getChars().length);
            try {
                this.session.getOutputStream().write((command + "\n").getBytes());
            }
            catch (IOException e) {
                this.session.getOutputStream().write((command + "\n").getBytes());
            }
            CharBuffer e = this.sb;
            synchronized (e) {
                this.sb.wait(60000L);
                return (new String(this.tempChar.getChars()) + new String(this.sb.getChars())).replace(this.expect, "");
            }
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error while executing command on the device", e);
            return command + "\nError while executing command on the device.Check the network connectivity before you retry";
        }
    }

    public void reconnect() {
        if (this.ssh != null) {
            this.disconnect();
            this.terminal = "PS1=COMMAND#";
            this.expect = "COMMAND#";
            try {
                this.init();
            }
            catch (Exception e) {
                Activator.log(4, 0, "Error during reconnect", e);
            }
        }
    }

    public synchronized String executeAsync(String command) {
        try {
            this.session.getOutputStream().write((command + "\n").getBytes());
        }
        catch (IOException e) {
            Activator.log(4, 0, "Error in async execution", e);
        }
        return "";
    }

    public boolean isConnected() {
        return this.isConnected && this.ssh.isConnected() && !this.getSession().isClosed();
    }

    public void setConnected(boolean isConnected) {
        this.isConnected = isConnected;
    }

    private void init() throws IOException, SshException, ChannelOpenException {
        Activator.log(1, "init started");
        SshConnector sshConn = null;
        SocketTransport st = null;
        try {
            sshConn = SshConnector.createInstance();
            HostKeyVerification hkv = new HostKeyVerification(){

                public boolean verifyHost(String hostname, SshPublicKey key) {
                    return true;
                }
            };
            sshConn.getContext().setHostKeyVerification(hkv);
            st = new SocketTransport(this.ei.getIp(), this.ei.getPort());
            this.ssh = sshConn.connect((SshTransport)st, this.ei.getUserName());
            this.ssh2 = (Ssh2Client)this.ssh;
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error in HostKeyVerification", e);
            if (!PluginUtilities.getInstance().isDemoMode()) {
                CEOperation.openDialog("HostKeyVerification Failure", "An error occurred while trying to perform the operation. Please check the 'System Manager/Avaya Breeze\u00ae' IP address, SSH Port, reachability and credentials configured for servers.");
            }
            throw new RuntimeException("HostKeyVerification Failure");
        }
        KBIAuthentication kbi = new KBIAuthentication();
        String username = this.ei.getUserName();
        kbi.setUsername(username);
        kbi.setKBIRequestHandler(new KBIRequestHandler(){

            public boolean showPrompts(String name, String instructions, KBIPrompt[] prompts) {
                Activator.log(1, name);
                Activator.log(1, instructions);
                if (prompts != null) {
                    for (int i = 0; i < prompts.length; ++i) {
                        try {
                            String response = SSHConnection.this.ei.getPassword();
                            prompts[i].setResponse(response);
                            continue;
                        }
                        catch (Exception ex) {
                            prompts[i].setResponse("");
                            Activator.log(4, 0, "Error in KBI request handler", ex);
                            return false;
                        }
                    }
                    return true;
                }
                if (instructions != null && instructions.contains("Your account has expired; please contact your system administrator")) {
                    if (!PluginUtilities.getInstance().isDemoMode()) {
                        CEOperation.openDialog("Authentication Failure", "Host IP : " + SSHConnection.this.ei.getIp() + " -  Your account has expired. Please contact your system administrator.");
                    }
                    throw new RuntimeException("Authentication Failure");
                }
                return false;
            }
        });
        int result = this.ssh.authenticate((SshAuthentication)kbi);
        if (result == 2) {
            Activator.log(4, "Connection attempt failed with host IP : " + this.ei.getIp() + ". " + "Please check the '{}' IP address, SSH Port, reachability and credential configured for the server.");
            if (this.operationObj != null) {
                this.operationObj.logConsole("Connection attempt failed with host IP : " + this.ei.getIp() + ". " + "Please check the '{}' IP address, SSH Port, reachability and credential configured for the server.");
            }
        }
        if (result == 1) {
            this.session = this.ssh.openSessionChannel();
            if (!this.session.requestPseudoTerminal("vt100", 80, 24, 0, 0)) {
                Activator.log(4, "Failed to allocate a pseudo terminal");
            }
            if (this.session.startShell()) {
                new Thread(){

                    @Override
                    public void run() {
                        context.set(SSHConnection.this.ei.getIp());
                        try {
                            InputStream ins = SSHConnection.this.session.getInputStream();
                            int i = -1;
                            while ((i = ins.read()) != -1) {
                                SSHConnection.this.addAndCheckCommand((char)i);
                            }
                        }
                        catch (IOException e) {
                            Activator.log(4, 0, "Error in connection", e);
                            context.remove();
                        }
                    }
                }.start();
                if (this.terminal != null) {
                    this.execute("PS1=COMMAND#");
                }
                String termEnd = this.getTermEnd();
                Activator.log(1, "Received Terminal Response.........." + termEnd);
                this.execute("stty -echo");
                this.setConnected(true);
            } else {
                Activator.log(4, "Failed to start the users shell");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTermEnd() {
        if (this.termOut == null) {
            CharBuffer charBuffer = this.sb;
            synchronized (charBuffer) {
                try {
                    this.sb.wait(60000L);
                }
                catch (InterruptedException e) {
                    Activator.log(4, 0, "Error getting term end", e);
                }
            }
        }
        return this.termOut;
    }

    public void disconnect() {
        context.remove();
        if (this.ssh != null) {
            this.ssh.disconnect();
        }
        if (this.sftp != null) {
            try {
                this.sftp.quit();
            }
            catch (Exception e) {
                Activator.log(4, 0, "Error closing SFTP connection", e);
            }
            this.sftp = null;
        }
        if (this.session != null) {
            this.session.close();
        }
        this.setConnected(false);
    }

    public final SftpClient getSftpClient() throws IOException, SftpStatusException, ChannelOpenException, SshException {
        if (this.sftp != null && !this.sftp.isClosed()) {
            return this.sftp;
        }
        if (this.sftp != null) {
            try {
                this.sftp.quit();
            }
            catch (Exception e) {
                Activator.log(4, 0, "Error in SFTP client", e);
            }
        }
        this.sftp = new SftpClient((SshClient)this.ssh2);
        return this.sftp;
    }

    public final synchronized void put(String absolutePathToFile, String targetPath) throws IOException, SftpStatusException, ChannelOpenException, SshException, TransferCancelledException {
        for (int i = 0; i < 2; ++i) {
            try {
                SftpClient sftpp = this.getSftpClient();
                sftpp.cd(targetPath);
                sftpp.put(absolutePathToFile);
                if (this.operationObj == null) break;
                this.operationObj.logConsole(absolutePathToFile + " Copied Successfully on to server");
                break;
            }
            catch (TransferCancelledException e) {
                Activator.log(4, 0, "Error while transferring file to server", e);
                this.operationObj.logConsole("Error while transferring " + absolutePathToFile + " on to server : Error Message : " + e.getMessage());
                if (i > 0) {
                    throw e;
                }
                this.sftp = null;
                this.getSftpClient();
                continue;
            }
        }
    }

    public void startUpdating(CEOperation operationObj) {
        this.operationObj = operationObj;
    }
}

