/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.alarming;

import com.avaya.asm.alarming.DMBasedTimer;
import com.avaya.asm.alarming.GenericAlarm;
import com.avaya.asm.alarming.GenericAlarmFailurePair;
import com.avaya.asm.alarming.GenericAlarmRecoveryIntf;
import com.avaya.asm.alarming.LeakyBucketAlarm;
import com.avaya.asm.alarming.PollingAlarm;
import com.avaya.asm.alarming.datamgr.BSMFailedOverUserAlarm;
import com.avaya.asm.alarming.datamgr.BSMNoAvayaLspAlarm;
import com.avaya.asm.alarming.datamgr.BSMNoEntityLinksAlarm;
import com.avaya.asm.alarming.datamgr.CACDeniedCallsAlarm;
import com.avaya.asm.alarming.datamgr.CACThresholdAlarm;
import com.avaya.asm.alarming.datamgr.CdrAlarm;
import com.avaya.asm.alarming.datamgr.ConfigFileEntryAlarm;
import com.avaya.asm.alarming.datamgr.DAOAsmIdentityAlarm;
import com.avaya.asm.alarming.datamgr.DAOAssetIdentityAlarm;
import com.avaya.asm.alarming.datamgr.DAOConnectionAlarm;
import com.avaya.asm.alarming.datamgr.DAOCorruptDataAlarm;
import com.avaya.asm.alarming.datamgr.DAODatabaseQueryAlarm;
import com.avaya.asm.alarming.datamgr.DAOFileIOAlarm;
import com.avaya.asm.alarming.datamgr.ELINMissingEntityLinksAlarm;
import com.avaya.asm.alarming.datamgr.JGroupsKeystoreAlarm;
import com.avaya.asm.alarming.datamgr.ManualFailedOverUserAlarm;
import com.avaya.asm.alarming.datamgr.NoMatchingEntityLinkAlarm;
import com.avaya.asm.alarming.datamgr.NoSuchDomainAlarm;
import com.avaya.asm.alarming.datamgr.UREPxRegAlarm;
import com.avaya.asm.alarming.datamgr.URERegAuthAlarm;
import com.avaya.asm.alarming.datamgr.URESubAuthAlarm;
import com.avaya.asm.alarming.datamgr.URESubStoreAlarm;
import com.avaya.asm.alarming.jgroups.JGroupsSendQueueAlarm;
import com.avaya.asm.alarming.routing.RouteThroughAlarm;
import com.avaya.asm.alarming.sipmonitor.SipMonitorAlarm;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.BSMFailedOverUserAlarmException;
import com.avaya.asm.core.exceptions.BSMNoAvayaLspAlarmException;
import com.avaya.asm.core.exceptions.BSMNoEntityLinksAlarmException;
import com.avaya.asm.core.exceptions.CACBwLocException;
import com.avaya.asm.core.exceptions.CdrCallException;
import com.avaya.asm.core.exceptions.ConfigFileEntryException;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.core.exceptions.ExceptionParameters;
import com.avaya.asm.core.exceptions.JGroupsKeystoreException;
import com.avaya.asm.core.exceptions.JGroupsSendQueueException;
import com.avaya.asm.core.exceptions.ManualFailedOverUserException;
import com.avaya.asm.core.exceptions.MissingEntityLinkException;
import com.avaya.asm.core.exceptions.NoMatchingEntityLinkException;
import com.avaya.asm.core.exceptions.NoSuchDomainException;
import com.avaya.asm.core.exceptions.RouteThroughException;
import com.avaya.asm.core.exceptions.SMAssetIdentityException;
import com.avaya.asm.core.exceptions.SMIdentityException;
import com.avaya.asm.core.exceptions.SipContainerIdentityException;
import com.avaya.asm.core.exceptions.SipMonitorException;
import com.avaya.asm.core.exceptions.UREPxRegException;
import com.avaya.asm.core.exceptions.URERegAuthException;
import com.avaya.asm.core.exceptions.URESubAuthException;
import com.avaya.asm.core.exceptions.URESubStoreException;
import com.avaya.common.logging.client.Logger;
import com.avaya.normalEventing.EventLogger;
import com.avaya.operationEventing.OperationalEventLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public class GenericAlarmHandler {
    private static final Logger log = AsmLogger.getLogger(GenericAlarmHandler.class);
    private static DMBasedTimer timer;
    private static Map<String, GenericAlarmFailurePair> alarmMap;
    private static Map<String, Integer> alarmTimerFireCountMap;
    private static final int INITIAL_TIMER_MAP_VALUE = -1;

    private static String getUniqueKey(Class<? extends GenericAlarm> clazz, Exception ex, String failedObjClassName, boolean forTimerFireCountMap) {
        String uniqueKey = clazz.getSimpleName();
        boolean isSingularFailure = true;
        try {
            isSingularFailure = clazz.newInstance().isSingularFailure();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!forTimerFireCountMap || !isSingularFailure) {
            uniqueKey = uniqueKey + "_" + failedObjClassName;
        }
        if (ExceptionParameters.class.isAssignableFrom(ex.getClass())) {
            uniqueKey = uniqueKey + ((ExceptionParameters)((Object)ex)).getExtraEventKeyParams();
        }
        return uniqueKey;
    }

    private static String getUniqueKey(GenericAlarm alarm, boolean forTimerFireCountMap) {
        return GenericAlarmHandler.getUniqueKey(alarm.getClass(), alarm.getException(), alarm.getFailedObjectClassName(), forTimerFireCountMap);
    }

    private static GenericAlarm createAlarm(Class<? extends GenericAlarm> clazz, Exception ex) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Unknown alarm type for " + clazz.getSimpleName() + ", exception: " + ex + ".  Likely cause is due to not adding the alarm into the AlarmFactory."));
            return null;
        }
    }

    private static synchronized GenericAlarmFailurePair getCreateAlarmPair(Class<? extends GenericAlarm> clazz, Exception ex, GenericAlarmRecoveryIntf failedObj) {
        String alarmMapKey = GenericAlarmHandler.getUniqueKey(clazz, ex, failedObj == null ? "" : failedObj.getClass().getSimpleName(), false);
        GenericAlarmFailurePair pair = alarmMap.get(alarmMapKey);
        if (pair == null || pair.canReplaceAlarm()) {
            GenericAlarm newAlarm = GenericAlarmHandler.createAlarm(clazz, ex);
            if (newAlarm == null) {
                return null;
            }
            if (log.isFineEnabled()) {
                log.fine((Object)("Created new Alarm object for the following: " + ex));
            }
            pair = new GenericAlarmFailurePair(newAlarm);
            alarmMap.put(alarmMapKey, pair);
            newAlarm.init(failedObj, ex, alarmMapKey);
            if (log.isFinestEnabled()) {
                log.finest((Object)("Scheduling timer for alarm: " + pair.getAlarm().toString()));
            }
            GenericAlarmHandler.scheduleAlarm(pair.getAlarm());
        }
        return pair;
    }

    private static GenericAlarmFailurePair getCreateAlarmPair(GenericAlarm alarm) {
        return GenericAlarmHandler.getCreateAlarmPair(alarm.getClass(), alarm.getException(), alarm.getFailedObj());
    }

    private static void incFailures(GenericAlarmFailurePair alarmPair) {
        if (alarmPair == null) {
            log.error((Object)"Could not increment failure count.  Abandoning alarm.");
            return;
        }
        alarmPair.incFailures(1);
    }

    protected static void decFailures(LeakyBucketAlarm alarm) {
        GenericAlarmFailurePair alarmPair = GenericAlarmHandler.getCreateAlarmPair(alarm);
        if (alarmPair == null) {
            log.error((Object)("Tried to decrement the number of failures for " + alarm.toString() + ", but had no record of it (was null)"));
            return;
        }
        alarmPair.decFailures(alarm.getDecrementAmount());
    }

    private static void scheduleAlarm(GenericAlarm alarm) {
        if (timer == null) {
            log.warn((Object)("Cannot create alarms because " + GenericAlarmHandler.class.getSimpleName() + "'s timer object is null."));
            return;
        }
        long timerInterval = GenericAlarm.junitAlarmInterval == -1L ? alarm.getTimerInterval() : GenericAlarm.junitAlarmInterval;
        timer.scheduleAtFixedRate((TimerTask)alarm, timerInterval, timerInterval);
    }

    protected static void upgradeToAlarm(GenericAlarm alarm) {
        alarm.cancel();
        GenericAlarm newAlarm = alarm.clone();
        String alarmKey = GenericAlarmHandler.getUniqueKey(newAlarm, false);
        GenericAlarmFailurePair pair = alarmMap.get(alarmKey);
        pair.setAlarm(newAlarm);
        if (log.isFineEnabled()) {
            log.fine((Object)("Upgrading failure to an alarm: " + newAlarm));
        }
        GenericAlarmHandler.scheduleAlarm(newAlarm);
    }

    protected static synchronized boolean incTimerFireCount(GenericAlarm alarm) {
        String uniqueKey = GenericAlarmHandler.getUniqueKey(alarm, true);
        Integer count = alarmTimerFireCountMap.get(uniqueKey);
        if (count == null) {
            count = -1;
        }
        if (alarm.getTimerFireCount() > count) {
            alarmTimerFireCountMap.put(uniqueKey, count + 1);
            return true;
        }
        return false;
    }

    protected static synchronized boolean clearTimerFireCount(GenericAlarm alarm) {
        String uniqueKey = GenericAlarmHandler.getUniqueKey(alarm, true);
        boolean rc = false;
        Integer timerFireCount = alarmTimerFireCountMap.get(uniqueKey);
        if (timerFireCount != null && alarm instanceof PollingAlarm) {
            if (timerFireCount > -1) {
                alarmTimerFireCountMap.put(uniqueKey, -1);
                GenericAlarmFailurePair failurePair = alarmMap.get(GenericAlarmHandler.getUniqueKey(alarm, false));
                if (failurePair != null) {
                    failurePair.setCanReplaceAlarm();
                }
                rc = true;
            }
            alarm.cancel();
        } else if (timerFireCount != null && alarm instanceof LeakyBucketAlarm) {
            rc = true;
            if (GenericAlarmHandler.getCreateAlarmPair(alarm).getFailureCount() <= 0) {
                alarmTimerFireCountMap.put(uniqueKey, -1);
                alarmMap.get(GenericAlarmHandler.getUniqueKey(alarm, false)).setCanReplaceAlarm();
                alarm.cancel();
            }
        }
        return rc;
    }

    public static int getFailureCount(GenericAlarm alarm) {
        String key = GenericAlarmHandler.getUniqueKey(alarm, false);
        GenericAlarmFailurePair pair = alarmMap.get(key);
        if (pair == null) {
            return 0;
        }
        return pair.getFailureCount();
    }

    public static synchronized void create() {
        log.info((Object)"Alarm handler created");
        timer = new DMBasedTimer(true);
        alarmMap = new HashMap<String, GenericAlarmFailurePair>();
        alarmTimerFireCountMap = new HashMap<String, Integer>();
    }

    private static boolean isDBConnectionError(DMException ex) {
        Throwable e = ex.getNestedException();
        if (e == null) {
            return false;
        }
        if (e instanceof SQLException) {
            SQLException se = (SQLException)e;
            String sqlstate = se.getSQLState();
            return sqlstate != null && (sqlstate.startsWith("08") || sqlstate.startsWith("57"));
        }
        return e instanceof TimeoutException;
    }

    private static boolean isExecutionError(DMException ex) {
        SQLException se;
        String sqlstate;
        Throwable e = ex.getNestedException();
        if (e == null) {
            return false;
        }
        if (e instanceof ExecutionException) {
            return true;
        }
        return e instanceof SQLException && (sqlstate = (se = (SQLException)e).getSQLState()) != null && sqlstate.startsWith("42");
    }

    private static boolean isCorruptedDatabase(DMException ex) {
        Throwable e = ex.getNestedException();
        if (e == null) {
            return false;
        }
        return e instanceof UnsupportedOperationException || e instanceof IllegalArgumentException;
    }

    private static boolean isFileIoError(DMException ex) {
        Throwable e = ex.getNestedException();
        if (e == null) {
            return false;
        }
        return e instanceof IOException;
    }

    protected static synchronized Class<? extends GenericAlarm> getAlarmClass(Exception e) {
        if (e instanceof DMException) {
            DMException dmEx = (DMException)e;
            if (GenericAlarmHandler.isDBConnectionError(dmEx)) {
                return DAOConnectionAlarm.class;
            }
            if (GenericAlarmHandler.isExecutionError(dmEx)) {
                return DAODatabaseQueryAlarm.class;
            }
            if (GenericAlarmHandler.isCorruptedDatabase(dmEx)) {
                return DAOCorruptDataAlarm.class;
            }
            if (GenericAlarmHandler.isFileIoError(dmEx)) {
                return DAOFileIOAlarm.class;
            }
            return DAOCorruptDataAlarm.class;
        }
        if (e instanceof SMIdentityException) {
            return DAOAsmIdentityAlarm.class;
        }
        if (e instanceof SMAssetIdentityException) {
            return DAOAssetIdentityAlarm.class;
        }
        if (e instanceof CACBwLocException) {
            int errorType = ((CACBwLocException)e).getErrorType();
            if (errorType == 0 || errorType == 1) {
                return CACThresholdAlarm.class;
            }
            if (errorType == 6) {
                return CACDeniedCallsAlarm.class;
            }
        } else {
            if (e instanceof SipMonitorException) {
                return SipMonitorAlarm.class;
            }
            if (e instanceof CdrCallException) {
                return CdrAlarm.class;
            }
            if (e instanceof SipContainerIdentityException) {
                return DAOAsmIdentityAlarm.class;
            }
            if (e instanceof RouteThroughException) {
                return RouteThroughAlarm.class;
            }
            if (e instanceof BSMNoAvayaLspAlarmException) {
                return BSMNoAvayaLspAlarm.class;
            }
            if (e instanceof BSMNoEntityLinksAlarmException) {
                return BSMNoEntityLinksAlarm.class;
            }
            if (e instanceof URERegAuthException) {
                return URERegAuthAlarm.class;
            }
            if (e instanceof UREPxRegException) {
                return UREPxRegAlarm.class;
            }
            if (e instanceof URESubAuthException) {
                return URESubAuthAlarm.class;
            }
            if (e instanceof URESubStoreException) {
                return URESubStoreAlarm.class;
            }
            if (e instanceof ManualFailedOverUserException) {
                return ManualFailedOverUserAlarm.class;
            }
            if (e instanceof BSMFailedOverUserAlarmException) {
                return BSMFailedOverUserAlarm.class;
            }
            if (e instanceof MissingEntityLinkException) {
                return ELINMissingEntityLinksAlarm.class;
            }
            if (e instanceof ConfigFileEntryException) {
                return ConfigFileEntryAlarm.class;
            }
            if (e instanceof JGroupsKeystoreException) {
                return JGroupsKeystoreAlarm.class;
            }
            if (e instanceof NoSuchDomainException) {
                return NoSuchDomainAlarm.class;
            }
            if (e instanceof NoMatchingEntityLinkException) {
                return NoMatchingEntityLinkAlarm.class;
            }
            if (e instanceof JGroupsSendQueueException) {
                return JGroupsSendQueueAlarm.class;
            }
        }
        return null;
    }

    public static void handleFailureEvent(GenericAlarmRecoveryIntf failedObj, Exception e) {
        if (timer == null) {
            log.warn((Object)("Cannot create alarms because " + GenericAlarmHandler.class.getSimpleName() + "'s timer object is null."));
            return;
        }
        Class<? extends GenericAlarm> clazz = GenericAlarmHandler.getAlarmClass(e);
        if (clazz != null) {
            GenericAlarmFailurePair alarmPair = GenericAlarmHandler.getCreateAlarmPair(clazz, e, failedObj);
            GenericAlarmHandler.incFailures(alarmPair);
        }
    }

    public static synchronized boolean manuallyClearEvent(GenericAlarmRecoveryIntf failingObj, Exception exception) {
        Class<? extends GenericAlarm> clazz = GenericAlarmHandler.getAlarmClass(exception);
        if (clazz != null) {
            String alarmMapKey = GenericAlarmHandler.getUniqueKey(clazz, exception, failingObj.getClass().getSimpleName(), false);
            return GenericAlarmHandler.manuallyClearEvent(alarmMapKey);
        }
        return false;
    }

    public static synchronized boolean manuallyClearEvent(String alarmMapKey) {
        if (alarmMap.get(alarmMapKey) == null) {
            log.warn((Object)("Cannot manually clear alarm because key was invalid: " + alarmMapKey));
            return false;
        }
        GenericAlarm alarm = alarmMap.get(alarmMapKey).getAlarm();
        if (alarm == null) {
            return false;
        }
        try {
            if (GenericAlarmHandler.clearTimerFireCount(alarm)) {
                Object[] args = alarm.getClearEventArgs();
                Object[] objectArray = args = args == null ? new Object[]{} : args;
                if (GenericAlarm.junitLog != null) {
                    GenericAlarm.junitLog.logEvent(alarm.getClearEventCode(), args);
                } else if (alarm.isOperationalEvent()) {
                    OperationalEventLogger.logOpEvent(alarm.getClearEventCode(), args);
                } else {
                    EventLogger.logEvent(alarm.getClearEventCode(), args);
                }
            }
            alarm.status = GenericAlarm.AlarmStatus.CLEARED;
        }
        catch (Exception e) {
            log.error((Object)("Could not manually clear the alarm.  The clearing will have to wait until Alarm timer fires: " + e));
            return false;
        }
        return true;
    }

    public static synchronized void shutdown() {
        log.info((Object)"Cancelling all Alarm Timers.");
        if (timer != null) {
            timer.cancelAll();
            timer = null;
        }
    }

    public static synchronized void shutdownByApp() {
        log.info((Object)"Cancelling Alarm Timers for the Application");
        Set<TimerTask> tasks = timer.cancel();
        for (TimerTask t : tasks) {
            alarmMap.remove(((GenericAlarm)t).alarmKey);
        }
        if (log.isFineEnabled()) {
            log.fine((Object)("Cleaned up " + tasks.size()));
        }
    }

    public static Map<String, GenericAlarmFailurePair> getAllAlarmInfo() {
        return Collections.unmodifiableMap(alarmMap);
    }

    public static String printDetails() {
        StringBuffer output = new StringBuffer();
        for (Map.Entry<String, GenericAlarmFailurePair> pair : Collections.unmodifiableMap(alarmMap).entrySet()) {
            output.append(pair.getKey() + ":" + pair.getValue().toString() + "\n");
        }
        output.append(timer.toString());
        return output.toString();
    }

    static {
        alarmMap = new HashMap<String, GenericAlarmFailurePair>();
        alarmTimerFireCountMap = new HashMap<String, Integer>();
    }
}

