/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.core;

import com.avaya.asm.core.Description;
import com.avaya.asm.core.Limits;
import java.nio.charset.Charset;

public class AsmConstants {
    public static final String LSP_FS_ENTITY_NAME = "avaya-lsp-fs";
    public static final String CALLLOG_RETENTION_SECONDS = "calllog.retention.seconds";
    public static final String ZERO_ADDRESS_IP = "0.0.0.0";
    public static final String ZERO_ADDRESS_IP_V6 = "::0";
    public static final String LOOPBACK_IP = "127.0.0.1";
    public static final String LOOPBACK_IP_V6 = "::1";
    public static final String SIP_CONTAINER_IP4 = "127.0.0.2";
    public static final String SIP_CONTAINER_IP6 = "::2";
    public static final Charset CHARSET = Charset.forName("UTF-8");
    public static final String ORIGINATION = "origination";
    public static final String DESTINATION = "destination";
    public static final String BOTH = "both";
    public static final int POLLING_SUBSCRIBES_PER_SECOND = 65;
    public static final int POLLING_SUBSCRIBE_BASE_RATE_INCREASE = 5;
    public static final int POLLING_SUBSCRIBE_RATE_DECREASE = 35;
    public static final int POLLING_SUBSCRIBE_OVERLOAD_RATE_INCREASE = 5;
    public static final int MAX_NUMBER_CORE_SM_INSTANCES = 28;
    public static final String IPT_STATION_MUTEONOFFHOOK = "muteonoffhookinscmode";
    public static final String SMGR_FOREIGN_DOMAIN = "__foreign__";
    public static final String STANDARD_FLAT = "standard_flat";
    public static final String ENHANCED_FLAT = "enhanced_flat";
    public static final String ENHANCED_XML = "enhanced_xml";
    public static final String AVEXT_PARAMETER_EQ = "avext=";
    public static final String SIP_URI_SCHEME = "sip";
    public static final String XMPP_URI_SCHEME = "xmpp";
    public static final String SMTP_URI_SCHEME = "smtp";
    public static final Integer ENDPOINT_TIMER_B = 4;

    private AsmConstants() {
    }

    public static final class FILE_PATHS {
        public static final String SUDO = "/usr/bin/sudo";
        public static final String RNDC_UTIL = "/opt/Avaya/CommonServerPlatform/bin/rndcUtil.sh";
    }

    public static final class SM_LOCAL_PARAMETERS
    extends LOCAL_PARAMETERS {
        @Description(value="Total time limit (mS) for querying access element(s) for preemption candidates.")
        @Limits(type=Integer.class, defaultValue="1000", minimum=0L)
        public static final String ACCESS_ELEMENT_QUERY_TIMEOUT = "ACCESS_ELEMENT_QUERY_TIMEOUT";
        @Description(value="If true, modifies all events/alarms to trigger alarm/clear events immediately on first discovery of the problem, rather than using retries to minimize alarm noise.")
        @Limits(type=Boolean.class, defaultValue="false")
        public static final String ALARM_IMMEDIATELY = "ALARM_IMMEDIATELY";
        @Description(value="Load Factor value which SM sets in Av-SM-Load-Factor header of SIP message (set value between 0 and 200 to override the load factor calculation mechanism).")
        @Limits(type=Integer.class, defaultValue="-1", minimum=-1L, maximum=200L)
        public static final String ASM_LOAD_FACTOR = "ASM_LOAD_FACTOR";
        @Description(value="Maximum number of user's alternate SMs to retry push notifications on upon failure.")
        @Limits(type=Integer.class, defaultValue="1", minimum=0L, maximum=3L)
        public static final String APN_ALTSM_RETRIES = "APN_ALTSM_RETRIES";
        @Description(value="Timeout (in milliSeconds) for push notification HTTP requests (0=no timeout).")
        @Limits(type=Integer.class, defaultValue="5000", minimum=0L, maximum=32000L)
        public static final String APN_HTTP_TIMEOUT = "APN_HTTP_TIMEOUT";
        @Description(value="Maximum time (in milliSeconds) for alternate SM push notification retries (0=no timeout).")
        @Limits(type=Integer.class, defaultValue="0", minimum=0L, maximum=60000L)
        public static final String APN_RETRY_TIMEOUT = "APN_RETRY_TIMEOUT";
        @Description(value="APNS expiration timer(in seconds).")
        @Limits(type=Integer.class, defaultValue="3600", minimum=60L, maximum=3600L)
        public static final String APN_EXPIRATION_TIMER = "APN_EXPIRATION_TIMER";
        @Description(value="If true, we will process all replication events ASAP. If false, then when a large number of events for a single DAO come in, we may wait several minutes until the events stop, then process all the events with a single DAO reinit.")
        @Limits(type=Boolean.class, defaultValue="false")
        public static final String BULK_UPDATE_ASAP = "BULK_UPDATE_ASAP";
        @Description(value="Maximum time in minutes between Call Admission Controls Audits for a given limit. Max value is 7 days.")
        @Limits(type=Integer.class, defaultValue="120", minimum=1L, maximum=10080L)
        public static final String CAC_AUDIT_INTERVAL = "CAC_AUDIT_INTERVAL";
        @Description(value="Time limit (mS) for sequentially querying other SMs for bandwidth")
        @Limits(type=Integer.class, defaultValue="600", minimum=0L)
        public static final String CAC_REQUEST_TIME_LIMIT = "CAC_REQUEST_TIME_LIMIT";
        @Description(value="Maximum SIP threads able to do concurrent inter-SM CAC bandwidth queries (-1 = disabled)")
        @Limits(type=Integer.class, defaultValue="12", scaleToProfile=true, minimum=-1L)
        public static final String CAC_THREAD_COUNT_THRESHOLD = "CAC_THREAD_COUNT_THRESHOLD";
        @Description(value="Total time limit (mS) for querying other SMs for bandwidth")
        @Limits(type=Integer.class, defaultValue="4000", minimum=0L)
        public static final String CAC_TOTAL_QUERY_TIMEOUT = "CAC_TOTAL_QUERY_TIMEOUT";
        @Description(value="Defines the SIP Resiliency call reconstruction rate in calls per second.")
        @Limits(type=Integer.class, defaultValue="40", scaleToProfile=true, minimum=1L, maximum=200L)
        public static final String CALL_RECONSTRUCTIONS_PER_SECOND = "CALL_RECONSTRUCTIONS_PER_SECOND";
        @Description(value="Defines the SIP Resiliency polling interval in seconds at which state of other SMs is checked.")
        @Limits(type=Integer.class, defaultValue="5", minimum=1L)
        public static final String CALL_RECONSTRUCTION_POLLING_INTERVAL = "CALL_RECONSTRUCTION_POLLING_INTERVAL";
        @Description(value="Defines the SIP Resiliency call age threshold in hours (0 = unlimited).")
        @Limits(type=Integer.class, defaultValue="10", minimum=0L)
        public static final String CALL_RECONSTRUCTION_AGE_THRESHOLD = "CALL_RECONSTRUCTION_AGE_THRESHOLD";
        @Description(value="Defines the SIP Resiliency call reconstruction retries per call.")
        @Limits(type=Integer.class, defaultValue="3", minimum=0L, maximum=100L)
        public static final String CALL_RECONSTRUCTION_RETRIES = "CALL_RECONSTRUCTION_RETRIES";
        @Description(value="Time in minutes during which SM will assume bandwidth remains in use after the serving SM fails. This value is only used if this SM is the CAC Auditor.")
        @Limits(type=Integer.class, defaultValue="5", minimum=0L, maximum=120L)
        public static final String CONN_PRESERVED_CALL_LENGTH = "CONN_PRESERVED_CALL_LENGTH";
        @Description(value="Defines the default Min-SE value for call reconstruction.")
        @Limits(type=Integer.class, defaultValue="90", minimum=90L, maximum=86400L)
        public static final String DEFAULT_MIN_SE = "DEFAULT_MIN_SE";
        @Description(value="Defines the number of commprofiles audited per 5 second interval (0 = off).")
        @Limits(type=Integer.class, defaultValue="10", scaleToProfile=true, minimum=0L, maximum=100L)
        public static final String DYNAMIC_ASSIGN_AUDIT_RATE = "DYNAMIC_ASSIGN_AUDIT_RATE";
        @Description(value="Defines the maximum admin rate (hourly) limit for SM reassignment.")
        @Limits(type=Integer.class, defaultValue="14400", scaleToProfile=true, minimum=1L, maximum=144000L)
        public static final String DYNAMIC_ASSIGN_ADMIN_RATE_LIMIT = "DYNAMIC_ASSIGN_ADMIN_RATE_LIMIT";
        @Description(value="Defines whether cross SM queries are enabled for dynamic SM assignment.")
        @Limits(type=Boolean.class, defaultValue="true")
        public static final String DYNAMIC_ASSIGN_ENABLE_CROSS_SM_QUERY = "DYNAMIC_ASSIGN_ENABLE_CROSS_SM_QUERY";
        @Description(value="Defines the maximum level registration rate (hourly) limit for SM reassignment (stops load balancing).")
        @Limits(type=Integer.class, defaultValue="36000", scaleToProfile=true, minimum=1L, maximum=144000L)
        public static final String DYNAMIC_ASSIGN_REG_RATE_LIMIT = "DYNAMIC_ASSIGN_REG_RATE_LIMIT";
        @Description(value="Defines the maximum high level registration rate (hourly) limit for SM reassignment (stop all dynamic assignments).")
        @Limits(type=Integer.class, defaultValue="144000", scaleToProfile=true, minimum=1L, maximum=576000L)
        public static final String DYNAMIC_ASSIGN_HIGH_REG_RATE_LIMIT = "DYNAMIC_ASSIGN_HIGH_REG_RATE_LIMIT";
        @Description(value="Defines the minimum time between SM (re)assignments for a commprofile in seconds.")
        @Limits(type=Integer.class, defaultValue="60", minimum=1L, maximum=86400L)
        public static final String DYNAMIC_ASSIGN_TIME_THRESHOLD = "DYNAMIC_ASSIGN_TIME_THRESHOLD";
        @Description(value="Defines the EC500 delay rate for push notification clients per second.")
        @Limits(type=Integer.class, defaultValue="5", scaleToProfile=true, minimum=1L, maximum=50L)
        public static final String EC500_DELAYS_PER_SECOND = "EC500_DELAYS_PER_SECOND";
        @Description(value="Defines the interval at which SM will wait before attempting to batch up ELIN requests for newly registered users into one PUBLISH messagee to the ELIN server.  The units are in seconds.  Setting to 0 will send individual PUBLISH messages for each registration event.")
        @Limits(type=Integer.class, defaultValue="10", minimum=0L)
        public static final String ELIN_BATCH_SEND_INTERVAL = "ELIN_BATCH_SEND_INTERVAL";
        @Description(value="Defines batch size for bulk ELIN PUBLISH and SUBSCRIBE.")
        @Limits(type=Integer.class, defaultValue="50", minimum=1L)
        public static final String ELIN_BATCH_SIZE = "ELIN_BATCH_SIZE";
        @Description(value="Defines the ELIN request retry time in seconds.  A value of 0 disables retries.")
        @Limits(type=Integer.class, defaultValue="300", minimum=0L)
        public static final String ELIN_REQUEST_RETRY = "ELIN_REQUEST_RETRY";
        @Description(value="Defines the number of requests per second sent to the ELIN server.")
        @Limits(type=Integer.class, defaultValue="20", minimum=1L)
        public static final String ELIN_REQUESTS_PER_SECOND = "ELIN_REQUESTS_PER_SECOND";
        @Description(value="Minimum retry-after header value used in BSM when ESH is down.")
        @Limits(type=Integer.class, defaultValue="30", minimum=0L)
        public static final String ESHDOWN_RETRY_MIN = "ESHDOWN_RETRY_MIN";
        @Description(value="Range of randomized retry-after header value used in BSM when ESH is down. Randomized interval is [min, range+min)")
        @Limits(type=Integer.class, defaultValue="60", minimum=0L)
        public static final String ESHDOWN_RETRY_RANGE = "ESHDOWN_RETRY_RANGE";
        @Description(value="Defines whether sending SUBSCRIBE to ELIN server is enabled.")
        @Limits(type=Boolean.class, defaultValue="false")
        public static final String ENABLE_ELIN_SUBSCRIBE = "ENABLE_ELIN_SUBSCRIBE";
        @Description(value="Defines whether IP interworking is enabled.")
        @Limits(type=Boolean.class, defaultValue="true")
        public static final String ENABLE_IP_INTERWORKING = "ENABLE_IP_INTERWORKING";
        @Description(value="Defines whether mid-call preemption is enabled.")
        @Limits(type=Boolean.class, defaultValue="false")
        public static final String ENABLE_MID_CALL_PREEMPTION = "ENABLE_MID_CALL_PREEMPTION";
        @Description(value="Defines whether capability checking for SIP Resiliency is enabled.")
        @Limits(type=Boolean.class, defaultValue="true")
        public static final String ENABLE_RESILIENCY_CAPABILITY_CHECKING = "ENABLE_RESILIENCY_CAPABILITY_CHECKING";
        @Description(value="Defines whether SM will log an operational event when an endpoint refreshes a registration with a Call-ID that is different from the previous Call-ID. This is usually evidence that the device has rebooted.")
        @Limits(type=Boolean.class, defaultValue="true")
        public static final String ENABLE_REBOOT_EVENT = "ENABLE_REBOOT_EVENT";
        @Description(value="Defines the amount of time (in ms) worth of avaya-cm-feature-status polling subscribes which we allow in queuing before sending 503s to endpoint subscribe attempts. This should correspond to the endpoint's provisioned retry interval.")
        @Limits(type=Integer.class, defaultValue="12000")
        public static final String FEATURE_STATUS_RETRY = "FEATURE_STATUS_RETRY";
        @Description(value="Defines the multiplier applied to avaya-cm-feature-status subscription randomized Retry-After header value when 503 response is sent.")
        @Limits(type=Integer.class, defaultValue="24")
        public static final String FEATURE_STATUS_RETRY_FACTOR = "FEATURE_STATUS_RETRY_FACTOR";
        @Description(value="Defines the maximum amount of time (in minutes) that IPTCM DAOs will go without processing replication events due to IPTCM syncs being in progress before they stop waiting and start processing database changes.")
        @Limits(type=Integer.class, defaultValue="480", minimum=3L, maximum=1440L)
        public static final String IPTCM_SYNC_TIMEOUT = "IPTCM_SYNC_TIMEOUT";
        @Description(value="Defines the delay in seconds between inter cluster fragmentation audits")
        @Limits(type=Long.class, defaultValue="3600", minimum=30L)
        public static final String INTER_CLUSTER_AUDIT_INTERVAL = "INTER_CLUSTER_AUDIT_INTERVAL";
        @Description(value="Defines the threshold that the inter cluster fragmentation audit will rejoin the inter cluster member at or below.  Set this to a logical value that the minority (island) cluster(s) rejoins the majority cluster and not the other way around.")
        @Limits(type=Double.class, defaultValue=".5", minimum=0L, maximum=1L)
        public static final String INTER_CLUSTER_AUDIT_REJOIN_THRESHOLD = "INTER_CLUSTER_AUDIT_REJOIN_THRESHOLD";
        @Description(value="Defines the retry interval (in seconds) that the JGroups cluster will wait for a newly joined member to broadcast its type information before proactively requesting it.  This can be used to reduce multiple bulk stores.")
        @Limits(type=Long.class, defaultValue="10", minimum=1L, maximum=120L)
        public static final String JGROUP_TYPE_RETRY_INTERVAL = "JGROUP_TYPE_RETRY_INTERVAL";
        @Description(value="The load factor value at which this SM will be considered to be overloaded.")
        @Limits(type=Integer.class, defaultValue="100", minimum=0L, maximum=200L)
        public static final String LF_OVERLOADED = "LF_OVERLOADED";
        @Description(value="Defines the time threshold (in milliSeconds) for recalculating SM's load factor.")
        @Limits(type=Long.class, defaultValue="2000", minimum=0L, maximum=60000L)
        public static final String LF_RECALCULATE_THRESHOLD = "LF_RECALCULATE_THRESHOLD";
        @Description(value="Defines percentage weight of number of registrations (between 0 and 100) for calculation of SM's load factor.")
        @Limits(type=Integer.class, defaultValue="20", minimum=0L, maximum=100L)
        public static final String LF_REG_WEIGHT = "LF_REG_WEIGHT";
        @Description(value="Defines percentage weight of number of users (between 0 and 100) for calculation of SM's load factor.")
        @Limits(type=Integer.class, defaultValue="10", minimum=0L, maximum=100L)
        public static final String LF_USER_WEIGHT = "LF_USER_WEIGHT";
        @Description(value="Method used to synchronize event state between SM and CM. Allowed values are 'CALCULATE', 'POLLING_SUBSCRIBE', and 'PUBLISH_ALL'.")
        @Limits(type=String.class, defaultValue="CALCULATE")
        public static final String LINK_RECOVERY_METHOD = "LINK_RECOVERY_METHOD";
        @Description(value="Defines interval in milliseconds at which load balancer reports statistics, 0 = off.")
        @Limits(type=Integer.class, defaultValue="0", minimum=0L)
        public static final String LOAD_BALANCER_STATS_INT = "LOAD_BALANCER_STATS_INT";
        @Description(value="List of SipApplicationSession-level attributes that are printed by the GET CallAttributes command and similar debug logging. Setting this to \"ALL\" (case-insensitive) will print all stored attributes. Otherwise, attribute names are case-sensitive.")
        @Limits(type=String.class, defaultValue="ALL")
        public static final String LOG_ATTRIBUTES_APPSESSION = "LOG_ATTRIBUTES_APPSESSION";
        @Description(value="List of CallData-level attributes that are printed by the GET CallAttributes command and similar debug logging. Setting this to \"ALL\" (case-insensitive) will print all stored attributes. Otherwise, attribute names are case-sensitive.")
        @Limits(type=String.class, defaultValue="ALL")
        public static final String LOG_ATTRIBUTES_CALL = "LOG_ATTRIBUTES_CALL";
        @Description(value="List of SipServletMessage-level attributes that are printed by the GET CallAttributes command and similar debug logging. Setting this to \"ALL\" (case-insensitive) will print all stored attributes. Otherwise, attribute names are case-sensitive.")
        @Limits(type=String.class, defaultValue="ALL")
        public static final String LOG_ATTRIBUTES_MESSAGE = "LOG_ATTRIBUTES_MESSAGE";
        @Description(value="List of SipSession-level attributes that are printed by the GET CallAttributes command and similar debug logging. Setting this to \"ALL\" (case-insensitive) will print all stored attributes. Otherwise, attribute names are case-sensitive.")
        @Limits(type=String.class, defaultValue="ALL")
        public static final String LOG_ATTRIBUTES_SESSION = "LOG_ATTRIBUTES_SESSION";
        @Limits(type=Boolean.class, defaultValue="false")
        public static final String MEASURE_PROCESSING_DELAY = "MEASURE_PROCESSING_DELAY";
        @Description(value="The number of minutes to retain message counts for (0 = off).")
        @Limits(type=Integer.class, defaultValue="0", minimum=0L, maximum=1440L)
        public static final String MESSAGE_COUNTER_LENGTH = "MESSAGE_COUNTER_LENGTH";
        @Description(value="The minimum time (in milliseconds) that SM will ever allocate for the task of sending one polling SUBSCRIBE. This value is only meaningful if the SM is connected to an event state holder that supports rate adjustment.")
        @Limits(type=Integer.class, defaultValue="1")
        public static final String MIN_POLLING_SUBSCRIBE_TIME = "MIN_POLLING_SUBSCRIBE_TIME";
        @Description(value="Timeout value (in milliseconds) for call preemption request.")
        @Limits(type=Integer.class, defaultValue="1500")
        public static final String PREEMPT_CALL_TIMEOUT = "PREEMPT_CALL_TIMEOUT";
        @Description(value="Percentage bandwidth factor for preemption candidate queries.")
        @Limits(type=Integer.class, defaultValue="200", minimum=0L)
        public static final String PREEMPT_CANDIDATE_QUERY_BANDWIDTH_PERCENT = "PREEMPT_CANDIDATE_QUERY_BANDWIDTH_PERCENT";
        @Description(value="Defines the number of seconds after a CM re-subscribe notification is received during which we will ignore any additional re-subscribes. A value of zero means we will not ignore any re-subscribes.")
        @Limits(type=Integer.class, defaultValue="15", minimum=0L)
        public static final String RESUBSCRIBE_IGNORE_PERIOD = "RESUBSCRIBE_IGNORE_PERIOD";
        @Description(value="Number of contiguous updates for a DAO that appear at the end of an update interval that will cause us to retain the events until the next interval in case contiguous eventing continues then.")
        @Limits(type=Integer.class, defaultValue="1000", minimum=0L)
        public static final String RETAIN_EVENTS_THRESHOLD = "RETAIN_EVENTS_THRESHOLD";
        @Description(value="Defines whether sequenced application CAC accounting is enabled.")
        @Limits(type=Boolean.class, defaultValue="true")
        public static final String SEQUENCED_APP_CAC_ACCOUNTING = "SEQUENCED_APP_CAC_ACCOUNTING";
        @Description(value="The interval (in seconds) between times that SM will re-calculate the throttled polling SUBSCRIBE rate. This value is only meaningful if the SM is connected to an event state holder that supports rate adjustment.")
        @Limits(type=Integer.class, defaultValue="2")
        public static final String THROTTLE_CALCULATION_INTERVAL = "THROTTLE_CALCULATION_INTERVAL";
        @Description(value="Defines the number of PPM requests per second triggered by the Message Throttler, which throttles traffic originated by Session Manager.")
        @Limits(type=Integer.class, defaultValue="100", scaleToProfile=true, minimum=1L)
        public static final String THROTTLED_PPM_REQUESTS_PER_SECOND = "THROTTLED_PPM_REQUESTS_PER_SECOND";
        @Description(value="Defines the number of SIP requests per second allowed by the Message Throttler, which throttles traffic originated by Session Manager. Note that SIP responses are not counted, so the number of messages is likely twice this number.")
        @Limits(type=Integer.class, defaultValue="480", scaleToProfile=true, minimum=1L)
        public static final String THROTTLED_REQUESTS_PER_SECOND = "THROTTLED_REQUESTS_PER_SECOND";
        @Limits(type=Integer.class, defaultValue="3600000", minimum=30000L, maximum=3600000L)
        public static final String TLS_NONCE_VALIDITY = "TLS_NONCE_VALIDITY";
        @Limits(type=Integer.class, defaultValue="30000", minimum=30000L, maximum=3600000L)
        public static final String UDP_TCP_NONCE_VALIDITY = "UDP_TCP_NONCE_VALIDITY";
        @Description(value="Defines the number of INVITE-created GSIDs that can be active at the time that the daily usage audit is scheduled before the audit will be canceled to avoid performance impacts.")
        @Limits(type=Integer.class, defaultValue="100", minimum=0L)
        public static final String USAGE_AUDIT_GSID_THRESHOLD = "USAGE_AUDIT_GSID_THRESHOLD";
        @Description(value="Defines the time at which a daily audit of all bandwidth and call count usage will be executed. A value of -1 disables the daily audit. Any other value is the number of minutes after 00:00 (midnight) system time at which the audit will run, subject to its other constraints.")
        @Limits(type=Integer.class, defaultValue="180", minimum=-1L, maximum=1439L)
        public static final String USAGE_AUDIT_TIME = "USAGE_AUDIT_TIME";
        @Description(value="Defines the number of milliseconds that the daily usage audit is allowed to run before it will terminate in order to avoid performance impacts. During the audit, no SIP traffic which impacts usage will be processed, so the time needs to be short.")
        @Limits(type=Long.class, defaultValue="100", minimum=0L, maximum=4000L)
        public static final String USAGE_AUDIT_TIMEOUT = "USAGE_AUDIT_TIMEOUT";
        @Description(value="Defines the maximum number of domains that will be processed at once into the zone configuration file.  This setting is useful for throttling bulk changes in LHNR entries.")
        @Limits(type=Integer.class, defaultValue="600", minimum=1L, maximum=1000L)
        public static final String ZONEFILE_BATCH_SIZE = "ZONEFILE_BATCH_SIZE";
        @Description(value="Defines the registration expiration grace period in seconds.")
        @Limits(type=Integer.class, defaultValue="120", minimum=0L, maximum=600L)
        public static final String REGISTRATION_EXPIRATION_GRACE_PERIOD = "REGISTRATION_EXPIRATION_GRACE_PERIOD";
        @Description(value="Defines the subscription expiration grace period in seconds.")
        @Limits(type=Integer.class, defaultValue="120", minimum=0L, maximum=600L)
        public static final String SUBSCRIPTION_EXPIRATION_GRACE_PERIOD = "SUBSCRIPTION_EXPIRATION_GRACE_PERIOD";
        @Description(value="Disables sending of background PPM related NOTIFY messages to endpoints.")
        @Limits(type=Boolean.class, defaultValue="false")
        public static final String DISABLE_PPM_NOTIFIES = "DISABLE_PPM_NOTIFIES";
        @Description(value="Number of seconds to keep a strong reference to CallData messages")
        @Limits(type=Long.class, defaultValue="10", minimum=0L, maximum=0x7FFFFFFFL)
        public static final String CALLDATA_STRONG_REFERENCE_DELAY = "CALLDATA_STR_REF_DELAY";
        @Description(value="Represents day(s) on which to invoke database refresh on CM homing audit (Allowed values are a sequence of digits between 1 and 7, representing 1-Mon 2-Tues 3-Wed 4-Thur 5-Fri 6-Sat 7-Sun)")
        @Limits(type=String.class, defaultValue="6")
        public static final String CM_AUDIT_TOUCH_DAYS = "CM_AUDIT_TOUCH_DAYS";
        @Description(value="Number of thread pool size to be used in case of push notification failure")
        @Limits(type=String.class, defaultValue="10")
        public static final String PUSH_NOTIFICATION_ALT_ROUTE_THREAD_SIZE = "PUSH_NOTIFICATION_ALT_ROUTE_THREAD_SIZE";
        @Description(value="Number of connection pool size to be used for push notification http client")
        @Limits(type=String.class, defaultValue="5")
        public static final String PUSH_NOTIFICATION_CONNECTION_POOL_SIZE = "PUSH_NOTIFICATION_CONNECTION_POOL_SIZE";
        @Description(value="Defines push notification connection keep alive period (in milliseconds)")
        @Limits(type=Long.class, defaultValue="20000", minimum=1000L, maximum=50000L)
        public static final String PUSH_NOTIFICATION_CONNECTION_KEEP_ALIVE_PERIOD = "PUSH_NOTIFICATION_CONNECTION_KEEP_ALIVE_PERIOD";
    }

    public static class LOCAL_PARAMETERS {
        @Description(value="Seconds between OPTIONS sent for ASSET monitoring; 0 = off")
        @Limits(type=Integer.class, defaultValue="10", minimum=0L, maximum=3600L)
        public static final String ASSET_MONITORING_INTERVAL = "ASSET_MONITORING_INTERVAL";
        @Description(value="Number of OPTIONS retry attempts for ASSET monitoring")
        @Limits(type=Integer.class, defaultValue="2", minimum=0L)
        public static final String ASSET_MONITORING_RETRIES = "ASSET_MONITORING_RETRIES";
        @Description(value="Defines the numbr of retries for a database query")
        @Limits(type=Integer.class, defaultValue="1", minimum=0L)
        public static final String DATABASE_RETRIES = "DATABASE_RETRIES";
        @Description(value="Defines the timeout for a database connection")
        @Limits(type=Integer.class, defaultValue="30000", minimum=0L)
        public static final String DATABASE_TIMEOUT = "DATABASE_TIMEOUT";
        @Description(value="Defines whether ASSET is in the Deny New Service state.")
        @Limits(type=Boolean.class, defaultValue="true")
        public static final String DENY_SERVICE = "DENY_SERVICE";
        @Description(value="Record last time Deny or Accept New Service state change occurred.")
        @Limits(type=Long.class, defaultValue="0")
        public static final String DENY_SERVICE_TIMESTAMP = "DENY_SERVICE_TIMESTAMP";
        @Description(value="Record last time the Jboss identity or trust certificate was changed")
        @Limits(type=Long.class, defaultValue="0")
        public static final String JBOSS_CERT_CHANGE = "JBOSS_CERT_CHANGE";
        @Description(value="Threshold limit for JGroups executing synchronous CAC queries")
        @Limits(type=Integer.class, defaultValue="10000")
        public static final String JGROUP_QUEUE_THRESHOLD = "JGROUP_QUEUE_THRESHOLD";
        @Description(value="JGroup Single host query timeout")
        @Limits(type=Integer.class, defaultValue="2100", minimum=0L)
        public static final String JGROUP_SINGLEHOST_QUERY_TIMEOUT = "JGROUP_SINGLEHOST_QUERY_TIMEOUT";
        @Description(value="The minimum number of contiguous replication events that a particular DAO receives before we determine that it is better to reinit the DAO instead of process each event individually.  Also see MIN_CONTIG_EVENTS_REINIT_THRESHOLD - code takes MAX between these two numbers.")
        @Limits(type=Integer.class, defaultValue="50", minimum=20L)
        public static final String MIN_CONTIG_EVENTS_REINIT = "MIN_CONTIG_EVENTS_REINIT";
        @Description(value="The minimum threshold, based on the size of DAOs main collection, for contiguous replication events receive before we determine that it is better to reinit the DAO instead of process each event individually. ie. size=6000, threshold=10%, we must get at least 600 contiguous replication events prior to reiniting.  Also see MIN_CONTIG_EVENTS_REINIT - code takes MAX between these two numbers.")
        @Limits(type=Double.class, defaultValue=".1", minimum=0L, maximum=1L)
        public static final String MIN_CONTIG_EVENTS_REINIT_THRESHOLD = "MIN_CONTIG_EVENTS_REINIT_THRESHOLD";
        @Description(value="The minimum version of SM for the whole cluster.  This is used to determine which jgroups version to use.")
        @Limits(type=Integer.class, defaultValue="8000")
        public static final String MIN_SM_VERSION = "MIN_SM_VERSION";
        @Description(value="Record last time the WebSphere identity or trust certificate was changed")
        @Limits(type=Long.class, defaultValue="0")
        public static final String WEBSPHERE_CERT_CHANGE = "WEBSPHERE_CERT_CHANGE";
    }

    public static final class LOAD_FACTOR {
        public static final String DEFAULT_REG_WEIGHT = "20";
        public static final String DEFAULT_USER_WEIGHT = "10";
    }

    public static final class PERFORMANCE_MONITORING {
        public static final int EXPIRATION_RETRY = 300;
        public static final int PRESERVATION_TIME = 600;

        public static final class PUSH_NOTIFICATION {
            public static final String ACTIVATE = "activate";
            public static final String ACTIVATE_TOTAL = "activatetotal";
            public static final String DEACTIVATE = "deactivate";
            public static final String NOTIFY_OK = "notifyok";
            public static final String NOTIFY_ERR = "notifyerr";
            public static final String VOIP_NOTIFY_OK = "voipnotifyok";
            public static final String VOIP_NOTIFY_ERR = "voipnotifyerr";
        }

        public static final class LOCATION {
            public static final String CAC_DENIED = "CAC_DENIED";
            public static final String CAC_DOWNSPED = "CAC_DOWNSPED";
            public static final String CAC_CALL_COMPLETED = "CAC_CALL_COMPLETED";
        }
    }

    public static final class USER_COMMUNITY_ID {
        public static int COMPACT_ID_BITS = 8;
        public static long COMPACT_ID_MASK = 255L;
        public static int MAX_USERCOMMUNITY_ASM = 4;
    }

    public static final class DEVICE_DATA_NAME {
        public static final String XML = "XML";
    }

    public static final class DEVICE_DATA_CATEGORY {
        public static final String CONFIG = "Config";
    }

    public static final class REGISTRATION_ATTRIBUTES {
        public static final int MIN_REG_EXPIRY = 60;
        public static final int MAX_REG_EXPIRY = 86400;
    }

    public static final class EVENTING_ATTRIBUTES {
        public static final int MIN_SUB_EXPIRY = 60;
        public static final int MAX_SUB_EXPIRY = 86400;
    }

    public static enum TRANSPORT {
        TLS,
        TCP,
        UDP;


        public static TRANSPORT fromString(String transStr) {
            for (TRANSPORT t : TRANSPORT.values()) {
                if (!t.toString().equalsIgnoreCase(transStr)) continue;
                return t;
            }
            return UDP;
        }
    }

    public static final class ENTITY_TYPE {
        public static final String ASM = "ASM";
        public static final String SBC = "SBC";
        public static final String CM = "CM";
        public static final String VP = "VP";
        public static final String GW = "Gateway";
        public static final String TRK = "SIP Trunk";
        public static final String PS = "PS";
        public static final String ELIN = "ELIN";
        public static final String MMCS = "MMCS";
        public static final String AMS = "AMS";
        public static final String OTHER = "OTHER";
        public static final String SERVICE_PROVIDER = "SVCPRO";
        public static final String EDP = "CE";
        public static final String SURVIVABILITY_SERVER = "Survivability Server";
    }
}

