/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.CallHistoryAPI;
import com.avaya.asm.datamgr.dao.CallHistoryDAO;
import com.avaya.asm.datamgr.dao.cassandra.CassandraDAOFactory;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.helpers.CassandraConnectionInfo;
import com.avaya.asm.datamgr.objectapi.CallLog;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.CallHistoryKey;
import com.avaya.ustore.SMVersionChecker;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.utils.UUIDs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class CallHistoryDM
implements CallHistoryAPI {
    private final Logger log = AsmLogger.getLogger(CallHistoryDM.class);
    private CassandraDAOFactory<CallHistoryDAO> callHistoryDAOFactory = new CassandraDAOFactory();
    private CassandraConnectionInfo cConnInfo = null;
    private final List<UUID> emptyUUIDList = new ArrayList<UUID>();
    protected final SortByTimestampComparator sorter = new SortByTimestampComparator();
    private SMVersionChecker smVersionChecker = new SMVersionChecker("8.1.12");
    private static final UserStoreKeyspace globalUserDCKeyspace = new UserStoreKeyspace("global_user_dc");
    private Comparator<UUID> timeBasedUUIDComparator = new Comparator<UUID>(){

        @Override
        public int compare(UUID o1, UUID o2) {
            long t2;
            long t1 = UUIDs.unixTimestamp((UUID)o1);
            int rc = Long.compare(t1, t2 = UUIDs.unixTimestamp((UUID)o2));
            if (rc == 0) {
                rc = o1.compareTo(o2);
            }
            return rc;
        }
    };
    private Comparator<CallLog> callLogComparatorByUUID = new Comparator<CallLog>(){

        @Override
        public int compare(CallLog o1, CallLog o2) {
            return CallHistoryDM.this.timeBasedUUIDComparator.compare(o1.getUUID(), o2.getUUID());
        }
    };

    public SMVersionChecker getSmVersionChecker() {
        return this.smVersionChecker;
    }

    public CallHistoryDM(CassandraConnectionInfo cConnInfo) {
        this.cConnInfo = cConnInfo;
    }

    public CallHistoryDM() {
    }

    @Override
    public List<CallLog> addCallHistory(CallHistoryKey key, List<CallLog> callLogs) throws DMException {
        String fcn_name = "addCallHistory";
        boolean isFinest = this.log.isFinestEnabled();
        boolean isFiner = this.log.isFinerEnabled();
        long startTime = 0L;
        if (isFiner) {
            this.log.finer((Object)("addCallHistory: enter with key=" + key + ", callLogs.size()=" + callLogs.size()));
        }
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        List<CallLog> addCallLogs = callLogs;
        CallHistoryDAO dao = this.getCallHistoryDAO();
        Boolean rc = this.smVersionChecker.checkMinimumSMVersions();
        if (!Boolean.TRUE.equals(rc)) {
            if (isFinest) {
                this.log.finest((Object)("addCallHistory: smVersionChecker.checkMinimumSMVersions() returned " + rc + ". Since SMs version is less 8.1.12 calling updateCallhistory"));
            }
            this.updateCallHistory(key, 100, addCallLogs);
        } else {
            if (isFinest) {
                this.log.finest((Object)("addCallHistory: smVersionChecker.checkMinimumSMVersions() returned " + rc + ". Since SMs version is 8.1.12 or higher calling updateCallLogs directly"));
            }
            dao.updateCallLogs(key, this.emptyUUIDList, addCallLogs);
        }
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            this.log.finest((Object)("addCallHistory: dao.updateCallLogs took " + (endTime - startTime) + "ms"));
        }
        if (isFiner) {
            this.log.finer((Object)("addCallHistory: leave, addCallLogs.size = " + addCallLogs.size()));
        }
        return addCallLogs;
    }

    @Override
    public List<CallLog> updateCallHistory(CallHistoryKey key, Integer maxLogs, List<CallLog> callLogs) throws DMException {
        long endTime;
        String fcn_name = "updateCallHistory";
        boolean isFinest = this.log.isFinestEnabled();
        boolean isFiner = this.log.isFinerEnabled();
        long startTime = 0L;
        if (isFiner) {
            this.log.finer((Object)("updateCallHistory: enter with key=" + key + ", maxLog=" + maxLogs + ", callLogs.size()=" + callLogs.size()));
        }
        if (key == null) {
            this.log.warn((Object)"updateCallHistory: key was null");
            return null;
        }
        CallHistoryDAO dao = this.getCallHistoryDAO();
        List<CallLog> addCallLogs = callLogs;
        ArrayList<UUID> deleteUuids = null;
        int numToDelete = 0;
        if (maxLogs != null) {
            int totalNum;
            if (maxLogs <= 0) {
                throw new IllegalArgumentException("maxLogs is <= 0: " + maxLogs);
            }
            if (isFinest) {
                startTime = System.currentTimeMillis();
            }
            List<UUID> existingUuids = dao.getCallLogIds(key);
            if (isFinest) {
                endTime = System.currentTimeMillis();
                this.log.finest((Object)("updateCallHistory: dao.getCallLogIds took " + (endTime - startTime) + "ms, existingUuids.size=" + existingUuids.size()));
            }
            if ((totalNum = existingUuids.size() + callLogs.size()) > maxLogs) {
                addCallLogs = new ArrayList<CallLog>(callLogs.size());
                ArrayList<UUID> allUuids = new ArrayList<UUID>(existingUuids.size() + callLogs.size());
                ArrayList<CallLog> callLogsWithUUID = null;
                for (CallLog cl : callLogs) {
                    UUID uuid = cl.getUUID();
                    if (uuid != null) {
                        allUuids.add(cl.getUUID());
                        if (callLogsWithUUID == null) {
                            callLogsWithUUID = new ArrayList<CallLog>();
                        }
                        callLogsWithUUID.add(cl);
                        continue;
                    }
                    addCallLogs.add(cl);
                }
                int addCallLogsSize = addCallLogs.size();
                if (addCallLogsSize > maxLogs) {
                    addCallLogs = addCallLogs.subList(addCallLogsSize - maxLogs, addCallLogsSize);
                    addCallLogsSize = maxLogs;
                }
                allUuids.addAll(existingUuids);
                int allUuidsSize = allUuids.size();
                Collections.sort(allUuids, this.timeBasedUUIDComparator);
                deleteUuids = new ArrayList<UUID>();
                numToDelete = allUuidsSize + addCallLogsSize - maxLogs;
                if (isFinest) {
                    this.log.finest((Object)("updateCallHistory: allUuidsSize=" + allUuidsSize + ", numToDelete=" + numToDelete + ", addCallLogsSize=" + addCallLogsSize));
                }
                ListIterator it = allUuids.listIterator();
                int idx = 0;
                for (idx = 0; idx < numToDelete; ++idx) {
                    UUID uuid = (UUID)it.next();
                    if (Collections.binarySearch(existingUuids, uuid, this.timeBasedUUIDComparator) < 0) continue;
                    deleteUuids.add(uuid);
                }
                if (callLogsWithUUID != null) {
                    CallLog cl = new CallLog();
                    while (idx < allUuidsSize) {
                        UUID uuid = (UUID)it.next();
                        cl.setUUID(uuid);
                        int curIdx = Collections.binarySearch(callLogsWithUUID, cl, this.callLogComparatorByUUID);
                        if (curIdx >= 0) {
                            addCallLogs.add((CallLog)callLogsWithUUID.get(curIdx));
                        }
                        ++idx;
                    }
                }
                if (isFinest) {
                    this.log.finest((Object)("updateCallHistory: deleteUuids=" + deleteUuids + " , addCallLogs=" + addCallLogs));
                }
            }
        }
        if (isFinest) {
            startTime = System.currentTimeMillis();
            this.log.finest((Object)("updateCallHistory: We will now update the call logs for: " + key));
        }
        dao.updateCallLogs(key, deleteUuids, addCallLogs);
        if (isFinest) {
            endTime = System.currentTimeMillis();
            this.log.finest((Object)("updateCallHistory: dao.updateCallLogs took " + (endTime - startTime) + "ms, deleteUuids.size=" + (deleteUuids != null ? deleteUuids.size() : -1)));
        }
        if (isFiner) {
            this.log.finer((Object)("updateCallHistory: leave, addCallLogs.size = " + addCallLogs.size()));
        }
        return addCallLogs;
    }

    @Override
    public void deleteCallHistoryById(CallHistoryKey key, List<UUID> callLogUuids) throws DMException {
        CallHistoryDAO dao = this.getCallHistoryDAO();
        dao.deleteCallLogs(key, callLogUuids);
    }

    @Override
    public void deleteCallHistoryByLimit(CallHistoryKey key, int maxLogs) throws DMException {
        String fcn_name = "deleteCallHistoryByLimit";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("deleteCallHistoryByLimit: enter with key=" + key + ", maxLogs=" + maxLogs));
        }
        if (key == null) {
            this.log.warn((Object)"deleteCallHistoryByLimit: key was null ");
            return;
        }
        CallHistoryDAO dao = this.getCallHistoryDAO();
        if (maxLogs == 0) {
            try {
                dao.deleteAllCallLogs(key, false);
            }
            catch (DMException e) {
                Throwable cause = e.getNestedException();
                if (cause instanceof InvalidQueryException) {
                    this.log.warn((Object)("deleteCallHistoryByLimit : Delete CallLog query failed with :" + cause.getMessage()));
                }
                dao.deleteAllCallLogs(key, true);
            }
        } else {
            List<UUID> deleteUuids = null;
            List<UUID> allUuids = dao.getCallLogIds(key);
            int numToDelete = allUuids.size() - maxLogs;
            if (numToDelete > 0) {
                deleteUuids = allUuids.subList(0, numToDelete);
                dao.deleteCallLogs(key, deleteUuids);
            }
        }
        if (isFiner) {
            this.log.finer((Object)"deleteCallHistoryByLimit: leave");
        }
    }

    @Override
    public List<CallLog> getCallHistory(CallHistoryKey key, Integer maxLogs) throws DMException {
        return this.getCallHistory(key, maxLogs, false);
    }

    @Override
    public List<CallLog> getCallHistory(CallHistoryKey key, Integer maxLogs, boolean includeSpecialCL) throws DMException {
        String fcn_name = "getCallHistory";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("getCallHistory: enter with key =" + key + ", maxLogs=" + maxLogs));
        }
        if (key == null) {
            this.log.warn((Object)"getCallHistory: key was null ");
            return null;
        }
        CallHistoryDAO dao = this.getCallHistoryDAO();
        List<CallLog> allCallLogs = dao.getCallHistory(key, null);
        if (isFinest) {
            this.log.finest((Object)("getCallHistory: DB returned callLogs.size()=" + allCallLogs.size()));
        }
        this.removeDuplicateCallHistoryRecords(key, allCallLogs);
        boolean maxLogCheck = maxLogs != null && maxLogs > 0;
        boolean specialCLExists = false;
        int size = allCallLogs.size();
        if (size > 0) {
            CallLog callLog = allCallLogs.get(0);
            if (callLog.getUUID().equals(dao.getMinTimeUUID())) {
                specialCLExists = true;
                if (!includeSpecialCL) {
                    allCallLogs.remove(0);
                    --size;
                    specialCLExists = false;
                    if (isFinest) {
                        this.log.finest((Object)("getCallHistory: removed special CL from call log list, new size=" + size));
                    }
                } else if (isFinest) {
                    this.log.finest((Object)("getCallHistory: keeping the special CL in the calllog list, size=" + size));
                }
            } else if (isFinest) {
                this.log.finest((Object)("getCallHistory: no special CL in the calllog list, size=" + size));
            }
        }
        if (maxLogCheck) {
            int firstIdx = specialCLExists ? 1 : 0;
            int numDelete = 0;
            if (size - firstIdx > maxLogs) {
                numDelete = size - maxLogs - firstIdx;
            }
            if (isFinest) {
                this.log.finest((Object)("getCallHistory: firstIdx=" + firstIdx + ", size=" + size + ", maxLogs=" + maxLogs + ", numDelete=" + numDelete));
            }
            for (int i = 0; i < numDelete; ++i) {
                allCallLogs.remove(firstIdx);
            }
        }
        if (isFiner) {
            this.log.finer((Object)("getCallHistory: leave, allCallLogs.size()=" + allCallLogs.size()));
        }
        return allCallLogs;
    }

    @Override
    public void moveCallHistory(CallHistoryKey oldKey, CallHistoryKey newKey) throws DMException {
        String fcn_name = "moveCallHistory";
        boolean isFinest = this.log.isFinestEnabled();
        if (oldKey != null && oldKey.equals(newKey)) {
            return;
        }
        List<CallLog> oldKSCallLogs = this.getCallHistory(oldKey, 100);
        if (oldKSCallLogs == null || oldKSCallLogs.isEmpty()) {
            if (isFinest) {
                this.log.finest((Object)("moveCallHistory: Tried to move the user's Call Logs, but no call logs were found for oldCallHistoryKeyInfo: " + oldKey));
            }
            return;
        }
        List<CallLog> updatedOldKSCallLogs = null;
        updatedOldKSCallLogs = newKey != null && newKey.getKeyspace().equals(globalUserDCKeyspace) ? this.filterOutExpiredCallLogs(newKey, oldKSCallLogs) : oldKSCallLogs;
        if (updatedOldKSCallLogs != null && !updatedOldKSCallLogs.isEmpty()) {
            if (isFinest) {
                this.log.finest((Object)("moveCallHistory : size of updated callLogs of oldKeyspace after removing expired callLogs is : " + updatedOldKSCallLogs.size()));
            }
            this.updateCallHistory(newKey, 100, updatedOldKSCallLogs);
        } else if (isFinest) {
            this.log.finest((Object)("moveCallHistory: All the callLogs of keyspace : " + oldKey.getKeyspace().getName() + " is expired. Nothing to move. updatedOldKSCallLogs : " + updatedOldKSCallLogs));
        }
        this.deleteAllCallHistory(oldKey);
    }

    protected List<CallLog> filterOutExpiredCallLogs(CallHistoryKey newKey, List<CallLog> callLogs) throws DMException {
        String fcn_name = "filterOutExpiredCallLogs";
        boolean isFinest = this.log.isFinestEnabled();
        boolean isFiner = this.log.isFinerEnabled();
        List<CallLog> filteredCallLogs = null;
        int expiredCLCount = 0;
        CallHistoryDAO dao = this.getCallHistoryDAO();
        long currentTTL = dao.getCurrentTTL(newKey.getKeyspace(), "calllog");
        if (currentTTL > 0L) {
            long currentTime = System.currentTimeMillis();
            for (CallLog calllog : callLogs) {
                long currentCLTime = 0L;
                long calllogTimestamp = 0L;
                try {
                    calllogTimestamp = UUIDs.unixTimestamp((UUID)calllog.getUUID());
                }
                catch (IllegalArgumentException e) {
                    this.log.warn((Object)("filterOutExpiredCallLogs : provided argument calllog.getUUID - " + calllog.getUUID() + " is Illegal, for UUIDs.unixTimestamp()"));
                }
                if (calllogTimestamp < currentTime) {
                    currentCLTime = TimeUnit.MILLISECONDS.toSeconds(currentTime - calllogTimestamp);
                }
                if (currentTTL <= currentCLTime) {
                    ++expiredCLCount;
                    if (!isFinest) continue;
                    this.log.finest((Object)("filterOutExpiredCallLogs : calllog - " + calllog + ", is expired with currentCLTime - " + currentCLTime));
                    continue;
                }
                if (filteredCallLogs == null) {
                    filteredCallLogs = new ArrayList<CallLog>();
                }
                filteredCallLogs.add(calllog);
            }
        } else {
            filteredCallLogs = callLogs;
        }
        if (isFiner) {
            this.log.finer((Object)("filterOutExpiredCallLogs : count of expired callLogs is - " + expiredCLCount));
        }
        return filteredCallLogs;
    }

    @Override
    public void deleteAllCallHistory(CallHistoryKey key) throws DMException {
        this.deleteAllCallHistory(key, true);
    }

    @Override
    public void deleteAllCallHistory(CallHistoryKey key, boolean deleteSpecialLog) throws DMException {
        this.getCallHistoryDAO().deleteAllCallLogs(key, deleteSpecialLog);
    }

    protected CallHistoryDAO getCallHistoryDAO() throws DMException {
        String fcn_name = "getCallHistoryDAO";
        CallHistoryDAO dao = this.callHistoryDAOFactory.getDAOInstance(this.cConnInfo, CallHistoryDAO.class);
        if (dao == null) {
            String msg = "getCallHistoryDAO: getDAOInstance failed, cConnInfo=" + this.cConnInfo;
            this.log.error((Object)msg);
            throw new DMException(msg);
        }
        return dao;
    }

    @Override
    public void getSetIdsForKeyspace(UserStoreKeyspace keyspace, CassandraConnectionInfo cConnInfo, Collection<Long> ids) throws DMException {
        CallHistoryDAO dao = this.getCallHistoryDAO();
        dao.getSetIdsForKeyspace(keyspace, cConnInfo, ids);
    }

    @Override
    public void removeDuplicateCallHistoryRecords(CallHistoryKey key, List<CallLog> callLogsFromDb) throws DMException {
        String fcn_name = "removeDuplicateCallHistoryRecords";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        ArrayList<UUID> uuidsToDelete = null;
        if (isFiner) {
            this.log.finer((Object)("removeDuplicateCallHistoryRecords: Enter with Call History Key: " + key + " and callLogsfromDB size: " + callLogsFromDb.size()));
        }
        block0: for (int i = 0; i < callLogsFromDb.size() - 1; ++i) {
            CallLog currentCallLog = callLogsFromDb.get(i);
            if (isFinest) {
                this.log.finest((Object)("removeDuplicateCallHistoryRecords: callLog from the DB #" + i + ": " + currentCallLog));
            }
            int j = i + 1;
            while (j < callLogsFromDb.size()) {
                CallLog compareCallLog = callLogsFromDb.get(j);
                if (isFinest) {
                    this.log.finest((Object)("removeDuplicateCallHistoryRecords: callLog from the DB #" + j + ": " + compareCallLog + " to compare with the previous call log to see if it's a duplicate or not."));
                }
                if (compareCallLog.getTimestamp() - currentCallLog.getTimestamp() > 5000L) {
                    if (!isFinest) continue block0;
                    this.log.finest((Object)"removeDuplicateCallHistoryRecords: The timestamps of the call Logs are more than 5 seconds apart, move onto the next one.");
                    continue block0;
                }
                if (currentCallLog.isDuplicateCallLogByFieldEquality(compareCallLog)) {
                    if (isFinest) {
                        this.log.finest((Object)"removeDuplicateCallHistoryRecords: Found callLog to remove because it's a duplicate.");
                    }
                    if (uuidsToDelete == null) {
                        uuidsToDelete = new ArrayList<UUID>();
                    }
                    if (currentCallLog.getDialogId() == null && compareCallLog.getDialogId() != null) {
                        uuidsToDelete.add(currentCallLog.getUUID());
                        callLogsFromDb.remove(i);
                        continue;
                    }
                    if (currentCallLog.getDialogId() != null && compareCallLog.getDialogId() == null) {
                        uuidsToDelete.add(compareCallLog.getUUID());
                        callLogsFromDb.remove(j);
                        continue;
                    }
                    uuidsToDelete.add(compareCallLog.getUUID());
                    callLogsFromDb.remove(j);
                    continue;
                }
                ++j;
                if (!isFinest) continue;
                this.log.finest((Object)"removeDuplicateCallHistoryRecords: The two call logs we just compared don't match, so the callLogsfromDB size remains the same. ");
            }
        }
        if (isFinest) {
            this.log.finest((Object)("removeDuplicateCallHistoryRecords: Final callLogsfromDB size: " + callLogsFromDb.size()));
        }
        if (uuidsToDelete != null && !uuidsToDelete.isEmpty()) {
            if (isFinest) {
                this.log.finest((Object)("removeDuplicateCallHistoryRecords: uuidsToDelete size: " + uuidsToDelete.size()));
            }
            this.deleteCallHistoryById(key, (List<UUID>)uuidsToDelete);
        }
        if (isFiner) {
            this.log.finer((Object)"removeDuplicateCallHistoryRecords: Leaving");
        }
    }

    @Override
    public boolean checkAndSetTimeToLive(UserStoreKeyspace keyspace, long seconds) throws DMException {
        String fcn_name = "checkAndSetTimeToLive";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("checkAndSetTimeToLive: enter with seconds = " + seconds));
        }
        if (seconds < 0L) {
            throw new IllegalArgumentException("checkAndSetTimeToLiveInvalid value of TTL, It can't be negative : " + seconds);
        }
        CallHistoryDAO dao = this.getCallHistoryDAO();
        boolean fcnRC = dao.checkAndSetTimeToLive(keyspace, seconds);
        if (isFiner) {
            this.log.finer((Object)"checkAndSetTimeToLive: leave");
        }
        return fcnRC;
    }

    @Override
    public boolean calllogsMigratedToGlobalDC(long cscommprofilesetId) throws DMException {
        String fcn_name = "calllogsMigratedToGlobalDC";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("calllogsMigratedToGlobalDC: enter with cscommprofilesetId = " + cscommprofilesetId));
        }
        CallHistoryDAO dao = this.getCallHistoryDAO();
        boolean fcnRC = dao.calllogsMigratedToGlobalDC(cscommprofilesetId);
        if (isFiner) {
            this.log.finer((Object)("calllogsMigratedToGlobalDC: leave with isCalllogsMigratedToGlobalDC : " + fcnRC));
        }
        return fcnRC;
    }

    @Override
    public void setMigrationCallLog(long cscommprofilesetId) throws DMException {
        String fcn_name = "setMigrationCallLog";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("setMigrationCallLog: enter with cscommprofilesetId = " + cscommprofilesetId));
        }
        CallHistoryDAO dao = this.getCallHistoryDAO();
        dao.setMigrationCallLog(cscommprofilesetId);
        if (isFiner) {
            this.log.finer((Object)"setMigrationCallLog: leave");
        }
    }

    public UUID getMinTimeUUID() throws DMException {
        String fcn_name = "getMinTimeUUID";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"CallHistoryDM.getMinTimeUUID : enter.");
        }
        CallHistoryDAO dao = this.getCallHistoryDAO();
        return dao.getMinTimeUUID();
    }

    class SortByTimestampComparator
    implements Comparator<CallLog> {
        SortByTimestampComparator() {
        }

        @Override
        public int compare(CallLog callLog1, CallLog callLog2) {
            Long clTimestamp2;
            Long clTimestamp1 = callLog1.getTimestamp();
            if (clTimestamp1.equals(clTimestamp2 = Long.valueOf(callLog2.getTimestamp()))) {
                return 0;
            }
            if (clTimestamp1 < clTimestamp2) {
                return -1;
            }
            return 1;
        }
    }
}

