/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.datamgr.BLDMEnumType;
import com.avaya.asm.datamgr.BusinessLogicDM;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.CmCommProfileDAO;
import com.avaya.asm.datamgr.dao.CsDomainDAO;
import com.avaya.asm.datamgr.dao.CsHandleDAO;
import com.avaya.asm.datamgr.dao.GlobalDAO;
import com.avaya.asm.datamgr.dao.UserDAO;
import com.avaya.asm.datamgr.dao.ppm.ContactAddressDAO;
import com.avaya.asm.datamgr.dao.ppm.ContactDAO;
import com.avaya.asm.datamgr.dao.ppm.ContactListMemberDAO;
import com.avaya.asm.datamgr.dao.ppm.ContactOnDemandDAO;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.asm.datamgr.objectapi.CmCommProfile;
import com.avaya.asm.datamgr.objectapi.CsHandle;
import com.avaya.asm.datamgr.objectapi.User;
import com.avaya.asm.datamgr.objectapi.ppm.ContactAddress;
import com.avaya.asm.datamgr.objectapi.ppm.ContactListMember;
import com.avaya.common.logging.client.Logger;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EndpointAgentDM
extends BusinessLogicDM {
    protected final Logger log = Logger.getLogger(EndpointAgentDM.class);
    private static DMFactory factory;

    public static DMFactory getFactory() {
        if (factory == null) {
            factory = DMFactory.getInstance();
        }
        return factory;
    }

    public void setFactory(DMFactory dmFactory) {
        factory = dmFactory;
    }

    @Override
    public EnumSet<? extends BLDMEnumType> getDMUsages() {
        return EnumSet.allOf(EndpointAgentBLDM.class);
    }

    @Override
    public void init() {
        this.log.info((Object)"Started initializing EndpointAgentDM");
        DataMgr.Status status = DataMgr.Status.OKAY;
        for (EndpointAgentBLDM dm : EndpointAgentBLDM.values()) {
            DataMgr dataMgr = dm.get();
            if (dataMgr.okay()) continue;
            status = DataMgr.Status.FAIL;
            this.log.error((Object)("Failed to init: " + dm));
        }
        this.setStatus(status);
        this.log.info((Object)"Finished initializing EndpointAgentDM");
    }

    public String getContactAddressCategoryName(long categoryId) {
        return ((ContactAddressDAO)EndpointAgentBLDM.CONTACT_ADDRESS_DAO.get()).getContactCategoryName(categoryId);
    }

    public String getContactAddressTypeName(Integer typeId) {
        return ((ContactAddressDAO)EndpointAgentBLDM.CONTACT_ADDRESS_DAO.get()).getContactTypeName(Long.parseLong(typeId.toString()));
    }

    public List<Long> getCsContactForContactAddressId(long csContactAddressId) {
        return ((ContactAddressDAO)EndpointAgentBLDM.CONTACT_ADDRESS_DAO.get()).getIdsFromCsContactAddressId(csContactAddressId);
    }

    public String getHandleDomainName(long id) {
        return null;
    }

    public String getDomainName(long domainId) {
        return ((CsDomainDAO)EndpointAgentBLDM.CS_DOMAIN_DAO.get()).getCsDomain(domainId);
    }

    public CmCommProfile getCmCommProfileBySetId(long setId) {
        return ((CmCommProfileDAO)EndpointAgentBLDM.CM_COMM_PROFILE_DAO.get()).getCmCommProfileBySetId(setId);
    }

    public List<AsmInstance> getAsmInstancesForCsUserId(Long csUserId) {
        Map<Long, Integer> asmInstanceIdsAndPOmap = ContactOnDemandDAO.getListOfAsmInstanceIdsForCsUserId(csUserId);
        ArrayList<AsmInstance> asmInstanceList = new ArrayList<AsmInstance>();
        AsmInstanceDAO asmInstanceDAO = (AsmInstanceDAO)EndpointAgentBLDM.ASM_INSTANCE_DAO.get();
        if (asmInstanceIdsAndPOmap != null) {
            for (Long asmInstanceId : asmInstanceIdsAndPOmap.keySet()) {
                AsmInstance asmInstance = asmInstanceDAO.getAsmInstance(asmInstanceId);
                if (asmInstance == null) continue;
                asmInstanceList.add(asmInstance);
            }
        }
        return asmInstanceList;
    }

    public ContactListMember getCLMFromEvent(DAOTableEvent event) {
        return ((ContactListMemberDAO)EndpointAgentBLDM.CLM_DAO.get()).getContactListMemberFromEvent(event);
    }

    public User getUser(Long ownerCsUserId) {
        return ((UserDAO)EndpointAgentBLDM.USER_DAO.get()).getUser(ownerCsUserId);
    }

    public Set<CsHandle> getHandles(long setId) {
        return ((CsHandleDAO)EndpointAgentBLDM.CS_HANDLE_DAO.get()).getHandles(setId);
    }

    public String getCsDomain(long domainId) {
        return ((CsDomainDAO)EndpointAgentBLDM.CS_DOMAIN_DAO.get()).getCsDomain(domainId);
    }

    public AsmInstance getAsmInstance(long asmInstanceId) {
        return ((AsmInstanceDAO)EndpointAgentBLDM.ASM_INSTANCE_DAO.get()).getAsmInstance(asmInstanceId);
    }

    public User getCsUserFromContactListId(long csContactListId) {
        return ((UserDAO)EndpointAgentBLDM.USER_DAO.get()).getUserForContactListId(csContactListId);
    }

    public User getCsUserFromUserId(long userId) {
        return ((UserDAO)EndpointAgentBLDM.USER_DAO.get()).getUser(userId);
    }

    public Set<Long> getAllContactListIds() {
        return ((UserDAO)EndpointAgentBLDM.USER_DAO.get()).getAllContactListIds();
    }

    public Map<Long, Long> getUserIdToContactListIdMap() {
        return ((UserDAO)EndpointAgentBLDM.USER_DAO.get()).getUserIdToContactListIdMap();
    }

    public List<ContactListMember> getAllContactListMembers(Long contactListId) {
        return ((ContactListMemberDAO)EndpointAgentBLDM.CLM_DAO.get()).getAllContactListMembers(contactListId);
    }

    public String getEnableStorageCluster() {
        return "true";
    }

    public String getHandleTypeName(long typeId) {
        return ((CsHandleDAO)EndpointAgentBLDM.CS_HANDLE_DAO.get()).getCsHandleType(typeId);
    }

    public String getHandleSubTypeName(Integer subTypeId) {
        return ((CsHandleDAO)EndpointAgentBLDM.CS_HANDLE_DAO.get()).getCsHandleSubType(Long.parseLong(subTypeId.toString()));
    }

    public List<ContactAddress> getContactAddressList(Long contactId, Long csPrivContInfoId) {
        if (contactId == null && csPrivContInfoId == null) {
            return null;
        }
        return ContactOnDemandDAO.loadContactAddressList(contactId, csPrivContInfoId);
    }

    public List<Long> getListOfCommunityIdsAssociatedWithAsmInstanceId(long asmInstanceId) {
        return ContactOnDemandDAO.getListOfCommunityIdsAssociatedWithAsmInstanceId(asmInstanceId);
    }

    public List<ContactOnDemandDAO.UserInitialLoadData> getUserILDataListForCommunityId(long communityId) {
        return ContactOnDemandDAO.getUserILDataListForCommunityId(communityId);
    }

    public static enum EndpointAgentBLDM implements BLDMEnumType
    {
        ASM_INSTANCE_DAO(AsmInstanceDAO.class),
        USER_DAO(UserDAO.class),
        CS_DOMAIN_DAO(CsDomainDAO.class),
        CM_COMM_PROFILE_DAO(CmCommProfileDAO.class),
        CONTACT_ADDRESS_DAO(ContactAddressDAO.class),
        CLM_DAO(ContactListMemberDAO.class),
        CONTACT_DAO(ContactDAO.class),
        CS_HANDLE_DAO(CsHandleDAO.class),
        GLOBAL_DAO(GlobalDAO.class);

        private DataMgr subDM;

        private EndpointAgentBLDM(Class<? extends DataMgr> dmClass) {
            this.subDM = EndpointAgentDM.getFactory().getDataMgr(dmClass);
        }

        @Override
        public DataMgr get() {
            return this.subDM;
        }
    }
}

