/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.LoadBalancerAPI;
import com.avaya.asm.datamgr.dao.cassandra.CassandraDAOFactory;
import com.avaya.asm.datamgr.dao.ustore.LoadBalancerDAO1;
import com.avaya.asm.datamgr.helpers.CassandraConnectionInfo;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.objectapi.LoadBalancerData;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class LoadBalancerDM
implements LoadBalancerAPI {
    private final Logger log = AsmLogger.getLogger(LoadBalancerDM.class);
    private CassandraDAOFactory<LoadBalancerDAO1> loadBalancerDAOFactory = new CassandraDAOFactory();
    private CassandraConnectionInfo cConnInfo = null;
    private static final String KEYSPACE = "loadbalancer";
    private static final String COLUMNFAMILYNAME = "resolvedaddress";
    private static final boolean RETRY_DOWNGRADING_CONSISTENCY = true;

    public LoadBalancerDM(CassandraConnectionInfo cConnInfo) {
        this.cConnInfo = cConnInfo;
    }

    public LoadBalancerDM() {
    }

    @Override
    public List<String> getAllKeysByResolvedAddress(long loadBalancerId, String addr) throws DMException {
        String fcn_name = "getAllKeysByResolvedAddress";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        long startTime = 0L;
        List<String> keyList = null;
        if (isFiner) {
            this.log.finer((Object)("getAllKeysByResolvedAddress: enter with loadbalancerId=" + loadBalancerId + ", addr=" + addr));
        }
        LoadBalancerDAO1 loadBalancerDAO = this.getLoadBalancerDAO();
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        if (loadBalancerId <= 0L || addr == null) {
            this.log.error((Object)("Illegal argument passed loadBalancerId=" + loadBalancerId + " and addr=" + addr));
            throw new IllegalArgumentException("LoadbalancerId: " + loadBalancerId + " and addr: " + addr);
        }
        keyList = loadBalancerDAO.getAllKeysByResolvedAddress(loadBalancerId, addr);
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            this.log.finest((Object)("getAllKeysByResolvedAddress: loadBalancerDAO.getAllKeysByResolvedAddress() took " + (endTime - startTime) + " ms."));
        }
        if (isFiner) {
            this.log.finer((Object)("getAllKeysByResolvedAddress: leave, keyList.size=" + (keyList == null ? null : Integer.valueOf(keyList.size()))));
        }
        return keyList;
    }

    @Override
    public String queryResolvedAddress(long loadBalancerId, String key) throws DMException {
        String fcn_name = "queryResolvedAddress";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        long startTime = 0L;
        String resolvedAddress = null;
        if (isFiner) {
            this.log.finer((Object)("queryResolvedAddress: enter with loadbalancerId=" + loadBalancerId + ", key=" + key));
        }
        LoadBalancerDAO1 loadBalancerDAO = this.getLoadBalancerDAO();
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        if (loadBalancerId > 0L && key != null) {
            resolvedAddress = loadBalancerDAO.queryResolvedAddress(loadBalancerId, key);
            if (isFinest) {
                long endTime = System.currentTimeMillis();
                this.log.finest((Object)("queryResolvedAddress: loadBalancerDAO.queryResolvedAddress() took " + (endTime - startTime) + " ms."));
            }
            return resolvedAddress;
        }
        this.log.error((Object)("Illegal argument passed loadBalancerId=" + loadBalancerId + " and Key=" + key));
        throw new IllegalArgumentException("LoadbalancerId: " + loadBalancerId + " and Key: " + key);
    }

    @Override
    public String setResolvedAddress(long loadBalancerId, String key, String addr, LoadBalancerAPI.ConsistencyScope cScope) throws DMException {
        String fcn_name = "setResolvedAddress";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        long startTime = 0L;
        String resolved_address = null;
        if (isFiner) {
            this.log.finer((Object)("setResolvedAddress: enter with loadbalancerId=" + loadBalancerId + ", key=" + key + ",addr=" + addr + ",cScope=" + (Object)((Object)cScope)));
        }
        LoadBalancerDAO1 loadBalancerDAO = this.getLoadBalancerDAO();
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        if (loadBalancerId < 0L && key == null) {
            this.log.error((Object)("Illegal argument passed loadBalancerId=" + loadBalancerId + " and Key=" + key));
            throw new IllegalArgumentException("LoadbalancerId: " + loadBalancerId + " and Key: " + key);
        }
        resolved_address = loadBalancerDAO.setResolvedAddress(loadBalancerId, key, addr, cScope, true);
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            this.log.finest((Object)("setResolvedAddress: loadBalancerDAO.setResolvedAddress() took " + (endTime - startTime) + " ms."));
        }
        if (isFiner) {
            this.log.finer((Object)("setResolvedAddress: Leave with resolved_address=" + resolved_address));
        }
        return resolved_address;
    }

    @Override
    public String compareAndSetResolvedAddress(long loadBalancerId, String key, String addr, String expect, LoadBalancerAPI.ConsistencyScope cScope) throws DMException {
        String fcn_name = "compareAndSetResolvedAddress";
        boolean isFiner = this.log.isFinerEnabled();
        String resolved_address = null;
        if (isFiner) {
            this.log.finer((Object)("compareAndSetResolvedAddress: enter with loadbalancerId=" + loadBalancerId + ", key=" + key + ",addr=" + addr + ",expect=" + expect + ",cScope=" + (Object)((Object)cScope)));
        }
        LoadBalancerDAO1 loadBalancerDAO = this.getLoadBalancerDAO();
        if (loadBalancerId < 0L || key == null || expect == null && addr == null) {
            this.log.error((Object)("Illegal argument passed loadBalancerId=" + loadBalancerId + " and Key=" + key));
            throw new IllegalArgumentException("LoadbalancerId: " + loadBalancerId + " and Key: " + key + ", expected address: " + expect + ", toBeSetAddress: " + addr);
        }
        resolved_address = loadBalancerDAO.compareAndSetResolvedLocation(loadBalancerId, key, expect, addr, cScope, true);
        if (isFiner) {
            this.log.finer((Object)("compareAndSetResolvedAddress: Leave with resolved_address=" + resolved_address));
        }
        return resolved_address;
    }

    protected LoadBalancerDAO1 getLoadBalancerDAO() throws DMException {
        String fcn_name = "getLoadBalancerDAO";
        LoadBalancerDAO1 dao = this.loadBalancerDAOFactory.getDAOInstance(this.cConnInfo, LoadBalancerDAO1.class);
        if (dao == null) {
            String msg = "getLoadBalancerDAO: getDAOInstance failed, cConnInfo=" + this.cConnInfo;
            this.log.error((Object)msg);
            throw new DMException(msg);
        }
        return dao;
    }

    @Override
    public void deleteByResolvedAddress(long loadBalancerId, String addr) throws DMException {
        String fcn_name = "getAllResolvedAddress";
        boolean isFinest = this.log.isFinestEnabled();
        boolean isFiner = this.log.isFinerEnabled();
        long keySize = 0L;
        if (isFiner) {
            this.log.finer((Object)("getAllResolvedAddressenter with loadBalancerId=" + loadBalancerId + ", and resolved_address=" + addr));
        }
        LoadBalancerDAO1 loadBalancerDAO = this.getLoadBalancerDAO();
        ArrayList<String> keys = new ArrayList<String>();
        if (loadBalancerId <= 0L) {
            throw new IllegalArgumentException("LoadbalancerId: " + loadBalancerId + ", and resolvedAddress: " + addr);
        }
        loadBalancerDAO.getKeys(loadBalancerId, addr, keys);
        keySize = keys.size();
        if (keySize > 0L) {
            loadBalancerDAO.deleteKeys(loadBalancerId, keys);
        } else if (isFinest) {
            this.log.finest((Object)("No keys found for loadBalancerId=" + loadBalancerId + ", and resolvedAddress=" + addr));
        }
        if (isFiner) {
            this.log.finer((Object)"getAllResolvedAddressLeave");
        }
    }

    @Override
    public void resolvedAddressByLoadbalancerId(long loadBalancerId, Map<String, String> resolvedAddressesByloadbalancerId) throws DMException {
        String fcn_name = "resolvedAddressByLoadbalacerId";
        boolean isFiner = this.log.isFinerEnabled();
        LoadBalancerDAO1 loadBalancerDAO = this.getLoadBalancerDAO();
        if (isFiner) {
            this.log.finer((Object)("resolvedAddressByLoadbalacerIdenter with loadBalancerId=" + loadBalancerId));
        }
        loadBalancerDAO.resolvedAddressByLoadbalancerId(loadBalancerId, resolvedAddressesByloadbalancerId);
        if (isFiner) {
            this.log.finer((Object)("resolvedAddressByLoadbalacerIdLeave with loadBalancerData of size=" + resolvedAddressesByloadbalancerId.size()));
        }
    }

    @Override
    public void touch(long loadBalancerId, String key) throws DMException {
        String fcn_name = "touch";
        boolean isFiner = this.log.isFinerEnabled();
        String address = null;
        if (isFiner) {
            this.log.finer((Object)("touchenter with loadBalancerId =" + loadBalancerId + " and key=" + key));
        }
        address = this.queryResolvedAddress(loadBalancerId, key);
        this.compareAndSetResolvedAddress(loadBalancerId, key, address, address, LoadBalancerAPI.ConsistencyScope.DATACENTER_LEVEL);
        if (isFiner) {
            this.log.finer((Object)"touchLeave ");
        }
    }

    @Override
    public int getDefaultTimeToLive() throws DMException {
        String fcn_name = "getDefaultTimeToLive";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"getDefaultTimeToLiveenter");
        }
        LoadBalancerDAO1 loadBalancerDAO = this.getLoadBalancerDAO();
        int defaultTimeToLive = loadBalancerDAO.getDefaultTimeToLive(KEYSPACE, COLUMNFAMILYNAME);
        if (isFiner) {
            this.log.finer((Object)("getDefaultTimeToLiveLeave with defaultTimeToLive " + defaultTimeToLive));
        }
        return defaultTimeToLive;
    }

    @Override
    public void getAllRecordsByLocalTokenRanges(List<InetAddress> downNodes, Collection<LoadBalancerData> lbDataRecs, LoadBalancerAPI.DataFilter filter) throws DMException {
        String fcn_name = "getAllRecordsByLocalTokenRanges";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getAllRecordsByLocalTokenRangesenter, downNodes=" + downNodes));
        }
        LoadBalancerDAO1 loadBalancerDAO = this.getLoadBalancerDAO();
        loadBalancerDAO.getAllRecordsByLocalTokenRanges(downNodes, lbDataRecs, filter);
        if (isFiner) {
            this.log.finer((Object)("getAllRecordsByLocalTokenRangesleave, with lbDataRecs.size=" + lbDataRecs.size()));
        }
    }

    @Override
    public void deleteResolvedAddresses(long loadBalancerId, Collection<String> keys) throws DMException {
        String fcn_name = "deleteResolvedAddress";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("deleteResolvedAddressenter, loadBalancerId=" + loadBalancerId + ", keys.size=" + keys.size()));
        }
        LoadBalancerDAO1 loadBalancerDAO = this.getLoadBalancerDAO();
        loadBalancerDAO.deleteKeys(loadBalancerId, keys);
        if (isFiner) {
            this.log.finer((Object)"deleteResolvedAddress: leave");
        }
    }

    @Override
    public void deleteResolvedAddresses(Collection<LoadBalancerData> lbDataRecords) throws DMException {
        String fcn_name = "deleteResolvedAddress";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("deleteResolvedAddressenter, lbDataRecords.size=" + lbDataRecords.size()));
        }
        LoadBalancerDataSublistIterator lbDataListIter = new LoadBalancerDataSublistIterator(lbDataRecords, 500);
        LoadBalancerDAO1 loadBalancerDAO = this.getLoadBalancerDAO();
        ArrayList<String> keyList = new ArrayList<String>();
        int numLists = 0;
        int numRecs = 0;
        while (lbDataListIter.hasNext()) {
            List<LoadBalancerData> lbDataList = lbDataListIter.next();
            if (lbDataList.isEmpty()) {
                this.log.warn((Object)"deleteResolvedAddress: lbDataListIter.hasNext() returned true but next() returned an empty list");
                break;
            }
            keyList.clear();
            long loadBalancerId = lbDataList.get(0).getLoadbalancerId();
            for (LoadBalancerData lbd : lbDataList) {
                keyList.add(lbd.getKey());
            }
            numRecs += keyList.size();
            ++numLists;
            if (isFinest) {
                this.log.finest((Object)("deleteResolvedAddress: calling loadBalancerDAO.deleteKeys(), loadBalancerId=" + loadBalancerId + ", keyList.size=" + keyList.size()));
            }
            loadBalancerDAO.deleteKeys(loadBalancerId, keyList);
        }
        if (isFiner) {
            this.log.finer((Object)("deleteResolvedAddress: leave, numLists=" + numLists + ", numRecs=" + numRecs));
        }
    }

    private class LoadBalancerDataSublistIterator {
        private ArrayList<LoadBalancerData> lbDataList;
        private int startIdx = 0;
        private int listSize;
        private int maxListSize;

        public LoadBalancerDataSublistIterator(Collection<LoadBalancerData> lbDataRecs, int maxListSize) {
            this.init(lbDataRecs, maxListSize);
        }

        public LoadBalancerDataSublistIterator(Collection<LoadBalancerData> lbDataRecs) {
            this.init(lbDataRecs, null);
        }

        private void init(Collection<LoadBalancerData> lbDataRecs, Integer maxListSize) {
            this.lbDataList = new ArrayList<LoadBalancerData>(lbDataRecs);
            Collections.sort(this.lbDataList);
            this.listSize = this.lbDataList.size();
            this.maxListSize = maxListSize != null ? maxListSize : this.listSize;
        }

        public boolean hasNext() {
            return this.startIdx < this.listSize;
        }

        public List<LoadBalancerData> next() {
            long nextLbId;
            int idx;
            if (!this.hasNext()) {
                return null;
            }
            long lbId = this.lbDataList.get(this.startIdx).getLoadbalancerId();
            int maxIdx = this.listSize - this.startIdx > this.maxListSize ? this.startIdx + this.maxListSize : this.listSize;
            for (idx = this.startIdx + 1; idx < maxIdx && lbId == (nextLbId = this.lbDataList.get(idx).getLoadbalancerId()); ++idx) {
            }
            List<LoadBalancerData> next = null;
            next = this.startIdx == 0 && idx == this.listSize ? this.lbDataList : this.lbDataList.subList(this.startIdx, idx);
            this.startIdx = idx;
            return next;
        }
    }
}

