/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.SMInfoAPI;
import com.avaya.asm.datamgr.dao.cassandra.CassandraDAOFactory;
import com.avaya.asm.datamgr.dao.ustore.SMInfoDAO;
import com.avaya.asm.datamgr.helpers.CassandraConnectionInfo;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.objectapi.SMInfo;
import java.util.Collection;

public class SMInfoDM
implements SMInfoAPI {
    private final Logger log = AsmLogger.getLogger(SMInfoDM.class);
    private CassandraDAOFactory<SMInfoDAO> smInfoDAOFactory = new CassandraDAOFactory();
    private CassandraConnectionInfo cConnInfo = null;

    public SMInfoDM(CassandraConnectionInfo cConnInfo) {
        this.cConnInfo = cConnInfo;
    }

    public SMInfoDM() {
    }

    @Override
    public void setSMInfo(SMInfo smInfo) throws DMException {
        String fcn_name = "setSMInfo";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("setSMInfo: enter, smInfo=" + smInfo));
        }
        SMInfoDAO smInfoDAO = this.getSMInfoDAO();
        smInfoDAO.setSMInfo(smInfo);
        if (isFiner) {
            this.log.finer((Object)"setSMInfo: leave");
        }
    }

    @Override
    public SMInfo getSMInfo(long asmInstId) throws DMException {
        String fcn_name = "getSMInfo";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getSMInfo: enter, asmInstId=" + asmInstId));
        }
        SMInfoDAO smInfoDAO = this.getSMInfoDAO();
        SMInfo smInfo = smInfoDAO.getSMInfo(asmInstId);
        if (isFiner) {
            this.log.finer((Object)("getSMInfo: leave, smInfo=" + smInfo));
        }
        return smInfo;
    }

    @Override
    public void getAllSMInfo(Collection<SMInfo> smInfoColl) throws DMException {
        String fcn_name = "getAllSMInfo";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"getAllSMInfo: enter");
        }
        SMInfoDAO smInfoDAO = this.getSMInfoDAO();
        smInfoDAO.getAllSMInfo(smInfoColl);
        if (isFiner) {
            this.log.finer((Object)("getAllSMInfo: leave, smInfoColl.size()=" + smInfoColl.size()));
        }
    }

    @Override
    public void deleteSMInfo(long asmInstId) throws DMException {
        String fcn_name = "deleteSMInfo";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("deleteSMInfo: enter, asmInstId=" + asmInstId));
        }
        SMInfoDAO smInfoDAO = this.getSMInfoDAO();
        smInfoDAO.deleteSMInfo(asmInstId);
        if (isFiner) {
            this.log.finer((Object)"deleteSMInfo: leave");
        }
    }

    private SMInfoDAO getSMInfoDAO() throws DMException {
        String fcn_name = "getSMInfoDAO";
        SMInfoDAO dao = this.smInfoDAOFactory.getDAOInstance(this.cConnInfo, SMInfoDAO.class);
        if (dao == null) {
            String msg = "getSMInfoDAO: getDAOInstance failed, cConnInfo=" + this.cConnInfo;
            this.log.error((Object)msg);
            throw new DMException(msg);
        }
        return dao;
    }
}

