/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.datamgr.BLDMEnumType;
import com.avaya.asm.datamgr.BusinessLogicDM;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.UserCommunityDAO;
import com.avaya.asm.datamgr.datadistributionlayer.DDLRedundancyIntfc;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerData;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerFactory;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerListener;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMemberAddr;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMessage;
import com.avaya.asm.datamgr.datadistributionlayer.GroupCommIntf;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.asm.datamgr.objectapi.FQDNOrIpAddr;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.asm.datamgr.objectapi.Instance;
import com.avaya.common.logging.client.Logger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UserCommunityDM
extends BusinessLogicDM
implements DataDistLayerListener,
DMListener,
DDLRedundancyIntfc {
    private final Logger log = AsmLogger.getLogger(UserCommunityDM.class);
    protected static DMFactory factory;
    protected DataDistLayerMemberAddr thisMemberId;
    protected final Map<Long, DataDistLayerMemberAddr> asmInstToDDLAddrMap = new ConcurrentHashMap<Long, DataDistLayerMemberAddr>();
    protected final DataDistLayerMemberAddr nullDDLMemberAddr = new DataDistLayerMemberAddr();

    public static DMFactory getFactory() {
        if (factory == null) {
            factory = DMFactory.getInstance();
        }
        return factory;
    }

    @Override
    public EnumSet<? extends BLDMEnumType> getDMUsages() {
        return EnumSet.allOf(ucDM.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        this.log.info((Object)("Started initializing " + UserCommunityDM.class.getSimpleName()));
        DataMgr.Status status = DataMgr.Status.OKAY;
        for (ucDM dm : ucDM.values()) {
            if (dm.get().okay()) continue;
            status = DataMgr.Status.FAIL;
            this.log.error((Object)("Failed to init: " + dm));
        }
        this.lock.acquireWriteLock();
        try {
            this.asmInstToDDLAddrMap.clear();
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.setStatus(status);
        this.getAsmInstanceDAO().registerListener(this);
        this.log.info((Object)("Finished initializing " + UserCommunityDM.class.getSimpleName() + " with status " + (Object)((Object)status)));
    }

    protected List<DataDistLayerMemberAddr> getInterClusterMemberList() {
        return DataDistLayerFactory.getInstance().getInterClusterMember().getMembers();
    }

    protected AsmInstanceDAO getAsmInstanceDAO() {
        return (AsmInstanceDAO)this.getDataMgr(AsmInstanceDAO.class);
    }

    protected UserCommunityDAO getUserCommunityDAO() {
        return (UserCommunityDAO)this.getDataMgr(UserCommunityDAO.class);
    }

    public Long getUserCommunityId(List<Long> sipentityIds) {
        ArrayList<Long> asmInstanceIds = new ArrayList<Long>();
        Map<Long, Instance> asmInstanceMap = this.getAsmInstanceDAO().getAllAsmInstances();
        for (Long id : sipentityIds) {
            boolean found = false;
            for (Instance instance : asmInstanceMap.values()) {
                if (!id.equals(instance.getSipEntityId())) continue;
                asmInstanceIds.add(instance.getId());
                found = true;
                break;
            }
            if (found) continue;
            return null;
        }
        if (asmInstanceIds.isEmpty()) {
            return null;
        }
        UserCommunityDAO userCommunityDAO = this.getUserCommunityDAO();
        List<Long> userCommunitiesForFirstSM = userCommunityDAO.getUserCommunityIds((Long)asmInstanceIds.get(0));
        for (Long userCommunityId : userCommunitiesForFirstSM) {
            if (!asmInstanceIds.equals(userCommunityDAO.getUserCommAsmInstanceIds(userCommunityId))) continue;
            return userCommunityId;
        }
        return null;
    }

    public List<Long> getAsmInstanceIds(Long userCommunityId) {
        return this.getUserCommunityDAO().getUserCommAsmInstanceIds(userCommunityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SMConsole(parameterNames={"userCommId"}, description="Get the DDL addresses of the other members of the given user community.")
    public Collection<DataDistLayerMemberAddr> getRedundantMemberAddrs(Long userCommId) {
        if (userCommId == null) {
            return null;
        }
        Long myInstanceId = this.getAsmInstanceDAO().getMyInstanceId();
        if (myInstanceId == null) {
            return null;
        }
        ArrayList<DataDistLayerMemberAddr> retVal = new ArrayList<DataDistLayerMemberAddr>();
        List<Long> asmIds = this.getUserCommunityDAO().getUserCommAsmInstanceIds(userCommId);
        if (asmIds.isEmpty()) {
            this.log.warn((Object)("getRedundantMemberAddrs: empty user community instance list for user community " + userCommId));
            return retVal;
        }
        this.lock.acquireReadLock();
        try {
            for (Long asmInstanceId : asmIds) {
                if (myInstanceId.equals(asmInstanceId)) continue;
                retVal.add(this.getMemberAddr(asmInstanceId));
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return retVal;
    }

    @Override
    @SMConsole(parameterNames={"userCommId"}, description="Get the DDL addresses of the other members of the given user community.")
    public DataDistLayerMemberAddr getPrimaryRedundantMemberAddr(Long userCommId) {
        if (userCommId == null) {
            return null;
        }
        Long myInstanceId = this.getAsmInstanceDAO().getMyInstanceId();
        if (myInstanceId == null) {
            return null;
        }
        List<Long> asmIds = this.getUserCommunityDAO().getUserCommAsmInstanceIds(userCommId);
        if (asmIds.isEmpty()) {
            this.log.warn((Object)("getPrimaryRedundantMemberAddr: empty user community instance list for user community " + userCommId));
            return null;
        }
        Long primAsmInstanceId = asmIds.get(0);
        if (myInstanceId.equals(primAsmInstanceId)) {
            return this.thisMemberId;
        }
        return this.getMemberAddr(primAsmInstanceId);
    }

    protected DataDistLayerMemberAddr matchDDLMemberToInstance(Long otherInstanceId) {
        if (otherInstanceId != null) {
            AsmInstance otherInstance = this.getAsmInstanceDAO().getAsmInstance(otherInstanceId);
            String instanceMgmtAccess = otherInstance.getManagementAccessPointHostName();
            try {
                Object[] addresses = InetAddress.getAllByName(instanceMgmtAccess);
                if (addresses.length > 1) {
                    this.log.warn((Object)("matchDDLMemberToInstance: Trying to match an FQDN, but it resolves to multiple IP addresses: " + instanceMgmtAccess + "-->" + Arrays.toString(addresses)));
                }
                for (Object iNetAddress : addresses) {
                    IPAddress address = IPAddress.fromString(((InetAddress)iNetAddress).getHostAddress());
                    if (this.log.isFinerEnabled()) {
                        this.log.finer((Object)("matchMemberToInstance: Going to find the hostId for this ASM Instance's resolved management access " + address));
                    }
                    for (DataDistLayerMemberAddr addr : this.getInterClusterMemberList()) {
                        if (!address.isEqualTo(addr.getIpAddress())) continue;
                        if (this.log.isFinerEnabled()) {
                            this.log.finer((Object)("matchMemberToInstance: Found it: " + addr));
                        }
                        return addr;
                    }
                }
            }
            catch (UnknownHostException e) {
                this.log.error((Object)("matchDDLMemberToInstance: The ASM Instance has an FQDN that does not resolve in real DNS: " + instanceMgmtAccess));
            }
        }
        return this.nullDDLMemberAddr;
    }

    public Instance matchIPAddrToInstance(String ipAddress, boolean searchBranches) {
        IPAddress ipAddr = IPAddress.fromString(ipAddress);
        if (ipAddr != null) {
            for (Instance instance : this.getAsmInstanceDAO().getAllAsmInstances().values()) {
                if (instance.isBranch() && !searchBranches) continue;
                String mgmtAccessPointHostName = instance.getManagementAccessPointHostName();
                if (ipAddr.isEqualTo(mgmtAccessPointHostName)) {
                    return instance;
                }
                try {
                    InetAddress[] addresses;
                    for (InetAddress iNetAddress : addresses = InetAddress.getAllByName(mgmtAccessPointHostName)) {
                        if (!ipAddr.isEqualTo(iNetAddress.getHostAddress())) continue;
                        return instance;
                    }
                }
                catch (UnknownHostException e) {
                    this.log.error((Object)("matchIPAddrToInstance: The ASM Instance has an FQDN that does not resolve in real DNS: " + ipAddress));
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hostLeftTheGroup(DataDistLayerMemberAddr hostId, GroupCommIntf.DDLGroupType groupType) {
        block6: {
            this.lock.acquireReadLock();
            try {
                if (groupType != GroupCommIntf.DDLGroupType.INTER_SM_CLUSTER) break block6;
                for (Map.Entry<Long, DataDistLayerMemberAddr> e : this.asmInstToDDLAddrMap.entrySet()) {
                    DataDistLayerMemberAddr addr = e.getValue();
                    if (!addr.equals(hostId)) continue;
                    Long asmInstanceId = e.getKey();
                    if (this.log.isFinerEnabled()) {
                        this.log.finer((Object)("hostLeftTheGroup: Removing host " + hostId + " for asmInstanceId: " + asmInstanceId));
                    }
                    this.asmInstToDDLAddrMap.put(asmInstanceId, this.nullDDLMemberAddr);
                    return;
                }
            }
            finally {
                this.lock.releaseReadLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void otherMemberJoined(DataDistLayerMemberAddr otherMemberId, GroupCommIntf.DDLGroupType ddlGroupType) {
        block10: {
            this.lock.acquireReadLock();
            try {
                if (ddlGroupType != GroupCommIntf.DDLGroupType.INTER_SM_CLUSTER) break block10;
                if (this.log.isFinestEnabled()) {
                    this.log.finest((Object)("otherMemberJoined: " + otherMemberId.getHostId()));
                }
                FQDNOrIpAddr otherMemberIp = new FQDNOrIpAddr(otherMemberId.getIpAddress());
                for (Map.Entry<Long, DataDistLayerMemberAddr> e : this.asmInstToDDLAddrMap.entrySet()) {
                    Long asmInstanceId = e.getKey();
                    DataDistLayerMemberAddr addr = e.getValue();
                    if (addr.getHostId() == null) {
                        DataDistLayerMemberAddr usrCommAddress = this.matchDDLMemberToInstance(asmInstanceId);
                        if (!otherMemberId.equals(usrCommAddress)) continue;
                        if (this.log.isFinerEnabled()) {
                            this.log.finer((Object)("otherMemberJoined: Found a missing address matching asmInstanceId: " + asmInstanceId));
                        }
                        this.asmInstToDDLAddrMap.put(asmInstanceId, otherMemberId);
                        return;
                    }
                    String existingIP = addr.getIpAddress();
                    if (existingIP == null || !otherMemberIp.isEqualTo(existingIP)) continue;
                    if (this.log.isFinestEnabled()) {
                        this.log.finest((Object)("otherMemberJoined: Found replacement address for IP: " + existingIP + " matching asmInstanceId: " + asmInstanceId));
                    }
                    this.asmInstToDDLAddrMap.put(asmInstanceId, otherMemberId);
                    return;
                }
            }
            finally {
                this.lock.releaseReadLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void thisMemberJoinedTheGroup(DataDistLayerMemberAddr thisMemberId, GroupCommIntf.DDLGroupType ddlGroupType) {
        if (this.log.isFinestEnabled()) {
            this.log.finest((Object)("thisMemberJoinedTheGroup: member:" + thisMemberId + " type:" + (Object)((Object)ddlGroupType)));
        }
        if (ddlGroupType == GroupCommIntf.DDLGroupType.INTER_SM_CLUSTER) {
            this.thisMemberId = thisMemberId;
            this.lock.acquireWriteLock();
            try {
                this.asmInstToDDLAddrMap.clear();
                for (Long asmInstanceId : this.getAsmInstanceDAO().getAllAsmInstances().keySet()) {
                    this.asmInstToDDLAddrMap.put(asmInstanceId, this.matchDDLMemberToInstance(asmInstanceId));
                }
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    @Override
    public DataDistLayerMessage.TargetAppId getListenerAppId() {
        return DataDistLayerMessage.TargetAppId.USER_COMMUNITY;
    }

    @Override
    public void processMessage(DataDistLayerMessage message, DataDistLayerMemberAddr senderId) {
    }

    @Override
    public Object handleMessage(DataDistLayerMessage message, DataDistLayerMemberAddr srcMember) {
        if (this.log.isFinerEnabled()) {
            this.log.finer((Object)("handleMessage: " + message + ". Nothing to do."));
        }
        return null;
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (this.log.isFinestEnabled()) {
            this.log.finest((Object)("objectChanged: " + oldObject + " became " + newObject));
        }
        if (oldObject instanceof AsmInstance || newObject instanceof AsmInstance) {
            AsmInstance oldInstance = (AsmInstance)oldObject;
            AsmInstance newInstance = (AsmInstance)newObject;
            if (oldInstance == null) {
                Long asmInstanceId = newInstance.getId();
                this.asmInstToDDLAddrMap.put(asmInstanceId, this.matchDDLMemberToInstance(asmInstanceId));
            } else if (newInstance == null) {
                Long asmInstanceId = oldInstance.getId();
                this.asmInstToDDLAddrMap.remove(asmInstanceId);
            } else {
                Long asmInstanceId = oldInstance.getId();
                if (!IPAddress.areEqual(oldInstance.getManagementAccessPointHostName(), newInstance.getManagementAccessPointHostName())) {
                    this.asmInstToDDLAddrMap.put(asmInstanceId, this.matchDDLMemberToInstance(asmInstanceId));
                }
            }
        }
    }

    @SMConsole(description="Get a map of ASM Instance IDs to DDL Members. The map contains all ASM Instances in the system.")
    public Map<Long, DataDistLayerMemberAddr> getAsmInstanceToHostIdMap() {
        this.lock.acquireReadLock();
        try {
            Map<Long, DataDistLayerMemberAddr> map = this.asmInstToDDLAddrMap;
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Get a map of User Community IDs to other DDL Members currently representing that community. The map only contains User Communities that we are a part of.")
    public Map<Long, Map<Long, DataDistLayerMemberAddr>> getUserCommToHostIdMap() {
        Long myInstanceId = this.getAsmInstanceDAO().getMyInstanceId();
        if (myInstanceId == null) {
            return null;
        }
        HashMap<Long, Map<Long, DataDistLayerMemberAddr>> retVal = new HashMap<Long, Map<Long, DataDistLayerMemberAddr>>();
        this.lock.acquireReadLock();
        try {
            for (Long usrCommId : this.getUserCommunityDAO().getMyUserCommunityIds()) {
                HashMap<Long, DataDistLayerMemberAddr> asmMap = new HashMap<Long, DataDistLayerMemberAddr>();
                retVal.put(usrCommId, asmMap);
                List<Long> asmIds = this.getUserCommunityDAO().getUserCommAsmInstanceIds(usrCommId);
                for (Long asmInstanceId : asmIds) {
                    if (myInstanceId.equals(asmInstanceId)) continue;
                    asmMap.put(asmInstanceId, this.getMemberAddr(asmInstanceId));
                }
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMemberRedundantToUs(DataDistLayerMemberAddr member) {
        Long myInstanceId = this.getAsmInstanceDAO().getMyInstanceId();
        if (myInstanceId == null || member == null) {
            return false;
        }
        this.lock.acquireReadLock();
        try {
            for (Long usrCommId : this.getUserCommunityDAO().getMyUserCommunityIds()) {
                List<Long> asmIds = this.getUserCommunityDAO().getUserCommAsmInstanceIds(usrCommId);
                for (Long asmInstanceId : asmIds) {
                    if (myInstanceId.equals(asmInstanceId) || !member.equals(this.asmInstToDDLAddrMap.get(asmInstanceId))) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return false;
    }

    public Long getAsmInstanceId(Long usrCommId, DataDistLayerMemberAddr host) {
        FQDNOrIpAddr hostIp;
        if (host != null && !(hostIp = new FQDNOrIpAddr(host.getIpAddress())).isNull()) {
            for (Long asmInstanceId : this.getUserCommunityDAO().getUserCommAsmInstanceIds(usrCommId)) {
                if (!hostIp.isEqualTo(this.getMemberAddr(asmInstanceId).getIpAddress())) continue;
                return asmInstanceId;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Get the DDL Member Addr for a given ASM Instance ID.")
    public DataDistLayerMemberAddr getMemberAddr(Long asmInstanceId) {
        this.lock.acquireReadLock();
        try {
            DataDistLayerMemberAddr addr = this.asmInstToDDLAddrMap.get(asmInstanceId);
            DataDistLayerMemberAddr dataDistLayerMemberAddr = addr != null ? addr : this.nullDDLMemberAddr;
            return dataDistLayerMemberAddr;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getAsmInstanceId(DataDistLayerMemberAddr member) {
        this.lock.acquireReadLock();
        try {
            for (Map.Entry<Long, DataDistLayerMemberAddr> entry : this.asmInstToDDLAddrMap.entrySet()) {
                if (!entry.getValue().equals(member)) continue;
                Long l = entry.getKey();
                return l;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return null;
    }

    public List<DataDistLayerMemberAddr> getRedundantMemberAddrs(DataDistLayerMemberAddr curMemberAddr) {
        return null;
    }

    @Override
    public void dataStored(DataDistLayerMemberAddr senderId, DataDistLayerData data) {
    }

    @Override
    public void dataUpdated(DataDistLayerMemberAddr senderId, DataDistLayerData priorData, DataDistLayerData updatedData) {
    }

    @Override
    public void dataRemoved(DataDistLayerMemberAddr senderId, DataDistLayerData removedData) {
    }

    @Override
    public void bulkStoreReceived(DataDistLayerMemberAddr senderId, List<DataDistLayerData> dataList) {
    }

    @Override
    public void bulkRemoveReceived(DataDistLayerMemberAddr senderId, List<DataDistLayerData> dataList) {
    }

    @Override
    public void clearRedundancyCache() {
        this.lock.acquireReadLock();
        try {
            this.log.info((Object)"Clearing AsmInstanceId to DataDistLayerMemberAddr Map");
            this.asmInstToDDLAddrMap.clear();
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public static enum ucDM implements BLDMEnumType
    {
        ASM_INSTANCE_DAO(AsmInstanceDAO.class),
        USER_COMMUNITYDAO(UserCommunityDAO.class);

        private Class<? extends DataMgr> subDM;

        private ucDM(Class<? extends DataMgr> dm) {
            this.subDM = dm;
        }

        @Override
        public DataMgr get() {
            return UserCommunityDM.getFactory().getDataMgr(this.subDM);
        }
    }
}

