/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmConstants;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.AsmSettings;
import com.avaya.asm.core.WaitStatus;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.FailoverGroupDAO;
import com.avaya.asm.datamgr.dao.HostNameDAO;
import com.avaya.asm.datamgr.dao.SIPEntityDAO;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.helpers.RndcInvoker;
import com.avaya.asm.datamgr.helpers.RndcInvokerIntfc;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.asm.datamgr.objectapi.FailoverGroup;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.asm.datamgr.objectapi.IPAddressFamilyTransportKey;
import com.avaya.asm.datamgr.objectapi.MonitoredAddress;
import com.avaya.asm.datamgr.objectapi.MonitoredEntity;
import com.avaya.asm.datamgr.objectapi.ResolvedIPAddress;
import com.avaya.asm.datamgr.objectapi.ResolvedName;
import com.avaya.asm.datamgr.objectapi.ResolvedNameChangeObj;
import com.avaya.asm.datamgr.objectapi.SIPEntity;
import com.avaya.asm.jni.JniExec;
import com.avaya.asm.jni.JniExecException;
import com.avaya.asm.jni.JniExecInterface;
import com.avaya.common.logging.client.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ZoneFileWriter
implements DMListener {
    private static final Logger log = AsmLogger.getLogger(ZoneFileWriter.class);
    public static final long FOREVER_TTL = 315360000L;
    private static final String DEFAULT_ZONE_MASTER_DIR = "/var/named/master";
    private static final String DEFAULT_NAMED_DIR = "/var/named";
    private static final String SET_ZONE_PERMISSIONS_SCRIPT = "/opt/Avaya/CommonServerPlatform/bin/setZoneFilePermission.sh";
    private static final long TIMER_FREQUENCY = 1L;
    private static PrintWriter mockPrintWriter = null;
    private static JniExecInterface jniexec = null;
    private Timer timer;
    private final MessageFormat headerForm;
    private final MessageFormat srvRecordForm;
    private final MessageFormat aRecordForm;
    private final MessageFormat aaaaRecordForm;
    private DomainUpdateList domainUpdateList;
    private static volatile ZoneFileWriter myInstance;
    private HostNameDAO hostnameDAO;
    private SIPEntityDAO sipEntityDAO;
    private FailoverGroupDAO failoverGroupDAO;
    private AsmInstanceDAO asmInstanceDAO;
    private final int DEAD_ZONE_THREADS = 5;
    private ScheduledThreadPoolExecutor executor = null;
    private BlockingQueue<ZoneFileChange> zoneFileChanges = new LinkedBlockingQueue<ZoneFileChange>();
    private Thread objectChangeWorkerThread;
    private int batchsize;
    private volatile boolean taskRunning = true;

    public ZoneFileWriter() {
        String hostname;
        this.executor = new ScheduledThreadPoolExecutor(5);
        this.startZoneFileChangesThread();
        this.batchsize = (int)Math.ceil(0.9 * (double)AsmSettings.getZonefileBatchSize().intValue());
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.error((Object)"Failed to get local host name");
            hostname = "localhost";
        }
        this.headerForm = new MessageFormat("$TTL {0}\n@\tIN\tSOA\t" + hostname + ". {1}. (\n\t\t\t{2} ; serial\n\t\t\t{3} ; refresh\n\t\t\t{4} ; retry\n\t\t\t{5} ; expiry\n\t\t\t{6} ; ttl\n)\n\tIN\tNS\t" + hostname + ".\n");
        this.aRecordForm = new MessageFormat("{0}.\t{1,number,#}\tIN\tA\t{2}");
        this.aaaaRecordForm = new MessageFormat("{0}.\t{1,number,#}\tIN\tAAAA\t{2}");
        this.srvRecordForm = new MessageFormat("_{0}._{1}.{2}.\t{3,number,#}\tIN\tSRV\t{4,number,#}\t{5,number,#}\t{6,number,#}\t{7}.");
        if (jniexec == null) {
            jniexec = new JniExec();
        }
        this.timer = null;
        this.domainUpdateList = new DomainUpdateList();
        if (mockPrintWriter == null) {
            this.getHostNameDAO().registerListener(this);
            this.getSIPEntityDAO().registerListener(this);
            this.getFailoverGroupDAO().registerListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ZoneFileWriter getInstance() {
        if (myInstance != null) return myInstance;
        Class<ZoneFileWriter> clazz = ZoneFileWriter.class;
        synchronized (ZoneFileWriter.class) {
            if (myInstance != null) return myInstance;
            myInstance = new ZoneFileWriter();
            log.info((Object)"ZoneFileWriter created");
            // ** MonitorExit[var0] (shouldn't be in output)
            return myInstance;
        }
    }

    public synchronized void removeZoneFile(String domainName, DAOReplicationEvent.OperationType operation) throws IOException {
        block5: {
            String fcn_name = "removeZoneFile";
            if (mockPrintWriter != null) {
                return;
            }
            if (log.isFinestEnabled()) {
                log.finest((Object)("removeZoneFile: removing the zone file for domain name: " + domainName));
            }
            String filePath = "/var/named/master/" + domainName + ".zone";
            try {
                Files.delete(Paths.get(filePath, new String[0]));
            }
            catch (IOException e) {
                if (!log.isFinestEnabled()) break block5;
                log.finest((Object)("removeZoneFile: failed to delete the file " + filePath));
            }
        }
        if (operation != DAOReplicationEvent.OperationType.UPDATE) {
            this.reloadZoneAndUpdateMappings(domainName, DAOReplicationEvent.OperationType.DELETE);
        }
    }

    public synchronized void removeFGDNZoneFile(FailoverGroup fg) {
        if (fg == null) {
            return;
        }
        try {
            this.removeZoneFile(fg.getDomainName(), DAOReplicationEvent.OperationType.DELETE);
            this.removeZoneFile(fg.getInverseDomainName(), DAOReplicationEvent.OperationType.DELETE);
            this.removeZoneFile("dead." + fg.getDomainName(), DAOReplicationEvent.OperationType.DELETE);
            this.removeZoneFile("dead." + fg.getInverseDomainName(), DAOReplicationEvent.OperationType.DELETE);
        }
        catch (IOException e) {
            log.error((Object)("An error occurred removing the following failover group from zone file records: " + fg), (Throwable)e);
        }
    }

    public synchronized void publishZoneFile(ResolvedName resolvedName, DAOReplicationEvent.OperationType operation) throws IOException {
        this.publishZoneFile(resolvedName, false);
        this.reloadZoneAndUpdateMappings(resolvedName.getFqdn(), operation);
    }

    public synchronized void publishZoneFiles(List<ResolvedName> resolvedNames, boolean publishZoneFile) throws IOException {
        block2: {
            try {
                this.runPublishZonesFileTask(resolvedNames, publishZoneFile, resolvedNames.iterator());
            }
            catch (IOException e) {
                log.error((Object)("Error publishing zones files\" rescheduling after catching exception " + e));
                if (!log.isFineEnabled()) break block2;
                log.fine((Object)("Failed while publishing zones for resolved names: " + resolvedNames));
            }
        }
    }

    protected synchronized void runPublishZonesFileTask(final List<ResolvedName> resolvedNames, boolean publishZoneFile, final Iterator<ResolvedName> iter) throws IOException {
        if (log.isFinestEnabled()) {
            log.finest((Object)"Publish All Zone Files");
        }
        if (publishZoneFile) {
            for (ResolvedName resolvedName : resolvedNames) {
                this.publishZoneFile(resolvedName, true);
            }
            this.runSetZonePermissionsScript("all");
        }
        int i = 0;
        while (iter.hasNext()) {
            ResolvedName resolvedName;
            resolvedName = iter.next();
            this.reloadZoneAndUpdateMappings(resolvedName.getFqdn(), DAOReplicationEvent.OperationType.INSERT);
            if (++i < this.batchsize) continue;
            Callable<Boolean> task = new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    Thread.currentThread().setName("runPublishZoneFilesTaskThread");
                    try {
                        ZoneFileWriter.this.runPublishZonesFileTask(resolvedNames, false, iter);
                    }
                    catch (IOException e) {
                        log.error((Object)"Error publishing zones files. Rescheduling after catching exception ", (Throwable)e);
                        if (log.isFineEnabled()) {
                            log.fine((Object)("Failed while publishing zones for resolved names: " + resolvedNames));
                        }
                        ZoneFileWriter.this.executor.schedule(this, 1000L, TimeUnit.MILLISECONDS);
                    }
                    return true;
                }
            };
            this.executor.schedule(task, 1150L, TimeUnit.MILLISECONDS);
            return;
        }
    }

    private void runSetZonePermissionsScript(String zoneFile) {
        String fcn_name = "runSetZonePermissionsScript";
        String[] execArgs = new String[]{"/usr/bin/sudo", SET_ZONE_PERMISSIONS_SCRIPT, zoneFile};
        int retVal = 0;
        try {
            retVal = jniexec.exec(execArgs);
        }
        catch (JniExecException e) {
            log.warn((Object)("runSetZonePermissionsScript JniExec.exec through a JniExecException for, SUDO_PATH=/usr/bin/sudo, SET_ZONE_PERMISSIONS_SCRIPT=/opt/Avaya/CommonServerPlatform/bin/setZoneFilePermission.sh, zoneFile=" + zoneFile), (Throwable)e);
        }
        if (retVal != 0) {
            log.warn((Object)("runSetZonePermissionsScript: JniExec exec returned " + retVal + " for, SUDO_PATH=" + "/usr/bin/sudo" + ", SET_ZONE_PERMISSIONS_SCRIPT=" + SET_ZONE_PERMISSIONS_SCRIPT + ", zoneFile=" + zoneFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void publishZoneFile(ResolvedName resolvedName, boolean initializing) throws IOException {
        List<ResolvedIPAddress> addresses = resolvedName.getAddresses();
        if (addresses.isEmpty()) {
            return;
        }
        if (log.isFinestEnabled()) {
            log.finest((Object)("Publish zone file for: " + resolvedName.toString()));
        }
        boolean writeAsSrvRecord = this.useSrvRecord(addresses);
        long ttl = 900L;
        String ttlStr = String.valueOf(ttl);
        try (PrintWriter out = null;){
            String serialNumber;
            if (mockPrintWriter == null) {
                out = new PrintWriter("/var/named/master/" + resolvedName.getFqdn() + ".zone");
                long currentTimeSecs = Calendar.getInstance().getTimeInMillis() / 1000L;
                serialNumber = Long.toString(currentTimeSecs &= 0xFFFFFFFFFFFFFFFFL);
            } else {
                out = mockPrintWriter;
                serialNumber = "123456";
            }
            Object[] headerArgs = new Object[]{ttlStr, "default.hostmaster", serialNumber, "172800", "900", "1209600", ttlStr};
            out.println(this.headerForm.format(headerArgs));
            int i = 0;
            for (ResolvedIPAddress addr : addresses) {
                if (writeAsSrvRecord) {
                    String urischeme = null;
                    String transport = null;
                    int port = addr.getPortnumber();
                    String targetName = ++i + "-dmmySRVTrgt." + resolvedName.getFqdn();
                    if (addr.getTransportprotocol().compareToIgnoreCase("tls") == 0) {
                        urischeme = "sips";
                        transport = "tcp";
                    } else {
                        urischeme = "sip";
                        transport = addr.getTransportprotocol().toLowerCase();
                    }
                    if (port == 0) {
                        port = addr.getTransportprotocol().compareToIgnoreCase("tls") == 0 ? 5061 : 5060;
                    }
                    Object[] srvArgs = new Object[]{urischeme, transport, resolvedName.getFqdn(), ttl, addr.getPriority(), addr.getWeight(), port, targetName};
                    out.println(this.srvRecordForm.format(srvArgs));
                    if (IPAddress.getAddressFamily(addr.getIpaddress()) == IPAddress.IPAddressFamily.IPV6) {
                        Object[] aaaaArgs = new Object[]{targetName, ttl, addr.getIpaddress()};
                        out.println(this.aaaaRecordForm.format(aaaaArgs));
                    } else {
                        Object[] aArgs = new Object[]{targetName, ttl, addr.getIpaddress()};
                        out.println(this.aRecordForm.format(aArgs));
                    }
                }
                if (IPAddress.getAddressFamily(addr.getIpaddress()) == IPAddress.IPAddressFamily.IPV6) {
                    Object[] aaaaArgs = new Object[]{resolvedName.getFqdn(), ttl, addr.getIpaddress()};
                    out.println(this.aaaaRecordForm.format(aaaaArgs));
                    continue;
                }
                Object[] aArgs = new Object[]{resolvedName.getFqdn(), ttl, addr.getIpaddress()};
                out.println(this.aRecordForm.format(aArgs));
            }
            if (!initializing) {
                this.runSetZonePermissionsScript("/var/named/master/" + resolvedName.getFqdn() + ".zone");
            }
        }
    }

    public void publishDeadZoneFile(final MonitoredEntity entity, final boolean publishZoneFile) {
        Callable<Boolean> task = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                Thread.currentThread().setName("runDeadZoneTaskThread");
                try {
                    ZoneFileWriter.this.runDeadZoneTask(entity, publishZoneFile);
                }
                catch (IOException e) {
                    log.error((Object)("Dead zone task for entity \"" + entity.getName() + "\" rescheduling after catching exception " + e));
                    ZoneFileWriter.this.executor.schedule(this, 1000L, TimeUnit.MILLISECONDS);
                }
                return true;
            }
        };
        this.executor.schedule(task, 0L, TimeUnit.MILLISECONDS);
    }

    protected void runDeadZoneTask(MonitoredEntity entity, boolean publishZoneFile) throws IOException {
        if (!entity.trackForDeadZone()) {
            return;
        }
        if (entity.hasFQDN()) {
            this.changeZoneFilesFQDN(entity, publishZoneFile);
        } else {
            this.changeZoneFilesFailoverGroups(entity, publishZoneFile);
        }
        entity.setWriteDeadZoneFiles(MonitoredEntity.ZoneFileStatus.NOCHANGE);
    }

    protected void changeZoneFilesFQDN(MonitoredEntity entity, boolean publishZoneFile) throws IOException {
        ResolvedName resolvedName = new ResolvedName("dead." + entity.getFQDNOrIPAddrs().get(0), entity.getUseRFC3263(), 315360000L);
        Map<String, MonitoredAddress> addressMap = entity.getAddressMap();
        for (MonitoredAddress monitoredAddr : addressMap.values()) {
            if (monitoredAddr.getStatus() != MonitoredAddress.Status.DOWN) continue;
            resolvedName.addResolvedIP(new ResolvedIPAddress(monitoredAddr.getIpaddress(), monitoredAddr.getPort(), monitoredAddr.getTransport().toString()));
        }
        this.invokeZoneFileChanges(resolvedName, entity, publishZoneFile);
    }

    protected void changeZoneFilesFailoverGroups(MonitoredEntity entity, boolean publishZoneFile) throws IOException {
        SIPEntity sipEntity = entity.getEntity();
        List<FailoverGroup> failoverGroups = this.getFailoverGroupsForSM(sipEntity.getId());
        if (failoverGroups == null) {
            return;
        }
        Map<IPAddressFamilyTransportKey, Integer> contactPorts = sipEntity.getSmContactPorts();
        ArrayList<Long> fgdnIds = new ArrayList<Long>();
        for (FailoverGroup fg : failoverGroups) {
            if (fgdnIds.contains(fg.getId())) continue;
            fgdnIds.add(fg.getId());
            ResolvedName resolvedName = new ResolvedName("dead." + fg.getDomainName(), false, 315360000L);
            ResolvedName resolvedNameInv = new ResolvedName("dead." + fg.getInverseDomainName(), false, 315360000L);
            Map<String, MonitoredAddress> addressMap = entity.getAddressMap();
            for (MonitoredAddress monitoredAddr : addressMap.values()) {
                for (Map.Entry<IPAddressFamilyTransportKey, Integer> entry : contactPorts.entrySet()) {
                    IPAddressFamilyTransportKey mutliKey = entry.getKey();
                    AsmConstants.TRANSPORT transport = mutliKey.getTransport();
                    IPAddress.IPAddressFamily ipAddressFamily = mutliKey.getIpAddressFamily();
                    int port = entry.getValue();
                    IPAddress.IPAddressFamily monitoredIpAddressFamily = IPAddress.getAddressFamily(monitoredAddr.getIpaddress());
                    if (monitoredAddr.getPort() != port || !monitoredAddr.getTransport().equals((Object)transport) || ipAddressFamily != monitoredIpAddressFamily || monitoredAddr.getStatus() != MonitoredAddress.Status.DOWN) continue;
                    resolvedName.addResolvedIP(new ResolvedIPAddress(monitoredAddr.getIpaddress(), port, transport.toString()));
                    resolvedNameInv.addResolvedIP(new ResolvedIPAddress(monitoredAddr.getIpaddress(), port, transport.toString()));
                    break;
                }
                if (log.isFinestEnabled()) {
                    log.finest((Object)("Invoke zone file changes for: " + resolvedName + " , " + resolvedNameInv));
                }
                this.invokeZoneFileChanges(resolvedName, entity, publishZoneFile);
                this.invokeZoneFileChanges(resolvedNameInv, entity, publishZoneFile);
            }
        }
    }

    protected void invokeZoneFileChanges(ResolvedName resolvedName, MonitoredEntity entity, boolean publishZoneFile) throws IOException {
        switch (entity.needToWriteDeadZoneFiles()) {
            case MODIFYZONE: {
                if (resolvedName.getAddresses().isEmpty()) {
                    this.removeZoneFile(resolvedName.getFqdn(), DAOReplicationEvent.OperationType.DELETE);
                    break;
                }
                if (publishZoneFile) {
                    this.publishDeadZoneFile(resolvedName);
                }
                this.newDeadZoneFile(resolvedName.getFqdn());
                break;
            }
            case REMOVEZONE: {
                if (!resolvedName.getAddresses().isEmpty() && publishZoneFile) {
                    this.publishDeadZoneFile(resolvedName);
                }
                this.removeZoneFile(resolvedName.getFqdn(), DAOReplicationEvent.OperationType.DELETE);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void publishDeadZoneFile(ResolvedName resolvedName) throws IOException {
        List<ResolvedIPAddress> addresses = resolvedName.getAddresses();
        if (addresses.isEmpty()) {
            return;
        }
        if (log.isFinestEnabled()) {
            log.finest((Object)("Publish dead zone file for: " + resolvedName.toString()));
        }
        long ttl = 10L;
        String ttlStr = String.valueOf(ttl);
        try (PrintWriter out = null;){
            String serialNumber;
            if (mockPrintWriter == null) {
                out = new PrintWriter("/var/named/master/" + resolvedName.getFqdn() + ".zone");
                long currentTimeSecs = Calendar.getInstance().getTimeInMillis() / 1000L;
                serialNumber = Long.toString(currentTimeSecs &= 0xFFFFFFFFFFFFFFFFL);
            } else {
                out = mockPrintWriter;
                serialNumber = "123456";
            }
            Object[] headerArgs = new Object[]{ttlStr, "default.hostmaster", serialNumber, "172800", "900", "1209600", ttlStr};
            out.println(this.headerForm.format(headerArgs));
            for (ResolvedIPAddress addr : addresses) {
                String transport;
                String string = transport = addr.getTransportprotocol() == null ? "udp" : addr.getTransportprotocol().toLowerCase();
                String port = addr.getPortnumber() <= 0 ? (transport.equals("tls") ? "5061" : "5060") : Integer.toString(addr.getPortnumber());
                String name = port + "." + transport + "." + resolvedName.getFqdn();
                if (IPAddress.getAddressFamily(addr.getIpaddress()) == IPAddress.IPAddressFamily.IPV6) {
                    Object[] aaaaArgs = new Object[]{name, ttl, addr.getIpaddress()};
                    out.println(this.aaaaRecordForm.format(aaaaArgs));
                    continue;
                }
                Object[] aArgs = new Object[]{name, ttl, addr.getIpaddress()};
                out.println(this.aRecordForm.format(aArgs));
            }
            this.runSetZonePermissionsScript("/var/named/master/" + resolvedName.getFqdn() + ".zone");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void newDeadZoneFile(String domainName) {
        String fcn_name = "newDeadZoneFile";
        boolean isFinest = log.isFinestEnabled();
        RndcInvoker rndcInvoker = null;
        try {
            rndcInvoker = RndcInvoker.Open();
            if (isFinest) {
                log.finest((Object)"newDeadZoneFile: RndcInvoker.Open() is called");
            }
        }
        catch (JniExecException e) {
            log.warn((Object)("newDeadZoneFile: RndcInvoker.Open received JndiExecException processing domainName=" + domainName), (Throwable)e);
            return;
        }
        try {
            this.delRndcZones(domainName, (RndcInvokerIntfc)rndcInvoker);
            this.addRndcZones(domainName, (RndcInvokerIntfc)rndcInvoker);
        }
        finally {
            try {
                int rc = rndcInvoker.Close();
                if (rc != 0) {
                    log.warn((Object)("newDeadZoneFile: RndcInvoker.Close() returned with status " + rc + " (" + WaitStatus.asString(rc) + ") while processing domainName " + domainName));
                } else if (isFinest) {
                    log.finest((Object)"newDeadZoneFile: RndcInvoker.Close() is called and succeeded");
                }
            }
            catch (JniExecException | IOException e) {
                log.warn((Object)("newDeadZoneFile: RndcInvokerClose threw an exception while processing domainName " + domainName), (Throwable)e);
            }
        }
    }

    public synchronized void publishFGDNZoneFiles(SIPEntity smEntity, DAOReplicationEvent.OperationType operation) {
        List<FailoverGroup> failoverGroups = this.getFailoverGroupsForSM(smEntity.getId());
        if (failoverGroups == null) {
            return;
        }
        for (FailoverGroup fg : failoverGroups) {
            this.publishFGDNZoneFiles(fg, operation);
        }
    }

    public synchronized void publishFGDNZoneFiles(FailoverGroup fg, DAOReplicationEvent.OperationType operation) {
        ArrayList<ResolvedName> resolvedNames = new ArrayList<ResolvedName>();
        this.createResolvedNames(fg, resolvedNames);
        try {
            for (ResolvedName rs : resolvedNames) {
                this.publishZoneFile(rs, operation);
            }
        }
        catch (IOException e) {
            log.error((Object)("Failed to publish FGDN zone file for failover group: " + fg + " on operation" + (Object)((Object)operation)), (Throwable)e);
        }
    }

    public synchronized void publishFGDNZoneFiles(Set<FailoverGroup> fgs) throws IOException {
        ArrayList<ResolvedName> resolvedNames = new ArrayList<ResolvedName>();
        for (FailoverGroup fg : fgs) {
            this.createResolvedNames(fg, resolvedNames);
        }
        this.publishZoneFiles(resolvedNames, true);
    }

    public void createResolvedNames(FailoverGroup fg, List<ResolvedName> resolvedNames) {
        ResolvedName name;
        List<ResolvedIPAddress> ipAddresses = this.getResolvedIPAddress(fg, false);
        if (!ipAddresses.isEmpty()) {
            name = new ResolvedName(fg.getDomainName(), true);
            for (ResolvedIPAddress ipaddr : ipAddresses) {
                name.addResolvedIP(ipaddr);
            }
            resolvedNames.add(name);
        }
        if (!(ipAddresses = this.getResolvedIPAddress(fg, true)).isEmpty()) {
            name = new ResolvedName(fg.getInverseDomainName(), true);
            for (ResolvedIPAddress ipaddr : ipAddresses) {
                name.addResolvedIP(ipaddr);
            }
            resolvedNames.add(name);
        }
    }

    private List<ResolvedIPAddress> getResolvedIPAddress(FailoverGroup fg, boolean inverseDomain) {
        ArrayList<ResolvedIPAddress> ipAddresses = new ArrayList<ResolvedIPAddress>();
        SIPEntity sipEntity = this.getSIPEntityFromInstanceId(fg.getPrimarySMId());
        if (sipEntity != null) {
            this.addIpAddresses(ipAddresses, sipEntity, inverseDomain ? 200 : 100);
        }
        if ((sipEntity = this.getSIPEntityFromInstanceId(fg.getSecondarySMId())) != null) {
            this.addIpAddresses(ipAddresses, sipEntity, inverseDomain ? 100 : 200);
        }
        return ipAddresses;
    }

    private void addIpAddresses(List<ResolvedIPAddress> ipAddresses, SIPEntity sipEntity, int priority) {
        Map<IPAddressFamilyTransportKey, Integer> contactPorts = sipEntity.getSmContactPorts();
        if (contactPorts.isEmpty()) {
            return;
        }
        for (Map.Entry<IPAddressFamilyTransportKey, Integer> entry : contactPorts.entrySet()) {
            IPAddressFamilyTransportKey mutliKey = entry.getKey();
            AsmConstants.TRANSPORT transport = mutliKey.getTransport();
            int port = entry.getValue();
            ipAddresses.add(new ResolvedIPAddress(sipEntity.getFqdnoripaddr(), port, transport.toString(), priority, 100));
            String fqdnoripaddr2 = sipEntity.getFqdnoripaddr2();
            if (fqdnoripaddr2 == null) continue;
            ipAddresses.add(new ResolvedIPAddress(fqdnoripaddr2, port, transport.toString(), priority, 100));
        }
    }

    protected HostNameDAO getHostNameDAO() {
        return this.hostnameDAO == null ? (HostNameDAO)DMFactory.getInstance().getDataMgr(HostNameDAO.class) : this.hostnameDAO;
    }

    protected SIPEntityDAO getSIPEntityDAO() {
        return this.sipEntityDAO == null ? (SIPEntityDAO)DMFactory.getInstance().getDataMgr(SIPEntityDAO.class) : this.sipEntityDAO;
    }

    protected FailoverGroupDAO getFailoverGroupDAO() {
        return this.failoverGroupDAO == null ? (FailoverGroupDAO)DMFactory.getInstance().getDataMgr(FailoverGroupDAO.class) : this.failoverGroupDAO;
    }

    protected AsmInstanceDAO getAsmInstanceDAO() {
        return this.asmInstanceDAO == null ? (AsmInstanceDAO)DMFactory.getInstance().getDataMgr(AsmInstanceDAO.class) : this.asmInstanceDAO;
    }

    private List<FailoverGroup> getFailoverGroupsForSM(Long sipEntityId) {
        if (sipEntityId == null) {
            return null;
        }
        AsmInstance asmInstance = this.getAsmInstance(sipEntityId);
        if (asmInstance == null) {
            return null;
        }
        return this.getFailoverGroupDAO().getFailoverGroupsForSm(asmInstance.getId());
    }

    private AsmInstance getAsmInstance(long SIPEntityId) {
        return (AsmInstance)this.getAsmInstanceDAO().getEntityInstance(SIPEntityId);
    }

    private SIPEntity getSIPEntityFromInstanceId(long instanceId) {
        AsmInstance asmInstance = this.getAsmInstanceDAO().getAsmInstance(instanceId);
        if (asmInstance == null) {
            return null;
        }
        return this.getSIPEntityDAO().getSIPEntity(asmInstance.getSipEntityId());
    }

    private boolean useSrvRecord(List<ResolvedIPAddress> addresses) {
        if (addresses.isEmpty()) {
            return false;
        }
        ResolvedIPAddress firstAddr = addresses.iterator().next();
        int priority = firstAddr.getPriority();
        int weight = firstAddr.getWeight();
        for (ResolvedIPAddress addr : addresses) {
            if (priority != addr.getPriority()) {
                return true;
            }
            if (weight != addr.getWeight()) {
                return true;
            }
            int port = addr.getPortnumber();
            if ((port == 5060 || port == 0) && (addr.getTransportprotocol().compareToIgnoreCase("tcp") == 0 || addr.getTransportprotocol().compareToIgnoreCase("udp") == 0) || (port == 5061 || port == 0) && addr.getTransportprotocol().compareToIgnoreCase("tls") == 0) continue;
            return true;
        }
        return false;
    }

    private void reloadZoneAndUpdateMappings(String domainName, DAOReplicationEvent.OperationType operation) {
        if (mockPrintWriter != null) {
            // empty if block
        }
        this.restartTimer(1L, domainName, operation);
    }

    private synchronized void restartTimer(long timerFrequency, String domainName, DAOReplicationEvent.OperationType operation) {
        if (log.isFinestEnabled()) {
            log.finest((Object)("Restart timer to update rndc zone configuration mapping data: " + domainName + "/" + timerFrequency + "/" + (Object)((Object)operation)));
        }
        if (operation == DAOReplicationEvent.OperationType.INSERT) {
            this.domainUpdateList.addToAddList(domainName);
            this.domainUpdateList.removeFromDeleteList(domainName);
        } else if (operation == DAOReplicationEvent.OperationType.DELETE) {
            this.domainUpdateList.addToDeleteList(domainName);
            this.domainUpdateList.removeFromAddList(domainName);
        }
        if (this.domainUpdateList.getAddListSize() >= this.batchsize || this.domainUpdateList.getDeleteListSize() >= this.batchsize) {
            return;
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer(true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ZoneFileWriter zoneFileWriter = ZoneFileWriter.getInstance();
                zoneFileWriter.executeZoneFileTasks();
            }
        }, timerFrequency * 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void executeZoneFileTasks() {
        String fcn_name = "executeZoneFileTasks";
        boolean isFinest = log.isFinestEnabled();
        if (log.isFinestEnabled()) {
            log.finest((Object)("TimerTask.run() invoked to update zone file configuration status through rndc addzone/delzone, numAdds=" + this.domainUpdateList.getAddListSize() + ", numDels=" + this.domainUpdateList.getDeleteListSize()));
        }
        RndcInvoker rndcInvoker = null;
        try {
            rndcInvoker = RndcInvoker.Open();
            if (isFinest) {
                log.finest((Object)"executeZoneFileTasks: RndcInvoker.Open() is called");
            }
        }
        catch (JniExecException e) {
            log.warn((Object)"executeZoneFileTasks: RndcInvoker.Open received JndiExecException", (Throwable)e);
            return;
        }
        try {
            this.delRndcZones(this.domainUpdateList.getDeleteList(), (RndcInvokerIntfc)rndcInvoker);
            this.addRndcZones(this.domainUpdateList.getAddList(), (RndcInvokerIntfc)rndcInvoker);
            this.domainUpdateList.clearLists();
            if (log.isFinestEnabled()) {
                log.finest((Object)"executeZoneFileTasks: refresh DNS with RndcInvoker.reload()");
            }
            rndcInvoker.reload();
        }
        catch (Exception e) {
            log.error((Object)"executeZoneFileTasks: Exception in task for performing rndc reload", (Throwable)e);
        }
        finally {
            try {
                int rc = rndcInvoker.Close();
                if (rc != 0) {
                    log.warn((Object)("executeZoneFileTasks: RndcInvoker.Close() returned with status " + rc + " (" + WaitStatus.asString(rc) + ") for a DNS reload"));
                } else if (isFinest) {
                    log.finest((Object)"executeZoneFileTasks: RndcInvoker.Close() is called and succeeded");
                }
            }
            catch (JniExecException | IOException e) {
                log.warn((Object)"executeZoneFileTasks: RndcInvokerClose threw an exception", (Throwable)e);
            }
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.timer = null;
        }
    }

    private void addRndcZones(String domainName, RndcInvokerIntfc rndcInvoker) {
        HashSet<String> singleSet = new HashSet<String>();
        singleSet.add(domainName);
        this.addRndcZones(singleSet, rndcInvoker);
    }

    private void addRndcZones(Set<String> domainNames, RndcInvokerIntfc rndcInvoker) {
        if (domainNames == null || domainNames.isEmpty()) {
            return;
        }
        String fcn_name = "addRndcZones";
        for (String domainName : domainNames) {
            if (log.isFinestEnabled()) {
                log.finest((Object)("addRndcZones: add " + domainName + " using rndc addzone"));
            }
            try {
                rndcInvoker.addzone(domainName);
            }
            catch (IOException exc) {
                log.warn((Object)("addRndcZones: rndcInvoker.addzone() threw IOException for domain " + domainName), (Throwable)exc);
            }
        }
    }

    private void delRndcZones(String domainName, RndcInvokerIntfc rndcInvoker) {
        HashSet<String> singleSet = new HashSet<String>();
        singleSet.add(domainName);
        this.delRndcZones(singleSet, rndcInvoker);
    }

    private void delRndcZones(Set<String> domainNames, RndcInvokerIntfc rndcInvoker) {
        if (domainNames == null || domainNames.isEmpty()) {
            return;
        }
        String fcn_name = "delRndcZones";
        for (String domainName : domainNames) {
            if (log.isFinestEnabled()) {
                log.finest((Object)("delRndcZones: removing " + domainName + " using rndc delzone"));
            }
            try {
                rndcInvoker.delzone(domainName);
            }
            catch (IOException exc) {
                log.warn((Object)("delRndcZones: rndcInvoker.delzone() threw IOException for domain " + domainName), (Throwable)exc);
            }
        }
    }

    public void reloadZoneConfig(List<ResolvedName> resolvedNames) throws IOException {
        this.delRndcAllZones();
        this.publishZoneFiles(resolvedNames, false);
    }

    public void removeAllZoneFiles() throws IOException {
        if (mockPrintWriter != null) {
            return;
        }
        if (log.isFinestEnabled()) {
            log.finest((Object)"Remove all zone files");
        }
        File zoneFileDirectory = new File(DEFAULT_ZONE_MASTER_DIR);
        FilenameFilter fileFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".zone");
            }
        };
        this.delRndcAllZones();
        File[] zoneFiles = zoneFileDirectory.listFiles(fileFilter);
        if (zoneFiles != null) {
            for (int i = 0; i < zoneFiles.length; ++i) {
                if (zoneFiles[i].delete() || !log.isFineEnabled()) continue;
                log.fine((Object)("removeAllZoneFiles: zone file: " + zoneFiles[i] + " could not be deleted"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delRndcAllZones() {
        String fcn_name = "delRndcAllZones";
        boolean isFinest = log.isFinestEnabled();
        if (mockPrintWriter != null) {
            return;
        }
        if (isFinest) {
            log.finest((Object)"delRndcAllZones: remove all domains");
        }
        RndcInvoker rndcInvoker = null;
        try {
            rndcInvoker = RndcInvoker.Open();
            if (isFinest) {
                log.finest((Object)"delRndcAllZones: RndcInvoker.Open() is called");
            }
        }
        catch (JniExecException e) {
            log.warn((Object)"delRndcAllZones: RndcInvoker.Open received JndiExecException", (Throwable)e);
            return;
        }
        try {
            Set<String> domains = this.getDomainsManagedByRndc();
            this.delRndcZones(domains, (RndcInvokerIntfc)rndcInvoker);
        }
        finally {
            try {
                int rc = rndcInvoker.Close();
                if (rc != 0) {
                    log.warn((Object)("delRndcAllZones: RndcInvoker.Close() returned with status " + rc + " (" + WaitStatus.asString(rc) + ") while deleting domains"));
                } else if (isFinest) {
                    log.finest((Object)"delRndcAllZones: RndcInvoker.Close() is called and succeeded");
                }
            }
            catch (JniExecException | IOException e) {
                log.warn((Object)"delRndcAllZones: RndcInvokerClose threw an exception", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getDomainsManagedByRndc() {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".nzf");
            }
        };
        File namedDir = new File(DEFAULT_NAMED_DIR);
        File[] nzfFiles = namedDir.listFiles(filter);
        HashSet<String> domains = new HashSet<String>();
        if (nzfFiles == null) {
            log.error((Object)"Error reading files from /var/named.  Check integrity of the directory.  Domain name resolution will not function properly until this is resolved.");
            return domains;
        }
        for (File file : nzfFiles) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(file));
                String zoneData = br.readLine();
                while (zoneData != null) {
                    int startIdx = zoneData.indexOf(32) + 1;
                    int endIdx = zoneData.indexOf(32, startIdx);
                    domains.add(zoneData.substring(startIdx, endIdx));
                    zoneData = br.readLine();
                }
            }
            catch (FileNotFoundException e) {
                log.error((Object)("Error reading file " + file.getName()), (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)("Error reading file " + file.getName()), (Throwable)e);
            }
            catch (StringIndexOutOfBoundsException e) {
                log.error((Object)("Data format erorr in " + file.getName()), (Throwable)e);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        log.error((Object)("Error closing buffered reader for file " + file.getName()), (Throwable)e);
                    }
                }
            }
        }
        return domains;
    }

    public DomainUpdateList getDomainUpdateList() {
        return this.domainUpdateList;
    }

    public static void setMockPrintWriter(PrintWriter mockPrintWriter) {
        ZoneFileWriter.mockPrintWriter = mockPrintWriter;
    }

    public static void setJniExec(JniExecInterface jniexec) {
        ZoneFileWriter.jniexec = jniexec;
    }

    public void init() {
        if (!DMFactory.getInstance().isContainerProcess()) {
            return;
        }
        Callable<Boolean> task = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                Thread.currentThread().setName("initializeZoneFiles");
                log.info((Object)"Initializing ZoneFileWriter");
                Map<Long, ResolvedName> resolvedMap = ZoneFileWriter.this.getHostNameDAO().getResolvedMap();
                Set<FailoverGroup> fgs = ZoneFileWriter.this.getFailoverGroupDAO().getAllFailoverGroups();
                try {
                    ZoneFileWriter.this.removeAllZoneFiles();
                    ZoneFileWriter.this.publishZoneFiles(new ArrayList<ResolvedName>(resolvedMap.values()), true);
                    ZoneFileWriter.this.publishFGDNZoneFiles(fgs);
                }
                catch (IOException e) {
                    log.error((Object)"ZoneFileWriter initialization exception", (Throwable)e);
                    ZoneFileWriter.this.executor.schedule(this, 1000L, TimeUnit.MILLISECONDS);
                }
                return true;
            }
        };
        this.executor.schedule(task, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (!DMFactory.getInstance().isContainerProcess()) {
            return;
        }
        try {
            this.zoneFileChanges.put(new ZoneFileChange(oldObject, newObject));
        }
        catch (InterruptedException e) {
            log.error((Object)e.getLocalizedMessage());
        }
    }

    private void doObjectChanged(ZoneFileChange change) {
        Object oldObject = change.oldObject;
        Object newObject = change.newObject;
        if (oldObject instanceof ResolvedNameChangeObj || newObject instanceof ResolvedNameChangeObj) {
            ResolvedName oldName = ((ResolvedNameChangeObj)oldObject).getResolvedName();
            ResolvedName newName = ((ResolvedNameChangeObj)newObject).getResolvedName();
            String tableName = ((ResolvedNameChangeObj)oldObject).getTableChanged();
            if (log.isFinerEnabled()) {
                log.finer((Object)("Notified of change in HostNameDAO for table " + tableName + ", oldName=" + oldName + ", newName=" + newName));
            }
            try {
                if (tableName.equals("asmhostnameresolution")) {
                    if (oldName != null && newName == null) {
                        this.removeZoneFile(oldName.getFqdn(), DAOReplicationEvent.OperationType.DELETE);
                    } else if (oldName != null && newName != null) {
                        this.removeZoneFile(oldName.getFqdn(), DAOReplicationEvent.OperationType.DELETE);
                        this.publishZoneFile(newName, DAOReplicationEvent.OperationType.INSERT);
                    } else if (oldName == null && newName != null) {
                        this.publishZoneFile(newName, DAOReplicationEvent.OperationType.UPDATE);
                    }
                } else if (tableName.equals("asmhostnameresolutionip")) {
                    if (oldName != null && newName == null) {
                        this.publishZoneFile(oldName, DAOReplicationEvent.OperationType.UPDATE);
                    } else if (newName != null) {
                        this.publishZoneFile(newName, DAOReplicationEvent.OperationType.INSERT);
                    }
                }
            }
            catch (IOException e) {
                log.error((Object)"IOException thrown creating ZoneFileWriter", (Throwable)e);
            }
        } else if (oldObject instanceof ResolvedName || newObject instanceof ResolvedName) {
            ResolvedName oldName = (ResolvedName)oldObject;
            ResolvedName newName = (ResolvedName)newObject;
            if (log.isFinerEnabled()) {
                log.finer((Object)"Notified of change in HostNameDAO due to a HostnameDAO reinit");
            }
            try {
                if (oldName != null && newName == null) {
                    this.removeZoneFile(oldName.getFqdn(), DAOReplicationEvent.OperationType.DELETE);
                } else if (oldName != null && newName != null) {
                    this.removeZoneFile(oldName.getFqdn(), DAOReplicationEvent.OperationType.DELETE);
                    this.publishZoneFile(newName, DAOReplicationEvent.OperationType.INSERT);
                } else if (oldName == null && newName != null) {
                    this.publishZoneFile(newName, DAOReplicationEvent.OperationType.INSERT);
                }
            }
            catch (IOException e) {
                log.error((Object)"IOException thrown creating ZoneFileWriter", (Throwable)e);
            }
        } else if (oldObject instanceof SIPEntity || newObject instanceof SIPEntity) {
            SIPEntity oldEntity = (SIPEntity)oldObject;
            SIPEntity newEntity = (SIPEntity)newObject;
            if (log.isFinerEnabled()) {
                log.finer((Object)"Notified of change in SIPEntityDAO for table sipentity");
            }
            if (oldEntity == null && newEntity != null && "ASM".equals(newEntity.getType())) {
                this.publishFGDNZoneFiles(newEntity, DAOReplicationEvent.OperationType.UPDATE);
            }
        } else if (oldObject instanceof FailoverGroup || newObject instanceof FailoverGroup) {
            FailoverGroup oldFailoverGroup = (FailoverGroup)oldObject;
            FailoverGroup newFailoverGroup = (FailoverGroup)newObject;
            if (log.isFinerEnabled()) {
                log.finer((Object)"Notified of change in FailoverGroupDAO for table asm_failover_group");
            }
            if (oldFailoverGroup != null && newFailoverGroup == null) {
                this.removeFGDNZoneFile(oldFailoverGroup);
            }
            if (oldFailoverGroup != null && newFailoverGroup != null) {
                this.removeFGDNZoneFile(oldFailoverGroup);
                this.publishFGDNZoneFiles(newFailoverGroup, DAOReplicationEvent.OperationType.INSERT);
            }
            if (oldFailoverGroup == null && newFailoverGroup != null) {
                this.publishFGDNZoneFiles(newFailoverGroup, DAOReplicationEvent.OperationType.INSERT);
            }
        } else {
            log.warn((Object)("objectChanged(" + oldObject + "," + newObject + "): Default behavior executing, this could have ill effects: " + this.getClass().getSimpleName()));
            this.init();
        }
    }

    public void startZoneFileChangesThread() {
        this.objectChangeWorkerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (ZoneFileWriter.this.taskRunning) {
                    ZoneFileChange change = null;
                    try {
                        change = (ZoneFileChange)ZoneFileWriter.this.zoneFileChanges.take();
                    }
                    catch (InterruptedException e) {
                        log.error((Object)e.getLocalizedMessage());
                        ZoneFileWriter.this.taskRunning = false;
                    }
                    if (change == null) continue;
                    ZoneFileWriter.this.doObjectChanged(change);
                }
            }
        }, "Thread-ObjectChanged");
        Thread.UncaughtExceptionHandler unCaughtException = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                log.error((Object)("UncaughtException " + e));
            }
        };
        this.objectChangeWorkerThread.setUncaughtExceptionHandler(unCaughtException);
        this.objectChangeWorkerThread.start();
    }

    public void destroy() {
        this.taskRunning = false;
        this.objectChangeWorkerThread.interrupt();
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.zoneFileChanges.clear();
        this.executor = null;
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
        myInstance = null;
        log.info((Object)"ZoneFileWriter destroyed.");
    }

    class ZoneFileChange {
        private Object oldObject;
        private Object newObject;

        public ZoneFileChange(Object oldObject, Object newObject) {
            this.oldObject = oldObject;
            this.newObject = newObject;
        }
    }

    class DomainUpdateList {
        private Set<String> deletelist = new HashSet<String>();
        private Set<String> addlist = new HashSet<String>();

        DomainUpdateList() {
        }

        public void addToAddList(String domainName) {
            if (domainName == null) {
                return;
            }
            this.addlist.add(domainName);
        }

        public void addToDeleteList(String domainName) {
            if (domainName == null) {
                return;
            }
            this.deletelist.add(domainName);
        }

        public void removeFromAddList(String domainName) {
            if (domainName == null) {
                return;
            }
            this.addlist.remove(domainName);
        }

        public void removeFromDeleteList(String domainName) {
            if (domainName == null) {
                return;
            }
            this.deletelist.remove(domainName);
        }

        public Set<String> getAddList() {
            return this.addlist;
        }

        public Set<String> getDeleteList() {
            return this.deletelist;
        }

        public int getAddListSize() {
            return this.addlist.size();
        }

        public int getDeleteListSize() {
            return this.deletelist.size();
        }

        public void clearLists() {
            this.addlist.clear();
            this.deletelist.clear();
        }
    }
}

