/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.BatchStatementBuilder;
import com.avaya.asm.datamgr.dao.cassandra.CallHistoryKeyspaceBuilder;
import com.avaya.asm.datamgr.dao.cassandra.CallHistoryPreparedStatementType;
import com.avaya.asm.datamgr.dao.cassandra.CallHistoryPreparedStatements;
import com.avaya.asm.datamgr.dao.cassandra.ColumnFamilyMetaData;
import com.avaya.asm.datamgr.dao.cassandra.PreparedStatementBuilder;
import com.avaya.asm.datamgr.dao.cassandra.SessionBasedDAO;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspaceBuilder;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreStatementBuilder;
import com.avaya.asm.datamgr.helpers.CassandraConnectionInfo;
import com.avaya.asm.datamgr.objectapi.CallLog;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.CallHistoryKey;
import com.avaya.ustore.CassandraUtils;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.utils.UUIDs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class CallHistoryDAO
extends SessionBasedDAO {
    private final Logger log = AsmLogger.getLogger(CallHistoryDAO.class);
    private final CallHistoryPreparedStatements preparedStatements;
    private static final String DEFAULT_TTL = " WITH default_time_to_live =";
    private static final String CALLLOG_CF_NAME = "calllog";
    private static final String CALLLOGIDS_CF_NAME = "calllogids";
    private final String[] ttlTables = new String[]{"calllog", "calllogids"};
    private static UUID MIN_TIME_UUID = UUIDs.startOf((long)0L);
    private static final UserStoreKeyspace globalUserDCKeyspace = new UserStoreKeyspace("global_user_dc");
    static final int MAX_UUIDS_PER_SET = 5000;

    public CallHistoryDAO(SessionDAO sessionDAO) {
        super(sessionDAO);
        this.preparedStatements = new CallHistoryPreparedStatements(sessionDAO);
    }

    public List<UUID> getCallLogIds(CallHistoryKey key) throws DMException {
        CallHistoryKeyspaceBuilder builder = new CallHistoryKeyspaceBuilder(key.getKeyspace());
        CHPreparedStatementBuilder psBuilder = new CHPreparedStatementBuilder(CallHistoryPreparedStatementType.GET_CALLLOGIDS, (UserStoreKeyspaceBuilder)builder, key.getSetId());
        ResultSet rs = this.sessionDAO.executeStatement((UserStoreStatementBuilder)psBuilder, builder);
        ArrayList<UUID> callLogIds = new ArrayList<UUID>();
        for (Row row : rs) {
            Set uuids = row.getSet("ids", UUID.class);
            callLogIds.addAll(uuids);
        }
        return callLogIds;
    }

    public List<CallLog> getCallHistory(CallHistoryKey key, Integer limit) throws DMException {
        UserStoreKeyspace keyspace = key.getKeyspace();
        boolean isGlobalKS = keyspace.equals(globalUserDCKeyspace);
        CallHistoryKeyspaceBuilder builder = new CallHistoryKeyspaceBuilder(keyspace);
        CHPreparedStatementBuilder psBuilder = limit == null ? new CHPreparedStatementBuilder(isGlobalKS ? CallHistoryPreparedStatementType.GET_CALLLOG_WITH_GLOBALMIGRATED : CallHistoryPreparedStatementType.GET_CALLLOG, (UserStoreKeyspaceBuilder)builder, key.getSetId()) : new CHPreparedStatementBuilder(isGlobalKS ? CallHistoryPreparedStatementType.GET_CALLLOG_LIMIT_WITH_GLOBALMIGRATED : CallHistoryPreparedStatementType.GET_CALLLOG_LIMIT, (UserStoreKeyspaceBuilder)builder, key.getSetId(), limit);
        ResultSet rs = this.sessionDAO.executeStatement((UserStoreStatementBuilder)psBuilder, builder);
        ArrayList<CallLog> callLogs = new ArrayList<CallLog>();
        for (Row row : rs) {
            CallLog callLog = this.createCallLog(row, isGlobalKS);
            callLogs.add(callLog);
        }
        return callLogs;
    }

    public void updateCallLogs(CallHistoryKey key, List<UUID> deleteList, List<CallLog> addList) throws DMException {
        CallHistoryKeyspaceBuilder builder = new CallHistoryKeyspaceBuilder(key.getKeyspace());
        CHBatchStatementBuilder batchBuilder = new CHBatchStatementBuilder((UserStoreKeyspaceBuilder)builder);
        if (deleteList != null && !deleteList.isEmpty()) {
            this.deleteCallLogs(batchBuilder, key, deleteList);
        }
        if (addList != null) {
            ArrayList<UUID> addUuidList = new ArrayList<UUID>(addList.size());
            for (CallLog callLog : addList) {
                this.bindAndBatchInsertCallLog(batchBuilder, CallHistoryPreparedStatementType.ADD_CALLLOG, key.getSetId(), callLog, addUuidList);
            }
            this.bindAndBatchCallLogIds(batchBuilder, addUuidList, key, false);
        }
        this.sessionDAO.executeStatement((UserStoreStatementBuilder)batchBuilder, builder);
    }

    private void bindAndBatchInsertCallLog(CHBatchStatementBuilder batchBuilder, CallHistoryPreparedStatementType psType, long cscommprofilesetId, CallLog callLog, List<UUID> addUuidList) {
        UUID timeUuid = null;
        timeUuid = callLog.getUUID() == null ? CassandraUtils.genTimeUUID() : callLog.getUUID();
        addUuidList.add(timeUuid);
        batchBuilder.addToBatch(psType, cscommprofilesetId, timeUuid, callLog.getDuration(), callLog.isBridged(), callLog.isPrivacy(), new Date(callLog.getTimestamp()), callLog.getDialogId(), callLog.getLocalPartyId(), callLog.getRemotePartyId(), callLog.getRemotePartyName(), callLog.getType() != null ? callLog.getType().toString() : null, callLog.getRemotePartyAvExt());
    }

    private int bindAndBatchCallLogIdsByBatchSize(CHBatchStatementBuilder batch, CallHistoryPreparedStatementType psType, int startIdx, List<UUID> uuidList, long cscommprofilesetId) {
        int batchSize = uuidList.size() - startIdx;
        if (batchSize > 5000) {
            batchSize = 5000;
        }
        HashSet<UUID> uuidSet = new HashSet<UUID>();
        for (int i = startIdx; i < startIdx + batchSize; ++i) {
            uuidSet.add(uuidList.get(i));
        }
        batch.addToBatch(psType, uuidSet, cscommprofilesetId);
        return batchSize;
    }

    public void deleteCallLogs(CallHistoryKey key, List<UUID> callLogIds) throws DMException {
        CallHistoryKeyspaceBuilder builder = new CallHistoryKeyspaceBuilder(key.getKeyspace());
        CHBatchStatementBuilder batch = new CHBatchStatementBuilder((UserStoreKeyspaceBuilder)builder);
        this.deleteCallLogs(batch, key, callLogIds);
        this.sessionDAO.executeStatement((UserStoreStatementBuilder)batch, builder);
    }

    private void deleteCallLogs(CHBatchStatementBuilder batch, CallHistoryKey key, List<UUID> uuidList) throws DMException {
        for (UUID id : uuidList) {
            batch.addToBatch(CallHistoryPreparedStatementType.DELETE_CALLLOG_SETID_AND_ID_EQUALS, key.getSetId(), id);
        }
        this.bindAndBatchCallLogIds(batch, uuidList, key, true);
    }

    private void bindAndBatchCallLogIds(CHBatchStatementBuilder batchBuilder, List<UUID> uuidList, CallHistoryKey key, boolean deleteFlag) throws DMException {
        CallHistoryPreparedStatementType psType = deleteFlag ? CallHistoryPreparedStatementType.DELETE_CALLLOGIDS_SETID_ID : CallHistoryPreparedStatementType.ADD_CALLLOGIDS;
        int numUuids = uuidList.size();
        for (int startIdx = 0; startIdx < numUuids; startIdx += this.bindAndBatchCallLogIdsByBatchSize(batchBuilder, psType, startIdx, uuidList, key.getSetId())) {
        }
    }

    public void deleteAllCallLogs(CallHistoryKey key, boolean deleteSpecialLog) throws DMException {
        String fcn_name = "deleteAllCallLogs";
        boolean isFinest = this.log.isFinestEnabled();
        CallHistoryKeyspaceBuilder builder = new CallHistoryKeyspaceBuilder(key.getKeyspace());
        CHBatchStatementBuilder batchBuilder = new CHBatchStatementBuilder((UserStoreKeyspaceBuilder)builder);
        long setId = key.getSetId();
        if (deleteSpecialLog) {
            batchBuilder.addToBatch(CallHistoryPreparedStatementType.DELETE_ALL_CALLLOG_SETID, setId);
        } else {
            batchBuilder.addToBatch(CallHistoryPreparedStatementType.DELETE_CALLLOG_SETID_AND_ID_GREATER_THAN, setId, this.getMinTimeUUID());
        }
        if (isFinest) {
            this.log.finest((Object)("deleteAllCallLogs: added the delete CallLog ps to the batch, deleteMigrationLog = " + deleteSpecialLog));
        }
        batchBuilder.addToBatch(CallHistoryPreparedStatementType.DELETE_CALLLOGIDS_SETID, key.getSetId());
        if (isFinest) {
            this.log.finest((Object)"deleteAllCallLogs: added the delete CallLogIds ps to the batch");
        }
        this.sessionDAO.executeStatement((UserStoreStatementBuilder)batchBuilder, builder);
    }

    private CallLog createCallLog(Row row, boolean isGlobalKS) {
        Date dateTime;
        boolean isFiner = this.log.isFinerEnabled();
        String fcn_name = "createCallLog";
        if (isFiner) {
            this.log.finer((Object)"createCallLog: enter");
        }
        long timestamp = (dateTime = row.getTimestamp("datetime")) != null ? dateTime.getTime() : 0L;
        String typeStr = row.getString("type");
        CallLog.CallLogType type = typeStr == null ? CallLog.CallLogType.unknown : CallLog.CallLogType.valueOf(typeStr);
        CallLog callLog = new CallLog(row.getUUID("id"), timestamp, row.getInt("duration"), row.getString("local_number"), row.getString("number"), row.getString("avext"), row.getString("name"), row.getString("dialog_id"), type, row.getBool("bridged"), row.getBool("privacy"));
        if (isGlobalKS && !row.isNull("is_global_migrated")) {
            callLog.setGlobalMigrated(row.getBool("is_global_migrated"));
        }
        if (isFiner) {
            this.log.finer((Object)("createCallLog: leave, callLog=" + callLog));
        }
        return callLog;
    }

    public Long getCountCallLogIds(long csuserId, long cscommprofilesetId, UserStoreKeyspace keyspace) throws DMException {
        CallHistoryKeyspaceBuilder builder = new CallHistoryKeyspaceBuilder(keyspace);
        CHPreparedStatementBuilder psBuilder = new CHPreparedStatementBuilder(CallHistoryPreparedStatementType.GET_USERID_COUNT_CALLLOGIDS, (UserStoreKeyspaceBuilder)builder, csuserId, cscommprofilesetId);
        ResultSet resultSet = this.sessionDAO.executeStatement((UserStoreStatementBuilder)psBuilder, builder);
        Long recordCount = 0L;
        for (Row row : resultSet) {
            recordCount = row.getLong(0);
        }
        return recordCount;
    }

    public void getSetIdsForKeyspace(UserStoreKeyspace keyspace, CassandraConnectionInfo cConnInfo, Collection<Long> ids) throws DMException {
        String fcn_name = "getSetIdsForKeyspace";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getSetIdsForKeyspace: enter, ids.size=" + ids.size()));
        }
        CallHistoryKeyspaceBuilder builder = new CallHistoryKeyspaceBuilder(keyspace);
        CHPreparedStatementBuilder psBuilder = new CHPreparedStatementBuilder(CallHistoryPreparedStatementType.GET_SETID_CALLLOGIDS, (UserStoreKeyspaceBuilder)builder, new Object[0]);
        long startTime = System.currentTimeMillis();
        ResultSet rs = this.sessionDAO.executeStatement(psBuilder);
        long lastSetId = 0L;
        for (Row row : rs) {
            if (row.isNull(0)) {
                this.log.warn((Object)"getSetIdsForKeyspace: retrieved a null ownercsuserid");
                continue;
            }
            lastSetId = row.getLong(0);
            ids.add(lastSetId);
        }
        int idSize = ids.size();
        int CHUNK_SIZE = 500;
        while (idSize != 0 && idSize % CHUNK_SIZE == 0) {
            psBuilder = new CHPreparedStatementBuilder(CallHistoryPreparedStatementType.GET_SETID_CALLLOGIDS_TOKEN, (UserStoreKeyspaceBuilder)builder, lastSetId);
            rs = this.sessionDAO.executeStatement(psBuilder);
            for (Row row : rs) {
                if (row.isNull(0)) {
                    this.log.warn((Object)"getSetIdsForKeyspace: retrieved a null ownercsuserid");
                    continue;
                }
                lastSetId = row.getLong(0);
                ids.add(lastSetId);
            }
            idSize = ids.size();
        }
        long endTime = System.currentTimeMillis() - startTime;
        if (isFiner) {
            this.log.finer((Object)("getSetIdsForKeyspace: leave, ids.size=" + ids.size() + ", totalTimeMS=" + (endTime - startTime)));
        }
    }

    public boolean checkAndSetTimeToLive(UserStoreKeyspace keyspace, long seconds) throws DMException {
        String fcn_name = "checkAndSetTimeToLive";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("checkAndSetTimeToLive: enter, keyspace = " + keyspace + ", seconds = " + seconds));
        }
        boolean fcnRC = true;
        String TTL_CALLLOGS_QRY = "ALTER TABLE " + keyspace.getName() + ".";
        for (String tableName : this.ttlTables) {
            if (seconds == this.getCurrentTTL(keyspace, tableName)) continue;
            fcnRC = false;
            String query = TTL_CALLLOGS_QRY + tableName + DEFAULT_TTL + seconds;
            this.sessionDAO.executeQuery(query);
        }
        if (isFiner) {
            this.log.finer((Object)"checkAndSetTimeToLive: leave");
        }
        return fcnRC;
    }

    public long getCurrentTTL(UserStoreKeyspace keyspace, String tableName) throws DMException {
        String fcn_name = "getCurrentTTL";
        ColumnFamilyMetaData cfMetaData = this.sessionDAO.getColumnFamily(keyspace.getName(), tableName);
        if (cfMetaData == null) {
            this.log.error((Object)("getCurrentTTLcaught DMException attempting to load current TTL of calllog/callLogids table :" + tableName));
            throw new DMException("cannot get metadata for keyspace=" + keyspace.getName() + ", table=" + tableName);
        }
        return cfMetaData.getDefaultTimeToLive();
    }

    public boolean calllogsMigratedToGlobalDC(long cscommprofilesetId) throws DMException {
        String fcn_name = "calllogsMigratedToGlobalDC";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("calllogsMigratedToGlobalDC: enter, cscommprofilesetId = " + cscommprofilesetId));
        }
        CallHistoryKeyspaceBuilder builder = new CallHistoryKeyspaceBuilder(globalUserDCKeyspace);
        CHPreparedStatementBuilder psBuilder = new CHPreparedStatementBuilder(CallHistoryPreparedStatementType.GET_MIGRATION_CALLLOG, (UserStoreKeyspaceBuilder)builder, cscommprofilesetId, this.getMinTimeUUID());
        ResultSet rs = this.sessionDAO.executeStatement((UserStoreStatementBuilder)psBuilder, builder);
        boolean isGlobalKS = true;
        int recordCount = 0;
        for (Row row : rs) {
            ++recordCount;
            CallLog callLog = this.createCallLog(row, isGlobalKS);
            Boolean isGlobalMigrated = callLog.isGlobalMigrated();
            if (isGlobalMigrated == null || !isGlobalMigrated.booleanValue()) continue;
            if (isFiner) {
                this.log.finer((Object)("calllogsMigratedToGlobalDC: leave, Migration is Done, for cscommprofilesetId =" + cscommprofilesetId));
            }
            return true;
        }
        if (recordCount > 1) {
            this.log.warn((Object)("calllogsMigratedToGlobalDCSpecialCallLog can't be more than one for cscommprofilesetId : " + cscommprofilesetId));
        }
        if (isFiner) {
            this.log.finer((Object)("calllogsMigratedToGlobalDC: leave, Migration is Not Done, for cscommprofilesetId =" + cscommprofilesetId));
        }
        return false;
    }

    public void setMigrationCallLog(long cscommprofilesetId) throws DMException {
        CallHistoryKeyspaceBuilder builder = new CallHistoryKeyspaceBuilder(globalUserDCKeyspace);
        CHBatchStatementBuilder batchBuilder = new CHBatchStatementBuilder((UserStoreKeyspaceBuilder)builder);
        batchBuilder.addToBatch(CallHistoryPreparedStatementType.SET_MIGRATION_CALLLOG, cscommprofilesetId, MIN_TIME_UUID, new Date(), true);
        this.sessionDAO.executeStatement((UserStoreStatementBuilder)batchBuilder, builder);
    }

    public void clearMigrationCallLog(long cscommprofilesetId) throws DMException {
        CallHistoryKeyspaceBuilder builder = new CallHistoryKeyspaceBuilder(globalUserDCKeyspace);
        CHBatchStatementBuilder batchBuilder = new CHBatchStatementBuilder((UserStoreKeyspaceBuilder)builder);
        batchBuilder.addToBatch(CallHistoryPreparedStatementType.CLEAR_MIGRATION_CALLLOG, cscommprofilesetId, MIN_TIME_UUID);
        this.sessionDAO.executeStatement((UserStoreStatementBuilder)batchBuilder, builder);
    }

    public UUID getMinTimeUUID() {
        return MIN_TIME_UUID;
    }

    public class CHBatchStatementBuilder
    extends BatchStatementBuilder<CallHistoryPreparedStatementType> {
        public CHBatchStatementBuilder(UserStoreKeyspaceBuilder builder) {
            super(CallHistoryDAO.this.preparedStatements, builder);
        }
    }

    public class CHPreparedStatementBuilder
    extends PreparedStatementBuilder<CallHistoryPreparedStatementType> {
        public CHPreparedStatementBuilder(CallHistoryPreparedStatementType type, UserStoreKeyspaceBuilder builder, Object ... args) {
            super(CallHistoryDAO.this.preparedStatements, type, builder, args);
        }
    }
}

