/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.LocationPatternDM;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.asm.datamgr.objectapi.LocationPattern;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LocationPatternDAO
extends DataAccessObject {
    protected final Logger log = AsmLogger.getLogger(LocationPatternDAO.class);
    protected static final String getLocationPatterns = "SELECT id, ipaddresspattern, routingorigination_id FROM routingoriginationpattern";
    protected static final String getLocationPattern = "SELECT id, ipaddresspattern, routingorigination_id FROM routingoriginationpattern WHERE id = ?";
    protected static final ResultSetMapper patternMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, LocationPattern> patternMap = new HashMap<Long, LocationPattern>();
            while (rs.next()) {
                patternMap.put(rs.getLong("id"), new LocationPattern(rs.getString("ipaddresspattern"), rs.getLong("routingorigination_id")));
            }
            return patternMap;
        }
    };
    LocationPatternDM locationPatternDM = null;

    public LocationPatternDAO() {
        super(true);
    }

    @Override
    protected Object getMainCollection() {
        this.lock.acquireReadLock();
        try {
            Map<Long, LocationPattern> map = this.locationPatternDM.getPatternMap();
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + LocationPatternDAO.class.getSimpleName()));
        }
        LocationPatternDM tmpLocationPatternDM = null;
        try {
            Object[] params = new Object[]{};
            Map patternMap = (Map)this.dataSource.executeQuery(getLocationPatterns, params, patternMapper);
            tmpLocationPatternDM = new LocationPatternDM(patternMap);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.locationPatternDM = tmpLocationPatternDM;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("routingoriginationpattern");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        Long id = event.getKey();
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)this.logTag(operation, tableName, id));
        }
        LocationPattern oldPattern = null;
        LocationPattern newPattern = null;
        boolean lockHeld = false;
        try {
            Map map = null;
            if (operation != DAOReplicationEvent.OperationType.DELETE) {
                Object[] params = new Object[]{id};
                map = (Map)this.dataSource.executeQuery(getLocationPattern, params, patternMapper);
            }
            this.lock.acquireWriteLock();
            lockHeld = true;
            oldPattern = this.locationPatternDM.removePattern(id);
            if (map != null && (newPattern = (LocationPattern)map.get(id)) != null) {
                if (this.log.isFinerEnabled()) {
                    this.log.finer((Object)(this.logTag(operation, tableName, id) + "Retrieved new LocationPattern " + newPattern));
                }
                this.locationPatternDM.addPattern(id, newPattern);
            }
        }
        catch (DMException e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            this.log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + LocationPatternDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
            newPattern = null;
            oldPattern = null;
            this.reinit();
            if (!this.okay()) {
                this.log.error((Object)(this.logTag(operation, tableName, id) + "Update NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
        }
        if (oldPattern != null || newPattern != null) {
            this.updateListeners(oldPattern, newPattern);
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(this.logTag(operation, tableName, id) + "Update successful"));
        }
    }

    public Long getMatchingLocation(String address) {
        if (address != null) {
            try {
                return this.getMatchingLocation(IPAddress.parseIPAddr(address));
            }
            catch (ParseException e) {
                this.log.warn((Object)("getMatchingLocation: bad address " + address));
            }
        }
        return null;
    }

    public Long getMatchingLocation(IPAddress address) {
        this.lock.acquireReadLock();
        try {
            Long l = this.locationPatternDM.getMatchingLocation(address);
            return l;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(parameterNames={"id"}, description="Get a pattern array for this Location ID.")
    public String[] getLocationPatterns(Long id) {
        this.lock.acquireReadLock();
        try {
            String[] stringArray = this.locationPatternDM.getLocationPatternsAsArray(id);
            return stringArray;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all provisioned LocationPatterns.")
    public String getLocationPatterns() {
        this.lock.acquireReadLock();
        try {
            String string = this.locationPatternDM.getLocationPatternsAsString();
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }
}

