/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.CommProfileDAO;
import com.avaya.asm.datamgr.dao.IsDeletedHandler;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.objectapi.CsCommProfile;
import com.avaya.asm.datamgr.objectapi.PsCommProfile;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PsCommProfileDAO
extends CommProfileDAO {
    private final Logger log = AsmLogger.getLogger(PsCommProfileDAO.class);
    public static final String commProfileType = "PS";
    protected final String getPSProfile = this.getSelectFields() + " WHERE cs.cscommprofilesetid NOT IN (" + IsDeletedHandler.isDeletedCommProfileSetId + ") AND cs.commprofiletype = '" + this.getCommProfileType() + "' AND cs.cscommprofilesetid=?";
    private static final ResultSetMapper mapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ConcurrentHashMap<Long, PsCommProfile> profileMap = new ConcurrentHashMap<Long, PsCommProfile>();
            while (rs.next()) {
                long id = rs.getLong("id");
                profileMap.put(id, new PsCommProfile(id, (Long)rs.getObject("cscommprofilesetid"), (Long)rs.getObject("preferredhandleid"), (Long)rs.getObject("ps_sipentity_id"), (Long)rs.getObject("im_gateway_sipentity_id")));
            }
            return profileMap;
        }
    };
    private static final ResultSetMapper psmapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            PsCommProfile psProfile = null;
            while (rs.next()) {
                psProfile = new PsCommProfile(rs.getLong("id"), (Long)rs.getObject("cscommprofilesetid"), (Long)rs.getObject("preferredhandleid"), (Long)rs.getObject("ps_sipentity_id"), (Long)rs.getObject("im_gateway_sipentity_id"));
            }
            return psProfile;
        }
    };

    @Override
    public String getMainTable() {
        return "pscommprofile";
    }

    @Override
    protected String getSelectFields() {
        return "SELECT cs.id, cs.cscommprofilesetid, cs.preferredhandleid, ps.ps_sipentity_id, ps.im_gateway_sipentity_id FROM cscommprofile cs JOIN pscommprofile ps ON cs.id=ps.id";
    }

    @Override
    protected ResultSetMapper getMapper() {
        return mapper;
    }

    public PsCommProfile getPsCommProfile(Long id) {
        try {
            this.lock.acquireReadLock();
            if (id != null) {
                PsCommProfile psCommProfile = (PsCommProfile)this.csCommProfileMap.get(id);
                return psCommProfile;
            }
            PsCommProfile psCommProfile = null;
            return psCommProfile;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsCommProfile getPsCommProfileBySetId(Long setId) {
        if (setId == null) {
            return null;
        }
        try {
            this.lock.acquireReadLock();
            Long id = (Long)this.setIdMap.get(setId);
            if (id != null) {
                PsCommProfile psCommProfile = (PsCommProfile)this.csCommProfileMap.get(id);
                return psCommProfile;
            }
            Object[] params = new Object[]{setId};
            PsCommProfile psProfile = null;
            try {
                psProfile = (PsCommProfile)this.dataSource.executeQuery(this.getPSProfile, params, psmapper);
            }
            catch (DMException e) {
                this.log.error((Object)"DMException while querying presence server");
            }
            PsCommProfile psCommProfile = psProfile;
            return psCommProfile;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all PsCommProfiles cached in memory.")
    public Map<Long, CsCommProfile> getPsCommProfiles() {
        this.lock.acquireReadLock();
        try {
            Map<Long, CsCommProfile> map = Collections.unmodifiableMap(this.csCommProfileMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(parameterNames={"setId"}, description="Set PsCommProfiles cached in memory for setId.")
    public String setPsCommProfiles(Long setId) {
        this.lock.acquireWriteLock();
        try {
            Long id = (Long)this.setIdMap.get(setId);
            this.csCommProfileMap.remove(id);
            String string = "success";
            return string;
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception while setting cache");
            ex.printStackTrace();
        }
        finally {
            this.lock.releaseWriteLock();
            return "failure";
        }
    }

    public static void main(String[] args) {
        PsCommProfileDAO dao = new PsCommProfileDAO();
        dao.printQueries();
    }

    @Override
    protected String getCommProfileType() {
        return commProfileType;
    }
}

