/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmCommon;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.ConsumesLoadRules;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.IsDeletedHandler;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.helpers.FlexCache;
import com.avaya.asm.datamgr.loadrulekeys.CacheSize;
import com.avaya.asm.datamgr.loadrules.LoadRule;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ConsumesLoadRules(key={CacheSize.class})
public class SetLocationDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(SetLocationDAO.class);
    protected boolean dynFields = false;
    private int capacity = 1;
    protected FlexCache<Long, Long> setLocationMap = new FlexCache();
    public static final String getSetLocations = "SELECT set.id, asm.homelocation_id FROM cscommprofile cs JOIN asmcommprofile asm ON cs.id=asm.id JOIN dyn_asmcommprofile dasm ON dasm.id=asm.id JOIN cscommprofileset set ON set.id=cs.cscommprofilesetid WHERE set.csuserid NOT IN (" + IsDeletedHandler.isDeletedCsUserId + ")";
    public static final String getLocalSetLocations = getSetLocations + " AND dasm.is_local=true";
    public static final String setIdStatement = getSetLocations + " AND set.id = ?";
    public static final String csIdStatement = getSetLocations + " AND cs.id = ?";
    public static final String asmIdStatement = getSetLocations + " AND asm.id = ?";
    public static final String getSetIdByUserId = "SELECT set.id FROM cscommprofileset set JOIN csuser u ON set.csuserid=u.id WHERE u.id = ?";
    protected static final ResultSetMapper mapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, Long> map = new HashMap<Long, Long>();
            while (rs.next()) {
                map.put(rs.getLong("id"), rs.getLong("homelocation_id"));
            }
            return map;
        }
    };
    protected static final ResultSetMapper userMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return rs.getLong("id");
            }
            return null;
        }
    };

    public SetLocationDAO() {
        super(false);
    }

    protected void setCapacity(int capacity) {
        if (!AsmCommon.jUnitEnvironment) {
            throw new IllegalStateException("Attempt to directly set Load Rule!");
        }
        this.capacity = capacity;
    }

    protected int getCapacity() {
        return this.capacity;
    }

    @Override
    protected void setLoadRules(Collection<LoadRule> appLoadRules) {
        super.setLoadRules(appLoadRules);
        boolean reinit = false;
        int bestCacheValue = 1;
        boolean bestDynFieldsValue = false;
        block0: for (Map.Entry entry : this.loadRules.entrySet()) {
            if ("cachesize".equals(((String)entry.getKey()).toLowerCase())) {
                for (String value : (Set)entry.getValue()) {
                    int cap = Integer.parseInt(value);
                    if (cap <= 0) {
                        bestCacheValue = -1;
                        continue block0;
                    }
                    if (bestCacheValue == -1 || cap <= bestCacheValue) continue;
                    bestCacheValue = cap;
                }
                continue;
            }
            if ("dynfields".equals(((String)entry.getKey()).toLowerCase())) {
                for (String value : (Set)entry.getValue()) {
                    if (!Boolean.parseBoolean(value)) continue;
                    bestDynFieldsValue = true;
                    continue block0;
                }
                continue;
            }
            this.log.warn((Object)("Unrecognized Load Rule detected; ignoring: " + (String)entry.getKey()));
        }
        if (bestCacheValue != this.capacity) {
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)("Setting FlexCache capacity to " + bestCacheValue));
            }
            this.capacity = bestCacheValue;
            reinit = true;
        }
        if (bestDynFieldsValue != this.dynFields) {
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)("Setting dynamic fields to " + bestDynFieldsValue));
            }
            this.dynFields = bestDynFieldsValue;
            reinit = true;
        }
        if (reinit && !this.uninitialized()) {
            this.reinit();
        }
    }

    protected AsmInstanceDAO getAsmInstanceDAO() {
        return (AsmInstanceDAO)DMFactory.getInstance().getDataMgr(AsmInstanceDAO.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        FlexCache setLocationMapTMP;
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + this.getClass().getSimpleName()));
        }
        try {
            Object[] params = new Object[]{};
            HashMap setLocationMapQueryResults = (HashMap)this.dataSource.executeQuery(this.getCapacity() >= 0 ? getLocalSetLocations : getSetLocations, params, mapper);
            setLocationMapTMP = new FlexCache(this.getCapacity(), setLocationMapQueryResults, true);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.setLocationMap = setLocationMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        long id = event.getKey();
        if ("cshandle".equals(tableName)) {
            return;
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)this.logTag(operation, tableName, id));
        }
        Object[] params = new Object[]{id};
        boolean lockHeld = false;
        try {
            if ("csuser".equals(tableName)) {
                Long setId = (Long)this.dataSource.executeQuery(getSetIdByUserId, params, userMapper);
                if (setId != null) {
                    if (this.getCapacity() >= 0) {
                        this.lock.acquireWriteLock();
                        lockHeld = true;
                        this.setLocationMap.remove(setId);
                    } else {
                        params = new Object[]{setId};
                        Map map = (Map)this.dataSource.executeQuery(setIdStatement, params, mapper);
                        this.lock.acquireWriteLock();
                        lockHeld = true;
                        if (map.isEmpty()) {
                            this.setLocationMap.remove(setId);
                            if (this.log.isFinestEnabled()) {
                                this.log.finest((Object)(this.logTag(operation, tableName, id) + "Set " + setId + " no longer maps to a Location"));
                            }
                        } else {
                            for (Map.Entry entry : map.entrySet()) {
                                this.setLocationMap.put((Long)entry.getKey(), (Long)entry.getValue());
                                if (!this.log.isFinestEnabled()) continue;
                                this.log.finest((Object)(this.logTag(operation, tableName, id) + "Set " + entry.getKey() + " now maps to Location " + entry.getValue()));
                            }
                        }
                    }
                }
            } else if ("cscommprofileset".equals(tableName)) {
                if (this.getCapacity() >= 0) {
                    this.lock.acquireWriteLock();
                    lockHeld = true;
                    this.setLocationMap.remove(id);
                } else {
                    Map map = (Map)this.dataSource.executeQuery(setIdStatement, params, mapper);
                    this.lock.acquireWriteLock();
                    lockHeld = true;
                    if (map.isEmpty()) {
                        this.setLocationMap.remove(id);
                        if (this.log.isFinestEnabled()) {
                            this.log.finest((Object)(this.logTag(operation, tableName, id) + "Set " + id + " no longer maps to a Location"));
                        }
                    } else {
                        for (Map.Entry entry : map.entrySet()) {
                            this.setLocationMap.put((Long)entry.getKey(), (Long)entry.getValue());
                            if (!this.log.isFinestEnabled()) continue;
                            this.log.finest((Object)(this.logTag(operation, tableName, id) + "Set " + entry.getKey() + " now maps to Location " + entry.getValue()));
                        }
                    }
                }
            } else if ("cscommprofile".equals(tableName)) {
                if (this.getCapacity() < 0) {
                    Map map = (Map)this.dataSource.executeQuery(csIdStatement, params, mapper);
                    this.lock.acquireWriteLock();
                    lockHeld = true;
                    for (Map.Entry entry : map.entrySet()) {
                        if (this.getCapacity() >= 0 && !this.setLocationMap.containsKey(entry.getKey())) continue;
                        this.setLocationMap.put((Long)entry.getKey(), (Long)entry.getValue());
                        if (!this.log.isFinestEnabled()) continue;
                        this.log.finest((Object)(this.logTag(operation, tableName, id) + "Set " + entry.getKey() + " now maps to Location " + entry.getValue()));
                    }
                }
            } else if ("dyn_asmcommprofile".equals(tableName) || "asmcommprofile".equals(tableName)) {
                Map map = (Map)this.dataSource.executeQuery(asmIdStatement, params, mapper);
                this.lock.acquireWriteLock();
                lockHeld = true;
                for (Map.Entry entry : map.entrySet()) {
                    if (this.getCapacity() >= 0 && !this.setLocationMap.containsKey(entry.getKey())) continue;
                    this.setLocationMap.put((Long)entry.getKey(), (Long)entry.getValue());
                    if (!this.log.isFinestEnabled()) continue;
                    this.log.finest((Object)(this.logTag(operation, tableName, id) + "Set " + entry.getKey() + " now maps to Location " + entry.getValue()));
                }
            }
        }
        catch (Exception e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            this.log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                this.log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
            }
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(this.logTag(operation, tableName, id) + "update successful"));
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("csuser");
        list.add("cscommprofileset");
        list.add("cscommprofile");
        list.add(this.dynFields ? "dyn_asmcommprofile" : "asmcommprofile");
        list.add("cshandle");
        return list;
    }

    @Override
    protected Object getMainCollection() {
        return this.setLocationMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getLocationId(Long setId) {
        if (setId == null) {
            return null;
        }
        Long locId = null;
        try {
            this.lock.acquireReadLock();
            locId = this.setLocationMap.get(setId);
        }
        finally {
            this.lock.releaseReadLock();
        }
        if (locId != null) {
            return locId;
        }
        if (this.getCapacity() < 0) {
            return null;
        }
        try {
            Object[] params = new Object[]{setId};
            Map map = (Map)this.dataSource.executeQuery(setIdStatement, params, mapper);
            if (this.log.isFinerEnabled()) {
                this.log.finer((Object)("Read object(s) into FlexCache: " + map));
            }
            if (map != null) {
                locId = (Long)map.get(setId);
            }
        }
        catch (DMException e) {
            this.log.error((Object)("Error reading Database for " + setId), (Throwable)e);
        }
        if (locId != null) {
            try {
                this.lock.acquireWriteLock();
                this.setLocationMap.put(setId, locId);
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        return locId;
    }

    @SMConsole(description="Print a map of CommProfileSet IDs to Location IDs.")
    public Map<Long, Long> getSetLocationMappings() {
        this.lock.acquireReadLock();
        try {
            Map<Long, Long> map = this.setLocationMap.getCopyOfInternalMap();
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }
}

