/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.IsDeletedHandler;
import com.avaya.asm.datamgr.dao.LocalUserDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.LocalUser;
import com.avaya.common.logging.client.Logger;
import java.lang.ref.WeakReference;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class TenantDAO
extends DataAccessObject
implements DMListener {
    private static final Logger log = AsmLogger.getLogger(TenantDAO.class);
    protected Map<Long, Set<Long>> userToTenantMap = new HashMap<Long, Set<Long>>(2);
    protected Map<Long, String> tenantNameMap = new HashMap<Long, String>(2);
    protected Boolean multitenancyEnabled = null;
    protected final WeakHashMap<Set<Long>, WeakReference<Set<Long>>> tenantGroups = new WeakHashMap();
    private static final String getUserMapping = "SELECT cstassign.cspersonid, cstassign.cstenantid FROM csusertenantassign cstassign, cscommprofileset set, cscommprofile cs, asmcommprofile asm, dyn_asmcommprofile dasm";
    protected static final String getLocalUsersMapping = "SELECT cstassign.cspersonid, cstassign.cstenantid FROM csusertenantassign cstassign, cscommprofileset set, cscommprofile cs, asmcommprofile asm, dyn_asmcommprofile dasm WHERE cstassign.cspersonid NOT IN (" + IsDeletedHandler.isDeletedCsUserId + ") AND set.csuserid = cstassign.cspersonid AND cs.cscommprofilesetid = set.id AND asm.id = cs.id AND dasm.id = asm.id AND dasm.is_local = true";
    protected static final String getTenantMapping = getLocalUsersMapping + " AND cstassign.cspersonid = ?";
    protected static final String getTenantNames = "SELECT id, name FROM cstenant";
    protected static final String getTenantName = "SELECT id, name FROM cstenant WHERE id = ?";
    protected static final String getMultiTenancyStatus = "SELECT isenabled FROM csmultitenancystatus";
    private static final boolean optimizeGroups = true;
    protected ResultSetMapper userMapper = new ResultSetMapper(){

        @Override
        public synchronized Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>();
            while (rs.next()) {
                long personId = rs.getLong("cspersonid");
                long tenantId = rs.getLong("cstenantid");
                HashSet<Long> value = (HashSet<Long>)map.get(personId);
                if (value == null) {
                    value = new HashSet<Long>(1);
                    map.put(personId, value);
                }
                if (value.contains(tenantId)) continue;
                value.add(tenantId);
            }
            return TenantDAO.this.optimizeTenantSets(map);
        }
    };
    protected static final ResultSetMapper nameMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, String> map = new HashMap<Long, String>();
            while (rs.next()) {
                map.put(rs.getLong("id"), rs.getString("name"));
            }
            return map;
        }
    };
    protected static final ResultSetMapper statusMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return rs.getBoolean("isenabled");
            }
            return null;
        }
    };

    protected LocalUserDAO getLocalUserDAO() {
        return (LocalUserDAO)this.getDataMgr(LocalUserDAO.class);
    }

    public TenantDAO() {
        super(false);
    }

    private synchronized Set<Long> getTenantGroup(Set<Long> group) {
        WeakReference<Set<Long>> reference = this.tenantGroups.get(group);
        if (reference != null) {
            return (Set)reference.get();
        }
        return null;
    }

    protected synchronized Map<Long, Set<Long>> optimizeTenantSets(Map<Long, Set<Long>> tmpMap) {
        long start = System.currentTimeMillis();
        if (log.isFinestEnabled()) {
            log.finest((Object)"Starting optimization of tenant groups.");
        }
        HashMap<Long, Set<Long>> retMap = new HashMap<Long, Set<Long>>(2);
        for (Map.Entry<Long, Set<Long>> entry : tmpMap.entrySet()) {
            Set<Long> originalSet = entry.getValue();
            Set<Long> referenceSet = this.getTenantGroup(originalSet);
            if (referenceSet == null) {
                this.tenantGroups.put(originalSet, new WeakReference<Set<Long>>(originalSet));
                retMap.put(entry.getKey(), originalSet);
                continue;
            }
            retMap.put(entry.getKey(), referenceSet);
        }
        long elapsed = System.currentTimeMillis() - start;
        if (log.isFinestEnabled()) {
            log.finest((Object)("Completed optimization of tenant groups in " + elapsed + " ms."));
        }
        return retMap;
    }

    @Override
    public Object getMainCollection() {
        return this.userToTenantMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + TenantDAO.class.getSimpleName()));
        }
        Boolean multitenancyEnabledTMP = null;
        Map userTenantMapTMP = new HashMap(1);
        Map tenantNameMapTMP = new HashMap(1);
        Object[] params = new Object[]{};
        this.getLocalUserDAO();
        try {
            multitenancyEnabledTMP = (Boolean)this.dataSource.executeQuery(getMultiTenancyStatus, params, statusMapper);
            userTenantMapTMP = (Map)this.dataSource.executeQuery(getLocalUsersMapping, params, this.userMapper);
            tenantNameMapTMP = (Map)this.dataSource.executeQuery(getTenantNames, params, nameMapper);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.multitenancyEnabled = multitenancyEnabledTMP;
                this.userToTenantMap = userTenantMapTMP;
                this.tenantNameMap = tenantNameMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("csmultitenancystatus");
        list.add("csusertenantassign");
        list.add("cstenant");
        list.add("dyn_asmcommprofile");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        Long id = event.getKey();
        boolean locked = false;
        if (log.isFineEnabled()) {
            log.fine((Object)this.logTag(operation, tableName, id));
        }
        try {
            if ("cstenant".equals(tableName)) {
                String newName = null;
                if (!DAOReplicationEvent.OperationType.DELETE.equals((Object)operation)) {
                    Map map = (Map)this.dataSource.executeQuery(getTenantName, new Object[]{id}, nameMapper);
                    newName = (String)map.get(id);
                }
                this.lock.acquireWriteLock();
                locked = true;
                if (newName == null) {
                    this.tenantNameMap.remove(id);
                } else {
                    this.tenantNameMap.put(id, newName);
                }
            } else if ("csmultitenancystatus".equals(tableName)) {
                Boolean multitenancyEnabledTMP = (Boolean)this.dataSource.executeQuery(getMultiTenancyStatus, new Object[0], statusMapper);
                this.lock.acquireWriteLock();
                locked = true;
                this.multitenancyEnabled = multitenancyEnabledTMP;
            } else if ("csusertenantassign".equals(tableName)) {
                Set newAssign = null;
                if (!DAOReplicationEvent.OperationType.DELETE.equals((Object)operation)) {
                    Map map = (Map)this.dataSource.executeQuery(getTenantMapping, new Object[]{id}, this.userMapper);
                    newAssign = (Set)map.get(id);
                }
                this.lock.acquireWriteLock();
                locked = true;
                this.userToTenantMap.remove(id);
                if (newAssign != null) {
                    if (log.isFinerEnabled()) {
                        log.finer((Object)("Retrieved new tenant mapping: " + id + " -> " + newAssign));
                    }
                    this.userToTenantMap.put(id, newAssign);
                }
            }
        }
        catch (DMException e) {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
            log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (locked) {
                this.lock.releaseWriteLock();
            }
        }
        if (log.isFineEnabled()) {
            log.fine((Object)(this.logTag(operation, tableName, id) + "Update successful"));
        }
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (oldObject instanceof LocalUser || newObject instanceof LocalUser) {
            if (newObject == null) {
                long uId = ((LocalUser)oldObject).getId();
                this.updateDAO(new DAOTableEvent("csusertenantassign", DAOReplicationEvent.OperationType.DELETE, uId));
            } else if (oldObject == null) {
                long uId = ((LocalUser)newObject).getId();
                this.updateDAO(new DAOTableEvent("csusertenantassign", DAOReplicationEvent.OperationType.INSERT, uId));
            }
        } else {
            super.objectChanged(oldObject, newObject);
        }
    }

    @SMConsole(description="Get multitenancy enabled status.")
    public boolean getMultitenancyEnabled() {
        this.lock.acquireReadLock();
        try {
            boolean bl = this.multitenancyEnabled != null && this.multitenancyEnabled == true;
            return bl;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(parameterNames={"csUserId"}, description="Get all tenant IDs for a CsUser ID.")
    public Collection<Long> getTenantMappings(Long csUserId) {
        this.lock.acquireReadLock();
        try {
            Set<Long> ret = this.userToTenantMap.get(csUserId);
            if (ret != null) {
                Set<Long> set = Collections.unmodifiableSet(ret);
                return set;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return new ArrayList<Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTenantName(long tenantId) {
        this.lock.acquireReadLock();
        try {
            String string = this.tenantNameMap.get(tenantId);
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all provisioned user to tenant mappings.")
    public Map<Long, Set<Long>> getAllTenantMappings() {
        this.lock.acquireReadLock();
        try {
            Map<Long, Set<Long>> map = Collections.unmodifiableMap(this.userToTenantMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all provisioned tenants.")
    public Map<Long, String> getAllTenants() {
        this.lock.acquireReadLock();
        try {
            Map<Long, String> map = Collections.unmodifiableMap(this.tenantNameMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public static void main(String[] args) {
        System.out.println("getLocalUsersMapping=" + getLocalUsersMapping);
        System.out.println("getTenantMapping=" + getTenantMapping);
    }
}

