/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.branch;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.BSMNoEntityLinksAlarmException;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.FeatureServerDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class BranchFeatureServerDAO
extends FeatureServerDAO {
    private final Logger log = AsmLogger.getLogger(BranchFeatureServerDAO.class);
    protected Long featureServerId = null;
    protected List<Long> otherFeatureServerIds = null;
    protected static final String getFeatureServers = "SELECT DISTINCT app.sipentity_id FROM asmapplication app JOIN entitylink link ON link.entity2_id = app.sipentity_id WHERE app.ipt_cm_id = ? AND link.entity1_id = ?";
    protected static final String getFeatureServersByRoutePolicyApp = "SELECT DISTINCT rp.sipentity_id FROM routingpolicy rp JOIN asmapplication_to_routingpolicy apprp ON apprp.routingpolicy_id = rp.id JOIN asmapplication app ON app.id = apprp.asmapplication_id JOIN entitylink link ON link.entity2_id = rp.sipentity_id JOIN sipentity se ON se.id = rp.sipentity_id WHERE se.entitytype = 'CM' AND app.ipt_cm_id = ? AND link.entity1_id = ?;";
    protected static final ResultSetMapper featureServerMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ArrayList<Long> entities = new ArrayList<Long>();
            while (rs.next()) {
                entities.add(rs.getLong("sipentity_id"));
            }
            return entities;
        }
    };

    public BranchFeatureServerDAO() {
        super(true);
    }

    @Override
    public synchronized void init() {
        AsmInstance myInstance;
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + BranchFeatureServerDAO.class.getSimpleName()));
        }
        if ((myInstance = ((AsmInstanceDAO)this.getDataMgr(AsmInstanceDAO.class)).getMyAsmInstance()) == null) {
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)"Don't know instance - giving up");
            }
            this.featureServerId = null;
            this.otherFeatureServerIds = null;
            this.setStatus(DataMgr.Status.OKAY);
            return;
        }
        Long featureServerIdTMP = null;
        ArrayList<Long> otherFeatureServerIdsTMP = null;
        try {
            Long cmAppId = myInstance.getCmAppId();
            if (cmAppId == null) {
                this.log.error((Object)"Don't know my CM app ID - failed to initialize!");
                throw new DMException("Failed to read CM app ID for branch");
            }
            Long myEntityId = myInstance.getSipEntityId();
            if (myEntityId == null) {
                this.log.error((Object)"Don't know my entity ID - failed to initialize!");
                throw new DMException("Failed to read instance entity for branch");
            }
            Object[] params = new Object[]{cmAppId, myEntityId};
            List fsList1 = (List)this.dataSource.executeQuery(getFeatureServers, params, featureServerMapper);
            List fsList2 = (List)this.dataSource.executeQuery(getFeatureServersByRoutePolicyApp, params, featureServerMapper);
            HashSet fsSet = new HashSet();
            fsSet.addAll(fsList1);
            fsSet.addAll(fsList2);
            otherFeatureServerIdsTMP = new ArrayList<Long>(fsSet);
            if (!otherFeatureServerIdsTMP.isEmpty()) {
                featureServerIdTMP = (Long)otherFeatureServerIdsTMP.remove(0);
            }
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)("Feature server is " + featureServerIdTMP + ", otherFeatureServerIds are " + otherFeatureServerIdsTMP));
            }
            if (featureServerIdTMP == null) {
                BSMNoEntityLinksAlarmException e = new BSMNoEntityLinksAlarmException("No feature server entity assigned to branch users");
                this.handleFailureEvent(e);
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            this.handleFailureEvent(e);
            return;
        }
        this.featureServerId = featureServerIdTMP;
        this.otherFeatureServerIds = otherFeatureServerIdsTMP;
    }

    @Override
    public void updateDAO(DAOTableEvent event) {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)"updateDAO: reinitialize");
        }
        this.reinit();
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("objectChanged(" + oldObject + ", " + newObject + ")"));
        }
        this.reinit();
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asmapplication");
        list.add("entitylink");
        list.add("routingpolicy");
        list.add("asmapplication_to_routingpolicy");
        list.add("sipentity");
        return list;
    }

    @Override
    protected Object getMainCollection() {
        ArrayList<Long> list = new ArrayList<Long>();
        if (this.featureServerId != null) {
            list.add(this.featureServerId);
        }
        if (this.otherFeatureServerIds != null) {
            list.addAll(this.otherFeatureServerIds);
        }
        return list;
    }

    @SMConsole(description="Get entity ID of the feature server.")
    public Long getFeatureServerId() {
        return this.featureServerId;
    }

    @SMConsole(description="Get entity IDs of other feature servers.")
    public List<Long> getOtherFeatureServerIds() {
        if (this.otherFeatureServerIds == null) {
            return new ArrayList<Long>();
        }
        return Collections.unmodifiableList(this.otherFeatureServerIds);
    }

    protected void handleFailureEvent(Exception e) {
        GenericAlarmHandler.handleFailureEvent(this, e);
    }
}

