/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.BaseRangeIterator;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.common.logging.client.Logger;
import com.datastax.driver.core.TypeCodec;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;

public class BucketRangeIterator
extends BaseRangeIterator<Integer> {
    private final Logger log = AsmLogger.getLogger(BucketRangeIterator.class);
    private int numBuckets;
    private Integer curBucket;

    public BucketRangeIterator(SessionDAO sessionDAO, String keyspace, int numBuckets, List<InetAddress> downNodes) throws DMException, UnknownHostException {
        super(sessionDAO, keyspace, downNodes);
        if (numBuckets <= 0) {
            throw new IllegalArgumentException("numBuckets must be > 0");
        }
        String fcn_name = "BucketRangeIterator";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("BucketRangeIterator: enter, keyspace=" + keyspace + ", downNodes=" + downNodes + ", numBuckets=" + numBuckets));
        }
        this.numBuckets = numBuckets;
        this.curBucket = 0;
    }

    @Override
    public Integer getNext() {
        Integer rc = null;
        while (rc == null && this.curBucket < this.numBuckets) {
            ByteBuffer bb = TypeCodec.cint().serialize(Integer.valueOf(this.curBucket), this.cqlVersion);
            Set replicas = this.metaData.getReplicas(this.keyspace, bb);
            boolean processBucket = this.checkReplicas(replicas);
            if (processBucket) {
                rc = this.curBucket;
            }
            Integer n = this.curBucket;
            Integer n2 = this.curBucket = Integer.valueOf(this.curBucket + 1);
        }
        return rc;
    }
}

