/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DynAsmCommProfileAPI;
import com.avaya.asm.datamgr.dao.cassandra.DynAsmCommProfilePreparedStatementType;
import com.avaya.asm.datamgr.dao.cassandra.DynAsmCommProfilePreparedStatements;
import com.avaya.asm.datamgr.dao.cassandra.NullUserStoreKeyspaceBuilder;
import com.avaya.asm.datamgr.dao.cassandra.PreparedStatementBuilder;
import com.avaya.asm.datamgr.dao.cassandra.SessionBasedDAO;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.TokenRangeIterator;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspaceBuilder;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreStatementBuilder;
import com.avaya.asm.datamgr.objectapi.DynAsmCommProfile;
import com.avaya.common.logging.client.Logger;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TokenRange;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class DynAsmCommProfileDAO
extends SessionBasedDAO {
    private static final Logger log = AsmLogger.getLogger(DynAsmCommProfileDAO.class);
    private static final Integer readTimeoutMillis = 3000;
    private static final int FETCHSIZE = 500;
    private final DynAsmCommProfilePreparedStatements preparedStatements;
    private final UserStoreKeyspaceBuilder ksBuilder = new NullUserStoreKeyspaceBuilder(new UserStoreKeyspace("global_user_dc"));

    public DynAsmCommProfileDAO(SessionDAO sessionDAO) throws DMException {
        super(sessionDAO);
        this.preparedStatements = new DynAsmCommProfilePreparedStatements(sessionDAO);
    }

    private SessionDAO.ExecuteOptions createExecuteOptions(DynAsmCommProfileAPI.ConsistencyScope cscope, Boolean downgrade, Integer readTimeoutMS) {
        ConsistencyLevel cl = null;
        ConsistencyLevel serialCL = null;
        SessionDAO.ExecuteOptions execOpts = new SessionDAO.ExecuteOptions();
        if (cscope != null) {
            switch (cscope) {
                case CLUSTER_LEVEL: {
                    cl = ConsistencyLevel.QUORUM;
                    serialCL = ConsistencyLevel.SERIAL;
                    break;
                }
                case DATACENTER_LEVEL: {
                    cl = ConsistencyLevel.LOCAL_QUORUM;
                    serialCL = ConsistencyLevel.LOCAL_SERIAL;
                }
            }
        }
        if (cl != null) {
            execOpts.setConsistencyLevel(cl);
        }
        if (serialCL != null) {
            execOpts.setSerialConsistencyLevel(serialCL);
        }
        if (downgrade != null) {
            execOpts.setDowngradingConsistencyRetry(downgrade);
        }
        if (readTimeoutMS != null) {
            execOpts.setReadTimeOutMillis(readTimeoutMS);
        }
        return execOpts;
    }

    public TokenRangeIterator newTokenRangeIterator(List<InetAddress> downNodes) throws UnknownHostException, DMException {
        TokenRangeIterator tokenRangeIterator = new TokenRangeIterator(this.sessionDAO, "global_user_dc", downNodes);
        return tokenRangeIterator;
    }

    private DynAsmCommProfile rowToProfile(Row row) {
        long commProfileId = row.getLong("commProfileId");
        Long userCommunityId = row.isNull("userCommunityId") ? null : Long.valueOf(row.getLong("userCommunityId"));
        Long userCommunityIdWriteTime = row.isNull("writetime(userCommunityId)") ? null : Long.valueOf(row.getLong("writetime(userCommunityId)"));
        return new DynAsmCommProfile(commProfileId, userCommunityId, userCommunityIdWriteTime);
    }

    public DynAsmCommProfile getDynAsmCommProfile(long commProfileId) throws DMException {
        ResultSet rs;
        String fcn_name = "getDynAsmCommProfile";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        DynAsmCommProfile dynAsmCommProfile = null;
        if (isFiner) {
            log.finer((Object)("getDynAsmCommProfile: enter with commProfileId=" + commProfileId));
        }
        DynAsmCommProfilePreparedStatementBuilder psBuilder = new DynAsmCommProfilePreparedStatementBuilder(DynAsmCommProfilePreparedStatementType.GET_DYN_ASMCOMMPROFILE, this.ksBuilder, commProfileId);
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        if (!(rs = this.sessionDAO.executeStatement((UserStoreStatementBuilder)psBuilder, this.ksBuilder)).isExhausted()) {
            Row row = rs.one();
            dynAsmCommProfile = this.rowToProfile(row);
        }
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            log.finest((Object)("getDynAsmCommProfile: getDynAsmCommProfile took " + (endTime - startTime)));
        }
        if (isFiner) {
            log.finer((Object)("getDynAsmCommProfile: Leave: with getDynAsmCommProfile=" + dynAsmCommProfile));
        }
        return dynAsmCommProfile;
    }

    public DynAsmCommProfile getDynAsmCommProfile(long commProfileId, DynAsmCommProfileAPI.ConsistencyScope cscope) throws DMException {
        ResultSet rs;
        String fcn_name = "getDynAsmCommProfile";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        DynAsmCommProfile dynAsmCommProfile = null;
        if (isFiner) {
            log.finer((Object)("getDynAsmCommProfile: enter with commProfileId=" + commProfileId));
        }
        DynAsmCommProfilePreparedStatementBuilder psBuilder = new DynAsmCommProfilePreparedStatementBuilder(DynAsmCommProfilePreparedStatementType.GET_DYN_ASMCOMMPROFILE, this.ksBuilder, commProfileId);
        SessionDAO.ExecuteOptions executeOptions = this.createExecuteOptions(cscope, false, null);
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        if (!(rs = this.sessionDAO.executeStatement(psBuilder, executeOptions, this.ksBuilder)).isExhausted()) {
            Row row = rs.one();
            dynAsmCommProfile = this.rowToProfile(row);
        }
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            log.finest((Object)("getDynAsmCommProfile: getDynAsmCommProfile took " + (endTime - startTime)));
        }
        if (isFiner) {
            log.finer((Object)("getDynAsmCommProfile: Leave: with getDynAsmCommProfile=" + dynAsmCommProfile));
        }
        return dynAsmCommProfile;
    }

    public List<DynAsmCommProfile> getAllDynAsmCommProfiles(List<Long> commProfileIds) throws DMException {
        int numCommProfileIds;
        String fcn_name = "getAllDynAsmCommProfile";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        long totalStartTime = 0L;
        ArrayList<DynAsmCommProfile> dynAsmCommProfileList = new ArrayList<DynAsmCommProfile>();
        if (isFiner) {
            log.finer((Object)("getAllDynAsmCommProfile: enter with commProfileIds=" + commProfileIds));
        }
        int numRemainingIds = numCommProfileIds = commProfileIds.size();
        int startIdx = 0;
        if (isFiner) {
            totalStartTime = System.currentTimeMillis();
        }
        while (numRemainingIds > 0) {
            int endIdx = startIdx + 500;
            if (endIdx > numCommProfileIds) {
                endIdx = numCommProfileIds;
                numRemainingIds = 0;
            } else {
                numRemainingIds -= 500;
            }
            List<Long> idSubList = commProfileIds.subList(startIdx, endIdx);
            DynAsmCommProfilePreparedStatementBuilder psBuilder = new DynAsmCommProfilePreparedStatementBuilder(DynAsmCommProfilePreparedStatementType.GET_ALL_DYN_ASMCOMMPROFILE, this.ksBuilder, idSubList);
            if (isFinest) {
                startTime = System.currentTimeMillis();
            }
            ResultSet rs = this.sessionDAO.executeStatement((UserStoreStatementBuilder)psBuilder, this.ksBuilder);
            if (isFinest) {
                long endTime = System.currentTimeMillis();
                log.finest((Object)("getAllDynAsmCommProfile: DynAsmCommProfileDAO.getAllDynAsmCommProfile with idSubList.size=" + idSubList.size() + " took " + (endTime - startTime)));
            }
            for (Row row : rs) {
                dynAsmCommProfileList.add(this.rowToProfile(row));
            }
            startIdx = endIdx;
        }
        if (isFiner) {
            long totalEndTime = System.currentTimeMillis();
            log.finer((Object)("getAllDynAsmCommProfile: leave, totalQueryTime=" + (totalEndTime - totalStartTime)));
        }
        return dynAsmCommProfileList;
    }

    public void setUserCommunityId(long commProfileId, Long updateUserCommunityId, DynAsmCommProfileAPI.ConsistencyScope cScope, boolean downgrade) throws DMException {
        String fcn_name = "setUserCommunityId";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            log.finer((Object)("setUserCommunityId: enter with commProfileId=" + commProfileId + ",updateUserCommunityId=" + updateUserCommunityId + ",cScope=" + (Object)((Object)cScope) + ",downgrade=" + downgrade));
        }
        DynAsmCommProfilePreparedStatementBuilder psBuilder = new DynAsmCommProfilePreparedStatementBuilder(DynAsmCommProfilePreparedStatementType.SET_USERCOMMUNITY, this.ksBuilder, updateUserCommunityId, commProfileId);
        DynAsmCommProfileAPI.ConsistencyScope curScope = cScope;
        DynAsmCommProfileAPI.ConsistencyScope retryScope = cScope == DynAsmCommProfileAPI.ConsistencyScope.CLUSTER_LEVEL ? DynAsmCommProfileAPI.ConsistencyScope.DATACENTER_LEVEL : DynAsmCommProfileAPI.ConsistencyScope.CLUSTER_LEVEL;
        Object returnedUserCommunity = null;
        while (true) {
            long endTime;
            try {
                SessionDAO.ExecuteOptions executeOptions = this.createExecuteOptions(curScope, downgrade, readTimeoutMillis);
                ResultSet rs = this.sessionDAO.executeStatement(psBuilder, executeOptions, this.ksBuilder);
                if (rs.wasApplied()) {
                    if (isFiner) {
                        log.finer((Object)("setUserCommunityId: Leave: with userCommunity=" + updateUserCommunityId));
                    }
                    if (!isFinest) break;
                    endTime = System.currentTimeMillis();
                    log.finest((Object)("setUserCommunityId: applied, executeStatement took " + (endTime - startTime) + " ms, cscope=" + (Object)((Object)curScope)));
                    startTime = endTime;
                    break;
                }
                if (!isFinest) break;
                endTime = System.currentTimeMillis();
                log.finest((Object)("setUserCommunityId: NOT applied, executeStatement took " + (endTime - startTime) + " ms, cscope=" + (Object)((Object)curScope)));
                startTime = endTime;
            }
            catch (DMException dme) {
                Throwable thr;
                if (isFinest) {
                    endTime = System.currentTimeMillis();
                    log.finest((Object)("setUserCommunityId: DME exception caught, dynAsmCommProfileDAO.setUserCommunity took " + (endTime - startTime) + "ms, curScope=" + (Object)((Object)curScope)), (Throwable)dme);
                    startTime = endTime;
                }
                if ((thr = dme.getNestedException()) != null && SessionDAO.isInsufficientReplicas(dme) && curScope != retryScope) {
                    curScope = retryScope;
                    continue;
                }
                throw dme;
            }
            break;
        }
        if (isFiner) {
            log.finer((Object)("setUserCommunityId: leave, returning " + returnedUserCommunity));
        }
    }

    public Long compareAndSetUserCommunityId(long commProfileId, Long expectedUserCommunityId, Long updateUserCommunityId, DynAsmCommProfileAPI.ConsistencyScope cScope, boolean downgrade) throws DMException {
        return this.compareAndSetUserCommunityId(commProfileId, expectedUserCommunityId, updateUserCommunityId, cScope, downgrade, null);
    }

    public Long compareAndSetUserCommunityId(long commProfileId, Long expectedUserCommunityId, Long updateUserCommunityId, DynAsmCommProfileAPI.ConsistencyScope cScope, boolean downgrade, CompareAndSetStats stats) throws DMException {
        boolean keepStats;
        String fcn_name = "compareAndSetUserCommunityId";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTimeMS = 0L;
        long queryStartTimeMS = 0L;
        long queryEndTimeMS = 0L;
        long diffTimeMS = 0L;
        boolean bl = keepStats = log.isFinestEnabled() || stats != null;
        if (isFiner) {
            log.finer((Object)("compareAndSetUserCommunityId: enter with commProfileId=" + commProfileId + ",expectedUserCommunityId=" + expectedUserCommunityId + ",updateUserCommunityId=" + updateUserCommunityId + ",cScope=" + (Object)((Object)cScope) + ",downgrade=" + downgrade));
        }
        if (keepStats) {
            startTimeMS = System.currentTimeMillis();
        }
        DynAsmCommProfilePreparedStatementBuilder psBuilder = new DynAsmCommProfilePreparedStatementBuilder(DynAsmCommProfilePreparedStatementType.CONDITIONAL_SET_USERCOMMUNITY, this.ksBuilder, updateUserCommunityId, commProfileId, expectedUserCommunityId);
        DynAsmCommProfileAPI.ConsistencyScope curScope = cScope;
        DynAsmCommProfileAPI.ConsistencyScope retryScope = cScope == DynAsmCommProfileAPI.ConsistencyScope.CLUSTER_LEVEL ? DynAsmCommProfileAPI.ConsistencyScope.DATACENTER_LEVEL : DynAsmCommProfileAPI.ConsistencyScope.CLUSTER_LEVEL;
        Long returnedUserCommunity = null;
        boolean insufficientReplicas = false;
        CompareAndSetStats.RetryCause retryCause = CompareAndSetStats.RetryCause.NO_RETRY;
        CompareAndSetStats.QueryType queryType = null;
        CompareAndSetStats.QueryStats queryStats = null;
        while (true) {
            try {
                SessionDAO.ExecuteOptions executeOptions = this.createExecuteOptions(curScope, downgrade, readTimeoutMillis);
                if (keepStats) {
                    queryStartTimeMS = System.currentTimeMillis();
                    queryType = CompareAndSetStats.QueryType.UPDATE;
                }
                ResultSet rs = this.sessionDAO.executeStatement(psBuilder, executeOptions, this.ksBuilder);
                boolean wasApplied = rs.wasApplied();
                if (keepStats) {
                    queryEndTimeMS = System.currentTimeMillis();
                    diffTimeMS = queryEndTimeMS - queryStartTimeMS;
                    if (stats != null) {
                        queryStats = new CompareAndSetStats.QueryStats(diffTimeMS, wasApplied, curScope, queryType, CompareAndSetStats.QueryResult.SUCCESS, retryCause);
                        stats.getQueryStats().add(queryStats);
                    }
                    if (isFinest) {
                        log.finest((Object)("compareAndSetUserCommunityId: UPDATE took " + diffTimeMS + " ms, cscope=" + (Object)((Object)curScope) + ", wasApplied=" + wasApplied));
                    }
                }
                if (wasApplied) {
                    returnedUserCommunity = updateUserCommunityId;
                    break;
                }
                DynAsmCommProfile dacp = this.getDynAsmCommProfile(commProfileId, cScope);
                if (dacp == null) break;
                returnedUserCommunity = dacp.getUserCommunityId();
            }
            catch (DMException dme) {
                boolean isWriteTimeoutException = false;
                Throwable thr = dme.getNestedException();
                if (thr != null) {
                    isWriteTimeoutException = thr instanceof WriteTimeoutException;
                    insufficientReplicas = SessionDAO.isInsufficientReplicas(dme);
                }
                if (keepStats) {
                    CompareAndSetStats.QueryResult queryResult = isWriteTimeoutException ? CompareAndSetStats.QueryResult.WRITE_TIMEOUT_EXCEPTION : (insufficientReplicas ? CompareAndSetStats.QueryResult.NOT_ENOUGH_REPLICA_EXCEPTION : CompareAndSetStats.QueryResult.OTHER_EXCEPTION);
                    queryEndTimeMS = System.currentTimeMillis();
                    diffTimeMS = queryEndTimeMS - queryStartTimeMS;
                    if (stats != null) {
                        queryStats = new CompareAndSetStats.QueryStats(diffTimeMS, false, curScope, queryType, queryResult, retryCause);
                        stats.getQueryStats().add(queryStats);
                    }
                }
                if (isFinest) {
                    log.finest((Object)("compareAndSetUserCommunityId: DME exception caught, dynAsmCommProfileDAO.compareAndSetUserCommunity took " + diffTimeMS + "ms, curScope=" + (Object)((Object)curScope)), (Throwable)dme);
                }
                if (insufficientReplicas && curScope != retryScope) {
                    curScope = retryScope;
                    if (!isFinest) continue;
                    log.finest((Object)("compareAndSetUserCommunityId: insufficientReplicas is true and retrying because curScope=" + (Object)((Object)curScope) + ", retryScope=" + (Object)((Object)retryScope)));
                    continue;
                }
                throw dme;
            }
            finally {
                if (!keepStats) continue;
                long endTimeMS = System.currentTimeMillis();
                diffTimeMS = endTimeMS - startTimeMS;
                if (stats == null) continue;
                stats.setTotalQueryTimeMS(diffTimeMS);
                continue;
            }
            break;
        }
        if (isFiner) {
            log.finer((Object)("compareAndSetUserCommunityId: leave, returning " + returnedUserCommunity));
        }
        return returnedUserCommunity;
    }

    public void deleteDynAsmCommProfile(long commProfileId) throws DMException {
        String fcn_name = "deleteDynAsmCommProfile";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            log.finer((Object)("deleteDynAsmCommProfile: enter with commProfileId=" + commProfileId));
        }
        DynAsmCommProfilePreparedStatementBuilder psBuilder = new DynAsmCommProfilePreparedStatementBuilder(DynAsmCommProfilePreparedStatementType.DELETE_DYN_ASMCOMMPROFILE, this.ksBuilder, commProfileId);
        if (isFiner) {
            startTime = System.currentTimeMillis();
        }
        this.sessionDAO.executeStatement((UserStoreStatementBuilder)psBuilder, this.ksBuilder);
        if (isFiner) {
            long endTime = System.currentTimeMillis();
            log.finer((Object)("deleteDynAsmCommProfile: leave, queryTime=" + (endTime - startTime)));
        }
    }

    public void deleteDynAsmCommProfiles(List<Long> commProfileIds) throws DMException {
        int numCommProfileIds;
        String fcn_name = "deleteDynAsmCommProfiles";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        long totalStartTime = 0L;
        if (isFiner) {
            log.finer((Object)("deleteDynAsmCommProfiles: enter, commProfileIds.size=" + commProfileIds.size()));
        }
        if (isFiner) {
            totalStartTime = System.currentTimeMillis();
        }
        int numRemainingIds = numCommProfileIds = commProfileIds.size();
        int startIdx = 0;
        while (numRemainingIds > 0) {
            int endIdx = startIdx + 500;
            if (endIdx > numCommProfileIds) {
                endIdx = numCommProfileIds;
                numRemainingIds = 0;
            } else {
                numRemainingIds -= 500;
            }
            List<Long> idSubList = commProfileIds.subList(startIdx, endIdx);
            DynAsmCommProfilePreparedStatementBuilder psBuilder = new DynAsmCommProfilePreparedStatementBuilder(DynAsmCommProfilePreparedStatementType.DELETE_DYN_ASMCOMMPROFILES, this.ksBuilder, idSubList);
            if (isFinest) {
                startTime = System.currentTimeMillis();
            }
            this.sessionDAO.executeStatement((UserStoreStatementBuilder)psBuilder, this.ksBuilder);
            if (isFinest) {
                long endTime = System.currentTimeMillis();
                log.finest((Object)("deleteDynAsmCommProfiles: DynAsmCommProfileDAO.getAllDynAsmCommProfile with idSubList.size=" + idSubList.size() + " took " + (endTime - startTime)));
            }
            startIdx = endIdx;
        }
        if (isFiner) {
            long totalEndTime = System.currentTimeMillis();
            log.finer((Object)("deleteDynAsmCommProfiles: leave, totalQueryTime=" + (totalEndTime - totalStartTime)));
        }
    }

    public void getCommProfileIdsByTokenRange(TokenRange tokenRange, Collection<Long> commProfileIds) throws DMException {
        DynAsmCommProfilePreparedStatementBuilder psBuilder;
        ResultSet rs;
        String fcn_name = "getCommProfileIdsByLocalTokenRanges";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        long startTime = 0L;
        Token startToken = null;
        Token endToken = null;
        Long lastCommProfileId = null;
        int commProfileIdsSize = commProfileIds.size();
        HashSet<Long> tmpIds = new HashSet<Long>(commProfileIdsSize);
        if (tokenRange != null) {
            startToken = tokenRange.getStart();
            endToken = tokenRange.getEnd();
        }
        if (isFiner) {
            log.finer((Object)("getCommProfileIdsByLocalTokenRanges: enter with tokenRange=" + tokenRange));
        }
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        while (!(rs = this.sessionDAO.executeStatement((UserStoreStatementBuilder)(psBuilder = this.getStatementBuilder(startToken, endToken, lastCommProfileId)), this.ksBuilder)).isExhausted()) {
            int numRows = 0;
            for (Row row : rs) {
                ++numRows;
                lastCommProfileId = row.getLong("commProfileId");
                if (lastCommProfileId == null) {
                    log.error((Object)("getCommProfileIdsByLocalTokenRanges: null commProfileId read from table, startToken=" + startToken + ", endToken=" + endToken));
                    continue;
                }
                tmpIds.add(lastCommProfileId);
            }
            if (numRows >= 500) continue;
            break;
        }
        commProfileIds.addAll(tmpIds);
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            log.finest((Object)("getCommProfileIdsByLocalTokenRanges: getCommProfileIdsByLocalTokenRanges took " + (endTime - startTime)));
        }
        if (isFiner) {
            log.finer((Object)("getCommProfileIdsByLocalTokenRanges: Leave: with commProfileList=" + commProfileIds));
        }
    }

    public void truncateDynAsmCommProfile() throws DMException {
        String fcn_name = "truncateDynAsmCommProfile";
        boolean isFiner = log.isFinerEnabled();
        long startTime = 0L;
        if (isFiner) {
            log.finer((Object)"truncateDynAsmCommProfile: enter");
        }
        if (isFiner) {
            startTime = System.currentTimeMillis();
        }
        DynAsmCommProfilePreparedStatementBuilder psBuilderSelect = new DynAsmCommProfilePreparedStatementBuilder(DynAsmCommProfilePreparedStatementType.TRUNCATE_DYN_ASMCOMMPROFILE, this.ksBuilder, new Object[0]);
        this.sessionDAO.executeStatement((UserStoreStatementBuilder)psBuilderSelect, this.ksBuilder);
        if (isFiner) {
            long endTime = System.currentTimeMillis();
            log.finer((Object)("truncateDynAsmCommProfile: leave, queryTime=" + (endTime - startTime)));
        }
    }

    private DynAsmCommProfilePreparedStatementBuilder getStatementBuilder(Token start, Token end, Long lastCommprofileId) {
        String fcn_name = "getStatementBuilder";
        boolean isFiner = log.isFinerEnabled();
        if (isFiner) {
            log.finer((Object)("getStatementBuilder: enter, start=" + start + ", end=" + end + ", lastCommprofileId=" + lastCommprofileId));
        }
        DynAsmCommProfilePreparedStatementBuilder builder = null;
        DynAsmCommProfilePreparedStatementType type = null;
        String args = null;
        if (start == null) {
            if (end == null) {
                if (lastCommprofileId != null) {
                    type = DynAsmCommProfilePreparedStatementType.GET_COMMPROFILEID_RANGE_START_KEY;
                    builder = new DynAsmCommProfilePreparedStatementBuilder(type, this.ksBuilder, lastCommprofileId, 500);
                    if (isFiner) {
                        args = ", lastCommprofileId=" + lastCommprofileId;
                    }
                } else {
                    type = DynAsmCommProfilePreparedStatementType.GET_COMMPROFILEID_RANGE_FULL;
                    builder = new DynAsmCommProfilePreparedStatementBuilder(type, this.ksBuilder, 500);
                    if (isFiner) {
                        args = "";
                    }
                }
            } else if (lastCommprofileId != null) {
                type = DynAsmCommProfilePreparedStatementType.GET_COMMPROFILEID_RANGE_START_KEY_BOUNDED;
                builder = new DynAsmCommProfilePreparedStatementBuilder(type, this.ksBuilder, lastCommprofileId, end, 500);
                if (isFiner) {
                    args = ", lastCommprofileId=" + lastCommprofileId + ", end=" + end;
                }
            } else {
                type = DynAsmCommProfilePreparedStatementType.GET_COMMPROFILEID_RANGE_BOUNDED;
                builder = new DynAsmCommProfilePreparedStatementBuilder(type, this.ksBuilder, end, 500);
                if (isFiner) {
                    args = ", end=" + end;
                }
            }
        } else if (end == null) {
            if (lastCommprofileId != null) {
                type = DynAsmCommProfilePreparedStatementType.GET_COMMPROFILEID_RANGE_START_KEY;
                builder = new DynAsmCommProfilePreparedStatementBuilder(type, this.ksBuilder, lastCommprofileId, 500);
                if (isFiner) {
                    args = ", lastCommprofileId=" + lastCommprofileId;
                }
            } else {
                type = DynAsmCommProfilePreparedStatementType.GET_COMMPROFILEID_RANGE_START_TOKEN;
                builder = new DynAsmCommProfilePreparedStatementBuilder(type, this.ksBuilder, start, 500);
                if (isFiner) {
                    args = ", start=" + start;
                }
            }
        } else if (lastCommprofileId != null) {
            type = DynAsmCommProfilePreparedStatementType.GET_COMMPROFILEID_RANGE_START_KEY_BOUNDED;
            builder = new DynAsmCommProfilePreparedStatementBuilder(type, this.ksBuilder, lastCommprofileId, end, 500);
            if (isFiner) {
                args = ", lastCommprofileId=" + lastCommprofileId + ", end=" + end;
            }
        } else {
            type = DynAsmCommProfilePreparedStatementType.GET_COMMPROFILEID_RANGE_START_TOKEN_BOUNDED;
            builder = new DynAsmCommProfilePreparedStatementBuilder(type, this.ksBuilder, start, end, 500);
            if (isFiner) {
                args = ", start=" + start + ", end=" + end;
            }
        }
        if (isFiner) {
            log.finer((Object)("getStatementBuilder: leave, statement type=" + (Object)((Object)type) + args));
        }
        return builder;
    }

    public static class CompareAndSetStats {
        private List<QueryStats> queryStats = new ArrayList<QueryStats>(4);
        private long totalQueryTimeMS = 0L;

        public void clear() {
            this.queryStats.clear();
            this.totalQueryTimeMS = 0L;
        }

        public List<QueryStats> getQueryStats() {
            return this.queryStats;
        }

        public long getTotalQueryTimeMS() {
            return this.totalQueryTimeMS;
        }

        public void setTotalQueryTimeMS(long totalQueryTimeMS) {
            this.totalQueryTimeMS = totalQueryTimeMS;
        }

        public static class QueryStats {
            private long queryDurationMS = 0L;
            private boolean wasApplied = false;
            private RetryCause retryCause = RetryCause.NO_RETRY;
            private QueryType queryType;
            private DynAsmCommProfileAPI.ConsistencyScope consistencyScope;
            private QueryResult queryResult;

            public QueryStats(long queryDurationMS, boolean wasApplied, DynAsmCommProfileAPI.ConsistencyScope consistencyScope, QueryType queryType, QueryResult queryResult, RetryCause retryCause) {
                this.queryDurationMS = queryDurationMS;
                this.wasApplied = wasApplied;
                this.consistencyScope = consistencyScope;
                this.queryType = queryType;
                this.queryResult = queryResult;
                this.retryCause = retryCause;
            }

            public long getQueryDurationMS() {
                return this.queryDurationMS;
            }

            public boolean isWasApplied() {
                return this.wasApplied;
            }

            public QueryResult getQueryResult() {
                return this.queryResult;
            }

            public void setQueryResult(QueryResult queryResult) {
                this.queryResult = queryResult;
            }

            public RetryCause getRetryCause() {
                return this.retryCause;
            }

            public boolean wasRetried() {
                return this.retryCause != RetryCause.NO_RETRY;
            }

            public QueryType getQueryType() {
                return this.queryType;
            }

            public DynAsmCommProfileAPI.ConsistencyScope getConsistencyScope() {
                return this.consistencyScope;
            }
        }

        public static enum QueryResult {
            SUCCESS,
            NOT_ENOUGH_REPLICA_EXCEPTION,
            WRITE_TIMEOUT_EXCEPTION,
            OTHER_EXCEPTION;

        }

        public static enum QueryType {
            SELECT,
            UPDATE;

        }

        public static enum RetryCause {
            NO_RETRY,
            WRITE_TIMEOUT_EXCEPTION,
            NOT_ENOUGH_REPLICAS;

        }
    }

    public class DynAsmCommProfilePreparedStatementBuilder
    extends PreparedStatementBuilder<DynAsmCommProfilePreparedStatementType> {
        public DynAsmCommProfilePreparedStatementBuilder(DynAsmCommProfilePreparedStatementType type, UserStoreKeyspaceBuilder builder, Object ... args) {
            super(DynAsmCommProfileDAO.this.preparedStatements, type, builder, args);
        }

        @Override
        public Statement getStatement() throws DMException {
            Statement statement = super.getStatement();
            return statement;
        }
    }
}

