/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.BaseRangeIterator;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.common.logging.client.Logger;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TokenRange;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TokenRangeIterator
extends BaseRangeIterator<TokenRange> {
    private TokenRange nextTokenRange = null;
    private Integer tokenRangeRingIdx = 0;
    private List<TokenRange> tokenRanges;
    private final Logger log = AsmLogger.getLogger(TokenRangeIterator.class);

    public TokenRangeIterator(SessionDAO sessionDAO, String keyspace, List<InetAddress> downNodes) throws DMException, UnknownHostException {
        super(sessionDAO, keyspace, downNodes);
        this.init(sessionDAO, downNodes);
    }

    public TokenRangeIterator(SessionDAO sessionDAO, String keyspace, InetAddress myInetAddress, List<InetAddress> downNodes) throws DMException, UnknownHostException {
        super(sessionDAO, keyspace, myInetAddress, downNodes);
        this.init(sessionDAO, downNodes);
    }

    private void init(SessionDAO sessionDAO, List<InetAddress> downNodes) throws DMException {
        String fcn_name = "init";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("init: enter, keyspace=" + this.keyspace + ", downNodes=" + downNodes));
        }
        Set metaTokenRanges = this.metaData.getTokenRanges();
        this.tokenRanges = new ArrayList<TokenRange>(metaTokenRanges.size() + 1);
        this.tokenRanges.addAll(metaTokenRanges);
        TokenRange lastRange = this.tokenRanges.get(this.tokenRanges.size() - 1);
        if (lastRange.isWrappedAround()) {
            this.tokenRanges.add(0, lastRange);
        }
        if (isFiner) {
            this.log.finer((Object)("init: leave, tokenRanges.size=" + this.tokenRanges.size()));
        }
    }

    @Override
    public TokenRange getNext() {
        TokenRangeData trData;
        boolean firstCall;
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        String fcn_name = "getNext";
        if (isFiner) {
            this.log.finer((Object)("getNext : enter, nextTokenRange=" + this.nextTokenRange));
        }
        TokenRange curTokenRange = this.nextTokenRange;
        this.nextTokenRange = null;
        boolean bl = firstCall = this.tokenRangeRingIdx == 0;
        while ((trData = this.getDataForRingIdx()) != null) {
            if (isFinest) {
                this.log.finest((Object)("getNext: trData=" + trData));
            }
            Set<Host> replicas = trData.getReplicas();
            TokenRange tokenRange = trData.getTokenRange();
            boolean processRange = this.checkReplicas(replicas);
            if (processRange) {
                if (curTokenRange == null) {
                    curTokenRange = tokenRange;
                    continue;
                }
                if (curTokenRange.getEnd().equals(tokenRange.getStart())) {
                    if (isFinest) {
                        this.log.finest((Object)("getNext: merging " + curTokenRange + " with " + tokenRange));
                    }
                    curTokenRange = this.metaData.newTokenRange(curTokenRange.getStart(), tokenRange.getEnd());
                    if (!isFinest) continue;
                    this.log.finest((Object)("getNext: curTokenRange after the merge: " + curTokenRange));
                    continue;
                }
                this.nextTokenRange = tokenRange;
                if (!isFinest) continue;
                this.log.finest((Object)("getNext: curTokenRange " + curTokenRange + " is not contiguous with " + tokenRange));
                continue;
            }
            if (curTokenRange == null) continue;
            break;
        }
        if (curTokenRange != null && curTokenRange.isWrappedAround()) {
            Token startToken = curTokenRange.getStart();
            Token endToken = curTokenRange.getEnd();
            if (firstCall) {
                startToken = null;
            }
            if (this.tokenRangeRingIdx.intValue() == this.tokenRanges.size()) {
                endToken = null;
            }
            curTokenRange = this.metaData.newTokenRange(startToken, endToken);
        }
        if (isFiner) {
            this.log.finer((Object)("getNext: leave, returning " + curTokenRange));
        }
        return curTokenRange;
    }

    private TokenRangeData getDataForRingIdx() {
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        String fcn_name = "getDataForRingIdx";
        if (isFiner) {
            this.log.finer((Object)("getDataForRingIdxenter, ringIdx=" + this.tokenRangeRingIdx));
        }
        if (this.tokenRangeRingIdx.intValue() == this.tokenRanges.size()) {
            if (isFiner) {
                this.log.finer((Object)("getDataForRingIdxleave, no more indexes: tokenRangeRingIdx=" + this.tokenRangeRingIdx));
            }
            return null;
        }
        TokenRange tokenRange = this.tokenRanges.get(this.tokenRangeRingIdx);
        Set replicas = this.metaData.getReplicas(this.keyspace, tokenRange);
        if (isFinest) {
            this.log.finest((Object)("getDataForRingIdx: getReplicas() for keyspace " + this.keyspace + ", tokenRange=" + tokenRange + " returned " + replicas));
        }
        Integer n = this.tokenRangeRingIdx;
        Integer n2 = this.tokenRangeRingIdx = Integer.valueOf(this.tokenRangeRingIdx + 1);
        TokenRangeData trData = new TokenRangeData(tokenRange, replicas);
        if (isFiner) {
            this.log.finer((Object)("getDataForRingIdx: leave, returning tokenRangeRingIdx=" + this.tokenRangeRingIdx + ", trData=" + trData));
        }
        return trData;
    }

    private class TokenRangeData {
        private TokenRange tokenRange;
        private Set<Host> replicas;

        public TokenRangeData(TokenRange tokenRange, Set<Host> replicas) {
            this.tokenRange = tokenRange;
            this.replicas = replicas;
        }

        public TokenRange getTokenRange() {
            return this.tokenRange;
        }

        public Set<Host> getReplicas() {
            return this.replicas;
        }

        public String toString() {
            return "TokenRangeData [tokenRange=" + this.tokenRange + ", replicas=" + this.replicas + "]";
        }
    }
}

