/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.jdbc;

import java.io.Serializable;

public class DAOResult
implements Serializable {
    private static final long serialVersionUID = -8897726406515090556L;
    private Status status = Status.OKAY;
    protected int count = 0;

    public DAOResult() {
        this.status = Status.OKAY;
    }

    public DAOResult(Status status) {
        this.status = status;
    }

    public DAOResult(int count) {
        this.count = count;
        this.status = count <= 0 ? Status.EMPTY : Status.OKAY;
    }

    public int getCount() {
        return this.count;
    }

    public boolean empty() {
        return this.status == Status.EMPTY;
    }

    public boolean notFound() {
        return this.status == Status.NOTFOUND;
    }

    public boolean okay() {
        return this.status == Status.OKAY;
    }

    public boolean failed() {
        return this.status == Status.FAIL;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public String toString() {
        return this.status.name();
    }

    public static enum Status {
        OKAY,
        EMPTY,
        NOTFOUND,
        FAIL;

    }
}

