/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.helpers;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.common.logging.client.Logger;
import java.util.ArrayList;
import java.util.List;

public class InClauseListBuilder {
    protected static final int limit = 100;
    protected int idxOfLastAcpIdProcessed = 0;
    protected List<Long> acpIdList = new ArrayList<Long>();
    static final Logger log = AsmLogger.getLogger(InClauseListBuilder.class);

    public int getIdxOfLastAcpIdProcessed() {
        return this.idxOfLastAcpIdProcessed;
    }

    public InClauseListBuilder(List<Long> acpIdList) {
        this.acpIdList = acpIdList;
    }

    public String buildNextListOfAcpIds() throws DMException {
        String fcn_name = "buildNextListOfAcpIds";
        boolean isFiner = log.isFinerEnabled();
        StringBuffer listOfAcpIdsForQuery = new StringBuffer();
        int numberOfAcpIds = this.acpIdList == null ? 0 : this.acpIdList.size();
        int nextIdx = 0;
        if (isFiner) {
            log.finer((Object)("buildNextListOfAcpIds enter with nextIdx = " + nextIdx + ", limit = " + 100 + ", idxOfLastAcpIdProcessed = " + this.idxOfLastAcpIdProcessed + ", numberOfAcpIds = " + numberOfAcpIds));
        }
        if (numberOfAcpIds > 0) {
            listOfAcpIdsForQuery.append("(");
            while (nextIdx < 100) {
                if (nextIdx != 0) {
                    listOfAcpIdsForQuery.append(", ");
                }
                listOfAcpIdsForQuery.append(this.acpIdList.get(this.idxOfLastAcpIdProcessed));
                ++this.idxOfLastAcpIdProcessed;
                if (++nextIdx < 100 && this.idxOfLastAcpIdProcessed < numberOfAcpIds) continue;
                listOfAcpIdsForQuery.append(")");
                break;
            }
        }
        if (isFiner) {
            log.finer((Object)("buildNextListOfAcpIds leave with nextIdx = " + nextIdx + ", idxOfLastAcpIdProcessed = " + this.idxOfLastAcpIdProcessed + ", listOfAcpIdsForQuery = " + listOfAcpIdsForQuery.toString()));
        }
        return listOfAcpIdsForQuery.toString();
    }
}

