/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.datamgr.objectapi.MediaAttributes;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AsmApplication
implements Serializable {
    private static final long serialVersionUID = -4070954004351099388L;
    protected long id;
    protected long sipEntityId;
    protected MediaAttributes mediaAttributes;
    protected Map<String, String> attributes;
    protected List<Long> routePolicyIDs;

    public AsmApplication(AsmApplication app) {
        this.id = app.id;
        this.sipEntityId = app.sipEntityId;
        this.mediaAttributes = new MediaAttributes(app.mediaAttributes);
        this.attributes = new HashMap<String, String>();
        this.attributes.putAll(app.attributes);
        this.routePolicyIDs = null;
        if (app.routePolicyIDs != null) {
            this.routePolicyIDs = new ArrayList<Long>();
            this.routePolicyIDs.addAll(app.routePolicyIDs);
        }
    }

    public AsmApplication(long id, long sipEntityId, MediaAttributes mediaAttributes) {
        this.id = id;
        this.sipEntityId = sipEntityId;
        this.mediaAttributes = mediaAttributes;
        this.attributes = new HashMap<String, String>();
        this.routePolicyIDs = null;
    }

    public AsmApplication(long id, List<Long> routePolicyIDs, MediaAttributes mediaAttributes) {
        this(id, 0L, mediaAttributes);
        this.routePolicyIDs = routePolicyIDs;
    }

    public long getId() {
        return this.id;
    }

    public long getSipEntityId() {
        return this.sipEntityId;
    }

    public String getHandle() {
        return this.attributes.get("Application Handle");
    }

    public String getURIParams() {
        return this.attributes.get("URI Parameters");
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public MediaAttributes getMediaAttributes() {
        return this.mediaAttributes;
    }

    public void setMediaAttributes(MediaAttributes mediaAttributes) {
        this.mediaAttributes = mediaAttributes;
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void removeAllAttributes() {
        this.attributes.clear();
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes.clear();
        this.attributes.putAll(attributes);
    }

    public List<Long> getRoutePolicyIDs() {
        return this.routePolicyIDs;
    }

    public void setRoutePolicyIDs(List<Long> routePolicyIDs) {
        this.routePolicyIDs = routePolicyIDs;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof AsmApplication) {
            AsmApplication other = (AsmApplication)o;
            return this.id == other.id && this.sipEntityId == other.sipEntityId && (this.mediaAttributes == other.mediaAttributes || this.mediaAttributes != null && this.mediaAttributes.equals(other.mediaAttributes)) && this.attributes.equals(other.attributes) && (this.routePolicyIDs == other.routePolicyIDs || this.routePolicyIDs != null && this.routePolicyIDs.equals(other.routePolicyIDs));
        }
        return false;
    }

    public int hashCode() {
        return 32 * (int)(this.id + this.sipEntityId + (long)this.mediaAttributes.hashCode());
    }

    public String toString() {
        return "AsmApplication[id=" + this.id + ", sipEntityId=" + this.sipEntityId + ", mediaAttributes=" + this.mediaAttributes + ", attributes=" + this.attributes + ", routePolicyIDs=" + this.routePolicyIDs + "]";
    }
}

