/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class AsmTerminalGroupParm
implements Serializable {
    private static final long serialVersionUID = 7982706845161728347L;
    private final Long id;
    private final String terminalGroupName;
    private final Integer terminalGroupNumber;
    private final Integer regMinExpirationTimer;
    private final Integer regMaxExpirationTimer;
    private final Integer lineReservationTimer;
    private final Map<String, Integer> minSubscriptionExpirationMap;
    private final Map<String, Integer> maxSubscriptionExpirationMap;
    private final Integer ringerVolume;
    private final Integer ringerCadence;
    private final Integer receiverVolume;
    private final Integer speakerVolume;
    private final String vmmServerIpAddress;
    private final Integer vmmServerPort;
    private final Integer vmmReportPeriod;
    private final String ipAddressForSnmpQueries;
    private final String snmpCommunity;
    private final String stationAdminPassword;
    private final String stationAccessCodeSalt;
    private final String stationAccessCodeHashAlgorithm;
    private final String stationAccessCodeHash;
    private final String quickLoginStatus;
    private final Integer reactiveMonitoringInterval;
    private final Integer timerb;
    private final String registrationPolicy;
    private final Integer vlanNumber;
    private final Integer callControlPhb;
    private final Integer audioPhb;
    private final Integer videoPhb;
    private final Integer callControl802Priority;
    private final Integer audio802Priority;
    private final Integer video802Priority;
    private final String signalingMode;
    private final String mediaMode;
    private final String timeZone;

    public AsmTerminalGroupParm(Long id, String terminalGroupName, Integer terminalGroupNumber, Integer regMinExpirationTimer, Integer regMaxExpirationTimer, Integer lineReservationTimer, Map<String, Integer> minSubscriptionExpirationMap, Map<String, Integer> maxSubscriptionExpirationMap, Integer ringerVolume, Integer ringerCadence, Integer receiverVolume, Integer speakerVolume, String vmmServerIpAddress, Integer vmmServerPort, Integer vmmReportPeriod, String ipAddressForSnmpQueries, String snmpCommunity, String stationAdminPassword, String stationAccessCodeSalt, String stationAccessCodeHashAlgorithm, String stationAccessCodeHash, String quickLoginStatus, Integer reactiveMonitoringInterval, Integer timerb, String registrationPolicy, Integer vlanNumber, Integer callControlPhb, Integer audioPhb, Integer videoPhb, Integer callControl802Priority, Integer audio802Priority, Integer video802Priority, String signalingMode, String mediaMode, String timeZone) {
        Integer max;
        this.id = id;
        this.terminalGroupName = terminalGroupName;
        this.terminalGroupNumber = terminalGroupNumber;
        this.regMinExpirationTimer = regMinExpirationTimer == null || regMinExpirationTimer < 60 ? Integer.valueOf(60) : regMinExpirationTimer;
        this.regMaxExpirationTimer = regMaxExpirationTimer == null || regMaxExpirationTimer > 86400 ? Integer.valueOf(86400) : (regMaxExpirationTimer < this.regMinExpirationTimer ? this.regMinExpirationTimer : regMaxExpirationTimer);
        this.lineReservationTimer = lineReservationTimer;
        this.minSubscriptionExpirationMap = minSubscriptionExpirationMap == null ? new HashMap<String, Integer>() : new HashMap<String, Integer>(minSubscriptionExpirationMap);
        this.maxSubscriptionExpirationMap = maxSubscriptionExpirationMap == null ? new HashMap<String, Integer>() : new HashMap<String, Integer>(maxSubscriptionExpirationMap);
        HashMap<String, Integer> hashMapForMin = new HashMap<String, Integer>();
        HashMap<String, Integer> hashMapForMax = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> e : this.minSubscriptionExpirationMap.entrySet()) {
            String eventPackage = e.getKey();
            Integer min = e.getValue();
            if (min < 60) {
                hashMapForMin.put(eventPackage, 60);
                min = 60;
            }
            if ((max = this.maxSubscriptionExpirationMap.get(eventPackage)) != null && max >= min) continue;
            hashMapForMax.put(eventPackage, min);
        }
        for (Map.Entry<String, Integer> e : this.maxSubscriptionExpirationMap.entrySet()) {
            String eventPackage = e.getKey();
            max = e.getValue();
            Integer min = this.minSubscriptionExpirationMap.get(eventPackage);
            if (max > 86400) {
                hashMapForMax.put(eventPackage, 86400);
                max = 86400;
            }
            if (min != null) continue;
            hashMapForMin.put(eventPackage, max);
        }
        for (Map.Entry me : hashMapForMin.entrySet()) {
            this.minSubscriptionExpirationMap.put((String)me.getKey(), (Integer)me.getValue());
        }
        for (Map.Entry me : hashMapForMax.entrySet()) {
            this.maxSubscriptionExpirationMap.put((String)me.getKey(), (Integer)me.getValue());
        }
        this.ringerVolume = ringerVolume;
        this.ringerCadence = ringerCadence;
        this.receiverVolume = receiverVolume;
        this.speakerVolume = speakerVolume;
        this.vmmServerIpAddress = vmmServerIpAddress;
        this.vmmServerPort = vmmServerPort;
        this.vmmReportPeriod = vmmReportPeriod;
        this.ipAddressForSnmpQueries = ipAddressForSnmpQueries;
        this.snmpCommunity = snmpCommunity;
        this.stationAdminPassword = stationAdminPassword;
        this.stationAccessCodeSalt = stationAccessCodeSalt;
        this.stationAccessCodeHashAlgorithm = stationAccessCodeHashAlgorithm;
        this.stationAccessCodeHash = stationAccessCodeHash;
        this.quickLoginStatus = quickLoginStatus;
        this.reactiveMonitoringInterval = reactiveMonitoringInterval;
        this.timerb = timerb;
        this.registrationPolicy = registrationPolicy;
        this.vlanNumber = vlanNumber;
        this.callControlPhb = callControlPhb;
        this.audioPhb = audioPhb;
        this.videoPhb = videoPhb;
        this.callControl802Priority = callControl802Priority;
        this.audio802Priority = audio802Priority;
        this.video802Priority = video802Priority;
        this.signalingMode = signalingMode;
        this.mediaMode = mediaMode;
        this.timeZone = timeZone;
    }

    @Deprecated
    public AsmTerminalGroupParm(Long id, String terminalGroupName, Integer terminalGroupNumber, Integer regMinExpirationTimer, Integer regMaxExpirationTimer, Integer lineReservationTimer, Map<String, Integer> minSubscriptionExpirationMap, Map<String, Integer> maxSubscriptionExpirationMap, Integer ringerVolume, Integer ringerCadence, Integer receiverVolume, Integer speakerVolume, String vmmServerIpAddress, Integer vmmServerPort, Integer vmmReportPeriod, String ipAddressForSnmpQueries, String snmpCommunity, String stationAdminPassword, String quickLoginStatus, Integer reactiveMonitoringInterval, Integer timerb, String registrationPolicy, Integer vlanNumber, Integer callControlPhb, Integer audioPhb, Integer videoPhb, Integer callControl802Priority, Integer audio802Priority, Integer video802Priority, String signalingMode, String mediaMode, String timeZone) {
        this(id, terminalGroupName, terminalGroupNumber, regMinExpirationTimer, regMaxExpirationTimer, lineReservationTimer, minSubscriptionExpirationMap, maxSubscriptionExpirationMap, ringerVolume, ringerCadence, receiverVolume, speakerVolume, vmmServerIpAddress, vmmServerPort, vmmReportPeriod, ipAddressForSnmpQueries, snmpCommunity, stationAdminPassword, null, null, null, quickLoginStatus, reactiveMonitoringInterval, timerb, registrationPolicy, vlanNumber, callControlPhb, audioPhb, videoPhb, callControl802Priority, audio802Priority, video802Priority, signalingMode, mediaMode, timeZone);
    }

    public Long getId() {
        return this.id;
    }

    public String getTerminalGroupName() {
        return this.terminalGroupName;
    }

    public Integer getTerminalGroupNumber() {
        return this.terminalGroupNumber;
    }

    public Integer getMinRegExpirationTimer() {
        return this.regMinExpirationTimer;
    }

    public Integer getMaxRegExpirationTimer() {
        return this.regMaxExpirationTimer;
    }

    public Integer getLineReservationTimer() {
        return this.lineReservationTimer;
    }

    public Integer getMinSubscriptionExpiration(String eventPackage) {
        Integer min = this.minSubscriptionExpirationMap.get(eventPackage);
        if (min == null) {
            return 60;
        }
        return min;
    }

    public Integer getMaxSubscriptionExpiration(String eventPackage) {
        Integer max = this.maxSubscriptionExpirationMap.get(eventPackage);
        if (max == null) {
            return 86400;
        }
        return max;
    }

    public Integer getRingerVolume() {
        return this.ringerVolume;
    }

    public Integer getRingerCadence() {
        return this.ringerCadence;
    }

    public Integer getReceiverVolume() {
        return this.receiverVolume;
    }

    public Integer getSpeakerVolume() {
        return this.speakerVolume;
    }

    public String getVmmServerIpAddress() {
        return this.vmmServerIpAddress;
    }

    public Integer getVmmServerPort() {
        return this.vmmServerPort;
    }

    public Integer getVmmReportPeriod() {
        return this.vmmReportPeriod;
    }

    public String getIpAddressForSnmpQueries() {
        return this.ipAddressForSnmpQueries;
    }

    public String getSnmpCommunity() {
        return this.snmpCommunity;
    }

    public String getStationAdminPassword() {
        return this.stationAdminPassword;
    }

    public String getStationAccessCodeSalt() {
        return this.stationAccessCodeSalt;
    }

    public String getStationAccessCodeHashAlgorithm() {
        return this.stationAccessCodeHashAlgorithm;
    }

    public String getStationAccessCodeHash() {
        return this.stationAccessCodeHash;
    }

    public String getQuickLoginStatus() {
        return this.quickLoginStatus;
    }

    public Integer getReactiveMonitoringInterval() {
        return this.reactiveMonitoringInterval;
    }

    public Integer getTimerb() {
        return this.timerb;
    }

    public String getRegistrationPolicy() {
        return this.registrationPolicy;
    }

    public Integer getVlanNumber() {
        return this.vlanNumber;
    }

    public Integer getCallControlPhb() {
        return this.callControlPhb;
    }

    public Integer getAudioPhb() {
        return this.audioPhb;
    }

    public Integer getVideoPhb() {
        return this.videoPhb;
    }

    public Integer getCallControl802Priority() {
        return this.callControl802Priority;
    }

    public Integer getAudio802Priority() {
        return this.audio802Priority;
    }

    public Integer getVideo802Priority() {
        return this.video802Priority;
    }

    public String getSignalingMode() {
        return this.signalingMode;
    }

    public String getMediaMode() {
        return this.mediaMode;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("AsmTerminalGroupParm[id =" + this.id + ", terminalGroupName =" + this.terminalGroupName + ", terminalGroupNumber =" + this.terminalGroupNumber + ", regExpirationTimer =" + this.regMinExpirationTimer + "/" + this.regMaxExpirationTimer + ", lineReservationTimer =" + this.lineReservationTimer);
        for (String eventPackage : Arrays.asList("avaya-cm-feature-status", "dialog", "message-summary", "avaya-ccs-profile", "reg")) {
            buf.append(", " + eventPackage + " =" + this.minSubscriptionExpirationMap.get(eventPackage) + "/" + this.maxSubscriptionExpirationMap.get(eventPackage));
        }
        buf.append(", ringerVolume =" + this.ringerVolume + ", ringerCadence =" + this.ringerCadence + ", receiverVolume =" + this.receiverVolume + ", speakerVolume =" + this.speakerVolume + ", vmmServerIpAddress =" + this.vmmServerIpAddress + ", vmmServerPort =" + this.vmmServerPort + ", vmmReportPeriod =" + this.vmmReportPeriod + ", ipAddressForSnmpQueries =" + this.ipAddressForSnmpQueries + ", snmpCommunity =" + this.snmpCommunity + ", stationAdminPassword =" + this.stationAdminPassword + ", stationAccessCodeSalt =" + this.stationAccessCodeSalt + ", stationAccessCodeHashAlgorithm =" + this.stationAccessCodeHashAlgorithm + ", stationAccessCodeHash =" + this.stationAccessCodeHash + ", quickLoginStatus =" + this.quickLoginStatus + ", reactiveMonitoringInterval =" + this.reactiveMonitoringInterval + ", timerb =" + this.timerb + ", registrationPolicy =" + this.registrationPolicy + ", vlanNumber=" + this.vlanNumber + ", callControlPhb=" + this.callControlPhb + ", audioPhb=" + this.audioPhb + ", videoPhb=" + this.videoPhb + ", callControl802Priority=" + this.callControl802Priority + ", audio802Priority=" + this.audio802Priority + ", video802Priority=" + this.video802Priority + ", signalingMode=" + this.signalingMode + ", mediaMode=" + this.mediaMode + ", timeZone=" + this.timeZone + "]");
        return buf.toString();
    }
}

