/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.core.AsmLogger;
import com.avaya.common.logging.client.Logger;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

public class AudioVideoPool
implements Serializable {
    private static final long serialVersionUID = -595749833654140046L;
    protected AtomicLong audio = null;
    protected AtomicLong video = null;
    private static final transient Logger log = AsmLogger.getLogger(AudioVideoPool.class);

    public AudioVideoPool() {
        this.audio = new AtomicLong(0L);
        this.video = new AtomicLong(0L);
    }

    public AudioVideoPool(Long audio, Long video) {
        if (audio == null) {
            audio = 0L;
        }
        if (video == null) {
            video = 0L;
        }
        this.audio = new AtomicLong(audio);
        this.video = new AtomicLong(video);
    }

    public AudioVideoPool(AudioVideoPool locBw) {
        this.audio = new AtomicLong(locBw.audio.get());
        this.video = new AtomicLong(locBw.video.get());
    }

    public synchronized long adjust(Long amount, int whichPool) {
        if (whichPool == 1) {
            return this.video.addAndGet(amount);
        }
        if (whichPool == 0) {
            return this.audio.addAndGet(amount);
        }
        log.error((Object)("Unknown adjustment: amount=" + amount + ", pool=" + whichPool));
        return 0L;
    }

    protected void adjust(AudioVideoPool amount, int sign) {
        this.audio.addAndGet((long)sign * amount.getAudio().get());
        this.video.addAndGet((long)sign * amount.getVideo().get());
    }

    public synchronized long transfer(long amount, int toPool) {
        long curAmt = 0L;
        if (toPool == 1) {
            curAmt = Math.min(this.audio.get(), amount);
            this.audio.addAndGet(-curAmt);
            this.video.addAndGet(curAmt);
        } else {
            curAmt = Math.min(this.video.get(), amount);
            this.video.addAndGet(-curAmt);
            this.audio.addAndGet(curAmt);
        }
        return curAmt;
    }

    public synchronized void add(AudioVideoPool amount) {
        this.adjust(amount, 1);
    }

    public synchronized void subtract(AudioVideoPool amount) {
        this.adjust(amount, -1);
    }

    public synchronized void set(long amount, int whichPool) {
        if (whichPool == 1) {
            this.video.set(amount);
        } else {
            this.audio.set(amount);
        }
    }

    public void clear() {
        this.audio.set(0L);
        this.video.set(0L);
    }

    public void abs() {
        this.audio.set(Math.abs(this.audio.get()));
        this.video.set(Math.abs(this.video.get()));
    }

    public void invert() {
        this.audio.set(-this.audio.get());
        this.video.set(-this.video.get());
    }

    public synchronized void set(AudioVideoPool bw) {
        this.video.set(bw.getAmount(1));
        this.audio.set(bw.getAmount(0));
    }

    public Long getAmount(int whichPool) {
        if (whichPool == 1) {
            return this.video.get();
        }
        if (whichPool == 0) {
            return this.audio.get();
        }
        return 0L;
    }

    public AtomicLong getAudio() {
        return this.audio;
    }

    public AtomicLong getVideo() {
        return this.video;
    }

    public long getAudioValue() {
        return this.audio.get();
    }

    public long getVideoValue() {
        return this.video.get();
    }

    public String toString() {
        return "A=" + this.audio + " V=" + this.video;
    }

    public String fullToString() {
        return this.getTotal() + " (" + this.toString() + ")";
    }

    public Long getTotal() {
        return this.audio.get() + this.video.get();
    }

    public boolean isEmpty() {
        return this.audio.get() == 0L && this.video.get() == 0L;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof AudioVideoPool) {
            AudioVideoPool other = (AudioVideoPool)o;
            return (this.audio == null ? other.audio == null : this.audio.get() == other.audio.get()) && (this.video == null ? other.video == null : this.video.get() == other.video.get());
        }
        return false;
    }

    public int hashCode() {
        return 32 * (int)(this.audio == null ? -1L : this.getTotal());
    }
}

