/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.datamgr.objectapi.IPAddress;
import java.io.Serializable;

public abstract class Instance
implements Serializable {
    private static final long serialVersionUID = -7552121291933612392L;
    protected final long id;
    protected final long sipEntityId;
    protected final String managementAccessPointHostName;
    protected final boolean isBranch;

    public Instance(long id, long sipEntityId, String managementAccessPointHostName, boolean isBranch) {
        this.id = id;
        this.sipEntityId = sipEntityId;
        this.managementAccessPointHostName = managementAccessPointHostName;
        this.isBranch = isBranch;
    }

    public long getId() {
        return this.id;
    }

    public long getSipEntityId() {
        return this.sipEntityId;
    }

    public String getManagementAccessPointHostName() {
        return this.managementAccessPointHostName;
    }

    public boolean isBranch() {
        return this.isBranch;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.managementAccessPointHostName == null ? 0 : IPAddress.toExpandedForm(this.managementAccessPointHostName).hashCode());
        result = 31 * result + (int)(this.sipEntityId ^ this.sipEntityId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Instance other = (Instance)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.managementAccessPointHostName == null ? other.managementAccessPointHostName != null : !IPAddress.areEqual(this.managementAccessPointHostName, other.managementAccessPointHostName)) {
            return false;
        }
        return this.sipEntityId == other.sipEntityId;
    }

    public String toString() {
        return "Instance[id=" + this.id + ", sipEntityId=" + this.sipEntityId + ", managementAccessPointHostName=" + this.managementAccessPointHostName + ", isBranch=" + this.isBranch + "]";
    }
}

