/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import java.io.Serializable;
import java.util.Comparator;

public class RegionCommunityAssign {
    private final long storageClusterId;
    private final long regionCommunityId;
    private final int priorityOrder;

    public RegionCommunityAssign(long storageClusterId, long regionCommunityId, int priorityOrder) {
        this.storageClusterId = storageClusterId;
        this.regionCommunityId = regionCommunityId;
        this.priorityOrder = priorityOrder;
    }

    public long getStorageClusterId() {
        return this.storageClusterId;
    }

    public long getRegionCommunityId() {
        return this.regionCommunityId;
    }

    public int getPriorityOrder() {
        return this.priorityOrder;
    }

    public int compareTo(RegionCommunityAssign assign) {
        if (assign == null || this.priorityOrder < assign.priorityOrder) {
            return -1;
        }
        if (this.priorityOrder > assign.priorityOrder) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.regionCommunityId ^ this.regionCommunityId >>> 32);
        result = 31 * result + (int)(this.storageClusterId ^ this.storageClusterId >>> 32);
        result = 31 * result + this.priorityOrder;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegionCommunityAssign other = (RegionCommunityAssign)obj;
        if (this.regionCommunityId != other.regionCommunityId) {
            return false;
        }
        if (this.storageClusterId != other.storageClusterId) {
            return false;
        }
        return this.priorityOrder == other.priorityOrder;
    }

    public String toString() {
        return "RegionCommunityAssign[storageClusterId=" + this.storageClusterId + ", regionCommunityId=" + this.regionCommunityId + ", priorityOrder=" + this.priorityOrder + "]";
    }

    public static class PriorityComparator
    implements Comparator<RegionCommunityAssign>,
    Serializable {
        private static final long serialVersionUID = -195820651428624508L;

        @Override
        public int compare(RegionCommunityAssign o1, RegionCommunityAssign o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }
}

