/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi.ppm;

import com.avaya.asm.datamgr.helpers.StringArrayBytes;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Arrays;

public class ContactListMember
implements Serializable {
    private static final long serialVersionUID = 718254766341870334L;
    private long id;
    private long cspersonid;
    private long cscontactlistid;
    private boolean ispresencebuddy;
    private boolean isspeeddial;
    private int entryindex;
    private byte[] stringData;
    private long cscontactaddressid;
    private long cshandleid;
    private long csprivatecontactinfoid;
    private boolean isCscontactaddressidSet;
    private boolean isCshandleidSet;
    private boolean isCsprivatecontactinfoidSet;
    private Timestamp updateDateTime;
    private boolean isCsUserId = false;

    public ContactListMember(long id, long cspersonid, long cscontactlistid, boolean ispresencebuddy, boolean isspeeddial, int entryindex, Long cscontactaddressid, Long cshandleid, String label, Long csprivatecontactinfoid, boolean isCsUserId, Timestamp updateDateTime) {
        this.id = id;
        this.cspersonid = cspersonid;
        this.cscontactlistid = cscontactlistid;
        this.ispresencebuddy = ispresencebuddy;
        this.isspeeddial = isspeeddial;
        this.entryindex = entryindex;
        this.isCsUserId = isCsUserId;
        if (cscontactaddressid != null) {
            this.cscontactaddressid = cscontactaddressid;
            this.isCscontactaddressidSet = true;
        } else {
            this.cscontactaddressid = 0L;
            this.isCscontactaddressidSet = false;
        }
        if (cshandleid != null) {
            this.cshandleid = cshandleid;
            this.isCshandleidSet = true;
        } else {
            this.cshandleid = 0L;
            this.isCshandleidSet = false;
        }
        if (csprivatecontactinfoid != null) {
            this.csprivatecontactinfoid = csprivatecontactinfoid;
            this.isCsprivatecontactinfoidSet = true;
        } else {
            this.csprivatecontactinfoid = 0L;
            this.isCsprivatecontactinfoidSet = false;
        }
        this.updateDateTime = updateDateTime;
        this.stringData = StringArrayBytes.encode(label);
    }

    public long getId() {
        return this.id;
    }

    public long getCspersonid() {
        return this.cspersonid;
    }

    public long getCscontactlistid() {
        return this.cscontactlistid;
    }

    public boolean isIspresencebuddy() {
        return this.ispresencebuddy;
    }

    public boolean isIsspeeddial() {
        return this.isspeeddial;
    }

    public int getEntryindex() {
        return this.entryindex;
    }

    public Long getCscontactaddressid() {
        return this.isCscontactaddressidSet ? Long.valueOf(this.cscontactaddressid) : null;
    }

    public Long getCshandleid() {
        return this.isCshandleidSet ? Long.valueOf(this.cshandleid) : null;
    }

    public String getLabel() {
        return StringArrayBytes.getString(this.stringData, StringIndex.LABEL.ordinal());
    }

    public void setLabel(String label) {
        this.stringData = StringArrayBytes.setString(this.stringData, label, StringIndex.LABEL.ordinal());
    }

    public Long getCsprivatecontactinfoid() {
        return this.isCsprivatecontactinfoidSet ? Long.valueOf(this.csprivatecontactinfoid) : null;
    }

    public boolean isCsUserId() {
        return this.isCsUserId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.cscontactaddressid ^ this.cscontactaddressid >>> 32);
        result = 31 * result + (int)(this.cscontactlistid ^ this.cscontactlistid >>> 32);
        result = 31 * result + (int)(this.cshandleid ^ this.cshandleid >>> 32);
        result = 31 * result + (int)(this.cspersonid ^ this.cspersonid >>> 32);
        result = 31 * result + (int)(this.csprivatecontactinfoid ^ this.csprivatecontactinfoid >>> 32);
        result = 31 * result + this.entryindex;
        result = 31 * result + 0;
        result = 31 * result + (this.isCsUserId ? 1231 : 1237);
        result = 31 * result + (this.isCscontactaddressidSet ? 1231 : 1237);
        result = 31 * result + (this.isCshandleidSet ? 1231 : 1237);
        result = 31 * result + (this.isCsprivatecontactinfoidSet ? 1231 : 1237);
        result = 31 * result + (this.ispresencebuddy ? 1231 : 1237);
        result = 31 * result + (this.isspeeddial ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.stringData);
        result = 31 * result + (this.updateDateTime == null ? 0 : this.updateDateTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContactListMember other = (ContactListMember)obj;
        if (this.cscontactaddressid != other.cscontactaddressid) {
            return false;
        }
        if (this.cscontactlistid != other.cscontactlistid) {
            return false;
        }
        if (this.cshandleid != other.cshandleid) {
            return false;
        }
        if (this.cspersonid != other.cspersonid) {
            return false;
        }
        if (this.csprivatecontactinfoid != other.csprivatecontactinfoid) {
            return false;
        }
        if (this.entryindex != other.entryindex) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.isCsUserId != other.isCsUserId) {
            return false;
        }
        if (this.isCscontactaddressidSet != other.isCscontactaddressidSet) {
            return false;
        }
        if (this.isCshandleidSet != other.isCshandleidSet) {
            return false;
        }
        if (this.isCsprivatecontactinfoidSet != other.isCsprivatecontactinfoidSet) {
            return false;
        }
        if (this.ispresencebuddy != other.ispresencebuddy) {
            return false;
        }
        if (this.isspeeddial != other.isspeeddial) {
            return false;
        }
        if (!Arrays.equals(this.stringData, other.stringData)) {
            return false;
        }
        return !(this.updateDateTime == null ? other.updateDateTime != null : !this.updateDateTime.equals(other.updateDateTime));
    }

    public String toString() {
        String cscontactaddressidStr = this.isCscontactaddressidSet ? Long.toString(this.cscontactaddressid) : "null";
        String cshandleidStr = this.isCshandleidSet ? Long.toString(this.cshandleid) : "null";
        String csprivatecontactinfoidStr = this.isCsprivatecontactinfoidSet ? Long.toString(this.csprivatecontactinfoid) : "null";
        return "ContactListMember[id: " + this.id + ", cspersonid: " + this.cspersonid + ", cscontactlistid: " + this.cscontactlistid + ", ispresencebuddy: " + this.ispresencebuddy + ", isspeeddial: " + this.isspeeddial + ", entryindex: " + this.entryindex + ", cscontactaddressid: " + cscontactaddressidStr + ", cshandleid: " + cshandleidStr + ", csprivatecontactinfoid: " + csprivatecontactinfoidStr + ", isCsUserId: " + this.isCsUserId + ", updateDateTime: " + this.updateDateTime + "]";
    }

    public Timestamp getUpdateDateTime() {
        return this.updateDateTime;
    }

    public void setUpdateDateTime(Timestamp updateDateTime) {
        this.updateDateTime = updateDateTime;
    }

    static enum StringIndex {
        LABEL;

    }
}

