/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.debug;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.tools.MemoryCounter;
import com.avaya.asm.debug.JavaDebugCallback;
import com.avaya.common.logging.client.Logger;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.TypeVariable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;

public class JavaDebug {
    private static final Logger log = AsmLogger.getLogger(JavaDebug.class);
    private final JavaDebugCallback classLoader;
    private final Map<String, Class<?>> classMap = new HashMap();
    private final Map<String, Object> vars = new HashMap<String, Object>();
    private final Reference nullReference = new Reference();

    public JavaDebug(JavaDebugCallback classLoader) {
        this.classLoader = classLoader;
    }

    private String exceptionToString(Exception ex) {
        try {
            throw ex;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "Parse exception: " + e.getMessage();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return "Class not found: " + e.getMessage();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return "Invocation target exception: " + e.getMessage();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return "Illegal access exception: " + e.getMessage();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return "No such field exception: " + e.getMessage();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return "No such method exception: " + e.getMessage();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return "Illegal state exception: " + e.getMessage();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            return "Array index out of bounds exception: " + e.getMessage();
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            return "Index out of bounds exception: " + e.getMessage();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return "Illegal argument exception: " + e.getMessage();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return "Null pointer exception: " + e.getMessage();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            return "Class cast exception: " + e.getMessage();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Unknown exception thrown: " + e.getMessage();
        }
    }

    public Object readData(String reference) {
        try {
            return this.readData(this.getTokens(reference));
        }
        catch (Exception e) {
            return this.exceptionToString(e);
        }
    }

    public Object readData(List<Token> refTokens) {
        try {
            ListIterator<Token> iter = refTokens.listIterator();
            Reference ref = this.getReference(iter, false);
            JavaDebug.checkForExtraTokens(iter, "reference");
            this.vars.put("_", ref.getObj());
            return ref.getObj();
        }
        catch (Exception e) {
            return this.exceptionToString(e);
        }
    }

    public Object storeData(String var, String reference) {
        try {
            return this.storeData(var, this.getTokens(reference));
        }
        catch (Exception e) {
            return this.exceptionToString(e);
        }
    }

    public Object storeData(String var, List<Token> refTokens) {
        try {
            String varName = this.getVarName(var);
            ListIterator<Token> iter = refTokens.listIterator();
            Reference ref = this.getReference(iter, false);
            JavaDebug.checkForExtraTokens(iter, "reference");
            this.vars.put(varName, ref.getObj());
            this.vars.put("_", ref.getObj());
            return ref.getObj();
        }
        catch (Exception e) {
            return this.exceptionToString(e);
        }
    }

    public Object writeData(String reference, String value) {
        try {
            return this.writeData(this.getTokens(reference), this.getTokens(value));
        }
        catch (ParseException e) {
            return this.exceptionToString(e);
        }
    }

    public Object writeData(List<Token> refTokens, List<Token> valTokens) {
        try {
            ListIterator<Token> refIter = refTokens.listIterator();
            Reference ref = this.getReference(refIter, false);
            JavaDebug.checkForExtraTokens(refIter, "reference");
            ListIterator<Token> valIter = valTokens.listIterator();
            Reference val = this.getReference(valIter, false);
            JavaDebug.checkForExtraTokens(valIter, "value");
            this.writeRefValue(ref, val.getObj());
            this.vars.put("_", val.getObj());
            return val.getObj();
        }
        catch (Exception e) {
            return this.exceptionToString(e);
        }
    }

    public Object expandData(String reference) {
        try {
            return this.expandData(this.getTokens(reference));
        }
        catch (Exception e) {
            return this.exceptionToString(e);
        }
    }

    public Object expandData(List<Token> refTokens) {
        try {
            ListIterator<Token> iter = refTokens.listIterator();
            Reference ref = this.getReference(iter, false);
            JavaDebug.checkForExtraTokens(iter, "reference");
            this.vars.put("_", ref.getObj());
            return this.expandRef(ref, false);
        }
        catch (Exception e) {
            return this.exceptionToString(e);
        }
    }

    private Object expandRef(Reference ref, boolean parseOnly) throws Exception {
        List fields = (List)this.getClassFields(ref, parseOnly).getObj();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields) {
            if (ref.getObj() == null && !Modifier.isStatic(field.getModifiers())) continue;
            String key = this.describeField(field);
            field.setAccessible(true);
            Object value = field.get(ref.getObj());
            map.put(key, value);
        }
        return map;
    }

    public Object sizeData(String reference) {
        try {
            return this.sizeData(this.getTokens(reference));
        }
        catch (Exception e) {
            return this.exceptionToString(e);
        }
    }

    public Object sizeData(List<Token> refTokens) {
        try {
            ListIterator<Token> iter = refTokens.listIterator();
            Reference ref = this.getReference(iter, false);
            JavaDebug.checkForExtraTokens(iter, "reference");
            return this.estimateSize(ref.getObj());
        }
        catch (Exception e) {
            return this.exceptionToString(e);
        }
    }

    private Long estimateSize(Object obj) {
        return new Long(new MemoryCounter().estimate(obj));
    }

    public Object clearData(String var) {
        try {
            String varName = this.getVarName(var);
            this.vars.remove(varName);
            return "SUCCESS";
        }
        catch (Exception e) {
            return this.exceptionToString(e);
        }
    }

    public Object clearAllData() {
        this.vars.clear();
        this.classMap.clear();
        return "SUCCESS";
    }

    public Object listVariables() {
        return new ArrayList<String>(this.vars.keySet());
    }

    public Object setVariable(String var, Object value) {
        try {
            String varName = this.getVarName(var);
            this.vars.put(varName, value);
            return "SUCCESS";
        }
        catch (Exception e) {
            return this.exceptionToString(e);
        }
    }

    public String describeClass(String name, boolean publicOnly) {
        try {
            Class<?> clazz = this.findClassBySimpleName(name);
            return this.describeClass(clazz, publicOnly, 0);
        }
        catch (Exception e) {
            return this.exceptionToString(e);
        }
    }

    private String describeClass(Class<?> clazz, boolean publicOnly, int indent) throws Exception {
        try {
            Method[] methodArray;
            Constructor<?>[] constructors;
            Class<?>[] classes;
            Field[] fields;
            Class<?>[] interfaces;
            StringBuilder buf = new StringBuilder();
            String bIndentStr = this.getIndent(indent);
            String indentStr = this.getIndent(indent + 1);
            buf.append(bIndentStr);
            buf.append(Modifier.toString(clazz.getModifiers()));
            if (buf.length() > 0) {
                buf.append(' ');
            }
            if (!clazz.isInterface()) {
                buf.append(clazz.isEnum() ? "enum " : "class ");
            }
            buf.append(indent > 0 ? clazz.getSimpleName() : clazz.getName());
            buf.append(this.describeTypeParameters(clazz.getTypeParameters()));
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null && !Object.class.equals(superClass) && !Enum.class.equals(superClass)) {
                buf.append(" extends " + superClass.getName());
            }
            if ((interfaces = clazz.getInterfaces()).length > 0) {
                buf.append(" implements ");
                boolean first = true;
                for (Class<?> clazz2 : interfaces) {
                    if (!first) {
                        buf.append(", ");
                    }
                    buf.append(clazz2.getName());
                    first = false;
                }
            }
            buf.append(" {");
            boolean fcm = false;
            Field[] fieldArray = fields = publicOnly ? clazz.getFields() : clazz.getDeclaredFields();
            if (fields.length > 0) {
                int n;
                fcm = true;
                int enumConst = 0;
                if (clazz.isEnum()) {
                    buf.append("\n");
                    boolean first = true;
                    Field[] fieldArray2 = fields;
                    n = fieldArray2.length;
                    for (int i = 0; i < n; ++i) {
                        Field field = fieldArray2[i];
                        if (!field.isEnumConstant()) continue;
                        if (!first) {
                            buf.append(",\n");
                        }
                        buf.append(indentStr);
                        buf.append(field.getName());
                        first = false;
                        ++enumConst;
                    }
                    buf.append(";\n");
                }
                if (fields.length - enumConst > 0) {
                    buf.append("\n");
                    buf.append(indentStr);
                    buf.append("// FIELDS\n");
                }
                Field[] first = fields;
                int n2 = first.length;
                for (n = 0; n < n2; ++n) {
                    Field field = first[n];
                    if (field.isEnumConstant()) continue;
                    buf.append(indentStr);
                    buf.append(this.describeField(field));
                    buf.append(";\n");
                }
            }
            Class<?>[] classArray = classes = publicOnly ? clazz.getClasses() : clazz.getDeclaredClasses();
            if (classes.length > 0) {
                fcm = true;
                buf.append("\n");
                buf.append(indentStr);
                buf.append("// CLASSES");
                for (Class<?> sClazz : classes) {
                    buf.append('\n');
                    buf.append(this.describeClass(sClazz, publicOnly, indent + 1));
                    buf.append(";\n");
                }
            }
            Constructor<?>[] constructorArray = constructors = publicOnly ? clazz.getConstructors() : clazz.getDeclaredConstructors();
            if (constructors.length > 0) {
                fcm = true;
                buf.append("\n");
                buf.append(indentStr);
                buf.append("// CONSTRUCTORS\n");
                for (Constructor<?> constructor : constructors) {
                    buf.append(indentStr);
                    buf.append(this.describeConstructor(constructor));
                    buf.append(";\n");
                }
            }
            Method[] methodArray2 = methodArray = publicOnly ? clazz.getMethods() : clazz.getDeclaredMethods();
            if (methodArray.length > 0) {
                fcm = true;
                buf.append("\n");
                buf.append(indentStr);
                buf.append("// METHODS\n");
                for (Method method : methodArray) {
                    buf.append(indentStr);
                    buf.append(this.describeMethod(method));
                    buf.append(";\n");
                }
            }
            if (!fcm) {
                buf.append("\n");
            }
            buf.append(bIndentStr);
            buf.append('}');
            if (indent == 0) {
                buf.append("\n");
            }
            return buf.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.exceptionToString(e);
        }
    }

    private String getIndent(int indent) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            buf.append('\t');
        }
        return buf.toString();
    }

    private String describeTypeParameters(TypeVariable<?>[] types) {
        StringBuffer buf = new StringBuffer();
        if (types.length > 0) {
            buf.append('<');
            boolean first = true;
            for (TypeVariable<?> type : types) {
                if (!first) {
                    buf.append(',');
                }
                buf.append(type.getName());
                first = false;
            }
            buf.append('>');
        }
        return buf.toString();
    }

    private String describeField(Field field) {
        StringBuffer buf = new StringBuffer();
        String packageName = field.getDeclaringClass().getPackage().getName();
        buf.append(Modifier.toString(field.getModifiers()));
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(this.describeType(field.getType(), false, packageName));
        buf.append(' ');
        buf.append(this.getSimpleName(field.getName()));
        return buf.toString();
    }

    private String describeConstructor(Constructor<?> constructor) {
        StringBuffer buf = new StringBuffer();
        String packageName = constructor.getDeclaringClass().getPackage().getName();
        buf.append(Modifier.toString(constructor.getModifiers()));
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(this.getSimpleName(constructor.getName()));
        buf.append('(');
        buf.append(this.getParametersString(constructor.getParameters(), constructor.isVarArgs(), packageName));
        buf.append(")");
        buf.append(this.getExceptionTypesString(constructor.getExceptionTypes(), packageName));
        return buf.toString();
    }

    private String describeMethod(Method method) {
        StringBuffer buf = new StringBuffer();
        String packageName = method.getDeclaringClass().getPackage().getName();
        buf.append(Modifier.toString(method.getModifiers()));
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(this.describeType(method.getReturnType(), false, packageName));
        buf.append(' ');
        buf.append(method.getName());
        buf.append('(');
        buf.append(this.getParametersString(method.getParameters(), method.isVarArgs(), packageName));
        buf.append(")");
        buf.append(this.getExceptionTypesString(method.getExceptionTypes(), packageName));
        return buf.toString();
    }

    private String getParametersString(Parameter[] parameters, boolean isVarArgs, String packageName) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        for (Parameter param : parameters) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.describeType(param.getType(), isVarArgs && i == parameters.length - 1, packageName));
            buf.append(' ');
            buf.append(param.getName());
            ++i;
        }
        return buf.toString();
    }

    private String describeType(Class<?> type, boolean isVarArgs, String packageName) {
        StringBuilder buf = new StringBuilder();
        if (type.isArray()) {
            buf.append(this.describeType(type.getComponentType(), false, packageName));
            buf.append(isVarArgs ? "..." : "[]");
        } else {
            String canonicalName = type.getCanonicalName();
            if (canonicalName == null) {
                canonicalName = type.getTypeName();
            }
            buf.append(this.shortenType(canonicalName, packageName));
            buf.append(this.describeTypeParameters(type.getTypeParameters()));
        }
        return buf.toString();
    }

    private String getExceptionTypesString(Class<?>[] exceptionClasses, String packageName) {
        StringBuilder buf = new StringBuilder();
        if (exceptionClasses.length > 0) {
            buf.append(" throws ");
            boolean first = true;
            for (Class<?> exClass : exceptionClasses) {
                if (!first) {
                    buf.append(", ");
                }
                buf.append(this.shortenType(exClass.getName(), packageName));
                first = false;
            }
        }
        return buf.toString();
    }

    private String getSimpleName(String name) {
        int index = name.lastIndexOf(46);
        return index < 0 ? name : name.substring(index + 1);
    }

    private String shortenType(String type, String packageName) {
        if ((type.startsWith("java.lang.") || type.startsWith("java.util.")) && type.indexOf(46, 10) < 0) {
            return type.substring(10);
        }
        int pkgLen = packageName.length();
        if (type.length() > pkgLen && type.startsWith(packageName) && type.charAt(pkgLen) == '.' && type.indexOf(46, pkgLen) < 0) {
            return type.substring(pkgLen);
        }
        return type;
    }

    private String getVarName(String var) throws Exception {
        List<Token> varTok = this.getTokens(var);
        if (varTok.size() != 1 || !varTok.get(0).isType(TokenType.IDENT)) {
            throw new IllegalArgumentException("var must be single identifier.");
        }
        return varTok.get(0).getStringValue();
    }

    private Reference getReference(ListIterator<Token> iter, boolean parseOnly) throws Exception {
        return this.getReferenceExprTernary(iter, parseOnly);
    }

    private Reference getReferenceExprTernary(ListIterator<Token> iter, boolean parseOnly) throws Exception {
        Reference ref1 = this.getReferenceExprLogicalOr(iter, parseOnly);
        if (JavaDebug.peekNext(iter).isType(TokenType.QUESTION_MARK)) {
            iter.next();
            if (!parseOnly && !Boolean.class.isInstance(ref1.getObj())) {
                throw new IllegalArgumentException("Non-boolean test result in ternary expression.");
            }
            boolean result = Boolean.TRUE.equals(ref1.getObj());
            ref1 = this.getReferenceExprTernary(iter, parseOnly || !result);
            JavaDebug.checkNextToken(iter, TokenType.COLON, "':' expected inside ternary expression.");
            Reference ref2 = this.getReferenceExprTernary(iter, parseOnly || result);
            return result ? ref1 : ref2;
        }
        return ref1;
    }

    private Reference getReferenceExprLogicalOr(ListIterator<Token> iter, boolean parseOnly) throws Exception {
        Reference ref1 = this.getReferenceExprLogicalAnd(iter, parseOnly);
        Token token = JavaDebug.peekNext(iter);
        while ((token = JavaDebug.peekNext(iter)).isType(TokenType.LOGICAL_OR)) {
            token = iter.next();
            Reference ref2 = this.getReferenceExprLogicalAnd(iter, parseOnly |= Boolean.TRUE.equals(ref1.getObj()));
            if (Boolean.class.isInstance(ref1.getObj()) && Boolean.class.isInstance(ref2.getObj())) {
                ref1 = new Reference((Boolean)ref1.getObj() != false || (Boolean)ref2.getObj() != false, null);
                continue;
            }
            if (parseOnly) continue;
            throw new IllegalArgumentException("Invalid argument type(s) for operator " + (Object)((Object)token.getType()));
        }
        return ref1;
    }

    private Reference getReferenceExprLogicalAnd(ListIterator<Token> iter, boolean parseOnly) throws Exception {
        Reference ref1 = this.getReferenceExprBitwiseOr(iter, parseOnly);
        Token token = JavaDebug.peekNext(iter);
        while ((token = JavaDebug.peekNext(iter)).isType(TokenType.LOGICAL_AND)) {
            token = iter.next();
            Reference ref2 = this.getReferenceExprBitwiseOr(iter, parseOnly |= !Boolean.TRUE.equals(ref1.getObj()));
            if (Boolean.class.isInstance(ref1.getObj()) && Boolean.class.isInstance(ref2.getObj())) {
                ref1 = new Reference((Boolean)ref1.getObj() != false && (Boolean)ref2.getObj() != false, null);
                continue;
            }
            if (parseOnly) continue;
            throw new IllegalArgumentException("Invalid argument type(s) for operator " + (Object)((Object)token.getType()));
        }
        return ref1;
    }

    private Reference getReferenceExprBitwiseOr(ListIterator<Token> iter, boolean parseOnly) throws Exception {
        Reference ref1 = this.getReferenceExprBitwiseXor(iter, parseOnly);
        Token token = JavaDebug.peekNext(iter);
        while ((token = JavaDebug.peekNext(iter)).isType(TokenType.BITWISE_OR)) {
            token = iter.next();
            Reference ref2 = this.getReferenceExprBitwiseXor(iter, parseOnly);
            if (ref1.canUnboxToNumeric() && !ref1.isFloatOrDouble() && ref2.canUnboxToNumeric() && !ref1.isFloatOrDouble()) {
                Class<?> resultType = this.getResultingType(ref1, ref2);
                ref1 = this.convertReferenceType(resultType, new Reference(ref1.unboxToLong() | ref2.unboxToLong(), null));
                continue;
            }
            if (parseOnly) {
                ref1 = this.nullReference;
                continue;
            }
            throw new IllegalArgumentException("Invalid argument type(s) for operator " + (Object)((Object)token.getType()));
        }
        return ref1;
    }

    private Reference getReferenceExprBitwiseXor(ListIterator<Token> iter, boolean parseOnly) throws Exception {
        Reference ref1 = this.getReferenceExprBitwiseAnd(iter, parseOnly);
        Token token = JavaDebug.peekNext(iter);
        while ((token = JavaDebug.peekNext(iter)).isType(TokenType.BITWISE_XOR)) {
            token = iter.next();
            Reference ref2 = this.getReferenceExprBitwiseAnd(iter, parseOnly);
            if (ref1.canUnboxToNumeric() && !ref1.isFloatOrDouble() && ref2.canUnboxToNumeric() && !ref1.isFloatOrDouble()) {
                Class<?> resultType = this.getResultingType(ref1, ref2);
                ref1 = this.convertReferenceType(resultType, new Reference(ref1.unboxToLong() ^ ref2.unboxToLong(), null));
                continue;
            }
            if (parseOnly) {
                ref1 = this.nullReference;
                continue;
            }
            throw new IllegalArgumentException("Invalid argument type(s) for operator " + (Object)((Object)token.getType()));
        }
        return ref1;
    }

    private Reference getReferenceExprBitwiseAnd(ListIterator<Token> iter, boolean parseOnly) throws Exception {
        Reference ref1 = this.getReferenceExprEquality(iter, parseOnly);
        Token token = JavaDebug.peekNext(iter);
        while ((token = JavaDebug.peekNext(iter)).isType(TokenType.BITWISE_AND)) {
            token = iter.next();
            Reference ref2 = this.getReferenceExprEquality(iter, parseOnly);
            if (ref1.canUnboxToNumeric() && !ref1.isFloatOrDouble() && ref2.canUnboxToNumeric() && !ref1.isFloatOrDouble()) {
                Class<?> resultType = this.getResultingType(ref1, ref2);
                ref1 = this.convertReferenceType(resultType, new Reference(ref1.unboxToLong() & ref2.unboxToLong(), null));
                continue;
            }
            if (parseOnly) {
                ref1 = this.nullReference;
                continue;
            }
            throw new IllegalArgumentException("Invalid argument type(s) for operator " + (Object)((Object)token.getType()));
        }
        return ref1;
    }

    private Reference getReferenceExprEquality(ListIterator<Token> iter, boolean parseOnly) throws Exception {
        Token token;
        Reference ref1 = this.getReferenceExprRelational(iter, parseOnly);
        while ((token = JavaDebug.peekNext(iter)).isType(TokenType.EQUAL_EQUAL) || token.isType(TokenType.NOT_EQUALS)) {
            token = iter.next();
            boolean isNotEquals = token.isType(TokenType.NOT_EQUALS);
            Reference ref2 = this.getReferenceExprRelational(iter, parseOnly);
            if (ref1.canUnboxToNumeric() && ref2.canUnboxToNumeric()) {
                if (ref1.isFloatOrDouble() || ref2.isFloatOrDouble()) {
                    ref1 = new Reference(ref1.unboxToDouble() == ref2.unboxToDouble() ^ isNotEquals, null);
                    continue;
                }
                ref1 = new Reference(ref1.unboxToLong() == ref2.unboxToLong() ^ isNotEquals, null);
                continue;
            }
            if (parseOnly) {
                ref1 = this.nullReference;
                continue;
            }
            ref1 = new Reference(ref1.getObj() == ref2.getObj() ^ isNotEquals, null);
        }
        return ref1;
    }

    private Reference getReferenceExprRelational(ListIterator<Token> iter, boolean parseOnly) throws Exception {
        Reference ref1 = this.getReferenceExprShift(iter, parseOnly);
        Token token = JavaDebug.peekNext(iter);
        if (token.isType(TokenType.GREATER) || token.isType(TokenType.GREATER_EQUAL) || token.isType(TokenType.LESS) || token.isType(TokenType.LESS_EQUAL)) {
            token = iter.next();
            boolean isGreater = token.isType(TokenType.GREATER);
            boolean isGreaterEqual = token.isType(TokenType.GREATER_EQUAL);
            boolean isLess = token.isType(TokenType.LESS);
            boolean isLessEqual = token.isType(TokenType.LESS_EQUAL);
            Reference ref2 = this.getReferenceExprShift(iter, parseOnly);
            if (ref1.canUnboxToNumeric() && ref2.canUnboxToNumeric()) {
                if (ref1.isFloatOrDouble() || ref2.isFloatOrDouble()) {
                    if (isGreater) {
                        return new Reference(ref1.unboxToDouble() > ref2.unboxToDouble(), null);
                    }
                    if (isGreaterEqual) {
                        return new Reference(ref1.unboxToDouble() >= ref2.unboxToDouble(), null);
                    }
                    if (isLess) {
                        return new Reference(ref1.unboxToDouble() < ref2.unboxToDouble(), null);
                    }
                    if (isLessEqual) {
                        return new Reference(ref1.unboxToDouble() <= ref2.unboxToDouble(), null);
                    }
                    throw new IllegalArgumentException("Invalid argument type(s) for operator " + (Object)((Object)token.getType()));
                }
                if (isGreater) {
                    return new Reference(ref1.unboxToLong() > ref2.unboxToLong(), null);
                }
                if (isGreaterEqual) {
                    return new Reference(ref1.unboxToLong() >= ref2.unboxToLong(), null);
                }
                if (isLess) {
                    return new Reference(ref1.unboxToLong() < ref2.unboxToLong(), null);
                }
                if (isLessEqual) {
                    return new Reference(ref1.unboxToLong() <= ref2.unboxToLong(), null);
                }
            } else if (parseOnly) {
                ref1 = this.nullReference;
            } else {
                throw new IllegalArgumentException("Invalid argument type(s) for operator " + (Object)((Object)token.getType()));
            }
        }
        return ref1;
    }

    private Reference getReferenceExprShift(ListIterator<Token> iter, boolean parseOnly) throws Exception {
        Reference ref1 = this.getReferenceExprAdditive(iter, parseOnly);
        Token token = JavaDebug.peekNext(iter);
        while ((token = JavaDebug.peekNext(iter)).isType(TokenType.SHIFT_LEFT) || token.isType(TokenType.SHIFT_RIGHT_SIGNED) || token.isType(TokenType.SHIFT_RIGHT_UNSIGNED)) {
            token = iter.next();
            boolean isShiftLeft = token.isType(TokenType.SHIFT_LEFT);
            boolean isShiftRightSigned = token.isType(TokenType.SHIFT_RIGHT_SIGNED);
            boolean isShiftRightUnsigned = token.isType(TokenType.SHIFT_RIGHT_UNSIGNED);
            Reference ref2 = this.getReferenceExprAdditive(iter, parseOnly);
            if (ref1.canUnboxToNumeric() && !ref1.isFloatOrDouble() && ref2.canUnboxToNumeric() && !ref1.isFloatOrDouble()) {
                Class<?> resultType = this.getResultingType(ref1);
                if (isShiftLeft) {
                    ref1 = this.convertReferenceType(resultType, new Reference(ref1.unboxToLong() << (int)ref2.unboxToLong(), null));
                    continue;
                }
                if (isShiftRightSigned) {
                    ref1 = this.convertReferenceType(resultType, new Reference(ref1.unboxToLong() >> (int)ref2.unboxToLong(), null));
                    continue;
                }
                if (isShiftRightUnsigned) {
                    ref1 = this.convertReferenceType(resultType, new Reference(ref1.unboxToLong() >>> (int)ref2.unboxToLong(), null));
                    continue;
                }
                throw new IllegalArgumentException("Invalid argument type(s) for operator " + (Object)((Object)token.getType()));
            }
            if (parseOnly) {
                ref1 = this.nullReference;
                continue;
            }
            throw new IllegalArgumentException("Invalid argument type(s) for operator " + (Object)((Object)token.getType()));
        }
        return ref1;
    }

    private Reference getReferenceExprAdditive(ListIterator<Token> iter, boolean parseOnly) throws Exception {
        Reference ref1 = this.getReferenceExprMultiplicative(iter, parseOnly);
        Token token = JavaDebug.peekNext(iter);
        while ((token = JavaDebug.peekNext(iter)).isType(TokenType.PLUS) || token.isType(TokenType.MINUS)) {
            token = iter.next();
            boolean isPlus = token.isType(TokenType.PLUS);
            Reference ref2 = this.getReferenceExprMultiplicative(iter, parseOnly);
            if (ref1.canUnboxToNumeric() && ref2.canUnboxToNumeric()) {
                Class<?> resultType = this.getResultingType(ref1, ref2);
                if (ref1.isFloatOrDouble() || ref2.isFloatOrDouble()) {
                    ref1 = this.convertReferenceType(resultType, isPlus ? new Reference(ref1.unboxToDouble() + ref2.unboxToDouble(), null) : new Reference(ref1.unboxToDouble() - ref2.unboxToDouble(), null));
                    continue;
                }
                ref1 = this.convertReferenceType(resultType, isPlus ? new Reference(ref1.unboxToLong() + ref2.unboxToLong(), null) : new Reference(ref1.unboxToLong() - ref2.unboxToLong(), null));
                continue;
            }
            if (isPlus && (ref1.isString() || ref2.isString())) {
                ref1 = new Reference(ref1.getObj().toString() + ref2.getObj().toString(), null);
                continue;
            }
            if (parseOnly) {
                ref1 = this.nullReference;
                continue;
            }
            throw new IllegalArgumentException("Invalid argument type(s) for operator " + (Object)((Object)token.getType()));
        }
        return ref1;
    }

    private Reference getReferenceExprMultiplicative(ListIterator<Token> iter, boolean parseOnly) throws Exception {
        Token token;
        Reference ref1 = this.getReferenceExprCastNew(iter, parseOnly);
        while ((token = JavaDebug.peekNext(iter)).isType(TokenType.TIMES) || token.isType(TokenType.DIVIDE) || token.isType(TokenType.PERCENT)) {
            token = iter.next();
            boolean isTimes = token.isType(TokenType.TIMES);
            boolean isDivide = token.isType(TokenType.DIVIDE);
            boolean isPercent = token.isType(TokenType.PERCENT);
            Reference ref2 = this.getReferenceExprCastNew(iter, parseOnly);
            if (ref1.canUnboxToNumeric() && ref2.canUnboxToNumeric()) {
                Class<?> resultType = this.getResultingType(ref1, ref2);
                if (ref1.isFloatOrDouble() || ref2.isFloatOrDouble()) {
                    if (isTimes) {
                        ref1 = this.convertReferenceType(resultType, new Reference(ref1.unboxToDouble() * ref2.unboxToDouble(), null));
                        continue;
                    }
                    if (isDivide) {
                        ref1 = this.convertReferenceType(resultType, new Reference(ref1.unboxToDouble() / ref2.unboxToDouble(), null));
                        continue;
                    }
                    if (!isPercent) continue;
                    ref1 = this.convertReferenceType(resultType, new Reference(ref1.unboxToDouble() % ref2.unboxToDouble(), null));
                    continue;
                }
                if (isTimes) {
                    ref1 = this.convertReferenceType(resultType, new Reference(ref1.unboxToLong() * ref2.unboxToLong(), null));
                    continue;
                }
                if (isDivide) {
                    ref1 = this.convertReferenceType(resultType, new Reference(ref1.unboxToLong() / ref2.unboxToLong(), null));
                    continue;
                }
                if (!isPercent) continue;
                ref1 = this.convertReferenceType(resultType, new Reference(ref1.unboxToLong() % ref2.unboxToLong(), null));
                continue;
            }
            if (parseOnly) {
                ref1 = this.nullReference;
                continue;
            }
            throw new IllegalArgumentException("Invalid argument type(s) for operator " + (Object)((Object)token.getType()));
        }
        return ref1;
    }

    private Reference getReferenceExprCastNew(ListIterator<Token> iter, boolean parseOnly) throws Exception {
        int saveIndex = iter.nextIndex();
        if (JavaDebug.peekNext(iter).isType(TokenType.LPAREN)) {
            iter.next();
            Reference ref = null;
            Token token = JavaDebug.peekNext(iter);
            switch (token.getType()) {
                case IDENT: 
                case BOOLEAN: 
                case BYTE: 
                case CHAR: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: {
                    try {
                        ref = this.getClassReference(iter, parseOnly);
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
            if (ref != null) {
                JavaDebug.checkNextToken(iter, TokenType.RPAREN, "Missing ')'.");
                if (ref.getObj() == null && ref.getObjClass() != null) {
                    return this.getCastReference(iter, ref.getObjClass(), parseOnly);
                }
            }
            while (iter.nextIndex() > saveIndex) {
                iter.previous();
            }
        }
        if (JavaDebug.peekNext(iter).isType(TokenType.NEW)) {
            return this.getNewObject(iter, parseOnly);
        }
        return this.getReferenceExprPreUnary(iter, parseOnly);
    }

    private Reference getReferenceExprPreUnary(ListIterator<Token> iter, boolean parseOnly) throws Exception {
        Token token = JavaDebug.peekNext(iter);
        if (token.isType(TokenType.PLUS) || token.isType(TokenType.PLUS_PLUS) || token.isType(TokenType.MINUS) || token.isType(TokenType.MINUS_MINUS) || token.isType(TokenType.LOGICAL_NOT) || token.isType(TokenType.BITWISE_NOT)) {
            token = iter.next();
            boolean isPlus = token.isType(TokenType.PLUS);
            boolean isPlusPlus = token.isType(TokenType.PLUS_PLUS);
            boolean isMinus = token.isType(TokenType.MINUS);
            boolean isMinusMinus = token.isType(TokenType.MINUS_MINUS);
            boolean isLogicalNot = token.isType(TokenType.LOGICAL_NOT);
            boolean isBitwiseNot = token.isType(TokenType.BITWISE_NOT);
            Reference ref = this.getReferenceExprPreUnary(iter, parseOnly);
            if (!parseOnly && ref.canUnboxToNumeric()) {
                Class<?> resultType = this.getResultingType(ref);
                if (isPlus) {
                    return ref;
                }
                if (isPlusPlus) {
                    Reference newRef = this.convertReferenceType(resultType, ref.isFloatOrDouble() ? new Reference(ref, (Object)(ref.unboxToDouble() + 1.0)) : new Reference(ref, (Object)(ref.unboxToLong() + 1L)));
                    this.incrDecrValue(ref, true);
                    return newRef;
                }
                if (isMinus) {
                    return this.convertReferenceType(resultType, ref.isFloatOrDouble() ? new Reference(-ref.unboxToDouble(), null) : new Reference(-ref.unboxToLong(), null));
                }
                if (isMinusMinus) {
                    Reference newRef = this.convertReferenceType(resultType, ref.isFloatOrDouble() ? new Reference(ref, (Object)(ref.unboxToDouble() - 1.0)) : new Reference(ref, (Object)(ref.unboxToLong() - 1L)));
                    this.incrDecrValue(ref, false);
                    return newRef;
                }
                if (isBitwiseNot && !ref.isFloatOrDouble()) {
                    return this.convertReferenceType(resultType, new Reference(ref.unboxToLong() ^ 0xFFFFFFFFFFFFFFFFL, null));
                }
                throw new IllegalArgumentException("Invalid unary operator for numeric value: " + token);
            }
            if (!parseOnly && isLogicalNot && ref.getObj() != null && Boolean.class.isInstance(ref.getObj())) {
                return new Reference((Boolean)ref.getObj() == false, null);
            }
            if (parseOnly) {
                return this.nullReference;
            }
            throw new IllegalArgumentException("Non-numeric value for unary " + token);
        }
        return this.getReferenceExprPostUnary(iter, parseOnly);
    }

    private Reference getReferenceExprPostUnary(ListIterator<Token> iter, boolean parseOnly) throws Exception {
        Reference ref = this.getReferenceExpr(iter, parseOnly);
        Token token = JavaDebug.peekNext(iter);
        if (token.isType(TokenType.PLUS_PLUS) || token.isType(TokenType.MINUS_MINUS)) {
            iter.next();
            boolean isPlusPlus = token.isType(TokenType.PLUS_PLUS);
            if (!parseOnly && ref.canUnboxToNumeric()) {
                this.incrDecrValue(ref, isPlusPlus);
                return ref;
            }
            if (parseOnly) {
                return this.nullReference;
            }
            throw new IllegalArgumentException("Non-numeric value for unary " + token);
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrDecrValue(Reference ref, boolean incr) throws Exception {
        Object parent = ref.getParent();
        Class<?> resultType = this.getResultingType(ref);
        Object syncObj = parent;
        if (syncObj == null) {
            syncObj = ref.getField();
        }
        if (syncObj == null) {
            syncObj = ref.getVarName();
        }
        Object object = syncObj;
        synchronized (object) {
            Object obj = this.readRefValue(ref);
            Reference newRef = new Reference(obj, null);
            newRef = incr ? this.convertReferenceType(resultType, ref.isFloatOrDouble() ? new Reference(newRef.unboxToDouble() + 1.0, null) : new Reference(newRef.unboxToLong() + 1L, null)) : this.convertReferenceType(resultType, ref.isFloatOrDouble() ? new Reference(newRef.unboxToDouble() - 1.0, null) : new Reference(newRef.unboxToLong() - 1L, null));
            this.writeRefValue(ref, newRef.getObj());
        }
    }

    private Object readRefValue(Reference ref) throws Exception {
        Field field = ref.getField();
        Object parent = ref.getParent();
        if (field != null) {
            return field.get(parent);
        }
        String varName = ref.getVarName();
        if (varName != null) {
            return this.vars.get(varName);
        }
        Object key = ref.getKeyOrIndex();
        if (Map.class.isInstance(parent)) {
            Map map = (Map)parent;
            return map.get(key);
        }
        if (List.class.isInstance(parent)) {
            if (!Integer.class.isInstance(key)) {
                throw new IllegalArgumentException("List index must be type integer");
            }
            List list = (List)ref.getParent();
            return list.get((Integer)key);
        }
        if (parent != null && parent.getClass().isArray()) {
            if (!Integer.class.isInstance(key)) {
                throw new IllegalArgumentException("Array index must be type integer");
            }
            return Array.get(parent, (Integer)key);
        }
        throw new IllegalArgumentException("Illegal lvalue.");
    }

    private void writeRefValue(Reference ref, Object obj) throws Exception {
        Field field = ref.getField();
        Object parent = ref.getParent();
        if (field != null) {
            field.set(parent, obj);
        } else {
            String varName = ref.getVarName();
            if (varName != null) {
                this.vars.put(varName, obj);
            } else {
                Object key = ref.getKeyOrIndex();
                if (Map.class.isInstance(parent)) {
                    Map map = (Map)parent;
                    map.put(key, obj);
                } else if (List.class.isInstance(parent)) {
                    if (!(key instanceof Integer)) {
                        throw new IllegalArgumentException("List index must be type integer");
                    }
                    List list = (List)parent;
                    list.set((Integer)key, obj);
                } else if (parent != null && parent.getClass().isArray()) {
                    if (!(key instanceof Integer)) {
                        throw new IllegalArgumentException("Array index must be type integer");
                    }
                    Array.set(parent, (Integer)key, obj);
                } else {
                    throw new IllegalArgumentException("Illegal lvalue reference for write data.");
                }
            }
        }
    }

    private Reference getReferenceExpr(ListIterator<Token> iter, boolean parseOnly) throws Exception {
        Reference ref = new Reference();
        JavaDebug.checkHasNext(iter, "Missing reference.");
        Token token = JavaDebug.peekNext(iter);
        switch (token.getType()) {
            case DOLLAR: {
                iter.next();
                ref = this.getVariableObject(iter, parseOnly);
                break;
            }
            case LPAREN: {
                iter.next();
                ref = this.getParenReference(iter, parseOnly);
                break;
            }
            case NULL: 
            case BOOLEAN_CONST: 
            case LONG_CONST: 
            case INT_CONST: 
            case FLOAT_CONST: 
            case DOUBLE_CONST: 
            case STRING_CONST: {
                token = iter.next();
                ref = new Reference(this.getObjectFromToken(token), null);
                break;
            }
            default: {
                ref = this.getSimpleClassReference(iter, parseOnly);
            }
        }
        return this.getReferenceOps(iter, ref, parseOnly);
    }

    private Reference getVariableObject(ListIterator<Token> iter, boolean parseOnly) throws Exception {
        boolean lbrace = false;
        if (JavaDebug.peekNext(iter).isType(TokenType.LBRACE)) {
            iter.next();
            lbrace = true;
        }
        Token token = JavaDebug.checkNextToken(iter, TokenType.IDENT, "Identifier expected after '$'.");
        String varName = token.getStringValue();
        if (!parseOnly && !this.vars.containsKey(varName)) {
            throw new IllegalArgumentException("No such variable: " + varName);
        }
        if (lbrace) {
            JavaDebug.checkNextToken(iter, TokenType.RBRACE, "Missing '}' after variable name.");
        }
        return new Reference(this.vars.get(varName), null, null, null, null, varName);
    }

    private Reference getParenReference(ListIterator<Token> iter, boolean parseOnly) throws Exception {
        Reference ref = this.getReference(iter, parseOnly);
        JavaDebug.checkNextToken(iter, TokenType.RPAREN, "Missing ')'.");
        return ref;
    }

    private Reference getClassReference(ListIterator<Token> iter, boolean parseOnly) throws Exception {
        Reference ref = this.getSimpleClassReference(iter, parseOnly);
        while (JavaDebug.peekNext(iter).isType(TokenType.LBRACKET)) {
            iter.next();
            JavaDebug.checkNextToken(iter, TokenType.RBRACKET, "']' expected in array type.");
            ref = parseOnly ? this.nullReference : new Reference(Array.newInstance(ref.getObjClass(), 0).getClass());
        }
        return ref;
    }

    private Reference getSimpleClassReference(ListIterator<Token> iter, boolean parseOnly) throws Exception {
        JavaDebug.checkHasNext(iter, "Type reference expected.");
        Token token = iter.next();
        switch (token.getType()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return new Reference(this.getPrimClass(token.getType()));
            }
            case IDENT: {
                String name = token.getStringValue();
                ClassNotFoundException lastEx = null;
                while (true) {
                    try {
                        return new Reference(this.findClassBySimpleName(name));
                    }
                    catch (ClassNotFoundException e) {
                        lastEx = e;
                        if (iter.next().isType(TokenType.DOT)) {
                            JavaDebug.checkHasNext(iter, "Identifier expected after '.'.");
                            token = iter.next();
                            if (token.isType(TokenType.IDENT)) {
                                name = name + "." + token.getStringValue();
                                continue;
                            }
                        }
                        throw lastEx;
                    }
                    break;
                }
            }
        }
        throw new ParseException("Unexpected token " + token, iter.previousIndex());
    }

    private Reference getReferenceOps(ListIterator<Token> iter, Reference ref, boolean parseOnly) throws Exception {
        Token peekTok;
        while (iter.hasNext() && ((peekTok = JavaDebug.peekNext(iter)).isType(TokenType.DOT) || peekTok.isType(TokenType.HASHTAG) || peekTok.isType(TokenType.LBRACE) || peekTok.isType(TokenType.LBRACKET))) {
            ref = this.getReferenceOp(iter, ref, parseOnly);
        }
        return ref;
    }

    private Reference getReferenceOp(ListIterator<Token> iter, Reference ref, boolean parseOnly) throws Exception {
        Token token = iter.next();
        block0 : switch (token.getType()) {
            case DOT: {
                JavaDebug.checkHasNext(iter, "Missing identifer following '.'.");
                token = iter.next();
                switch (token.getType()) {
                    case CLASS: {
                        ref = this.getObjClass(ref);
                        break block0;
                    }
                    case IDENT: {
                        if (JavaDebug.peekNext(iter).isType(TokenType.LPAREN)) {
                            ref = this.getMethodCall(iter, token.getStringValue(), ref, parseOnly);
                            break block0;
                        }
                        ref = this.getObjFieldValue(token.getStringValue(), ref, parseOnly);
                        break block0;
                    }
                }
                throw new ParseException("Unexpected token: " + token, iter.previousIndex());
            }
            case HASHTAG: {
                token = JavaDebug.checkNextToken(iter, TokenType.IDENT, "Missing identifer following ':'.");
                switch (token.getStringValue()) {
                    case "CONSTRUCTORS": {
                        ref = this.getOptionalFilter(iter, this.getClassConstructors(ref, parseOnly), parseOnly);
                        break block0;
                    }
                    case "METHODS": {
                        ref = this.getOptionalFilter(iter, this.getClassMethods(ref, parseOnly), parseOnly);
                        break block0;
                    }
                    case "FIELDS": {
                        ref = this.getOptionalFilter(iter, this.getClassFields(ref, parseOnly), parseOnly);
                        break block0;
                    }
                    case "CLASSES": {
                        ref = this.getOptionalFilter(iter, this.getClasses(ref, parseOnly), parseOnly);
                        break block0;
                    }
                    case "LIST": {
                        ref = this.getOptionalFilter(iter, this.getToList(ref, parseOnly), parseOnly);
                        break block0;
                    }
                    case "FORMAT": {
                        ref = parseOnly ? this.nullReference : this.toFormattedString(ref);
                        break block0;
                    }
                    case "SIZE": {
                        ref = parseOnly ? this.nullReference : new Reference(this.estimateSize(ref.getObj()), ref.getObj());
                        break block0;
                    }
                }
                throw new ParseException("Unrecognized identifier: " + token, iter.previousIndex());
            }
            case LBRACE: {
                ref = this.getMapRef(iter, ref, parseOnly);
                break;
            }
            case LBRACKET: {
                ref = this.getArrayListRef(iter, ref, parseOnly);
                break;
            }
            default: {
                throw new ParseException("Unexpected token: " + token, iter.previousIndex());
            }
        }
        return ref;
    }

    private Reference getOptionalFilter(ListIterator<Token> iter, Reference ref, boolean parseOnly) throws Exception {
        if (JavaDebug.peekNext(iter).isType(TokenType.LPAREN)) {
            iter.next();
            boolean reverse = false;
            if (JavaDebug.peekNext(iter).isType(TokenType.LOGICAL_NOT)) {
                reverse = true;
                iter.next();
            }
            JavaDebug.checkHasNext(iter, "Missing String value in filter specification.");
            Reference filterRef = this.getReference(iter, parseOnly);
            if (!String.class.isInstance(filterRef.getObj())) {
                throw new ParseException("String value required in filter specification.", iter.previousIndex());
            }
            JavaDebug.checkNextToken(iter, TokenType.RPAREN, "Missing ')' in filter specification.");
            if (ref.getObj() != null) {
                List<Object> list;
                Class<?> clazz = ref.getObj().getClass();
                boolean isArray = false;
                if (clazz.isArray()) {
                    isArray = true;
                    list = Arrays.asList(ref.getObj());
                } else {
                    list = (List<Object>)this.getToList(ref, parseOnly).getObj();
                }
                ArrayList<Object> filtList = new ArrayList<Object>();
                String filter = (String)filterRef.getObj();
                if (filter.isEmpty() || filter.charAt(0) != '^') {
                    filter = ".*" + filter;
                }
                if (filter.charAt(filter.length() - 1) != '$') {
                    filter = filter + ".*";
                }
                for (Object obj : list) {
                    if (reverse && (obj == null || !obj.toString().matches(filter))) {
                        filtList.add(obj);
                        continue;
                    }
                    if (reverse || obj == null || !obj.toString().matches(filter)) continue;
                    filtList.add(obj);
                }
                if (isArray) {
                    ref = new Reference(Array.newInstance(clazz.getComponentType(), filtList.size()), ref.getObj());
                    int i = 0;
                    for (Object e : filtList) {
                        Array.set(ref.getObj(), i++, e);
                    }
                } else {
                    ref = new Reference(filtList, ref.getObj());
                }
            }
        }
        return ref;
    }

    private Reference getClassConstructors(Reference ref, boolean parseOnly) throws Exception {
        HashSet constructors = new HashSet();
        if (!parseOnly) {
            Class<?> clazz = ref.getObjClass();
            for (Constructor<?> constructor : clazz.getConstructors()) {
                constructors.add(constructor);
            }
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                constructors.add(constructor);
            }
        }
        return new Reference(new ArrayList(constructors), ref.getObj());
    }

    private Reference getClassMethods(Reference ref, boolean parseOnly) throws Exception {
        HashSet<Method> methods = new HashSet<Method>();
        if (!parseOnly) {
            Class<?> clazz = ref.getObjClass();
            for (Method method : clazz.getMethods()) {
                methods.add(method);
            }
            for (Method method : clazz.getDeclaredMethods()) {
                methods.add(method);
            }
        }
        return new Reference(new ArrayList(methods), ref.getObj());
    }

    private Reference getClassFields(Reference ref, boolean parseOnly) throws Exception {
        HashSet<Field> fields = new HashSet<Field>();
        if (!parseOnly) {
            Class<?> clazz = ref.getObjClass();
            for (Field field : clazz.getFields()) {
                fields.add(field);
            }
            while (clazz != null) {
                for (Field field : clazz.getDeclaredFields()) {
                    fields.add(field);
                }
                clazz = clazz.getSuperclass();
            }
        }
        return new Reference(new ArrayList(fields), ref.getObj());
    }

    private Reference getClasses(Reference ref, boolean parseOnly) throws Exception {
        HashSet classes = new HashSet();
        if (!parseOnly) {
            Class<?> clazz = ref.getObjClass();
            for (Class<?> sclazz : clazz.getClasses()) {
                classes.add(sclazz);
            }
        }
        return new Reference(new ArrayList(classes), ref.getObj());
    }

    private Reference getMethodCall(ListIterator<Token> iter, String name, Reference ref, boolean parseOnly) throws Exception {
        iter.next();
        ArrayList<Object> args = new ArrayList<Object>();
        boolean argRequired = false;
        while (iter.hasNext()) {
            if (JavaDebug.peekNext(iter).isType(TokenType.RPAREN)) {
                if (!argRequired) break;
                throw new ParseException("Syntax error in method argument list.", iter.previousIndex());
            }
            Reference arg = this.getReference(iter, parseOnly);
            args.add(arg.getObj());
            argRequired = false;
            if (!JavaDebug.peekNext(iter).isType(TokenType.COMMA)) continue;
            iter.next();
            argRequired = true;
        }
        JavaDebug.checkNextToken(iter, TokenType.RPAREN, "Missing ')' after method reference.");
        if (parseOnly) {
            return this.nullReference;
        }
        Class<?> clazz = ref.getObjClass();
        Method method = this.findClassMethod(clazz, name, args);
        method.setAccessible(true);
        return new Reference(method.invoke(ref.getObj(), this.prepareArgs(args, method.getParameterTypes().length, method.isVarArgs())), ref.getObj(), null, null, method);
    }

    private Object[] prepareArgs(List<Object> args, int count, boolean isVarArgs) {
        if (isVarArgs) {
            int size = args.size();
            if (size < count) {
                args.add(null);
            } else {
                Object arg = args.get(size - 1);
                if (size > count || arg != null && !arg.getClass().isArray()) {
                    int i;
                    Object varArgAr = Array.newInstance(arg.getClass(), size - count + 1);
                    for (i = count - 1; i < size; ++i) {
                        Array.set(varArgAr, i - (count - 1), args.get(i));
                    }
                    for (i = size - 1; i >= count - 1; --i) {
                        args.remove(i);
                    }
                    args.add(varArgAr);
                }
            }
        }
        return args.toArray();
    }

    private Reference getNewObject(ListIterator<Token> iter, boolean parseOnly) throws Exception {
        Reference ref;
        if (!iter.next().isType(TokenType.NEW)) {
            throw new ParseException("Parser is out of sync.", iter.previousIndex());
        }
        if (JavaDebug.peekNext(iter).isType(TokenType.COLON)) {
            iter.next();
        }
        JavaDebug.checkHasNext(iter, "Token expected after keyword 'new'.");
        Token token = JavaDebug.peekNext(iter);
        switch (token.getType()) {
            case IDENT: 
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                ref = this.getSimpleClassReference(iter, parseOnly);
                if (JavaDebug.peekNext(iter).isType(TokenType.LBRACKET)) {
                    if ((ref = this.getArrayRef(iter, ref.getObjClass(), 0, new ArrayList<Integer>(), parseOnly)).getObj() != null) break;
                    if (JavaDebug.peekNext(iter).isType(TokenType.EQUALS)) {
                        iter.next();
                    }
                    JavaDebug.checkNextToken(iter, TokenType.LBRACE, "Initializer list expected.");
                    ref = this.getRefObjArray(iter, null, ref.getObjClass(), parseOnly);
                    break;
                }
                ref = this.getConstructedObject(iter, ref.getObjClass(), parseOnly);
                if (!JavaDebug.peekNext(iter).isType(TokenType.LBRACE)) break;
                iter.next();
                if (ref.getObj() instanceof Map) {
                    ref = this.getRefObjMap(iter, (Map)ref.getObj(), parseOnly);
                    break;
                }
                if (ref.getObj() instanceof Collection) {
                    ref = this.getRefObjArray(iter, (Collection)ref.getObj(), null, parseOnly);
                    break;
                }
                throw new IllegalArgumentException("Initializer used with non-Map/Collection type.");
            }
            default: {
                throw new ParseException("Type name expected after keyword 'new'.", iter.previousIndex());
            }
        }
        return ref;
    }

    private Reference getArrayRef(ListIterator<Token> iter, Class<?> arClass, int depth, List<Integer> dims, boolean parseOnly) throws Exception {
        JavaDebug.checkNextToken(iter, TokenType.LBRACKET, "Expected '['.");
        if (dims.size() == depth && JavaDebug.peekNext(iter).isType(TokenType.INT_CONST)) {
            Integer dim = (Integer)iter.next().getValue();
            if (dim < 0) {
                throw new ParseException("Negative dimension not allowed.", iter.previousIndex());
            }
            dims.add(dim);
        } else {
            arClass = Array.newInstance(arClass, 0).getClass();
        }
        JavaDebug.checkNextToken(iter, TokenType.RBRACKET, "Expected ']'.");
        Reference ref = JavaDebug.peekNext(iter).isType(TokenType.LBRACKET) ? this.getArrayRef(iter, arClass, depth + 1, dims, parseOnly) : (dims.isEmpty() ? new Reference(arClass) : new Reference(this.getArrayObject(arClass, dims), null));
        return ref;
    }

    private Object getArrayObject(Class<?> arClass, List<Integer> dimensions) {
        int[] dims = new int[dimensions.size()];
        for (int i = 0; i < dimensions.size(); ++i) {
            dims[i] = dimensions.get(i);
        }
        return Array.newInstance(arClass, dims);
    }

    private Class<?> getPrimClass(TokenType type) {
        switch (type) {
            case BYTE: {
                return Byte.TYPE;
            }
            case CHAR: {
                return Character.TYPE;
            }
            case INT: {
                return Integer.TYPE;
            }
            case SHORT: {
                return Short.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
        }
        return null;
    }

    private Class<?> getPrimObjClass(TokenType type) {
        switch (type) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case BYTE: {
                return Byte.class;
            }
            case CHAR: {
                return Character.class;
            }
            case SHORT: {
                return Short.class;
            }
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
        }
        return null;
    }

    private Reference getCastReference(ListIterator<Token> iter, Class<?> clazz, boolean parseOnly) throws Exception {
        Reference ref = this.getReferenceExprCastNew(iter, parseOnly);
        if (ref.getObj() != null) {
            boolean bType = false;
            boolean bValue = false;
            boolean lType = false;
            long lValue = 0L;
            boolean dType = false;
            double dValue = 0.0;
            boolean sType = false;
            String sValue = null;
            if (Boolean.class.isInstance(ref.getObj())) {
                bValue = (Boolean)ref.getObj();
                bType = true;
            } else if (Byte.class.isInstance(ref.getObj())) {
                lValue = ((Byte)ref.getObj()).longValue();
                lType = true;
            } else if (Character.class.isInstance(ref.getObj())) {
                lValue = ((Character)ref.getObj()).charValue();
                lType = true;
            } else if (Short.class.isInstance(ref.getObj())) {
                lValue = ((Short)ref.getObj()).longValue();
                lType = true;
            } else if (Integer.class.isInstance(ref.getObj())) {
                lValue = ((Integer)ref.getObj()).longValue();
                lType = true;
            } else if (Long.class.isInstance(ref.getObj())) {
                lValue = (Long)ref.getObj();
                lType = true;
            } else if (Float.class.isInstance(ref.getObj())) {
                dValue = ((Float)ref.getObj()).doubleValue();
                dType = true;
                lValue = ((Float)ref.getObj()).longValue();
                lType = true;
            } else if (Double.class.isInstance(ref.getObj())) {
                dValue = (Double)ref.getObj();
                dType = true;
                lValue = ((Double)ref.getObj()).longValue();
                lType = true;
            } else if (String.class.isInstance(ref.getObj())) {
                sType = true;
                sValue = (String)ref.getObj();
            }
            if (bType && (Boolean.TYPE.equals(clazz) || Boolean.class.equals(clazz))) {
                return new Reference(new Boolean(bValue), ref.getObj());
            }
            if (lType && (Byte.TYPE.equals(clazz) || Byte.class.equals(clazz))) {
                return new Reference(new Byte((byte)lValue), ref.getObj());
            }
            if (lType && (Character.TYPE.equals(clazz) || Character.class.equals(clazz))) {
                return new Reference(new Character((char)lValue), ref.getObj());
            }
            if (lType && (Short.TYPE.equals(clazz) || Short.class.equals(clazz))) {
                return new Reference(new Short((short)lValue), ref.getObj());
            }
            if (lType && (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz))) {
                return new Reference(new Integer((int)lValue), ref.getObj());
            }
            if (lType && (Long.TYPE.equals(clazz) || Long.class.equals(clazz))) {
                return new Reference(new Long(lValue), ref.getObj());
            }
            if (dType && (Float.TYPE.equals(clazz) || Float.class.equals(clazz))) {
                return new Reference(new Float((float)dValue), ref.getObj());
            }
            if (dType && (Double.TYPE.equals(clazz) || Double.class.equals(clazz))) {
                return new Reference(new Double(dValue), ref.getObj());
            }
            if (sType && sValue != null && sValue.length() == 1 && Character.class.equals(clazz)) {
                return new Reference(new Character(sValue.charAt(0)), ref.getObj());
            }
        }
        return new Reference(clazz.cast(ref.getObj()), ref.getObj());
    }

    private Reference getRefObjMap(ListIterator<Token> iter, Map<Object, Object> map, boolean parseOnly) throws Exception {
        if (map == null) {
            map = new HashMap<Object, Object>();
        }
        boolean refRequired = false;
        while (!JavaDebug.peekNext(iter).isType(TokenType.RBRACE)) {
            Reference key = this.getReference(iter, parseOnly);
            JavaDebug.checkNextToken(iter, TokenType.COMMA, "',' expected after Map key.");
            Reference value = this.getReference(iter, parseOnly);
            if (!parseOnly) {
                map.put(key.getObj(), value.getObj());
            }
            refRequired = false;
            if (!JavaDebug.peekNext(iter).isType(TokenType.COMMA)) continue;
            iter.next();
            refRequired = true;
        }
        iter.next();
        if (refRequired) {
            throw new ParseException("Reference expected after ','.", iter.previousIndex());
        }
        return new Reference(map, null);
    }

    private Reference getRefObjArray(ListIterator<Token> iter, Collection<Object> refList, Class<?> arClass, boolean parseOnly) throws Exception {
        boolean toArray = false;
        if (refList == null) {
            if (!parseOnly && !arClass.isArray()) {
                throw new IllegalArgumentException("Initializer list for non-array type.");
            }
            refList = new ArrayList<Object>();
            toArray = true;
        }
        boolean refRequired = false;
        JavaDebug.checkHasNext(iter, "Token expected after '{'.");
        while (!JavaDebug.peekNext(iter).isType(TokenType.RBRACE)) {
            Reference ref;
            if (toArray && JavaDebug.peekNext(iter).isType(TokenType.LBRACE)) {
                iter.next();
                ref = this.getRefObjArray(iter, null, arClass.getComponentType(), parseOnly);
            } else {
                ref = this.getReference(iter, parseOnly);
            }
            if (!parseOnly) {
                refList.add(ref.getObj());
            }
            refRequired = false;
            if (!JavaDebug.peekNext(iter).isType(TokenType.COMMA)) continue;
            iter.next();
            refRequired = true;
        }
        iter.next();
        if (refRequired) {
            throw new ParseException("Reference expected after ','.", iter.previousIndex());
        }
        if (toArray) {
            Class<?> componentType = arClass.getComponentType();
            Object array = Array.newInstance(componentType, refList.size());
            int i = 0;
            for (Object ref : refList) {
                if (Byte.TYPE.equals(componentType)) {
                    Array.setByte(array, i++, (Byte)ref);
                    continue;
                }
                if (Character.TYPE.equals(componentType)) {
                    Array.setChar(array, i++, ((Character)ref).charValue());
                    continue;
                }
                if (Short.TYPE.equals(componentType)) {
                    Array.setShort(array, i++, (Short)ref);
                    continue;
                }
                if (Integer.TYPE.equals(componentType)) {
                    Array.setInt(array, i++, (Integer)ref);
                    continue;
                }
                if (Long.TYPE.equals(componentType)) {
                    Array.setLong(array, i++, (Long)ref);
                    continue;
                }
                if (Float.TYPE.equals(componentType)) {
                    Array.setFloat(array, i++, ((Float)ref).floatValue());
                    continue;
                }
                if (Double.TYPE.equals(componentType)) {
                    Array.setDouble(array, i++, (Double)ref);
                    continue;
                }
                Array.set(array, i++, ref);
            }
            return new Reference(array, null);
        }
        return new Reference(refList, null);
    }

    private Reference getConstructedObject(ListIterator<Token> iter, Class<?> clazz, boolean parseOnly) throws Exception {
        JavaDebug.checkNextToken(iter, TokenType.LPAREN, "Arg list expected after 'new <className>'.");
        ArrayList<Object> args = new ArrayList<Object>();
        boolean argRequired = false;
        while (iter.hasNext()) {
            if (JavaDebug.peekNext(iter).isType(TokenType.RPAREN)) {
                if (!argRequired) break;
                throw new ParseException("Syntax error in method argument list.", iter.previousIndex());
            }
            Reference arg = this.getReference(iter, parseOnly);
            args.add(arg.getObj());
            argRequired = false;
            if (!JavaDebug.peekNext(iter).isType(TokenType.COMMA)) continue;
            iter.next();
            argRequired = true;
        }
        JavaDebug.checkNextToken(iter, TokenType.RPAREN, "Missing ')' after constructor arguments.");
        if (parseOnly) {
            return this.nullReference;
        }
        Constructor<?> constructor = this.findConstructor(clazz, args);
        constructor.setAccessible(true);
        return new Reference(constructor.newInstance(this.prepareArgs(args, constructor.getParameterTypes().length, constructor.isVarArgs())), null);
    }

    private Method findClassMethod(Class<?> clazz, String name, List<Object> args) throws Exception {
        Method method = this.findMatchingMethod(clazz.getMethods(), name, args);
        if (method == null) {
            method = this.findMatchingMethod(clazz.getDeclaredMethods(), name, args);
        }
        if (method == null) {
            throw new NoSuchMethodException(name);
        }
        return method;
    }

    private Method findMatchingMethod(Method[] methods, String name, List<Object> args) {
        for (Method method : methods) {
            if (!method.getName().equals(name) || !this.typesMatch(method.getParameterTypes(), method.isVarArgs(), args)) continue;
            return method;
        }
        return null;
    }

    private Constructor<?> findConstructor(Class<?> clazz, List<Object> args) throws Exception {
        Constructor<?> constructor = this.findMatchingConstructor(clazz.getConstructors(), args);
        if (constructor == null) {
            constructor = this.findMatchingConstructor(clazz.getDeclaredConstructors(), args);
        }
        if (constructor == null) {
            throw new NoSuchMethodException(clazz.getName());
        }
        return constructor;
    }

    private Constructor<?> findMatchingConstructor(Constructor<?>[] constructors, List<Object> args) {
        for (Constructor<?> constructor : constructors) {
            if (!this.typesMatch(constructor.getParameterTypes(), constructor.isVarArgs(), args)) continue;
            return constructor;
        }
        return null;
    }

    private boolean typesMatch(Class<?>[] parameterTypes, boolean isVarArgs, List<Object> args) {
        if (isVarArgs ? parameterTypes.length > args.size() + 1 : parameterTypes.length != args.size()) {
            return false;
        }
        int i = 0;
        for (Class<?> paramType : parameterTypes) {
            if (isVarArgs && i == parameterTypes.length - 1) {
                if (i == args.size() - 1 && this.typeMatch(paramType, args.get(i))) {
                    return true;
                }
                while (i < args.size()) {
                    if (this.typeMatch(paramType.getComponentType(), args.get(i++))) continue;
                    return false;
                }
                continue;
            }
            if (this.typeMatch(paramType, args.get(i++))) continue;
            return false;
        }
        return true;
    }

    private boolean typeMatch(Class<?> paramType, Object arg) {
        if (paramType == null) {
            return false;
        }
        if (paramType.isPrimitive() && (paramType.equals(Byte.TYPE) && Byte.class.isInstance(arg) || paramType.equals(Character.TYPE) && Character.class.isInstance(arg) || paramType.equals(Integer.TYPE) && Integer.class.isInstance(arg) || paramType.equals(Long.TYPE) && Long.class.isInstance(arg) || paramType.equals(Short.TYPE) && Short.class.isInstance(arg) || paramType.equals(Float.TYPE) && Float.class.isInstance(arg) || paramType.equals(Double.TYPE) && Double.class.isInstance(arg) || paramType.equals(Boolean.TYPE) && Boolean.class.isInstance(arg))) {
            return true;
        }
        return arg == null || paramType.isInstance(arg);
    }

    private Reference getObjClass(Reference ref) throws Exception {
        return new Reference(ref.getObjClass(), ref.getObj());
    }

    private Field getObjField(String name, Reference ref) throws Exception {
        Field field;
        block5: {
            Class<?> clazz;
            field = null;
            try {
                field = clazz.getField(name);
            }
            catch (NoSuchFieldException e) {
                for (clazz = ref.getObjClass(); clazz != null; clazz = clazz.getSuperclass()) {
                    try {
                        field = clazz.getDeclaredField(name);
                        continue;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
                if (field != null) break block5;
                throw new NoSuchFieldException(name);
            }
        }
        field.setAccessible(true);
        return field;
    }

    private Reference getObjFieldValue(String name, Reference ref, boolean parseOnly) throws Exception {
        if (parseOnly) {
            return this.nullReference;
        }
        if ("length".equals(name) && ref.getObj() != null && ref.getObj().getClass().isArray()) {
            return new Reference(Array.getLength(ref.getObj()), ref.getObj());
        }
        Field field = this.getObjField(name, ref);
        return new Reference(field.get(ref.getObj()), ref.getObj() != null ? ref.getObj() : ref.getClazz(), null, field, null);
    }

    private Reference getMapRef(ListIterator<Token> iter, Reference ref, boolean parseOnly) throws Exception {
        if (ref.getObj() == null) {
            throw new NullPointerException("Illegal Map reference on null object.");
        }
        if (!(ref.getObj() instanceof Map)) {
            throw new IllegalStateException("Illegal Map reference on non-Map object.");
        }
        Reference key = this.getReference(iter, parseOnly);
        JavaDebug.checkNextToken(iter, TokenType.RBRACE, "Missing '}' after Map key.");
        if (parseOnly) {
            return this.nullReference;
        }
        Map map = (Map)ref.getObj();
        return new Reference(map.get(key.getObj()), map, key.getObj(), null, null);
    }

    private Reference getArrayListRef(ListIterator<Token> iter, Reference ref, boolean parseOnly) throws Exception {
        if (!parseOnly && ref.getObj() == null) {
            throw new NullPointerException("Array/List reference on object with null value.");
        }
        Reference key = this.getReference(iter, parseOnly);
        if (!parseOnly && !(key.getObj() instanceof Integer)) {
            throw new IllegalArgumentException("Array/List index must be type integer");
        }
        if (parseOnly) {
            ref = this.nullReference;
        } else if (ref.getObj().getClass().isArray()) {
            ref = new Reference(Array.get(ref.getObj(), (Integer)key.getObj()), ref.getObj(), key.getObj(), null, null);
        } else if (ref.getObj() instanceof List) {
            List list = (List)ref.getObj();
            ref = new Reference(list.get((Integer)key.getObj()), list, key.getObj(), null, null);
        } else {
            throw new IllegalStateException("Illegal Array reference on non-Array/List object.");
        }
        JavaDebug.checkNextToken(iter, TokenType.RBRACKET, "Missing ']' after Array/List specification.");
        return ref;
    }

    private Reference getToList(Reference ref, boolean parseOnly) throws Exception {
        ArrayList<Object> retList = new ArrayList<Object>();
        if (!parseOnly) {
            if (ref.getObj() == null) {
                throw new NullPointerException("null");
            }
            Class<?> clazz = ref.getObj().getClass();
            if (clazz.isArray()) {
                Class<?> componentType = clazz.getComponentType();
                if (Byte.TYPE.equals(componentType)) {
                    for (byte b : (byte[])ref.getObj()) {
                        retList.add(b);
                    }
                } else if (Character.TYPE.equals(componentType)) {
                    for (char c : (char[])ref.getObj()) {
                        retList.add(Character.valueOf(c));
                    }
                } else if (Short.TYPE.equals(componentType)) {
                    for (short s : (short[])ref.getObj()) {
                        retList.add(s);
                    }
                } else if (Integer.TYPE.equals(componentType)) {
                    for (int n : (int[])ref.getObj()) {
                        retList.add(n);
                    }
                } else if (Long.TYPE.equals(componentType)) {
                    for (long l : (long[])ref.getObj()) {
                        retList.add(l);
                    }
                } else if (Float.TYPE.equals(componentType)) {
                    for (float f : (float[])ref.getObj()) {
                        retList.add(Float.valueOf(f));
                    }
                } else if (Double.TYPE.equals(componentType)) {
                    for (double d : (double[])ref.getObj()) {
                        retList.add(d);
                    }
                } else {
                    for (Object o : (Object[])ref.getObj()) {
                        retList.add(o);
                    }
                }
            } else if (ref.getObj() instanceof Collection) {
                Collection collection = (Collection)ref.getObj();
                for (Object obj : collection) {
                    retList.add(obj);
                }
            } else if (ref.getObj() instanceof Iterator) {
                Iterator iter = (Iterator)ref.getObj();
                while (iter.hasNext()) {
                    retList.add(iter.next());
                }
            } else if (ref.getObj() instanceof ListIterator) {
                ListIterator iter = (ListIterator)ref.getObj();
                while (iter.hasNext()) {
                    retList.add(iter.next());
                }
            } else if (ref.getObj() instanceof Vector) {
                Iterator iter = ((Vector)ref.getObj()).iterator();
                while (iter.hasNext()) {
                    retList.add(iter.next());
                }
            } else if (ref.getObj() instanceof Enumeration) {
                Enumeration enumer = (Enumeration)ref.getObj();
                while (enumer.hasMoreElements()) {
                    retList.add(enumer.nextElement());
                }
            } else {
                retList.add(ref.getObj());
            }
        }
        return new Reference(retList, ref.getObj());
    }

    private Reference toFormattedString(Reference ref) {
        if (ref.getObj() == null) {
            return new Reference("null", null);
        }
        String refStr = ref.getObj().toString();
        int indent = 0;
        StringBuilder buf = new StringBuilder();
        boolean inQuote = false;
        int len = refStr.length();
        int col = 0;
        block6: for (int i = 0; i < len; ++i) {
            char c = refStr.charAt(i);
            switch (c) {
                case ',': 
                case '[': {
                    int j;
                    buf.append(c);
                    if (inQuote) continue block6;
                    if (i < len - 1) {
                        char nc = refStr.charAt(i + 1);
                        if (c == '[' && nc == ']') {
                            buf.append(nc);
                            ++i;
                            continue block6;
                        }
                        if (nc == ' ') {
                            ++i;
                        }
                    }
                    if (c == '[') {
                        ++indent;
                        j = refStr.indexOf(93, i + 1);
                        if (col + j - i < 80) continue block6;
                    }
                    buf.append('\n');
                    col = 0;
                    for (j = 0; j < indent; ++j) {
                        buf.append('\t');
                        col += 8;
                    }
                    continue block6;
                }
                case ']': {
                    buf.append(c);
                    ++col;
                    if (inQuote || indent <= 0) continue block6;
                    --indent;
                    continue block6;
                }
                case '\"': {
                    buf.append(c);
                    ++col;
                    inQuote = !inQuote;
                    continue block6;
                }
                case '\\': {
                    buf.append(c);
                    ++col;
                    c = refStr.charAt(++i);
                }
                default: {
                    ++col;
                    if (c == '\n') {
                        col = 0;
                    }
                    buf.append(c);
                }
            }
        }
        return new Reference(buf.toString(), ref.getObj());
    }

    private Class<?> findClassBySimpleName(String name) throws ClassNotFoundException {
        Class<?> clazz = this.classMap.get(name);
        if (clazz == null) {
            if (this.classMap.containsKey(name)) {
                throw new ClassNotFoundException(name);
            }
            try {
                clazz = this.classLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                this.classMap.put(name, null);
                throw e;
            }
            this.classMap.put(name, clazz);
        }
        return clazz;
    }

    private Class<?> getResultingType(Reference ref1, Reference ref2) {
        Object refObj1 = ref1.getObj();
        Object refObj2 = ref2.getObj();
        if (refObj1 == null || refObj2 == null) {
            return null;
        }
        if (Double.class.isInstance(refObj1) || Double.class.isInstance(refObj2)) {
            return Double.class;
        }
        if (Float.class.isInstance(refObj1) || Float.class.isInstance(refObj2)) {
            return Float.class;
        }
        if (Long.class.isInstance(refObj1) || Long.class.isInstance(refObj2)) {
            return Long.class;
        }
        if (Integer.class.isInstance(refObj1) || Integer.class.isInstance(refObj2)) {
            return Integer.class;
        }
        if (Short.class.isInstance(refObj1) || Short.class.isInstance(refObj2)) {
            return Short.class;
        }
        if (Character.class.isInstance(refObj1) || Character.class.isInstance(refObj2)) {
            return Character.class;
        }
        if (Byte.class.isInstance(refObj1) || Byte.class.isInstance(refObj2)) {
            return Byte.class;
        }
        return null;
    }

    private Class<?> getResultingType(Reference ref) {
        if (ref.getObj() == null) {
            return null;
        }
        return ref.getObj().getClass();
    }

    private Reference convertReferenceType(Class<?> type, Reference ref) throws Exception {
        if (ref.getObj() == null) {
            throw new NullPointerException("Cannot convert null to type.");
        }
        if (Double.class.equals(type)) {
            return new Reference(ref, (Object)new Double(ref.unboxToDouble()));
        }
        if (Float.class.equals(type)) {
            return new Reference(ref, (Object)new Float(ref.unboxToDouble()));
        }
        if (Byte.class.equals(type)) {
            return new Reference(ref, (Object)new Byte((byte)ref.unboxToLong()));
        }
        if (Character.class.equals(type)) {
            return new Reference(ref, (Object)new Character((char)ref.unboxToLong()));
        }
        if (Short.class.equals(type)) {
            return new Reference(ref, (Object)new Short((short)ref.unboxToLong()));
        }
        if (Integer.class.equals(type)) {
            return new Reference(ref, (Object)new Integer((int)ref.unboxToLong()));
        }
        if (Long.class.equals(type)) {
            return new Reference(ref, (Object)new Long(ref.unboxToLong()));
        }
        throw new Exception("Cannot convert numeric to type: " + type);
    }

    public List<Token> getTokens(String input) throws ParseException {
        ArrayList<Token> retList = new ArrayList<Token>();
        if (input == null) {
            input = "null";
        }
        int len = input.length();
        block59: for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '.': {
                    retList.add(new Token(TokenType.DOT));
                    continue block59;
                }
                case '(': {
                    retList.add(new Token(TokenType.LPAREN));
                    continue block59;
                }
                case ')': {
                    retList.add(new Token(TokenType.RPAREN));
                    continue block59;
                }
                case '[': {
                    retList.add(new Token(TokenType.LBRACKET));
                    continue block59;
                }
                case ']': {
                    retList.add(new Token(TokenType.RBRACKET));
                    continue block59;
                }
                case '{': {
                    retList.add(new Token(TokenType.LBRACE));
                    continue block59;
                }
                case '}': {
                    retList.add(new Token(TokenType.RBRACE));
                    continue block59;
                }
                case '$': {
                    retList.add(new Token(TokenType.DOLLAR));
                    continue block59;
                }
                case ',': {
                    retList.add(new Token(TokenType.COMMA));
                    continue block59;
                }
                case ':': {
                    retList.add(new Token(TokenType.COLON));
                    continue block59;
                }
                case '+': {
                    if (i < len - 1 && input.charAt(i + 1) == '+') {
                        ++i;
                        retList.add(new Token(TokenType.PLUS_PLUS));
                        continue block59;
                    }
                    retList.add(new Token(TokenType.PLUS));
                    continue block59;
                }
                case '-': {
                    if (i < len - 1 && input.charAt(i + 1) == '-') {
                        ++i;
                        retList.add(new Token(TokenType.MINUS_MINUS));
                        continue block59;
                    }
                    retList.add(new Token(TokenType.MINUS));
                    continue block59;
                }
                case '*': {
                    retList.add(new Token(TokenType.TIMES));
                    continue block59;
                }
                case '/': {
                    retList.add(new Token(TokenType.DIVIDE));
                    continue block59;
                }
                case '%': {
                    retList.add(new Token(TokenType.PERCENT));
                    continue block59;
                }
                case '?': {
                    retList.add(new Token(TokenType.QUESTION_MARK));
                    continue block59;
                }
                case '#': {
                    retList.add(new Token(TokenType.HASHTAG));
                    continue block59;
                }
                case '|': {
                    if (i < len - 1 && input.charAt(i + 1) == '|') {
                        ++i;
                        retList.add(new Token(TokenType.LOGICAL_OR));
                        continue block59;
                    }
                    retList.add(new Token(TokenType.BITWISE_OR));
                    continue block59;
                }
                case '&': {
                    if (i < len - 1 && input.charAt(i + 1) == '&') {
                        ++i;
                        retList.add(new Token(TokenType.LOGICAL_AND));
                        continue block59;
                    }
                    retList.add(new Token(TokenType.BITWISE_AND));
                    continue block59;
                }
                case '^': {
                    retList.add(new Token(TokenType.BITWISE_XOR));
                    continue block59;
                }
                case '~': {
                    retList.add(new Token(TokenType.BITWISE_NOT));
                    continue block59;
                }
                case '!': {
                    if (i < len - 1 && input.charAt(i + 1) == '=') {
                        ++i;
                        retList.add(new Token(TokenType.NOT_EQUALS));
                        continue block59;
                    }
                    retList.add(new Token(TokenType.LOGICAL_NOT));
                    continue block59;
                }
                case '>': {
                    if (i < len - 1 && input.charAt(i + 1) == '=') {
                        ++i;
                        retList.add(new Token(TokenType.GREATER_EQUAL));
                        continue block59;
                    }
                    if (i < len - 2 && input.charAt(i + 1) == '>' && input.charAt(i + 2) == '>') {
                        i += 2;
                        retList.add(new Token(TokenType.SHIFT_RIGHT_UNSIGNED));
                        continue block59;
                    }
                    if (i < len - 1 && input.charAt(i + 1) == '>') {
                        ++i;
                        retList.add(new Token(TokenType.SHIFT_RIGHT_SIGNED));
                        continue block59;
                    }
                    retList.add(new Token(TokenType.GREATER));
                    continue block59;
                }
                case '<': {
                    if (i < len - 1 && input.charAt(i + 1) == '=') {
                        ++i;
                        retList.add(new Token(TokenType.LESS_EQUAL));
                        continue block59;
                    }
                    if (i < len - 1 && input.charAt(i + 1) == '<') {
                        ++i;
                        retList.add(new Token(TokenType.SHIFT_LEFT));
                        continue block59;
                    }
                    retList.add(new Token(TokenType.LESS));
                    continue block59;
                }
                case '=': {
                    if (i < len - 1 && input.charAt(i + 1) == '=') {
                        ++i;
                        retList.add(new Token(TokenType.EQUAL_EQUAL));
                        continue block59;
                    }
                    retList.add(new Token(TokenType.EQUALS));
                    continue block59;
                }
                case ' ': {
                    continue block59;
                }
                case '\"': 
                case '\'': {
                    char quoteChar = c;
                    StringBuilder buf = new StringBuilder();
                    boolean endQuote = false;
                    while (++i < len) {
                        c = input.charAt(i);
                        if (c == quoteChar) {
                            retList.add(new Token(TokenType.STRING_CONST, buf.toString()));
                            endQuote = true;
                            break;
                        }
                        if (c == '\\' && i < len - 1) {
                            c = JavaDebug.getEscapedChar(input.charAt(++i));
                        }
                        buf.append(c);
                    }
                    if (endQuote) continue block59;
                    throw new ParseException("Unterminated quoted string in input.", 0);
                }
                default: {
                    StringBuilder buf = new StringBuilder();
                    if (JavaDebug.isNumeric(c)) {
                        int radix = 10;
                        if (c == '0' && i < len - 1 && (input.charAt(i + 1) == 'x' || input.charAt(i + 1) == 'X')) {
                            ++i;
                            radix = 16;
                        } else {
                            buf.append(c);
                        }
                        while (i < len - 1 && (radix == 10 && JavaDebug.isNumericOrDecimal(c = input.charAt(i + 1)) || radix == 16 && JavaDebug.isHex(c = input.charAt(i + 1)))) {
                            buf.append(c);
                            ++i;
                        }
                        if (i < len - 1 && (c == 'l' || c == 'L')) {
                            ++i;
                            retList.add(JavaDebug.toLongToken(buf.toString(), radix));
                            continue block59;
                        }
                        if (radix == 10 && i < len - 1 && (c == 'f' || c == 'F')) {
                            ++i;
                            retList.add(JavaDebug.toFloatToken(buf.toString()));
                            continue block59;
                        }
                        if (radix == 10 && i < len - 1 && (c == 'd' || c == 'D')) {
                            ++i;
                            retList.add(JavaDebug.toDoubleToken(buf.toString()));
                            continue block59;
                        }
                        retList.add(JavaDebug.toIntToken(buf.toString(), radix));
                        continue block59;
                    }
                    if (c == '\\' || JavaDebug.isIdentChar(c)) {
                        if (c == '\\' && i < len - 1) {
                            c = JavaDebug.getEscapedChar(input.charAt(++i));
                        }
                        buf.append(c);
                        while (i < len - 1 && (JavaDebug.isIdentChar(c = input.charAt(i + 1)) || c == '\\')) {
                            if (c == '\\' && i < len - 2) {
                                c = JavaDebug.getEscapedChar(input.charAt(i + 2));
                                ++i;
                            }
                            buf.append(c);
                            ++i;
                        }
                        switch (buf.toString()) {
                            case "new": {
                                retList.add(new Token(TokenType.NEW));
                                continue block59;
                            }
                            case "null": {
                                retList.add(new Token(TokenType.NULL));
                                continue block59;
                            }
                            case "false": {
                                retList.add(new Token(TokenType.BOOLEAN_CONST, Boolean.FALSE));
                                continue block59;
                            }
                            case "true": {
                                retList.add(new Token(TokenType.BOOLEAN_CONST, Boolean.TRUE));
                                continue block59;
                            }
                            case "class": {
                                retList.add(new Token(TokenType.CLASS));
                                continue block59;
                            }
                            case "boolean": {
                                retList.add(new Token(TokenType.BOOLEAN));
                                continue block59;
                            }
                            case "byte": {
                                retList.add(new Token(TokenType.BYTE));
                                continue block59;
                            }
                            case "char": {
                                retList.add(new Token(TokenType.CHAR));
                                continue block59;
                            }
                            case "short": {
                                retList.add(new Token(TokenType.SHORT));
                                continue block59;
                            }
                            case "int": {
                                retList.add(new Token(TokenType.INT));
                                continue block59;
                            }
                            case "long": {
                                retList.add(new Token(TokenType.LONG));
                                continue block59;
                            }
                            case "float": {
                                retList.add(new Token(TokenType.FLOAT));
                                continue block59;
                            }
                            case "double": {
                                retList.add(new Token(TokenType.DOUBLE));
                                continue block59;
                            }
                        }
                        retList.add(new Token(TokenType.IDENT, buf.toString()));
                        continue block59;
                    }
                    throw new ParseException("Unexpected character in input: '" + c + "'.", 0);
                }
            }
        }
        return retList;
    }

    private static char getEscapedChar(char c) {
        switch (c) {
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 's': {
                return ' ';
            }
        }
        return c;
    }

    private static boolean isNumeric(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isNumericOrDecimal(char c) {
        return c == '.' || JavaDebug.isNumeric(c);
    }

    private static boolean isHex(char c) {
        return JavaDebug.isNumeric(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static boolean isIdentChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '$';
    }

    private static Token toIntToken(String s, int radix) throws NumberFormatException {
        return new Token(TokenType.INT_CONST, Integer.parseInt(s, radix));
    }

    private static Token toLongToken(String s, int radix) throws NumberFormatException {
        return new Token(TokenType.LONG_CONST, Long.parseLong(s, radix));
    }

    private static Token toFloatToken(String s) throws NumberFormatException {
        return new Token(TokenType.FLOAT_CONST, Float.valueOf(Float.parseFloat(s)));
    }

    private static Token toDoubleToken(String s) throws NumberFormatException {
        return new Token(TokenType.DOUBLE_CONST, Double.parseDouble(s));
    }

    private static Token peekNext(ListIterator<Token> iter) {
        if (iter.hasNext()) {
            Token token = iter.next();
            iter.previous();
            return token;
        }
        return new Token(TokenType.END);
    }

    private Object getObjectFromToken(Token token) throws ParseException {
        switch (token.getType()) {
            case NULL: {
                return null;
            }
            case BOOLEAN_CONST: {
                return (Boolean)token.getValue();
            }
            case LONG_CONST: {
                return (Long)token.getValue();
            }
            case INT_CONST: {
                return (Integer)token.getValue();
            }
            case FLOAT_CONST: {
                return (Float)token.getValue();
            }
            case DOUBLE_CONST: {
                return (Double)token.getValue();
            }
            case STRING_CONST: {
                return token.getStringValue();
            }
        }
        throw new ParseException("Value expected.", 0);
    }

    protected static void checkHasNext(ListIterator<Token> iter, String message) throws ParseException {
        if (!iter.hasNext()) {
            throw new ParseException(message, iter.previousIndex());
        }
    }

    protected static Token checkNextToken(ListIterator<Token> iter, TokenType tokenType, String message) throws ParseException {
        Token token;
        if (!iter.hasNext() || !(token = iter.next()).isType(tokenType)) {
            throw new ParseException(message, iter.previousIndex());
        }
        return token;
    }

    protected static void checkForExtraTokens(ListIterator<Token> iter, String item) throws ParseException {
        if (iter.hasNext()) {
            throw new ParseException("Extra token(s) in " + item + ": " + iter.next(), iter.previousIndex());
        }
    }

    private static class Reference {
        private final Class<?> clazz;
        private final Object obj;
        private final Object parent;
        private final Object keyOrIndex;
        private final Field field;
        private final Method method;
        private final String varName;

        public Reference(Class<?> clazz, Object obj, Object parent, Object keyOrIndex, Field field, Method method, String varName) {
            this.clazz = clazz;
            this.obj = obj;
            this.parent = parent;
            this.keyOrIndex = keyOrIndex;
            this.field = field;
            this.method = method;
            this.varName = varName;
        }

        public Reference(Object obj, Object parent, Object keyOrIndex, Field field, Method method, String varName) {
            this(null, obj, parent, keyOrIndex, field, method, varName);
        }

        public Reference(Object obj, Object parent, Object keyOrIndex, Field field, Method method) {
            this(null, obj, parent, keyOrIndex, field, method, null);
        }

        public Reference(Object obj, Object parent) {
            this(null, obj, parent, null, null, null, null);
        }

        public Reference(Class<?> clazz) {
            this(clazz, null, null, null, null, null, null);
        }

        public Reference(Reference ref, Object obj) {
            this(ref.clazz, obj, ref.parent, ref.keyOrIndex, ref.field, ref.method, ref.varName);
        }

        public Reference() {
            this(null, null, null, null, null);
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public Object getObj() {
            return this.obj;
        }

        public Class<?> getObjClass() throws NullPointerException {
            if (this.obj != null) {
                return this.obj.getClass();
            }
            if (this.clazz != null) {
                return this.clazz;
            }
            throw new NullPointerException("Null class.");
        }

        public Object getParent() {
            return this.parent;
        }

        public Field getField() {
            return this.field;
        }

        public Object getKeyOrIndex() {
            return this.keyOrIndex;
        }

        public Method getMethod() {
            return this.method;
        }

        public String getVarName() {
            return this.varName;
        }

        public boolean canUnboxToNumeric() {
            return this.obj != null && (Long.class.isInstance(this.obj) || Integer.class.isInstance(this.obj) || Short.class.isInstance(this.obj) || Character.class.isInstance(this.obj) || Byte.class.isInstance(this.obj) || Float.class.isInstance(this.obj) || Double.class.isInstance(this.obj));
        }

        public boolean isString() {
            return this.obj != null && String.class.isInstance(this.obj);
        }

        public boolean isFloatOrDouble() {
            return this.obj != null && (Float.class.isInstance(this.obj) || Double.class.isInstance(this.obj));
        }

        public long unboxToLong() throws IllegalArgumentException {
            if (Long.class.isInstance(this.obj)) {
                return (Long)this.obj;
            }
            if (Integer.class.isInstance(this.obj)) {
                return ((Integer)this.obj).longValue();
            }
            if (Short.class.isInstance(this.obj)) {
                return ((Short)this.obj).longValue();
            }
            if (Character.class.isInstance(this.obj)) {
                return ((Character)this.obj).charValue();
            }
            if (Byte.class.isInstance(this.obj)) {
                return ((Byte)this.obj).longValue();
            }
            if (Float.class.isInstance(this.obj)) {
                return ((Float)this.obj).longValue();
            }
            if (Double.class.isInstance(this.obj)) {
                return ((Double)this.obj).longValue();
            }
            throw new IllegalArgumentException("Cannot unbox to long.");
        }

        public double unboxToDouble() throws IllegalArgumentException {
            if (Long.class.isInstance(this.obj)) {
                return ((Long)this.obj).doubleValue();
            }
            if (Integer.class.isInstance(this.obj)) {
                return ((Integer)this.obj).doubleValue();
            }
            if (Short.class.isInstance(this.obj)) {
                return ((Short)this.obj).doubleValue();
            }
            if (Character.class.isInstance(this.obj)) {
                return ((Character)this.obj).charValue();
            }
            if (Byte.class.isInstance(this.obj)) {
                return ((Byte)this.obj).doubleValue();
            }
            if (Float.class.isInstance(this.obj)) {
                return ((Float)this.obj).doubleValue();
            }
            if (Double.class.isInstance(this.obj)) {
                return (Double)this.obj;
            }
            throw new IllegalArgumentException("Cannot unbox to double.");
        }

        public String toString() {
            return "Reference[clazz=" + this.clazz + ", obj=" + this.obj + ", parent=" + this.parent + ", keyOrIndex=" + this.keyOrIndex + ", field=" + this.field + ", method=" + this.method + ", varName=" + this.varName + "]";
        }
    }

    public static class Token {
        private final TokenType type;
        private final Object value;

        public Token(TokenType type) {
            this.type = type;
            this.value = null;
        }

        public Token(TokenType type, Object value) {
            this.type = type;
            this.value = value;
        }

        public TokenType getType() {
            return this.type;
        }

        public boolean isType(TokenType type) {
            return this.type == type;
        }

        public Object getValue() {
            return this.value;
        }

        public String getStringValue() {
            return (String)this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Token other = (Token)obj;
            if (this.type != other.type) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return (Object)((Object)this.type) + (this.value != null ? "[" + this.value + "]" : "");
        }
    }

    public static enum TokenType {
        IDENT,
        STRING_CONST,
        INT_CONST,
        LONG_CONST,
        FLOAT_CONST,
        DOUBLE_CONST,
        NULL,
        BOOLEAN_CONST,
        CLASS,
        NEW,
        BOOLEAN,
        BYTE,
        CHAR,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        DOT,
        COLON,
        SPACE,
        COMMA,
        DOLLAR,
        LPAREN,
        RPAREN,
        LBRACKET,
        RBRACKET,
        LBRACE,
        RBRACE,
        EQUALS,
        EQUAL_EQUAL,
        NOT_EQUALS,
        GREATER,
        GREATER_EQUAL,
        LESS,
        LESS_EQUAL,
        PLUS,
        PLUS_PLUS,
        MINUS,
        MINUS_MINUS,
        TIMES,
        DIVIDE,
        PERCENT,
        QUESTION_MARK,
        HASHTAG,
        BITWISE_NOT,
        BITWISE_OR,
        BITWISE_AND,
        BITWISE_XOR,
        LOGICAL_NOT,
        LOGICAL_OR,
        LOGICAL_AND,
        SHIFT_LEFT,
        SHIFT_RIGHT_SIGNED,
        SHIFT_RIGHT_UNSIGNED,
        END;

    }
}

