/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.trustmgmt;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.trustmgmt.RevocationInfoImpl;
import com.avaya.asm.trustmgmt.RevocationInfoUtilities;
import com.avaya.common.logging.client.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class RevocationInfoFileImpl
extends RevocationInfoImpl {
    private static final Logger log = AsmLogger.getLogger(RevocationInfoFileImpl.class);
    public static final String PROPERTY_REVOCATION_CHECK_METHOD = "CHECK_METHOD";
    public static final String PROPERTY_REVOCATION_VALIDATION = "REVOC_VALIDATION";
    public static final String PROPERTY_REVOCATION_TYPE = "REVOC_TYPE";
    public static final String PROPERTY_REVOCATION_TYPE_PREFERENCE = "TYPE_PREFERENCE";
    private final RevocationInfoUtilities revocationInfoUtilities = RevocationInfoUtilities.getInstance();
    private final String revocationPropertiesFile = this.revocationInfoUtilities.getRevocationPropertiesFile();

    public RevocationInfoFileImpl() {
        this.loadRevocationProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadRevocationProperties() {
        String functionName = "loadRevocationProperties";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (this.revocationPropertiesFile != null) {
            FileInputStream fileInputStream = null;
            try {
                File revFile = new File(this.revocationPropertiesFile);
                if (!revFile.exists()) {
                    log.info((Object)("loadRevocationProperties: Using Default Revocation Options. revocationPropertiesFile does not exist (" + this.revocationPropertiesFile + ")"));
                }
                fileInputStream = new FileInputStream(this.revocationPropertiesFile);
                if (isFinerEnabled) {
                    log.finer((Object)("loadRevocationProperties: Loading. revocationPropertiesFile=" + this.revocationPropertiesFile));
                }
                Properties revocationProperties = new Properties();
                revocationProperties.load(fileInputStream);
                this.setRevocationOptions(revocationProperties);
            }
            catch (FileNotFoundException e) {
                log.error((Object)("loadRevocationProperties: File not found.  revocationPropertiesFile=" + this.revocationPropertiesFile));
            }
            catch (IOException e) {
                log.error((Object)("loadRevocationProperties: Error reading file. revocationPropertiesFile=" + this.revocationPropertiesFile));
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        log.error((Object)("loadRevocationProperties: Unable to close. revocationPropertiesFile=" + this.revocationPropertiesFile));
                    }
                }
            }
        } else if (isFinerEnabled) {
            log.finer((Object)"loadRevocationProperties: System property revocation.properties.file not set, using defaults");
        }
        if (isFinerEnabled) {
            log.finer((Object)("loadRevocationProperties: leaving. revocationInfo=" + super.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void saveRevocationOptionsToFile() {
        String functionName = "saveRevocationOptionsToFile";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (this.revocationPropertiesFile != null) {
            FileOutputStream fileOutputStream = null;
            try {
                Properties revocationProperties = this.getRevocationProperties();
                fileOutputStream = new FileOutputStream(this.revocationPropertiesFile);
                revocationProperties.store(fileOutputStream, " Certificate Revocation Properties (This file is autogenerated by TM Agent)");
                if (!isFinerEnabled) return;
                log.finer((Object)("saveRevocationOptionsToFile: revocationPropertiesFile=" + this.revocationPropertiesFile + ", revocationProperties=" + revocationProperties));
                return;
            }
            catch (FileNotFoundException e) {
                log.error((Object)("saveRevocationOptionsToFile: File not found. revocationPropertiesFile=" + this.revocationPropertiesFile), (Throwable)e);
                return;
            }
            catch (IOException e) {
                log.error((Object)("saveRevocationOptionsToFile: Error writing file. revocationPropertiesFile=" + this.revocationPropertiesFile), (Throwable)e);
                return;
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                        File revFile = new File(this.revocationPropertiesFile);
                        if (!revFile.setReadable(true, false)) {
                            log.error((Object)("saveRevocationOptionsToFile: Failed to set read permissions. revocationPropertiesFile=" + this.revocationPropertiesFile));
                        }
                    }
                    catch (IOException e) {
                        log.error((Object)("saveRevocationOptionsToFile: Unable to close. revocationPropertiesFile=" + this.revocationPropertiesFile), (Throwable)e);
                    }
                }
            }
        }
        if (!isFinerEnabled) return;
        log.finer((Object)"saveRevocationOptionsToFile: revocation.properties.file not saved");
    }

    private synchronized void setRevocationOptions(Properties revocationProperties) {
        String functionName = "setRevocationProperties";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)("setRevocationProperties: revocationProperties=" + revocationProperties));
        }
        this.revocationOptions.setRevocationValidation(revocationProperties.getProperty(PROPERTY_REVOCATION_VALIDATION, "NONE"));
        this.revocationOptions.setRevocationType(revocationProperties.getProperty(PROPERTY_REVOCATION_TYPE, "CRL"));
        this.revocationOptions.setRevocationTypePreference(revocationProperties.getProperty(PROPERTY_REVOCATION_TYPE_PREFERENCE, "CRL"));
        this.revocationOptions.setRevocationCheckMethod(revocationProperties.getProperty(PROPERTY_REVOCATION_CHECK_METHOD, "ONLY_END_ENTITY"));
    }

    private synchronized Properties getRevocationProperties() {
        String revocationValidation = this.revocationOptions.getRevocationValidation();
        String revocationType = this.revocationOptions.getRevocationType();
        String revocationTypePreference = this.revocationOptions.getRevocationTypePreference();
        String revocationCheckMethod = this.revocationOptions.getRevocationCheckMethod();
        if (revocationValidation == null) {
            revocationValidation = "NONE";
        }
        if (revocationType == null) {
            revocationType = "CRL";
        }
        if (revocationTypePreference == null) {
            revocationTypePreference = "CRL";
        }
        if (revocationCheckMethod == null) {
            revocationCheckMethod = "ONLY_END_ENTITY";
        }
        Properties result = new Properties();
        result.setProperty(PROPERTY_REVOCATION_VALIDATION, revocationValidation);
        result.setProperty(PROPERTY_REVOCATION_TYPE, revocationType);
        result.setProperty(PROPERTY_REVOCATION_TYPE_PREFERENCE, revocationTypePreference);
        result.setProperty(PROPERTY_REVOCATION_CHECK_METHOD, revocationCheckMethod);
        return result;
    }
}

