/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ustore;

import com.avaya.asm.core.AsmLogger;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.CassandraClientProperties;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class CassandraSSLOptions {
    private SSLContext sslContext = null;
    private final Logger log = AsmLogger.getLogger(this.getClass());
    public static final String[] DEFAULT_CASSANDRA_TLS12_CIPHER_SUITES = new String[]{"TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA"};
    public static final String[] DEFAULT_CASSANDRA_TLS13_CIPHER_SUITES = CassandraSSLOptions.concatArrays(new String[]{"TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384", "TLS_CHACHA20_POLY1305_SHA256", "TLS_AES_128_CCM_8_SHA256", "TLS_AES_128_CCM_SHA256"}, DEFAULT_CASSANDRA_TLS12_CIPHER_SUITES);
    private String[] cipherSuites = null;
    private final String[] cipherPrefixes = new String[]{"SSL_", "TLS_"};
    private final String[] EMPTY_STRING_ARRAY = new String[0];

    public CassandraSSLOptions(SSLContext sslContext, String[] cipherSuites) {
        this.sslContext = sslContext;
        this.cipherSuites = cipherSuites;
    }

    public CassandraSSLOptions(SSLContext sslContext) {
        this.sslContext = sslContext;
        this.setCiphers();
    }

    private void setCiphers() {
        String fcn_name = "setCiphers";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"setCiphers: enter");
        }
        Object[] requestedCiphers = null;
        CassandraClientProperties ccp = CassandraClientProperties.getInstance();
        if (ccp == null) {
            this.log.error((Object)"setCiphers: CassandraClientProperties.getInstance() returned null");
        } else {
            requestedCiphers = ccp.getCipherSuite();
            if (requestedCiphers != null) {
                this.log.info((Object)("setCiphers: loaded requested cipher suites " + Arrays.toString(requestedCiphers)));
            }
        }
        this.cipherSuites = this.buildCipherSuites((String[])requestedCiphers);
        this.log.info((Object)("setCiphers: using the following ciphers " + Arrays.toString(this.cipherSuites)));
        if (isFiner) {
            this.log.finer((Object)"setCiphers: leave");
        }
    }

    private String[] buildCipherSuites(String[] requestedCiphers) {
        String fcn_name = "buildCipherSuites";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        Object[] ciphers = null;
        if (isFiner) {
            this.log.finer((Object)("buildCipherSuites: enter, requestedCiphers=" + requestedCiphers));
        }
        if (requestedCiphers == null) {
            ciphers = this.buildCipherSuitesFromProtocol(this.sslContext.getProtocol());
            this.log.info((Object)("buildCipherSuites: caller didn't specify ciphers so using default ciphers " + Arrays.toString(ciphers)));
        } else {
            ciphers = requestedCiphers;
        }
        SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        Object[] enabledCiphers = factory.getDefaultCipherSuites();
        ArrayList<Object> finalCiphersList = new ArrayList<Object>(ciphers.length);
        if (isFinest) {
            this.log.finest((Object)("buildCipherSuites: factory.supportedCiphers=" + Arrays.toString(factory.getSupportedCipherSuites())));
            this.log.finest((Object)("buildCipherSuites: factory.defaultCiphers=" + Arrays.toString(enabledCiphers)));
        }
        for (Object cipher : ciphers) {
            if (!this.cipherContains((String[])enabledCiphers, (String)cipher)) {
                this.log.info((Object)("buildCipherSuites: requested cipher " + (String)cipher + " is not supported by system and will be ignored."));
                continue;
            }
            finalCiphersList.add(cipher);
            if (!isFinest) continue;
            this.log.finest((Object)("buildCipherSuites: adding supported cipher " + (String)cipher));
        }
        if (isFiner) {
            this.log.finer((Object)("buildCipherSuites: leave, returning " + finalCiphersList));
        }
        String[] finalCiphers = new String[finalCiphersList.size()];
        return finalCiphersList.toArray(finalCiphers);
    }

    private final String[] buildCipherSuitesFromProtocol(String tlsProtocol) {
        String fcn_name = "buildCipherSuitesFromProtocol";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        Object[] ciphers = this.EMPTY_STRING_ARRAY;
        if (isFiner) {
            this.log.finer((Object)("buildCipherSuitesFromProtocol: enter, tlsProtocol=" + tlsProtocol));
        }
        if ("TLSv1.2".equals(tlsProtocol)) {
            ciphers = DEFAULT_CASSANDRA_TLS12_CIPHER_SUITES;
            if (isFinest) {
                this.log.finest((Object)"buildCipherSuitesFromProtocol: TLSv1.2 is specified so use its default ciphers");
            }
        } else if ("TLSv1.3".equals(tlsProtocol)) {
            ciphers = DEFAULT_CASSANDRA_TLS13_CIPHER_SUITES;
            if (isFinest) {
                this.log.finest((Object)"buildCipherSuitesFromProtocol: TLSv1.3 is specified so use its default ciphers");
            }
        } else {
            ciphers = DEFAULT_CASSANDRA_TLS12_CIPHER_SUITES;
            if (isFinest) {
                this.log.finest((Object)"buildCipherSuitesFromProtocol: less secure or unknown protocol specified so use default TLSv1.2 ciphers");
            }
        }
        if (isFiner) {
            this.log.finer((Object)("buildCipherSuitesFromProtocol: leave, returning " + Arrays.toString(ciphers)));
        }
        return ciphers;
    }

    private boolean cipherContains(String[] ciphers, String searchCipher) {
        for (String cipher : ciphers) {
            if (!this.equalCipher(cipher, searchCipher)) continue;
            return true;
        }
        return false;
    }

    private boolean equalCipher(String cipher1, String cipher2) {
        return this.cipherName(cipher1).equals(this.cipherName(cipher2));
    }

    private Object cipherName(String cipher) {
        String cipherBase = cipher;
        for (String pfx : this.cipherPrefixes) {
            if (!cipher.startsWith(pfx)) continue;
            cipherBase = cipher.substring(pfx.length());
            break;
        }
        return cipherBase;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public String[] getCipherSuites() {
        return this.cipherSuites;
    }

    private static String[] concatArrays(String[] arr1, String[] arr2) {
        String[] newArr = new String[arr1.length + arr2.length];
        int i = 0;
        for (String s : arr1) {
            newArr[i++] = s;
        }
        for (String s : arr2) {
            newArr[i++] = s;
        }
        return newArr;
    }

    public String toString() {
        return "UStoreDAOSSLOptions [sslContext=" + this.sslContext + ", cipherSuites=" + Arrays.toString(this.cipherSuites) + "]";
    }
}

