/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ustore.objectapi;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NetworkTopologyInfo {
    private String keyspaceName;
    private int replicationFactor;
    private int unassignedRF;
    private Pattern ksNamePattern;

    public NetworkTopologyInfo(String keyspaceName, int replicationFactor, int unassignedRF) {
        this.keyspaceName = keyspaceName;
        this.replicationFactor = replicationFactor;
        this.unassignedRF = unassignedRF;
        this.ksNamePattern = Pattern.compile(keyspaceName, 2);
    }

    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    public void setKeyspaceName(String keyspaceName) {
        this.keyspaceName = keyspaceName;
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public void setReplicationFactor(int replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public int getUnassignedRF() {
        return this.unassignedRF;
    }

    public void setUnassignedRF(int unassignedRF) {
        this.unassignedRF = unassignedRF;
    }

    public Matcher getMatcher(String ksName) {
        return this.ksNamePattern.matcher(ksName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keyspaceName == null ? 0 : this.keyspaceName.hashCode());
        result = 31 * result + this.replicationFactor;
        result = 31 * result + this.unassignedRF;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkTopologyInfo other = (NetworkTopologyInfo)obj;
        if (this.keyspaceName == null ? other.keyspaceName != null : !this.keyspaceName.equals(other.keyspaceName)) {
            return false;
        }
        if (this.replicationFactor != other.replicationFactor) {
            return false;
        }
        return this.unassignedRF == other.unassignedRF;
    }

    public String toString() {
        return "NetworkTopologyInfo [keyspaceName=" + this.keyspaceName + ", replicationFactor=" + this.replicationFactor + ", unassignedRF=" + this.unassignedRF + "]";
    }
}

