/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.BlockRevQueue;
import org.eclipse.jgit.revwalk.DepthWalk;
import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;

class DepthGenerator
extends Generator {
    private final FIFORevQueue pending = new FIFORevQueue();
    private final int depth;
    private final int deepenSince;
    private final RevWalk walk;
    private final RevFlag UNSHALLOW;
    private final RevFlag REINTERESTING;

    DepthGenerator(DepthWalk w, Generator s) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit c;
        this.walk = (RevWalk)((Object)w);
        this.depth = w.getDepth();
        this.deepenSince = w.getDeepenSince();
        this.UNSHALLOW = w.getUnshallowFlag();
        this.REINTERESTING = w.getReinterestingFlag();
        s.shareFreeList(this.pending);
        while ((c = s.next()) != null) {
            if (((DepthWalk.Commit)c).getDepth() != 0) continue;
            this.pending.add(c);
        }
    }

    @Override
    int outputType() {
        return this.pending.outputType() | 0x10;
    }

    @Override
    void shareFreeList(BlockRevQueue q) {
        this.pending.shareFreeList(q);
    }

    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        DepthWalk.Commit c;
        boolean produce;
        do {
            if ((c = (DepthWalk.Commit)this.pending.next()) == null) {
                return null;
            }
            if ((c.flags & 1) == 0) {
                c.parseHeaders(this.walk);
            }
            int newDepth = c.depth + 1;
            RevCommit[] revCommitArray = c.parents;
            int n = c.parents.length;
            int n2 = 0;
            while (n2 < n) {
                RevCommit p = revCommitArray[n2];
                DepthWalk.Commit dp = (DepthWalk.Commit)p;
                if (dp.depth == -1) {
                    boolean failsDeepenSince = false;
                    if (this.deepenSince != 0) {
                        if ((p.flags & 1) == 0) {
                            p.parseHeaders(this.walk);
                        }
                        failsDeepenSince = p.getCommitTime() < this.deepenSince;
                    }
                    dp.depth = newDepth;
                    if (newDepth <= this.depth && !failsDeepenSince) {
                        this.pending.add(p);
                    } else {
                        c.isBoundary = true;
                    }
                }
                if (c.has(this.UNSHALLOW) || c.has(this.REINTERESTING)) {
                    p.add(this.REINTERESTING);
                    p.flags &= 0xFFFFFFFB;
                }
                ++n2;
            }
            produce = true;
            if ((c.flags & 4) == 0 || c.has(this.UNSHALLOW)) continue;
            produce = false;
        } while (!produce);
        return c;
    }
}

