/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dal.api.objectapi;

import com.avaya.zephyr.platform.dal.api.objectapi.ReliableEventingBroker;
import com.avaya.zephyr.platform.dal.api.objectapi.ReliableEventingCluster;
import java.util.ArrayList;
import java.util.List;

public class ReliableEventingGroup {
    private Long id;
    private String name;
    private String description;
    private String reliabilityType;
    private Boolean isEnabled;
    public static final String STANDALONE = "standalone";
    public static final String HA = "ha";
    private List<ReliableEventingCluster> participatingClusters;
    private List<ReliableEventingBroker> brokers;

    public ReliableEventingGroup(long id, String name, String description, String reliabilityType, Boolean isEnabled) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.reliabilityType = reliabilityType;
        this.isEnabled = isEnabled;
    }

    public final Long getId() {
        return this.id;
    }

    public final void setId(Long id) {
        this.id = id;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getReliabilityType() {
        return this.reliabilityType;
    }

    public final Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public final List<ReliableEventingCluster> getParticipatingClusters() {
        if (this.participatingClusters == null) {
            this.participatingClusters = new ArrayList<ReliableEventingCluster>();
        }
        return this.participatingClusters;
    }

    public final void setParticipatingClusters(List<ReliableEventingCluster> participatingClusters) {
        this.participatingClusters = participatingClusters;
    }

    public final List<ReliableEventingBroker> getBrokers() {
        if (this.brokers == null) {
            this.brokers = new ArrayList<ReliableEventingBroker>();
        }
        return this.brokers;
    }

    public final void setBrokers(List<ReliableEventingBroker> brokers) {
        this.brokers = brokers;
    }

    public final boolean isStandalone() {
        return STANDALONE.equals(this.reliabilityType.toLowerCase());
    }

    public final boolean isHa() {
        return HA.equals(this.reliabilityType.toLowerCase());
    }
}

