/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.AusServicePortsData;
import com.avaya.zephyr.platform.dao.AusInstanceDAO;
import com.avaya.zephyr.platform.dm.AbstractDMListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class AusServicePortsDataDAO
extends DataAccessObject {
    private static final Logger LOGGER = AsmLogger.getLogger(AusServicePortsDataDAO.class);
    protected static final String SERVICE_PORTS = "zr_port";
    protected static final String SERVICE_VERSION = "zr_service_version";
    protected static final String PORT_TYPE_RESERVED = "reserved";
    protected static final String PORT_TYPE_SNAPIN = "snapin";
    protected static final String GET_SERVICEPORTSDATA_QUERY = "SELECT ports.id, ports.cluster_id, service.service_name,version.version_string, version.archive_name,ports.name, ports.number, ports.default_number, ports.protocol FROM ZR_PORT ports, ZR_SERVICE_VERSION version, ZR_SERVICE service WHERE ports.service_version_id = version.id and version.service_id = service.id and ports.port_type = 'snapin'";
    protected static final String GET_SERVICEPORTSDATA_QUERY_BY_ID = "SELECT ports.id, ports.cluster_id, service.service_name,version.version_string, version.archive_name,ports.name, ports.number, ports.default_number, ports.protocol FROM ZR_PORT ports, ZR_SERVICE_VERSION version, ZR_SERVICE service WHERE ports.service_version_id = version.id and version.service_id = service.id and ports.port_type = 'snapin' and ports.id = ?";
    protected static final List<DMListener> LISTENERS = new CopyOnWriteArrayList<DMListener>();
    private Map<Long, AusServicePortsData> servicePortsDataMap;

    public AusServicePortsDataDAO() {
        super(true);
    }

    public final void init() {
        Map servicePortsDataMapTmp;
        if (LOGGER.isFinerEnabled()) {
            LOGGER.finer((Object)"init ENTER");
        }
        try {
            servicePortsDataMapTmp = (Map)this.dataSource.executeQuery(GET_SERVICEPORTSDATA_QUERY, new Object[0], (Object)this.getServicePortsDataMapper());
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            LOGGER.error((Object)"init Error initializing AusServicePortsDataDAO", (Throwable)e);
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            this.servicePortsDataMap = servicePortsDataMapTmp;
        }
        finally {
            this.lock.releaseWriteLock();
        }
        if (LOGGER.isFinerEnabled()) {
            LOGGER.finer((Object)"init EXIT");
        }
    }

    protected final ResultSetMapper getServicePortsDataMapper() {
        return new ServicePortsDataMapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateDAO(DAOTableEvent tableEvent) {
        Long id = tableEvent.getKey();
        boolean snapinPortUpdatedFlag = false;
        AusServicePortsData oldEntry = null;
        AusServicePortsData newEntry = null;
        if (tableEvent.getTableName().equals(SERVICE_PORTS) && tableEvent.getOperation() != null) {
            block12: {
                try {
                    this.lock.acquireWriteLock();
                    if (tableEvent.getOperation().equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
                        oldEntry = this.servicePortsDataMap.get(id);
                        if (oldEntry != null) {
                            if (LOGGER.isFinestEnabled()) {
                                LOGGER.finest((Object)("updateDAO - oldEntry:" + oldEntry + " is deleted from DB, removing it from cache"));
                            }
                            this.servicePortsDataMap.remove(id);
                            snapinPortUpdatedFlag = true;
                        }
                        break block12;
                    }
                    try {
                        Map updatedPortMap = (Map)this.dataSource.executeQuery(GET_SERVICEPORTSDATA_QUERY_BY_ID, new Object[]{id}, (Object)this.getServicePortsDataMapper());
                        newEntry = (AusServicePortsData)updatedPortMap.get(id);
                        if (newEntry != null) {
                            if (LOGGER.isFinestEnabled()) {
                                LOGGER.finest((Object)("updateDAO - Entry:" + oldEntry + " is updated in DB, updating the cache"));
                            }
                            oldEntry = this.servicePortsDataMap.put(id, newEntry);
                            snapinPortUpdatedFlag = true;
                        }
                    }
                    catch (DMException e) {
                        LOGGER.error((Object)("Error while updating cache for change in table zr_port For id=" + id + " Exception:" + e.getMessage()));
                        this.reinit();
                    }
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            if (snapinPortUpdatedFlag) {
                this.updateListeners(oldEntry, newEntry);
            }
        }
    }

    public final List<String> getDependentTables() {
        return Arrays.asList(SERVICE_PORTS);
    }

    protected final Object getMainCollection() {
        return this.servicePortsDataMap;
    }

    public void registerListener(DMListener listener) {
        if (listener != null) {
            LISTENERS.add(listener);
        } else {
            LOGGER.info((Object)"registerListener - null listener not registered");
        }
    }

    public final void removeListener(DMListener listener) {
        LISTENERS.remove(listener);
    }

    protected AusInstanceDAO getAusInstanceDAO() {
        return (AusInstanceDAO)DMFactory.getInstance().getDataMgr(AusInstanceDAO.class);
    }

    protected final void updateListeners(Object oldObj, Object newObj) {
        if (LOGGER.isFinerEnabled()) {
            LOGGER.finer((Object)"updateListeners ENTER");
        }
        for (DMListener listener : LISTENERS) {
            try {
                if (LOGGER.isFinestEnabled()) {
                    LOGGER.finest((Object)("updateListeners - Calling listener:" + listener + ": old object=" + oldObj + " new object=" + newObj));
                }
                if (listener instanceof AbstractDMListener) {
                    this.notifyServiceOwnedListeners(oldObj, newObj, listener);
                    continue;
                }
                listener.objectChanged(oldObj, newObj);
            }
            catch (Exception e) {
                LOGGER.error((Object)("updateListeners : Error occurred while notifying listener " + listener + ": old object=" + oldObj + " new object=" + newObj + " , exception=" + e));
            }
            catch (NoClassDefFoundError e) {
                LOGGER.error((Object)("NoClassDefFoundError on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                LOGGER.error((Object)"Error is: ", (Throwable)e);
                LOGGER.error((Object)("Unregistering the listener " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                this.removeListener(listener);
            }
        }
        if (LOGGER.isFinerEnabled()) {
            LOGGER.finer((Object)"updateListeners EXIT");
        }
    }

    private void notifyServiceOwnedListeners(Object oldObj, Object newObj, DMListener listener) {
        if (LOGGER.isFinerEnabled()) {
            LOGGER.finer((Object)"notifyServiceOwnedListeners ENTER");
        }
        if (oldObj != null && newObj != null) {
            AbstractDMListener castedListener = (AbstractDMListener)listener;
            AusServicePortsData changedPortsData = (AusServicePortsData)oldObj;
            if (changedPortsData.getServiceName().equals(castedListener.getServiceName()) && changedPortsData.getServiceVersion().equals(castedListener.getServiceVersion())) {
                AusInstanceDAO ausInstanceDAO = this.getAusInstanceDAO();
                long currentClusterID = ausInstanceDAO.getMyClusterId();
                if (changedPortsData.getClusterID() == currentClusterID) {
                    listener.objectChanged(oldObj, newObj);
                }
            }
        }
        if (LOGGER.isFinerEnabled()) {
            LOGGER.finer((Object)"notifyServiceOwnedListeners EXIT");
        }
    }

    @SMConsole
    public List<AusServicePortsData> getPortsDataByServiceNameVersion(Long clusterId, String serviceName, String serviceVersion) {
        if (LOGGER.isFinerEnabled()) {
            LOGGER.finer((Object)"getPortsDataByClusterAndServiceVersion ENTER");
        }
        ArrayList<AusServicePortsData> portsData = new ArrayList<AusServicePortsData>();
        for (AusServicePortsData ausServicePortsData : this.servicePortsDataMap.values()) {
            if (ausServicePortsData.getClusterID() != clusterId.longValue() || !serviceName.equals(ausServicePortsData.getServiceName()) || !serviceVersion.equals(ausServicePortsData.getServiceVersion())) continue;
            portsData.add(ausServicePortsData);
        }
        if (LOGGER.isFinerEnabled()) {
            LOGGER.finer((Object)"getPortsDataByClusterAndServiceVersion EXIT");
        }
        return portsData;
    }

    @SMConsole
    public List<AusServicePortsData> getPortsDataBySrvcNPortNum(Long clusterId, String serviceName, int portNum) {
        if (LOGGER.isFinerEnabled()) {
            LOGGER.finer((Object)"getPortsDataBySrvcNPortNum ENTER");
        }
        ArrayList<AusServicePortsData> portsData = new ArrayList<AusServicePortsData>();
        for (AusServicePortsData ausServicePortsData : this.servicePortsDataMap.values()) {
            if (ausServicePortsData.getClusterID() != clusterId.longValue() || portNum != ausServicePortsData.getPortNumber() || !serviceName.equals(ausServicePortsData.getServiceName())) continue;
            portsData.add(ausServicePortsData);
        }
        if (LOGGER.isFinerEnabled()) {
            LOGGER.finer((Object)"getPortsDataBySrvcNPortNum EXIT");
        }
        return portsData;
    }

    @SMConsole
    public AusServicePortsData getNamedPortByServiceNameVersion(Long clusterId, String serviceName, String serviceVersion, String portName) {
        if (LOGGER.isFinerEnabled()) {
            LOGGER.finer((Object)"getNamedPortByClusterAndServiceVersion ENTER");
        }
        AusServicePortsData ausServicePortsDataItem = null;
        for (AusServicePortsData ausServicePortsData : this.servicePortsDataMap.values()) {
            if (ausServicePortsData.getClusterID() != clusterId.longValue() || !serviceName.equals(ausServicePortsData.getServiceName()) || !serviceVersion.equals(ausServicePortsData.getServiceVersion()) || !portName.equals(ausServicePortsData.getPortName())) continue;
            ausServicePortsDataItem = ausServicePortsData;
            break;
        }
        if (LOGGER.isFinerEnabled()) {
            LOGGER.finer((Object)"getNamedPortByClusterAndServiceVersion EXIT");
        }
        return ausServicePortsDataItem;
    }

    @SMConsole
    public List<AusServicePortsData> getPortsDataByServiceArchiveName(Long clusterId, String serviceArchiveName) {
        if (LOGGER.isFinerEnabled()) {
            LOGGER.finer((Object)"getPortsDataByServiceArchiveName ENTER");
        }
        ArrayList<AusServicePortsData> portsData = new ArrayList<AusServicePortsData>();
        for (AusServicePortsData ausServicePortsData : this.servicePortsDataMap.values()) {
            if (ausServicePortsData.getClusterID() != clusterId.longValue() || !serviceArchiveName.equals(ausServicePortsData.getServiceArchiveName())) continue;
            portsData.add(ausServicePortsData);
        }
        if (LOGGER.isFinerEnabled()) {
            LOGGER.finer((Object)"getPortsDataByServiceArchiveName EXIT");
        }
        return portsData;
    }

    private static final class ServicePortsDataMapper
    implements ResultSetMapper {
        private ServicePortsDataMapper() {
        }

        public Map<Long, AusServicePortsData> mapResults(ResultSet results) throws SQLException, DMException {
            ConcurrentHashMap<Long, AusServicePortsData> map = new ConcurrentHashMap<Long, AusServicePortsData>();
            while (results.next()) {
                map.put(results.getLong("id"), new AusServicePortsData(results.getLong("id"), results.getLong("cluster_id"), results.getString("service_name"), results.getString("version_string"), results.getString("archive_name"), results.getString("name"), results.getInt("number"), results.getInt("default_number"), results.getString("protocol")));
            }
            return map;
        }
    }
}

