/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.alarming.GenericAlarmRecoveryIntf;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.LDAPAttributeDetails;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LdapAttributeDetailsDAO
extends DataAccessObject {
    private final Map<String, LDAPAttributeDetails> ldapAttributeDetailsMap = new ConcurrentHashMap<String, LDAPAttributeDetails>();
    private static final Logger LOG = Logger.getLogger(LdapAttributeDetailsDAO.class);
    private static final String INIT_QUERY = "SELECT ID as ID, LDAPPARAMETER AS LDAPPARAMETER, UPMPARAMETER AS UPMPARAMETER, UMDATASOURCEID AS UPMDATASOURCEID FROM UPM_DATAPARAMETER";

    public final void init() {
        LOG.info((Object)"LdapAttributeDetailsDAO init ENTER");
        Object[] params = new Object[]{};
        try {
            List tmpLdapAttributeDetailsList = (List)this.dataSource.executeQuery(INIT_QUERY, params, (Object)this.getLdapConfigMapper());
            this.ldapAttributeDetailsMap.clear();
            if (tmpLdapAttributeDetailsList != null) {
                for (LDAPAttributeDetails ldapAttributeDetails : tmpLdapAttributeDetailsList) {
                    this.ldapAttributeDetailsMap.put(ldapAttributeDetails.getUpmParameter(), ldapAttributeDetails);
                }
            }
            if (LOG.isFinestEnabled()) {
                LOG.finest((Object)("LdapAttributeDetailsDAO init(): ldap attribute list : " + this.ldapAttributeDetailsMap));
            }
            this.setStatus(DataMgr.Status.OKAY);
            LOG.fine((Object)"LdapAttributeDetailsDAO init: Set status to okay");
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            LOG.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent((GenericAlarmRecoveryIntf)this, (Exception)((Object)e));
        }
        LOG.info((Object)"LdapAttributeDetailsDAO init EXIT");
    }

    public final List<String> getDependentTables() {
        return Arrays.asList("upm_dataparameter");
    }

    protected final Object getMainCollection() {
        return this.ldapAttributeDetailsMap;
    }

    public final void updateDAO(DAOTableEvent arg0) {
        LOG.fine((Object)("LdapAttributeDetailsDAO::updateDAO, received event " + arg0));
        this.init();
    }

    protected final LdapConfigMapper getLdapConfigMapper() {
        return new LdapConfigMapper();
    }

    @SMConsole(description="Get the details of Ldap directory of user by loginName")
    public String getLdapAttributeForLoginName() {
        try {
            LDAPAttributeDetails ldapAttributeDetails = this.ldapAttributeDetailsMap.get("loginName");
            if (ldapAttributeDetails != null) {
                return ldapAttributeDetails.getLdapParamter();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"LdapAttributeDetailsDAO getLdapAttributeForLoginName: Error in getting ldap attribute", (Throwable)e);
        }
        return null;
    }

    static class LdapConfigMapper
    implements ResultSetMapper {
        LdapConfigMapper() {
        }

        public List<LDAPAttributeDetails> mapResults(ResultSet results) throws SQLException, DMException {
            ArrayList<LDAPAttributeDetails> tmpList = new ArrayList<LDAPAttributeDetails>();
            while (results.next()) {
                tmpList.add(new LDAPAttributeDetails(results.getLong("ID"), results.getString("LDAPPARAMETER"), results.getString("UPMPARAMETER"), results.getLong("UPMDATASOURCEID")));
            }
            return tmpList;
        }
    }
}

