/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.MediaServerNode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class MediaServerDAO
extends DataAccessObject {
    private static final String COLON = ":";
    private static final String SLASH = "/";
    protected static final Logger logger = Logger.getLogger(MediaServerDAO.class);
    protected static final String AAMS_NODE_TABLE = "zr_aams_node";
    protected static final String ID = "id";
    protected static final String NAME = "name";
    protected static final String DESCRIPTION = "description";
    protected static final String MGMT_ACCESS_ADDRESS = "mgmt_access_address";
    protected static final String REST_IPV4_ADDRESS = "rest_ipv4_address";
    protected static final String REST_IPV6_ADDRESS = "rest_ipv6_address";
    protected static final String REST_TCP_PORT = "rest_tcp_port";
    protected static final String REST_TLS_PORT = "rest_tls_port";
    protected static final String LOCATION = "location";
    protected static final String GET_AAMS_NODES = "select id, name, description, mgmt_access_address, rest_ipv4_address, rest_ipv6_address,rest_tcp_port, rest_tls_port, location from zr_aams_node";
    protected static final String GET_AAMS_NODE_BY_ID = "select id, name, description, mgmt_access_address, rest_ipv4_address, rest_ipv6_address,rest_tcp_port, rest_tls_port, location from zr_aams_node where id = ?";
    private Map<Long, MediaServerNode> idToMediaServerNodeMap = new ConcurrentHashMap<Long, MediaServerNode>();
    private static final List<DMListener> LISTENERS = new CopyOnWriteArrayList<DMListener>();

    public final List<String> getDependentTables() {
        return Arrays.asList(AAMS_NODE_TABLE);
    }

    public final void registerListener(DMListener listener) {
        LISTENERS.add(listener);
    }

    public final void removeListener(DMListener listener) {
        LISTENERS.remove(listener);
    }

    public final List<DMListener> getListeners() {
        return LISTENERS;
    }

    public final Map<Long, MediaServerNode> getIdToMediaServerNodeMap() {
        return this.idToMediaServerNodeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init() {
        Map tempIdToMediaServerNodeMap;
        MediaServerNodeMapper mediaServerNodeMapper = new MediaServerNodeMapper();
        try {
            tempIdToMediaServerNodeMap = (Map)this.dataSource.executeQuery(GET_AAMS_NODES, new Object[0], (Object)mediaServerNodeMapper);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            logger.error((Object)("init(): Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            return;
        }
        this.lock.acquireWriteLock();
        try {
            this.idToMediaServerNodeMap = tempIdToMediaServerNodeMap;
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.setStatus(DataMgr.Status.OKAY);
    }

    protected final Object getMainCollection() {
        return null;
    }

    public final void updateDAO(DAOTableEvent tableEvent) {
        Long id = tableEvent.getKey();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        MediaServerNode oldNodeEntry = null;
        MediaServerNode newNodeEntry = null;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            try {
                newNodeEntry = (MediaServerNode)this.dataSource.executeQuery(GET_AAMS_NODE_BY_ID, new Object[]{id}, (Object)this.getMediaServerNodeMapperById());
                this.idToMediaServerNodeMap.put(id, newNodeEntry);
            }
            catch (DMException e) {
                logger.error((Object)("updateDAO :Exception while inserting new entry to DAO for change in table zr_aams_node For id=" + id + " Exception:" + e.getMessage()));
                this.reinit();
            }
        } else if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
            oldNodeEntry = this.idToMediaServerNodeMap.get(id);
            try {
                newNodeEntry = (MediaServerNode)this.dataSource.executeQuery(GET_AAMS_NODE_BY_ID, new Object[]{id}, (Object)this.getMediaServerNodeMapperById());
                this.idToMediaServerNodeMap.put(id, newNodeEntry);
            }
            catch (DMException e) {
                logger.error((Object)("updateDAO :Exception while updating DAO for change in table zr_aams_node For id=" + id + " Exception:" + e.getMessage()));
                this.reinit();
            }
        } else if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
            oldNodeEntry = this.idToMediaServerNodeMap.remove(id);
        }
        this.updateListeners(oldNodeEntry, newNodeEntry);
    }

    protected final ResultSetMapper getMediaServerNodeMapperById() {
        return new ResultSetMapper(){

            public MediaServerNode mapResults(ResultSet resultSet) throws SQLException, DMException {
                MediaServerNode mediaServerNode = null;
                String hostName = null;
                while (resultSet.next()) {
                    hostName = MediaServerDAO.getHostNameFromAccessAddress(resultSet.getString(MediaServerDAO.MGMT_ACCESS_ADDRESS));
                    mediaServerNode = new MediaServerNode(resultSet.getLong(MediaServerDAO.ID), resultSet.getString(MediaServerDAO.NAME), resultSet.getString(MediaServerDAO.DESCRIPTION), hostName, resultSet.getString(MediaServerDAO.REST_IPV4_ADDRESS), resultSet.getString(MediaServerDAO.REST_IPV6_ADDRESS), resultSet.getString(MediaServerDAO.REST_TCP_PORT), resultSet.getString(MediaServerDAO.REST_TLS_PORT), resultSet.getString(MediaServerDAO.LOCATION));
                }
                return mediaServerNode;
            }
        };
    }

    private static String getHostNameFromAccessAddress(String mgmtAccessAddress) {
        if (mgmtAccessAddress.contains(COLON)) {
            return mgmtAccessAddress.substring(0, mgmtAccessAddress.indexOf(COLON));
        }
        if (mgmtAccessAddress.contains(SLASH)) {
            return mgmtAccessAddress.substring(0, mgmtAccessAddress.indexOf(SLASH));
        }
        return mgmtAccessAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateListeners(Object oldObject, Object newObject) {
        ClassLoader platClassLoader = Thread.currentThread().getContextClassLoader();
        for (DMListener l : LISTENERS) {
            try {
                Thread.currentThread().setContextClassLoader(l.getClass().getClassLoader());
                l.objectChanged(oldObject, newObject);
            }
            catch (Exception e) {
                logger.error((Object)("updateListeners: Exception on invoking objectChanged on " + l + " from " + ((Object)((Object)this)).getClass().getName()));
                logger.error((Object)"Exception is: ", (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                logger.error((Object)("updateListeners: NoClassDefFoundError on invoking objectChanged on " + l + " from " + ((Object)((Object)this)).getClass().getName()));
                logger.error((Object)"Error is: ", (Throwable)e);
                logger.error((Object)("updateListeners: Unregistering the listener " + l + " from " + ((Object)((Object)this)).getClass().getName()));
                this.removeListener(l);
            }
            finally {
                Thread.currentThread().setContextClassLoader(platClassLoader);
            }
        }
    }

    @SMConsole(description="Returns the list of MediaServer nodes.")
    public final List<MediaServerNode> getNodes() {
        ArrayList<MediaServerNode> MediaServerNodelist = null;
        ArrayList<String> addressList = new ArrayList<String>();
        if (!this.idToMediaServerNodeMap.isEmpty()) {
            MediaServerNodelist = new ArrayList<MediaServerNode>();
            for (MediaServerNode node : this.idToMediaServerNodeMap.values()) {
                if (addressList.contains(node.getRestIPV4Address())) continue;
                addressList.add(node.getRestIPV4Address());
                MediaServerNodelist.add(node);
            }
        }
        return MediaServerNodelist;
    }

    @SMConsole(description="Returns the list of MediaServer nodes for the given location.")
    public final List<MediaServerNode> getNodesByLocation(String location) {
        ArrayList<MediaServerNode> MediaServerNodelist = null;
        ArrayList<String> addressList = new ArrayList<String>();
        if (!this.idToMediaServerNodeMap.isEmpty()) {
            for (MediaServerNode node : this.idToMediaServerNodeMap.values()) {
                if (!node.getLocation().equalsIgnoreCase(location) || addressList.contains(node.getRestIPV4Address())) continue;
                addressList.add(node.getRestIPV4Address());
                if (MediaServerNodelist == null) {
                    MediaServerNodelist = new ArrayList<MediaServerNode>();
                    MediaServerNodelist.add(node);
                    continue;
                }
                MediaServerNodelist.add(node);
            }
        }
        return MediaServerNodelist;
    }

    static class MediaServerNodeMapper
    implements ResultSetMapper {
        MediaServerNodeMapper() {
        }

        public Map<Long, MediaServerNode> mapResults(ResultSet resultSet) throws SQLException, DMException {
            ConcurrentHashMap<Long, MediaServerNode> map = new ConcurrentHashMap<Long, MediaServerNode>();
            while (resultSet.next()) {
                Long id = resultSet.getLong(MediaServerDAO.ID);
                String hostName = MediaServerDAO.getHostNameFromAccessAddress(resultSet.getString(MediaServerDAO.MGMT_ACCESS_ADDRESS));
                map.put(id, new MediaServerNode(id, resultSet.getString(MediaServerDAO.NAME), resultSet.getString(MediaServerDAO.DESCRIPTION), hostName, resultSet.getString(MediaServerDAO.REST_IPV4_ADDRESS), resultSet.getString(MediaServerDAO.REST_IPV6_ADDRESS), resultSet.getString(MediaServerDAO.REST_TCP_PORT), resultSet.getString(MediaServerDAO.REST_TLS_PORT), resultSet.getString(MediaServerDAO.LOCATION)));
            }
            return map;
        }
    }
}

