/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dm;

import com.avaya.asm.core.SMConsole;
import com.avaya.asm.datamgr.BLDMEnumType;
import com.avaya.asm.datamgr.BusinessLogicDM;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.zephyr.platform.dao.DynamicDevicePairingDAO;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public class DynamicDevicePairingDM
extends BusinessLogicDM {
    private List<Class<?>> allDAOs = Arrays.asList(DynamicDevicePairingDAO.class);
    private static DMFactory factory;

    public static DMFactory getFactory() {
        if (factory == null) {
            factory = DMFactory.getInstance();
        }
        return factory;
    }

    public List<Class<?>> getAllDAOs() {
        return this.allDAOs;
    }

    protected DynamicDevicePairingDAO getDDPDAO() {
        return (DynamicDevicePairingDAO)this.getDataMgr(DynamicDevicePairingDAO.class);
    }

    public void init() {
        for (Class<?> dm : this.allDAOs) {
            this.getDataMgr(dm);
        }
        this.setStatus(DataMgr.Status.OKAY);
    }

    @SMConsole(description="Get the paired number for a given user of the form 'handle@domain'.", parameterNames={"userHandle"})
    public String getPairedDevice(String userHandle) {
        return this.getDDPDAO().getPairedDevice(userHandle, new String[0]);
    }

    @SMConsole(description="Set the paired number for a given user of the form 'handle@domain'.", parameterNames={"userHandle", "pairedNumber"})
    public void setPairedDevice(String userHandle, String pairedNumber) {
        this.getDDPDAO().setDummyPairedDevice(userHandle, pairedNumber);
    }

    public EnumSet<? extends BLDMEnumType> getDMUsages() {
        return EnumSet.allOf(DdpDM.class);
    }

    public static enum DdpDM implements BLDMEnumType
    {
        DYNAMIC_DEVICE_PAIRING_DAO(DynamicDevicePairingDAO.class);

        private Class<? extends DataMgr> subDM;

        private DdpDM(Class<? extends DataMgr> dm) {
            this.subDM = dm;
        }

        public DataMgr get() {
            return DynamicDevicePairingDM.getFactory().getDataMgr(this.subDM);
        }
    }
}

