/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.bus.factory;

import com.avaya.collaboration.bus.CollaborationBusMessageHandler;
import com.avaya.collaboration.bus.CollaborationBusMessageHandlerImpl;
import com.avaya.common.logging.client.Logger;

public final class CollaborationBusFactory {
    private static Logger logger = Logger.getLogger(CollaborationBusFactory.class);
    private static volatile CollaborationBusMessageHandlerImpl collaborationBus;

    private CollaborationBusFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CollaborationBusMessageHandler getCollaborationBusMessageHandlerInstance(String serviceName, String serviceVersion) {
        if (collaborationBus == null) {
            Class<CollaborationBusMessageHandlerImpl> clazz = CollaborationBusMessageHandlerImpl.class;
            synchronized (CollaborationBusMessageHandlerImpl.class) {
                if (collaborationBus == null) {
                    logger.info((Object)("CollaborationBusFactory: getting a new Message Handler for service " + serviceName + "-" + serviceVersion));
                    collaborationBus = new CollaborationBusMessageHandlerImpl(serviceName, serviceVersion);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else {
            if (logger.isFinerEnabled()) {
                logger.finer((Object)("CollaborationBusFactory: Service " + serviceName + "-" + serviceVersion + " is getting an existing Message Handler that has already been setup for service " + collaborationBus.getServiceName() + "-" + collaborationBus.getServiceVersion()));
            }
            if (!serviceName.equals(collaborationBus.getServiceName())) {
                logger.warn((Object)"CollaborationBusFactory: service mismatch");
                logger.warn((Object)("requested:" + serviceName + "+" + serviceVersion));
                logger.warn((Object)("existing:" + collaborationBus.getServiceName() + "-" + collaborationBus.getServiceName()));
            }
        }
        return collaborationBus;
    }

    public static void closeBus() {
        if (collaborationBus != null) {
            collaborationBus.close();
            collaborationBus = null;
        }
    }
}

