/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin.model;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.model.ElementInfo;
import com.avaya.ssh.SSHConnection;
import com.avaya.ssh.SSHConnector;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.Viewer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServerTreeContentProvider
implements ITreeContentProvider,
ICheckStateProvider,
ICheckStateListener {
    private static final List<TreeNode> SystemManagers = new ArrayList<TreeNode>();
    private static ElementInfo[] selectedServers = null;

    public ServerTreeContentProvider() {
        ServerTreeContentProvider.load();
    }

    public void dispose() {
        SSHConnector.getInstance().disconnectAll();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        return (TreeNode[])inputElement;
    }

    public Object[] getChildren(Object parentElement) {
        ElementInfo server = (ElementInfo)((TreeNode)parentElement).getValue();
        if (server.getServerType() == ElementInfo.ServerType.CE) {
            return null;
        }
        if (((TreeNode)parentElement).getChildren() != null) {
            return ((TreeNode)parentElement).getChildren();
        }
        return ((TreeNode)parentElement).getChildren();
    }

    public static void setSelectedServers(ElementInfo[] selectedServers) {
        ServerTreeContentProvider.selectedServers = Arrays.copyOf(selectedServers, selectedServers.length);
    }

    public static ElementInfo[] getSelectedServers() {
        return Arrays.copyOf(selectedServers, selectedServers.length);
    }

    public Object getParent(Object element) {
        if (((TreeNode)element).getParent() != null) {
            return ((TreeNode)element).getParent();
        }
        ElementInfo server = (ElementInfo)((TreeNode)element).getValue();
        if (server.getServerType() == ElementInfo.ServerType.SMGR) {
            return null;
        }
        for (TreeNode smgr : SystemManagers) {
            for (TreeNode cluster : smgr.getChildren()) {
                if (((ElementInfo)cluster.getValue()).equals(element)) {
                    return smgr;
                }
                for (TreeNode ce : cluster.getChildren()) {
                    if (!((ElementInfo)ce.getValue()).equals(element)) continue;
                    return cluster;
                }
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        ElementInfo server = (ElementInfo)((TreeNode)element).getValue();
        return server.getServerType() != ElementInfo.ServerType.CE;
    }

    public static TreeNode[] getSystemManagers() {
        return SystemManagers.toArray(new TreeNode[0]);
    }

    public static TreeNode[] getSelectedSystemManagers() {
        ArrayList<TreeNode> systemManagersT = new ArrayList<TreeNode>();
        for (TreeNode tn : SystemManagers) {
            if (!((ElementInfo)tn.getValue()).isChecked()) continue;
            systemManagersT.add(tn);
        }
        return systemManagersT.toArray(new TreeNode[0]);
    }

    public static TreeNode[] getSelectedNodes() {
        ArrayList<TreeNode> systemManagersT = new ArrayList<TreeNode>();
        for (TreeNode tn : SystemManagers) {
            if (!((ElementInfo)tn.getValue()).isChecked()) continue;
            ServerTreeContentProvider.addSelectedNodes(tn, systemManagersT);
        }
        return systemManagersT.toArray(new TreeNode[0]);
    }

    public static void addSelectedNodes(TreeNode tn, List<TreeNode> nodes) {
        nodes.add(tn);
        if (tn.getChildren() != null) {
            for (TreeNode tn1 : tn.getChildren()) {
                if (!((ElementInfo)tn1.getValue()).isChecked()) continue;
                ServerTreeContentProvider.addSelectedNodes(tn1, nodes);
            }
        }
    }

    public static void addSystemManager(ElementInfo smgrElement) {
        ServerTreeContentProvider.addSystemManager(ServerTreeContentProvider.toTreeNode(ServerTreeContentProvider.fetchAssociations(smgrElement)));
    }

    private static ElementInfo fetchAssociations(ElementInfo smgr) {
        try {
            SSHConnection conn = SSHConnector.getInstance().getSSHConnection(smgr);
            String clusters = conn.execute("sudo /opt/Avaya/AUS/install/eclipse_helper.sh -l");
            for (String line : clusters.split("\n")) {
                if (line.trim().length() == 0 || line.contains("could not change directory")) continue;
                ElementInfo clusterElement = ElementInfo.createCluster(line.trim(), smgr.getIp());
                smgr.addAssociatedElement(clusterElement);
                String instances = conn.execute("sudo /opt/Avaya/AUS/install/eclipse_helper.sh -c \"" + clusterElement.getName() + "\"");
                for (String line1 : instances.split("\n")) {
                    try {
                        if (line1.trim().length() == 0 || line1.contains("could not change directory")) continue;
                        String[] details = line1.trim().split("\\|");
                        ElementInfo ceInfo = ElementInfo.createCE(details[0].trim(), details[1].trim());
                        clusterElement.addAssociatedElement(ceInfo);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error getting element associations from SMGR", e);
        }
        return smgr;
    }

    public static TreeNode toTreeNode(ElementInfo smgrElement) {
        Iterator<TreeNode> tnI = SystemManagers.iterator();
        TreeNode smgrTreeNode = null;
        while (tnI.hasNext()) {
            TreeNode existingParent = tnI.next();
            ElementInfo el = (ElementInfo)existingParent.getValue();
            if (!smgrElement.getIp().equals(el.getIp())) continue;
            smgrTreeNode = existingParent;
            break;
        }
        if (smgrTreeNode == null) {
            smgrTreeNode = new TreeNode((Object)smgrElement);
            SystemManagers.add(smgrTreeNode);
        } else {
            ((ElementInfo)smgrTreeNode.getValue()).setUserName(smgrElement.getUserName());
            ((ElementInfo)smgrTreeNode.getValue()).setPassword(smgrElement.getPassword());
            ((ElementInfo)smgrTreeNode.getValue()).setPort(smgrElement.getPort());
        }
        ArrayList<TreeNode> children = new ArrayList<TreeNode>();
        for (ElementInfo element : smgrElement.getAssociatedElements()) {
            TreeNode clusterNode = new TreeNode((Object)element);
            clusterNode.setParent(smgrTreeNode);
            children.add(clusterNode);
            ArrayList<TreeNode> ceChildren = new ArrayList<TreeNode>();
            for (ElementInfo ce : element.getAssociatedElements()) {
                TreeNode ceElement = new TreeNode((Object)ce);
                ceElement.setParent(clusterNode);
                ceChildren.add(ceElement);
            }
            clusterNode.setChildren(ceChildren.toArray(new TreeNode[0]));
        }
        smgrTreeNode.setChildren(children.toArray(new TreeNode[0]));
        return smgrTreeNode;
    }

    public static void addSystemManager(TreeNode smgrTreeNode) {
        ServerTreeContentProvider.save();
    }

    public void removeSystemManager(ElementInfo ei) {
        Iterator<TreeNode> tnI = SystemManagers.iterator();
        while (tnI.hasNext()) {
            ElementInfo el = (ElementInfo)tnI.next().getValue();
            if (!ei.getIp().equals(el.getIp())) continue;
            tnI.remove();
        }
        ServerTreeContentProvider.save();
    }

    public static void save() {
        File history = new File(".", "history.xml");
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement("history");
            doc.appendChild(root);
            for (TreeNode smgr : SystemManagers) {
                Element smgrElement = doc.createElement("smgr");
                ((ElementInfo)smgr.getValue()).save(smgrElement);
                root.appendChild(smgrElement);
                if (smgr.getChildren() == null) continue;
                for (TreeNode cluster : smgr.getChildren()) {
                    Element clusterElement = doc.createElement("cluster");
                    ((ElementInfo)cluster.getValue()).save(clusterElement);
                    smgrElement.appendChild(clusterElement);
                    if (cluster.getChildren() == null) continue;
                    for (TreeNode ce : cluster.getChildren()) {
                        Element ceElement = doc.createElement("ce");
                        ((ElementInfo)ce.getValue()).save(ceElement);
                        clusterElement.appendChild(ceElement);
                    }
                }
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult target = new StreamResult(history);
            transformer.transform(source, target);
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error saving tree data", e);
        }
    }

    static void load() {
        try {
            File stateLocation = new File(".");
            File history = new File(stateLocation, "history.xml");
            if (!history.exists()) {
                return;
            }
            SystemManagers.clear();
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(history);
            Element root = doc.getDocumentElement();
            if (root.hasChildNodes()) {
                NodeList smgrs = root.getChildNodes();
                for (int i = 0; i < smgrs.getLength(); ++i) {
                    TreeNode smgr = ServerTreeContentProvider.loadElement((Element)smgrs.item(i));
                    SystemManagers.add(smgr);
                }
            }
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error loading tree data", e);
        }
    }

    private static TreeNode loadElement(Element element) throws Exception {
        ElementInfo ei = ElementInfo.load(element);
        TreeNode treeNode = new TreeNode((Object)ei);
        if (element.hasChildNodes()) {
            NodeList children = element.getChildNodes();
            ArrayList<TreeNode> childTreeNodes = new ArrayList<TreeNode>();
            for (int i = 0; i < children.getLength(); ++i) {
                Element child = (Element)children.item(i);
                TreeNode childNode = ServerTreeContentProvider.loadElement(child);
                childNode.setParent(treeNode);
                childTreeNodes.add(childNode);
                ei.addAssociatedElement((ElementInfo)childNode.getValue());
            }
            treeNode.setChildren(childTreeNodes.toArray(new TreeNode[0]));
        }
        return treeNode;
    }

    public boolean isChecked(Object element) {
        return this.anyChildChecked((TreeNode)element);
    }

    public boolean isGrayed(Object element) {
        return this.anyChildChecked((TreeNode)element) && !this.allChildrenChecked((TreeNode)element);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        TreeNode treeNode = (TreeNode)event.getElement();
        ((ElementInfo)treeNode.getValue()).setChecked(event.getChecked());
        ServerTreeContentProvider.save();
    }

    private boolean anyChildChecked(TreeNode treeNode) {
        if (((ElementInfo)treeNode.getValue()).isChecked()) {
            return true;
        }
        if (treeNode.hasChildren()) {
            for (TreeNode child : treeNode.getChildren()) {
                if (!this.anyChildChecked(child)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean allChildrenChecked(TreeNode treeNode) {
        if (!((ElementInfo)treeNode.getValue()).isChecked()) {
            return false;
        }
        if (treeNode.hasChildren()) {
            for (TreeNode child : treeNode.getChildren()) {
                if (this.allChildrenChecked(child)) continue;
                return false;
            }
        }
        return true;
    }
}

