/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin.operation;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.CEProjectModel;
import com.avaya.eclipse.plugin.CEProjectUtils;
import com.avaya.eclipse.plugin.PropertyWindowEditor;
import com.avaya.eclipse.plugin.operation.CEDeploymentOperation;
import com.avaya.eclipse.plugin.operation.CEOperation;
import com.avaya.eclipse.plugin.util.CEMavenOperations;
import com.avaya.eclipse.plugin.util.CEPluginHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.prefs.Preferences;

public class CEBuildAndDeployOperation
extends CEOperation {
    private boolean isThroughSMGR = false;

    public CEBuildAndDeployOperation(IProject project) {
        this.project = project;
    }

    public CEBuildAndDeployOperation() {
        this(null);
    }

    public boolean isThroughSMGR() {
        return this.isThroughSMGR;
    }

    public void setThroughSMGR(boolean isThroughSMGR) {
        this.isThroughSMGR = isThroughSMGR;
    }

    @Override
    public IStatus execute(IProgressMonitor monitor) {
        this.setMessageConsoleStream();
        IStatus status = Status.OK_STATUS;
        CEProjectModel ceModelP = CEProjectUtils.evaluateAsCEProject(this.project.getLocation().toFile());
        monitor.beginTask("Clean,Build,(Re)Deploy " + ceModelP.getFullServiceName(), 3);
        this.startOperation(ceModelP, monitor);
        return status;
    }

    public void startOperation(CEProjectModel cep, IProgressMonitor monitor) {
        String version;
        boolean isMavenCli = false;
        CEPluginHelper mvnHelper = CEPluginHelper.INSTANCE;
        mvnHelper.reset();
        try {
            Class<?> c = Class.forName("org.apache.maven.cli.MavenCli");
            isMavenCli = true;
        }
        catch (ClassNotFoundException e) {
            CEBuildAndDeployOperation.openDialog("Maven Error", "Maven home is not set");
        }
        if (this.isMavenExternal(mvnHelper)) {
            isMavenCli = false;
            this.getWriter().println("External maven configured");
        }
        CEMavenOperations.getInstance().version(CEProjectUtils.getSelectedPomFile(this.project.getLocation().toFile()), "-v", this.getWriter(), isMavenCli, mvnHelper);
        if (mvnHelper.isVersionInfoAvail() && !this.checkMinMvnVersion(version = mvnHelper.getMvnVersion(), mvnHelper)) {
            Display.getDefault().syncExec((Runnable)mvnHelper);
        }
        if (mvnHelper.isConfirm()) {
            int i;
            String mvnArgs = "clean,install";
            String mavenOpts = PropertyWindowEditor.getServerConfProperties().getProperty("Maven Options");
            if (mavenOpts != null) {
                mavenOpts = mavenOpts.replace(" ", "");
                mvnArgs = mvnArgs + "," + mavenOpts;
            }
            if ((i = CEMavenOperations.getInstance().mavenAction(CEProjectUtils.getSelectedPomFile(this.project.getLocation().toFile()), mvnArgs, this.getWriter(), isMavenCli)) != 0) {
                CEBuildAndDeployOperation.openDialog("Maven Error", "Maven Operation failed");
            }
            if (i == 0) {
                CEProjectModel ceproject = CEProjectUtils.evaluateAsCEProject(this.project.getLocation().toFile());
                if (ceproject.getAbsolutePathToSvar() != null && !ceproject.getAbsolutePathToSvar().isEmpty()) {
                    CEDeploymentOperation cedep = new CEDeploymentOperation();
                    if (this.isThroughSMGR) {
                        cedep.followSMGR();
                    }
                    cedep.setProject(this.project);
                    try {
                        cedep.execute(monitor);
                    }
                    catch (Exception e) {
                        Activator.log(4, 0, "Error in build/deploy acion", e);
                    }
                } else {
                    CEBuildAndDeployOperation.openDialog("Deployment Error", "Deployment failed due to missing svar file");
                }
            } else {
                CEBuildAndDeployOperation.openDialog("Maven Error", "Maven Operation failed");
            }
        }
    }

    private boolean checkMinMvnVersion(String version, CEPluginHelper helper) {
        return helper.checkMinMvnVersion(version, this.getWriter());
    }

    public final boolean isMavenExternal(CEPluginHelper helper) {
        IPreferencesService service = helper.getPreferencesService();
        IEclipsePreferences configurationNode = helper.getConfigurationScope();
        IEclipsePreferences instanceNode = helper.getInstanceScope();
        Preferences[] nodes = new Preferences[]{instanceNode, configurationNode};
        if (service != null) {
            String defaultM2Runtimes = service.get("eclipse.m2.defaultRuntime", "MavenPathNotFound", nodes);
            if ("EMBEDDED".equals(defaultM2Runtimes)) {
                return false;
            }
            if (!"MavenPathNotFound".equals(defaultM2Runtimes)) {
                String mavenLocation = instanceNode.node("eclipse.m2.runtimesNodes").node(defaultM2Runtimes).get("location", "MavenPathNotFound");
                if (!"MavenPathNotFound".equals(mavenLocation)) {
                    PropertyWindowEditor.getServerConfProperties().setProperty("Maven Home Directory", mavenLocation);
                    return true;
                }
                PropertyWindowEditor.getServerConfProperties().setProperty("Maven Home Directory", defaultM2Runtimes);
                return true;
            }
        }
        return false;
    }
}

