/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin.operation;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.CEProjectModel;
import com.avaya.eclipse.plugin.CEProjectUtils;
import com.avaya.eclipse.plugin.PluginUtilities;
import com.avaya.eclipse.plugin.model.ElementInfo;
import com.avaya.eclipse.plugin.operation.CEDeleteServiceOperation;
import com.avaya.eclipse.plugin.operation.CEOperation;
import com.avaya.eclipse.plugin.operation.FileChecksumStatus;
import com.avaya.eclipse.plugin.util.SelectedProjectFinder;
import com.avaya.ssh.SSHConnection;
import com.avaya.ssh.SSHConnectionGroup;
import com.avaya.ssh.SSHConnector;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CEDeploymentOperation
extends CEOperation {
    private boolean followSMGR;
    private IProgressMonitor monitor;
    private boolean isReDeployOperation = false;

    public CEDeploymentOperation(IProject project) {
        this.project = project;
    }

    public CEDeploymentOperation() {
        this(null);
    }

    public boolean isReDeployOperation() {
        return this.isReDeployOperation;
    }

    public void setReDeployOperation(boolean isReDeployOperation) {
        this.isReDeployOperation = isReDeployOperation;
    }

    @Override
    public IStatus execute(IProgressMonitor monitor) {
        this.setMessageConsoleStream();
        this.monitor = monitor;
        IStatus status = Status.OK_STATUS;
        CEProjectModel ceModelP = CEProjectUtils.evaluateAsCEProject(this.project.getLocation().toFile());
        monitor.beginTask("Deploying " + ceModelP.getFullServiceName(), 3);
        this.startOperation(ceModelP);
        return status;
    }

    public void startOperation(CEProjectModel cep) {
        try {
            if (cep != null && cep.getAssociatedElements().size() == 0) {
                CEOperation.openErrorDialog("Deployment Failure", "Please select at least one cluster to proceed with Avaya Breeze\u00ae Eclipse plug-in action.");
                return;
            }
            if (cep != null && cep.getAssociatedElements() != null && cep.getAssociatedElements().size() > 0) {
                Map<String, ElementInfo> smgrIPMap = CEProjectUtils.getElementsIPMap(cep.getAssociatedElements());
                if (this.isReDeployOperation) {
                    for (Map.Entry<String, ElementInfo> entry : smgrIPMap.entrySet()) {
                        Set<ElementInfo> clusterList = entry.getValue().getAssociatedElements();
                        for (ElementInfo cluster : clusterList) {
                            if (cluster.getAssociatedElements() == null || !cluster.isChecked() || cluster.getAssociatedElements().size() <= 0) continue;
                            SSHConnectionGroup sshcgCE = new SSHConnectionGroup(cluster.getAssociatedElements());
                            this.logConsole("Re Deploying Service " + cep.getFullServiceName() + " through Avaya Breeze\u00ae");
                            sshcgCE.startUpdating(this);
                            sshcgCE.put(cep.getAbsolutePathToSvar(), "/tmp/");
                            Map<String, String> outMap = sshcgCE.execute("deploy_service  /tmp/" + cep.getDeploySvarName());
                            for (Map.Entry<String, String> outEntry : outMap.entrySet()) {
                                if (outEntry.getValue() != null && (outEntry.getValue().contains("Initialized successfully") || this.isIgnoreMsg(outEntry.getValue()))) {
                                    sshcgCE.execute("rm -rf /tmp/" + cep.getDeploySvarName());
                                    this.logConsole("Service Deployed Successfully for Avaya Breeze\u00ae ", outEntry.getKey());
                                    continue;
                                }
                                sshcgCE.execute("rm -rf /tmp/" + cep.getDeploySvarName());
                                boolean isDeployed = this.checkServiceDeploymentStatus(cep, sshcgCE);
                                if (isDeployed) continue;
                                this.logConsole("Service Deployment Failed for Avaya Breeze\u00ae ", outEntry.getKey());
                            }
                            sshcgCE.stopUpdating(this);
                        }
                    }
                    return;
                }
                SSHConnectionGroup sshcg = new SSHConnectionGroup(cep.getAssociatedElements());
                this.logConsole("Start Deploying service .....", cep.getAssociatedElements().toString());
                Map<String, String> returnMap = sshcg.execute("sudo /opt/Avaya/AUS/install/service_util.sh -p");
                FileChecksumStatus fileStatus = new FileChecksumStatus(this.project);
                boolean isChecksumUpdated = fileStatus.isChecksumChangedForPropertyOrAlarm();
                if (isChecksumUpdated) {
                    fileStatus.updatePropertyValue();
                }
                for (Map.Entry<String, String> retEntry : returnMap.entrySet()) {
                    Object servDetails;
                    SSHConnection sshce = SSHConnector.getInstance().getSSHConnection(smgrIPMap.get(retEntry.getKey()));
                    boolean serviceRequiredDeletion = false;
                    boolean atLeastOneClusterChecked = false;
                    for (ElementInfo cluster : smgrIPMap.get(retEntry.getKey()).getAssociatedElements()) {
                        if (cluster.getAssociatedElements() != null && cluster.getAssociatedElements().size() > 0 && cluster.isChecked()) {
                            atLeastOneClusterChecked = true;
                        }
                        String serviceList = sshce.execute("sudo /opt/Avaya/AUS/install/eclipse_helper.sh -s  '" + cluster.getName() + "'");
                        for (String line : serviceList.split("\n")) {
                            if (line.trim().length() == 0 || line.contains("could not change directory") || (servDetails = SelectedProjectFinder.getServiceStatus(line, cep)) == null) continue;
                            serviceRequiredDeletion = true;
                        }
                    }
                    if (serviceRequiredDeletion && atLeastOneClusterChecked && this.followSMGR) {
                        CEDeleteServiceOperation ced = new CEDeleteServiceOperation();
                        CEProjectModel ceModelP = CEProjectUtils.evaluateAsCEProject(this.project.getLocation().toFile());
                        ced.setMessageConsoleStream(this.project.getProject().getName());
                        ced.startOperation(ceModelP);
                        serviceRequiredDeletion = false;
                        atLeastOneClusterChecked = false;
                    }
                    for (ElementInfo cluster : smgrIPMap.get(retEntry.getKey()).getAssociatedElements()) {
                        Object servDetails2;
                        String tag = "SMGR : " + retEntry.getKey() + " , Cluster : " + cluster.getName();
                        if (cluster.getAssociatedElements() == null || cluster.getAssociatedElements().size() == 0) {
                            this.logConsole("No Avaya Breeze\u00ae present on this Cluster ", tag);
                            continue;
                        }
                        if (!cluster.isChecked()) continue;
                        SSHConnectionGroup sshcgCE = new SSHConnectionGroup(cluster.getAssociatedElements());
                        boolean isOnCEWay = false;
                        String serviceList = sshce.execute("sudo /opt/Avaya/AUS/install/eclipse_helper.sh -s  '" + cluster.getName() + "'");
                        for (String line : serviceList.split("\n")) {
                            if (line.trim().length() == 0 || line.contains("could not change directory") || (servDetails2 = SelectedProjectFinder.getServiceStatus(line, cep)) == null) continue;
                            isOnCEWay = true;
                        }
                        if (!isChecksumUpdated && isOnCEWay && !this.followSMGR) {
                            this.logConsole("Re Deploying Service " + cep.getFullServiceName() + " for SMGR " + retEntry.getKey() + " through Avaya Breeze\u00ae", retEntry.getKey());
                            sshcgCE.startUpdating(this);
                            sshcgCE.put(cep.getAbsolutePathToSvar(), "/tmp/");
                            Map<String, String> outMap = sshcgCE.execute("deploy_service  /tmp/" + cep.getDeploySvarName());
                            servDetails = outMap.entrySet().iterator();
                            while (servDetails.hasNext()) {
                                Map.Entry outEntry = (Map.Entry)servDetails.next();
                                sshcgCE.execute("rm -rf /tmp/" + cep.getDeploySvarName());
                                if (outEntry.getValue() != null && (((String)outEntry.getValue()).contains("Initialized successfully") || this.isIgnoreMsg((String)outEntry.getValue()))) {
                                    sshcgCE.execute("rm -rf /tmp/" + cep.getDeploySvarName());
                                    sshcgCE.execute("rm -rf /tmp/deploy*");
                                    sshcgCE.execute("rm -rf /tmp/ver*");
                                    this.logConsole("Service Deployed Successfully for Avaya Breeze\u00ae ", (String)outEntry.getKey());
                                    continue;
                                }
                                sshcgCE.execute("rm -rf /tmp/" + cep.getDeploySvarName());
                                sshcgCE.execute("rm -rf /tmp/deploy*");
                                sshcgCE.execute("rm -rf /tmp/ver*");
                                boolean isDeployed = this.checkServiceDeploymentStatus(cep, sshcgCE);
                                if (isDeployed) continue;
                                this.logConsole("Service Deployment Failed for Avaya Breeze\u00ae ", (String)outEntry.getKey());
                            }
                            sshcgCE.stopUpdating(this);
                            continue;
                        }
                        this.logConsole("Start Copying svar file to SMGR : " + retEntry.getKey(), retEntry.getKey());
                        sshce.startUpdating(this);
                        sshce.put(cep.getAbsolutePathToSvar(), "/tmp/");
                        sshce.execute("sudo /opt/Avaya/AUS/install/service_util.sh -n  /tmp/" + cep.getDeploySvarName() + " '" + cluster.getName() + "'");
                        this.logConsole("Verify Deployment Status for SMGR " + retEntry.getKey(), tag);
                        sshce.execute("rm -rf /tmp/" + cep.getDeploySvarName());
                        sshce.stopUpdating(this);
                        HashMap ceStatusMap = new HashMap();
                        for (int i = 0; i < 30; ++i) {
                            Map<String, String> outMap = sshcgCE.execute("deploy_service -lv");
                            boolean isCheckNeeded = false;
                            if (outMap.isEmpty()) {
                                isCheckNeeded = true;
                            }
                            servDetails2 = outMap.entrySet().iterator();
                            while (servDetails2.hasNext()) {
                                Map.Entry outEntry = (Map.Entry)servDetails2.next();
                                this.logConsole((String)outEntry.getValue());
                                boolean isDeployed = SelectedProjectFinder.getServiceStatusOnCE((String)outEntry.getValue(), cep);
                                ceStatusMap.put(outEntry.getKey(), isDeployed);
                                if (!isDeployed) {
                                    isCheckNeeded = true;
                                }
                                this.logConsole("Deployment Status of Snapin " + cep.getFullServiceName() + " on Avaya Breeze\u00ae " + (String)outEntry.getKey() + " is : " + isDeployed, tag + " , Avaya Breeze\u00ae : " + (String)outEntry.getKey());
                            }
                            if (!isCheckNeeded) break;
                            if (PluginUtilities.getInstance().isDemoMode()) continue;
                            Thread.sleep(10000L);
                        }
                        boolean isSuccess = true;
                        for (Map.Entry outEntry : ceStatusMap.entrySet()) {
                            isSuccess &= ((Boolean)outEntry.getValue()).booleanValue();
                            if (((Boolean)outEntry.getValue()).booleanValue()) {
                                this.logConsole("Service Deployed Successfully  on Avaya Breeze\u00ae " + (String)outEntry.getKey(), tag + " , Avaya Breeze\u00ae : " + (String)outEntry.getKey());
                                continue;
                            }
                            this.logConsole("Service Deployment Failed on Avaya Breeze\u00ae " + (String)outEntry.getKey(), tag + " , Avaya Breeze\u00ae : " + (String)outEntry.getKey());
                        }
                        if (isSuccess) {
                            this.logConsole("Service Deployed Successfully", tag);
                        } else {
                            this.logConsole("Service Deployment Failed", tag);
                        }
                        this.monitor.worked(1);
                        sshce.stopUpdating(this);
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Activator.log(4, 0, "Error", e);
            return;
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error: deployment failure", e);
            CEOperation.openDialog("Deployment Failure", e.getMessage());
        }
    }

    private boolean isIgnoreMsg(String msg) {
        return msg.contains("SipSessionsUtilImpl");
    }

    public void followSMGR() {
        this.followSMGR = true;
    }

    public boolean checkServiceDeploymentStatus(CEProjectModel cep, SSHConnectionGroup sshcgCE) {
        boolean serviceDeployed = false;
        HashMap<String, Boolean> ceStatusMap = new HashMap<String, Boolean>();
        try {
            for (int i = 0; i < 2; ++i) {
                Map<String, String> outMap = sshcgCE.execute("deploy_service -lv");
                boolean isCheckNeeded = false;
                if (outMap.isEmpty()) {
                    isCheckNeeded = true;
                }
                for (Map.Entry<String, String> outEntry : outMap.entrySet()) {
                    this.logConsole(outEntry.getValue());
                    boolean isDeployed = SelectedProjectFinder.getServiceStatusOnCE(outEntry.getValue(), cep);
                    ceStatusMap.put(outEntry.getKey(), isDeployed);
                    if (!isDeployed) {
                        isCheckNeeded = true;
                    }
                    this.logConsole("Deployment Status of Snapin " + cep.getFullServiceName() + " on Avaya Breeze\u00ae " + outEntry.getKey() + " is : " + isDeployed + " , Avaya Breeze\u00ae : " + outEntry.getKey());
                }
                if (isCheckNeeded && ceStatusMap.containsValue(false)) {
                    Thread.sleep(10000L);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error: re-deployment failure", e);
        }
        for (Map.Entry outEntry : ceStatusMap.entrySet()) {
            if (((Boolean)outEntry.getValue()).booleanValue()) {
                serviceDeployed = true;
                this.logConsole("Service Deployed Successfully  on Avaya Breeze\u00ae " + (String)outEntry.getKey() + " , Avaya Breeze\u00ae : " + (String)outEntry.getKey());
                continue;
            }
            serviceDeployed = false;
            this.logConsole("Service Deployment Failed on Avaya Breeze\u00ae " + (String)outEntry.getKey() + " , Avaya Breeze\u00ae : " + (String)outEntry.getKey());
        }
        return serviceDeployed;
    }
}

