/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ssh;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.model.ElementInfo;
import com.avaya.eclipse.plugin.operation.CEOperation;
import com.avaya.eclipse.plugin.operation.CETask;
import com.avaya.eclipse.plugin.operation.CETaskExecutor;
import com.avaya.ssh.SSHConnection;
import com.avaya.ssh.SSHConnector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

public class SSHConnectionGroup {
    private List<ElementInfo> elements;
    private CEOperation ceOp = null;

    public SSHConnectionGroup(Collection<ElementInfo> elements) {
        ArrayList<ElementInfo> elementTempList = new ArrayList<ElementInfo>();
        for (ElementInfo element : elements) {
            if (element.getServerType() == ElementInfo.ServerType.CLUSTER) {
                for (ElementInfo elementC : element.getAssociatedElements()) {
                    elementTempList.add(elementC);
                }
                continue;
            }
            elementTempList.add(element);
        }
        this.elements = elementTempList;
    }

    public void startUpdating(CEOperation ceop) {
        this.startUpdating(ceop, false);
    }

    public void stopUpdating(CEOperation ceop) {
        this.stopUpdating(ceop, false);
    }

    public void startUpdating(CEOperation ceop, boolean isContinuous) {
        this.ceOp = ceop;
        for (ElementInfo ce : this.elements) {
            try {
                if (isContinuous) continue;
                SSHConnector.getInstance().getSSHConnection(ce).startUpdating(ceop);
            }
            catch (Exception e) {
                Activator.log(4, 0, "Error starting update", e);
            }
        }
    }

    public void stopUpdating(CEOperation ceop, boolean isContinuous) {
        this.ceOp = null;
        for (ElementInfo ce : this.elements) {
            try {
                if (isContinuous) continue;
                SSHConnector.getInstance().getSSHConnection(ce).stopUpdating(ceop);
            }
            catch (Exception e) {
                Activator.log(4, 0, "Error stopping update", e);
            }
        }
    }

    public synchronized Map<String, String> put(String absolutePathToFile, String targetPath) throws Exception {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        ExecutorService executor = Executors.newFixedThreadPool(this.elements.size());
        ArrayList<FutureTask<String>> futureList = new ArrayList<FutureTask<String>>();
        for (ElementInfo elementInfo : this.elements) {
            if (!elementInfo.getServerType().equals((Object)ElementInfo.ServerType.CE)) continue;
            CETaskExecutor ceTastExec = new CETaskExecutor(new LocalCopyTask(elementInfo, returnMap, absolutePathToFile, targetPath));
            FutureTask<String> futureTask = new FutureTask<String>(ceTastExec);
            futureList.add(futureTask);
            executor.execute(futureTask);
        }
        for (FutureTask futureTask : futureList) {
            futureTask.get(1L, TimeUnit.MINUTES);
        }
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.MINUTES);
        return returnMap;
    }

    public synchronized Map<String, String> execute(String command) throws Exception {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        ExecutorService executor = Executors.newFixedThreadPool(this.elements.size());
        ArrayList<FutureTask<String>> futureList = new ArrayList<FutureTask<String>>();
        for (ElementInfo elementInfo : this.elements) {
            CETaskExecutor ceTastExec = new CETaskExecutor(new LocalTask(elementInfo, returnMap, command));
            FutureTask<String> futureTask = new FutureTask<String>(ceTastExec);
            futureList.add(futureTask);
            executor.execute(futureTask);
        }
        for (FutureTask futureTask : futureList) {
            futureTask.get(3L, TimeUnit.MINUTES);
        }
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.MINUTES);
        return returnMap;
    }

    public synchronized void executeAsync(String command) throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(this.elements.size());
        ArrayList<FutureTask<String>> futureList = new ArrayList<FutureTask<String>>();
        for (ElementInfo elementInfo : this.elements) {
            CETaskExecutor ceTastExec = new CETaskExecutor(new LocalContinuousTask(elementInfo, command));
            FutureTask<String> futureTask = new FutureTask<String>(ceTastExec);
            futureList.add(futureTask);
            executor.execute(futureTask);
        }
        for (FutureTask futureTask : futureList) {
            futureTask.get(3L, TimeUnit.MINUTES);
        }
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.MINUTES);
    }

    public void disConnectAll() {
        for (ElementInfo ce : this.elements) {
            try {
                SSHConnector.getInstance().getContinuousSSHConnection(ce, true).disconnect();
                SSHConnector.continuousSSHConnectionMap.remove(ce.getIp());
                SSHConnector.getInstance().getSSHConnection(ce).disconnect();
                SSHConnector.sshConnectionMap.remove(ce.getIp());
            }
            catch (Exception e) {
                Activator.log(4, 0, "Error disconnecing all", e);
            }
        }
    }

    private static class LocalCopyTask
    implements CETask {
        private final ElementInfo ce;
        private final String targetPath;
        private final Map<String, String> returnMap;
        private final String absolutePathToFile;

        public LocalCopyTask(ElementInfo ce, Map<String, String> returnMap, String absolutePathToFile, String targetPath) {
            this.ce = ce;
            this.targetPath = targetPath;
            this.absolutePathToFile = absolutePathToFile;
            this.returnMap = returnMap;
        }

        @Override
        public String execute() {
            try {
                SSHConnector.getInstance().getSSHConnection(this.ce).put(this.absolutePathToFile, this.targetPath);
                this.returnMap.put(this.ce.getIp(), "Success");
                return "Success";
            }
            catch (Exception e) {
                Activator.log(4, 0, "Error connecting to " + this.ce.getIp(), e);
                this.returnMap.put(this.ce.getIp(), "Failure");
                return "Failure";
            }
        }
    }

    private class LocalContinuousTask
    implements CETask {
        private ElementInfo ce;
        private String command;

        public LocalContinuousTask(ElementInfo ce, String command) {
            this.ce = ce;
            this.command = command;
        }

        @Override
        public String execute() {
            try {
                SSHConnection sshc = SSHConnector.getInstance().getContinuousSSHConnection(this.ce);
                if (SSHConnectionGroup.this.ceOp != null) {
                    sshc.startUpdating(SSHConnectionGroup.this.ceOp);
                }
                sshc.executeAsync(this.command);
            }
            catch (Exception e) {
                Activator.log(4, 0, "Error connecting to " + this.ce.getIp(), e);
            }
            return "Failure";
        }
    }

    private static class LocalTask
    implements CETask {
        private final ElementInfo ce;
        private final String command;
        private Map<String, String> returnMap;

        public LocalTask(ElementInfo ce, Map<String, String> returnMap, String command) {
            this.ce = ce;
            this.command = command;
            this.returnMap = returnMap;
        }

        @Override
        public String execute() {
            try {
                String outData = SSHConnector.getInstance().getSSHConnection(this.ce).execute(this.command);
                this.returnMap.put(this.ce.getIp(), outData);
                return outData;
            }
            catch (Exception e) {
                Activator.log(4, 0, "Error in execute", e);
                return "Failure";
            }
        }
    }
}

