/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.commons.lang;

import com.avaya.commons.lang.ArgAssert;
import com.avaya.commons.lang.Matchers;
import com.avaya.commons.lang.PatternsThatMustNotOccur;
import com.avaya.commons.lang.PatternsThatMustOccur;
import com.avaya.commons.lang.Validator;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PatternBasedCharSequenceValidator
implements Validator<CharSequence> {
    private final PatternsThatMustOccur patternsThatMustOccur;
    private final PatternsThatMustNotOccur patternsThatMustNotOccur;

    public PatternBasedCharSequenceValidator(PatternsThatMustOccur patternsThatMustOccur, PatternsThatMustNotOccur patternsThatMustNotOccur) {
        ArgAssert.assertNotNull(patternsThatMustOccur, "patternsThatMustOccur");
        ArgAssert.assertNotNull(patternsThatMustNotOccur, "patternsThatMustNotOccur");
        this.patternsThatMustOccur = patternsThatMustOccur;
        this.patternsThatMustNotOccur = patternsThatMustNotOccur;
    }

    public PatternBasedCharSequenceValidator(PatternsThatMustOccur patternsThatMustOccur) {
        this(patternsThatMustOccur, new PatternsThatMustNotOccur.Builder().build());
    }

    public PatternBasedCharSequenceValidator(PatternsThatMustNotOccur patternsThatMustNotOccur) {
        this(new PatternsThatMustOccur.Builder().build(), patternsThatMustNotOccur);
    }

    @Override
    public boolean isValid(CharSequence input) {
        if (input == null) {
            return false;
        }
        return this.isValidAccordingToPatternsThatMustOccur(input) && this.isValidAccordingToPatternsThatMustNotOccur(input);
    }

    private boolean isValidAccordingToPatternsThatMustOccur(CharSequence input) {
        for (Pattern pattern : this.patternsThatMustOccur.getPatterns()) {
            if (!this.areNotEnoughOccurrences(pattern, input)) continue;
            return false;
        }
        return true;
    }

    private boolean areNotEnoughOccurrences(Pattern pattern, CharSequence input) {
        int numOccurrences = this.getNumOccurrences(pattern, input);
        return numOccurrences < this.getMinNumOccurrences(pattern);
    }

    private int getNumOccurrences(Pattern pattern, CharSequence input) {
        return Matchers.getNumMatches(pattern.matcher(input));
    }

    private int getMinNumOccurrences(Pattern pattern) {
        return this.patternsThatMustOccur.getMinNumOccurrences(pattern);
    }

    private boolean isValidAccordingToPatternsThatMustNotOccur(CharSequence input) {
        for (Pattern pattern : this.patternsThatMustNotOccur.getPatterns()) {
            if (!this.areTooManyOccurrences(pattern, input)) continue;
            return false;
        }
        return true;
    }

    private boolean areTooManyOccurrences(Pattern pattern, CharSequence input) {
        int numOccurrences = this.getNumOccurrences(pattern, input);
        return numOccurrences > this.getMaxNumOccurrences(pattern);
    }

    private int getMaxNumOccurrences(Pattern pattern) {
        return this.patternsThatMustNotOccur.getMaxNumOccurrences(pattern);
    }
}

