/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.commons.lang;

import com.avaya.commons.lang.ArgAssert;
import com.avaya.commons.lang.CharsetMetadata;
import com.avaya.commons.lang.Charsets;
import com.avaya.commons.lang.PushbackInputStreamCharsetMetadata;
import com.avaya.commons.lang.UnicodeByteOrderMark;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Set;

public final class UnicodeReader
extends Reader {
    private final Set<Charset> charsets = Sets.newHashSet((Object[])new Charset[]{Charsets.UTF_8, Charsets.UTF_16_BIG_ENDIAN, Charsets.UTF_16_LITTLE_ENDIAN});
    private final Reader reader;

    public UnicodeReader(InputStream inputStream) throws IOException {
        ArgAssert.assertNotNull(inputStream, "inputStream");
        PushbackInputStream pushbackInputStream = this.getPushbackInputStream(inputStream);
        CharsetMetadata charsetMetadata = this.getCharsetMetadata(pushbackInputStream);
        this.reader = charsetMetadata.isCharsetSpecified() ? new BufferedReader(new InputStreamReader((InputStream)pushbackInputStream, charsetMetadata.getCharset())) : new BufferedReader(new InputStreamReader(pushbackInputStream));
    }

    private PushbackInputStream getPushbackInputStream(InputStream inputStream) {
        int pushbackBufferSize = UnicodeByteOrderMark.getMaxNumBytes(this.charsets);
        return new PushbackInputStream(inputStream, pushbackBufferSize);
    }

    private CharsetMetadata getCharsetMetadata(PushbackInputStream pushbackInputStream) throws IOException {
        return new PushbackInputStreamCharsetMetadata(this.charsets, pushbackInputStream);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public int read(char[] destinationBuffer, int offset, int maxNumCharsToRead) throws IOException {
        return this.reader.read(destinationBuffer, offset, maxNumCharsToRead);
    }
}

