/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;

public interface DepthWalk {
    public int getDepth();

    default public int getDeepenSince() {
        return 0;
    }

    public RevFlag getUnshallowFlag();

    public RevFlag getReinterestingFlag();

    public static class Commit
    extends RevCommit {
        int depth = -1;
        boolean isBoundary;

        public int getDepth() {
            return this.depth;
        }

        public boolean isBoundary() {
            return this.isBoundary;
        }

        protected Commit(AnyObjectId id) {
            super(id);
        }
    }

    public static class ObjectWalk
    extends org.eclipse.jgit.revwalk.ObjectWalk
    implements DepthWalk {
        private final int depth;
        private int deepenSince;
        private final RevFlag UNSHALLOW;
        private final RevFlag REINTERESTING;

        public ObjectWalk(Repository repo, int depth) {
            super(repo);
            this.depth = depth;
            this.UNSHALLOW = this.newFlag("UNSHALLOW");
            this.REINTERESTING = this.newFlag("REINTERESTING");
        }

        public ObjectWalk(ObjectReader or, int depth) {
            super(or);
            this.depth = depth;
            this.UNSHALLOW = this.newFlag("UNSHALLOW");
            this.REINTERESTING = this.newFlag("REINTERESTING");
        }

        public void markRoot(RevObject o) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            RevObject c = o;
            while (c instanceof RevTag) {
                c = ((RevTag)c).getObject();
                this.parseHeaders(c);
            }
            if (c instanceof Commit) {
                ((Commit)c).depth = 0;
            }
            super.markStart(o);
        }

        public void markUnshallow(RevObject c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            if (c instanceof RevCommit) {
                c.add(this.UNSHALLOW);
            }
            super.markStart(c);
        }

        @Override
        protected RevCommit createCommit(AnyObjectId id) {
            return new Commit(id);
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        public int getDeepenSince() {
            return this.deepenSince;
        }

        @Override
        public RevFlag getUnshallowFlag() {
            return this.UNSHALLOW;
        }

        @Override
        public RevFlag getReinterestingFlag() {
            return this.REINTERESTING;
        }
    }

    public static class RevWalk
    extends org.eclipse.jgit.revwalk.RevWalk
    implements DepthWalk {
        private final int depth;
        private int deepenSince;
        private final RevFlag UNSHALLOW;
        private final RevFlag REINTERESTING;

        public RevWalk(Repository repo, int depth) {
            super(repo);
            this.depth = depth;
            this.UNSHALLOW = this.newFlag("UNSHALLOW");
            this.REINTERESTING = this.newFlag("REINTERESTING");
        }

        public RevWalk(ObjectReader or, int depth) {
            super(or);
            this.depth = depth;
            this.UNSHALLOW = this.newFlag("UNSHALLOW");
            this.REINTERESTING = this.newFlag("REINTERESTING");
        }

        public void markRoot(RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            if (c instanceof Commit) {
                ((Commit)c).depth = 0;
            }
            super.markStart(c);
        }

        @Override
        protected RevCommit createCommit(AnyObjectId id) {
            return new Commit(id);
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        public int getDeepenSince() {
            return this.deepenSince;
        }

        public void setDeepenSince(int limit) {
            this.deepenSince = limit;
        }

        @Override
        public RevFlag getUnshallowFlag() {
            return this.UNSHALLOW;
        }

        @Override
        public RevFlag getReinterestingFlag() {
            return this.REINTERESTING;
        }

        @Override
        public ObjectWalk toObjectWalkWithSameObjects() {
            ObjectWalk ow = new ObjectWalk(this.reader, this.depth);
            ow.deepenSince = this.deepenSince;
            ow.objects = this.objects;
            ow.freeFlags = this.freeFlags;
            return ow;
        }
    }
}

