/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.data.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.collaboration.data.api.AddressType;
import com.avaya.collaboration.data.api.EmailType;
import com.avaya.collaboration.data.api.MobileType;
import com.avaya.collaboration.data.api.model.UserCommProfile;
import com.avaya.collaboration.data.api.model.UserDataAttribute;
import com.avaya.collaboration.data.api.model.UserExtnEntry;
import com.avaya.collaboration.data.api.model.UserHandleAttribute;
import com.avaya.collaboration.data.api.model.UserHandleSubType;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dm.ZephyrDM;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EvictionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class UserDataDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(UserDataDAO.class);
    protected static final String getUserData = "SELECT CSUSER.ID, CSUSER.LOGINNAME, CSUSER.USERNAME, CSUSER.DEFAULTCOMMPROFILESETID, CSUSER.TENANTID, CSUSER.DISPLAYNAMEASCII, CSUSER.SOURCE, CSUSER.DN, CSCOMMPROFILESET.ID AS PROFILEID, CSCOMMPROFILESET.COMMPROFILESETNAME, CSCOMMPROFILESET.CSUSERID FROM CSUSER, CSCOMMPROFILESET WHERE CSUSER.ID = CSCOMMPROFILESET.CSUSERID AND CSUSER.LOGINNAME = ?";
    protected static final String getUserDataByID = "SELECT ID, LOGINNAME, USERNAME, DEFAULTCOMMPROFILESETID, TENANTID, DISPLAYNAMEASCII, SOURCE, DN FROM CSUSER WHERE ID = ?";
    protected static final String getUserHandlesByLoginName = "SELECT ID, HANDLE, CSCOMMPROFILESETID, CSHANDLETYPEID, CSHANDLESUBTYPEID, CSDOMAINID FROM CSHANDLE WHERE CSCOMMPROFILESETID IN (SELECT CSCOMMPROFILESET.ID FROM CSUSER, CSCOMMPROFILESET WHERE CSUSER.ID = CSCOMMPROFILESET.CSUSERID AND CSUSER.LOGINNAME = ?)";
    protected static final String getUserHandleByID = "SELECT ID, HANDLE, CSCOMMPROFILESETID, CSHANDLETYPEID, CSHANDLESUBTYPEID, CSDOMAINID FROM CSHANDLE WHERE ID = ?";
    protected static final String getUserByPhoneNumber = "SELECT LOGINNAME FROM CSUSER WHERE ID IN (SELECT CSUSERID FROM CSCOMMPROFILESET WHERE ID IN (SELECT CSCOMMPROFILESETID FROM CSHANDLE WHERE HANDLE = ? AND CSDOMAINID IN (SELECT ID FROM CSDOMAIN WHERE DOMAINNAME = ?)))";
    protected static final String getUserByHandleName = "SELECT LOGINNAME FROM CSUSER WHERE ID IN (SELECT CSUSERID FROM CSCOMMPROFILESET WHERE ID IN (SELECT CSCOMMPROFILESETID FROM CSHANDLE WHERE HANDLE = ?))";
    protected static final String getDomains = "SELECT ID, DOMAINNAME FROM CSDOMAIN";
    protected static final String getDomainByID = "SELECT ID, DOMAINNAME FROM CSDOMAIN WHERE ID = ?";
    protected static final String getUserProfileByID = "SELECT ID, COMMPROFILESETNAME, CSUSERID FROM CSCOMMPROFILESET WHERE ID = ?";
    protected static final int CACHE_SIZE = 5000;
    protected static final int DEFAULT_DOMAIN = 50;
    protected static final String getUserIdByExtnId = "SELECT ID, CSUSERID FROM CSCOMMPROFILESET WHERE ID = (SELECT CSCOMMPROFILESETID FROM CSCOMMPROFILE WHERE ID = (SELECT ID FROM CMCOMMPROFILE WHERE STATION_ID = (SELECT ID FROM IPT_STATION WHERE EXTENSION_ID = (SELECT STATIONEXTENSION_ID FROM IPT_OFFPBX_STA_MAP  WHERE ID = ( SELECT OFFPBXTEL_STAMAP_ID FROM IPT_OFFPBX_CSP_OPS WHERE APPLICATION = 'EC500' AND ID = ?)))))";
    protected static final String getUserIdByExtnIdAndOPS = "SELECT ID, CSUSERID FROM CSCOMMPROFILESET WHERE ID = (SELECT CSCOMMPROFILESETID FROM CSCOMMPROFILE WHERE ID = (SELECT ID FROM CMCOMMPROFILE WHERE STATION_ID = (SELECT ID FROM IPT_STATION WHERE EXTENSION_ID = (SELECT STATIONEXTENSION_ID FROM IPT_OFFPBX_STA_MAP  WHERE ID = ( SELECT OFFPBXTEL_STAMAP_ID FROM IPT_OFFPBX_CSP_OPS WHERE APPLICATION = 'OPS' AND ID = ?)))))";
    protected static final String getMobileNumbersByUsrId = "SELECT ID, MOBILEPHONE, OTHERMOBILEPHONE FROM CSADDRESS WHERE ID IN (SELECT CSADDRESSID FROM CSUSERADDRESSASSIGN WHERE CSPERSONID = ?)";
    protected static final String getUsrIdByCSAddrsId = "SELECT CSPERSONID FROM CSUSERADDRESSASSIGN WHERE CSADDRESSID = ?";
    protected static final String getMobileNumbersByCSAddrsId = "SELECT ID, MOBILEPHONE, OTHERMOBILEPHONE FROM CSADDRESS WHERE ID = ?";
    protected static final String getExtensionMappingById = "SELECT ID, PHONENUMBER FROM IPT_OFFPBX_CSP_OPS WHERE APPLICATION= 'EC500' AND ID =?";
    protected static final String getUserMobileNumbersByID = "SELECT ID, PHONENUMBER FROM IPT_OFFPBX_CSP_OPS WHERE APPLICATION = 'EC500' AND OFFPBXTEL_STAMAP_ID IN (SELECT ID FROM IPT_OFFPBX_STA_MAP WHERE STATIONEXTENSION_ID IN (SELECT EXTENSION_ID FROM IPT_STATION WHERE ID IN (SELECT STATION_ID FROM CMCOMMPROFILE WHERE ID IN (SELECT ID FROM CSCOMMPROFILE WHERE CSCOMMPROFILESETID IN (SELECT ID FROM CSCOMMPROFILESET WHERE CSUSERID=?)))))";
    protected static final String getAllHandleTypes = "SELECT id, name FROM cshandletypeenum";
    protected static final String getAllHandleSubTypes = "SELECT id, name, cshandletypeid FROM cshandlesubtypeenum";
    private ConcurrentMap<Long, UserDataAttribute> userDataMap;
    private Map<String, Long> userDataMapByLoginName;
    private Map<Long, UserCommProfile> userProfileMap;
    private Map<Long, UserHandleAttribute> userHandleMap;
    private Map<String, Long> handlesByHandleID;
    private Map<Long, String> domains;
    private Map<String, Long> handleTypeMap;
    private Map<Long, UserExtnEntry> offPbxExtnMap;
    private Map<Long, UserExtnEntry> csAddrsMap;
    private Map<String, UserHandleSubType> handleSubTypeMap;
    private EvictionListener<Long, UserDataAttribute> evictionListener = new EvictionListener<Long, UserDataAttribute>(){

        public void onEviction(Long key, UserDataAttribute value) {
            log.fine((Object)("Evicting User with login name " + value.getLoginName() + " from cache."));
            UserDataDAO.this.updateCache(value);
        }
    };
    protected static final ResultSetMapper handleTypeMapper = new ResultSetMapper(){

        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<String, Long> map = new HashMap<String, Long>();
            while (rs.next()) {
                map.put(rs.getString("name"), rs.getLong("id"));
            }
            return map;
        }
    };
    protected static final ResultSetMapper handleSubTypeMapper = new ResultSetMapper(){

        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<String, UserHandleSubType> map = new HashMap<String, UserHandleSubType>();
            while (rs.next()) {
                UserHandleSubType obj = new UserHandleSubType();
                obj.setId(rs.getLong("id"));
                obj.setName(rs.getString("name"));
                obj.setTypeId(rs.getLong("cshandletypeid"));
                map.put(obj.getName(), obj);
            }
            return map;
        }
    };

    public Map<Long, UserExtnEntry> getCsAddrsMap() {
        return this.csAddrsMap;
    }

    public Map<Long, String> getDomains() {
        return this.domains;
    }

    protected Map<String, UserHandleSubType> getHandleSubTypeMap() {
        return this.handleSubTypeMap;
    }

    public Map<Long, UserExtnEntry> getOffPbxExtnMap() {
        return this.offPbxExtnMap;
    }

    protected Map<String, Long> getHandleTypeMap() {
        return this.handleTypeMap;
    }

    public Map<String, Long> getHandlesByHandleID() {
        return this.handlesByHandleID;
    }

    public Map<Long, UserHandleAttribute> getUserHandleMap() {
        return this.userHandleMap;
    }

    public Map<Long, UserCommProfile> getUserProfileMap() {
        return this.userProfileMap;
    }

    public Map<String, Long> getUserDataMapByLoginName() {
        return this.userDataMapByLoginName;
    }

    public ConcurrentMap<Long, UserDataAttribute> getUserDataMap() {
        return this.userDataMap;
    }

    public EvictionListener<Long, UserDataAttribute> getEvictionListener() {
        return this.evictionListener;
    }

    public UserDataDAO() {
        super(true);
        this.userDataMap = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(5000L).listener(this.evictionListener).build();
        this.userDataMapByLoginName = new ConcurrentHashMap<String, Long>();
        this.userProfileMap = new ConcurrentHashMap<Long, UserCommProfile>();
        this.userHandleMap = new ConcurrentHashMap<Long, UserHandleAttribute>();
        this.domains = new ConcurrentHashMap<Long, String>();
        this.handlesByHandleID = new ConcurrentHashMap<String, Long>();
        this.offPbxExtnMap = new ConcurrentHashMap<Long, UserExtnEntry>();
        this.csAddrsMap = new ConcurrentHashMap<Long, UserExtnEntry>();
        this.handleTypeMap = new ConcurrentHashMap<String, Long>();
        this.handleSubTypeMap = new ConcurrentHashMap<String, UserHandleSubType>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (ZephyrDM.isMgmtServer()) {
            log.info((Object)"Skipping initialization of UserDataDAO on management server.");
            return;
        }
        log.fine((Object)"Initializing UserDataDAO...");
        this.setStatus(DataMgr.Status.OKAY);
        Map tmpDomain = null;
        Map handleTypeMapTMP = null;
        Map handleSubTypeMapTMP = null;
        try {
            tmpDomain = (Map)this.dataSource.executeQuery(getDomains, new Object[0], (Object)this.getDomainMapper());
            handleTypeMapTMP = (Map)this.dataSource.executeQuery(getAllHandleTypes, new Object[0], (Object)handleTypeMapper);
            handleSubTypeMapTMP = (Map)this.dataSource.executeQuery(getAllHandleSubTypes, new Object[0], (Object)handleSubTypeMapper);
        }
        catch (DMException e) {
            log.error((Object)("Error while initializing User data dao : " + e.getMessage()));
        }
        try {
            this.lock.acquireWriteLock();
            if (tmpDomain != null) {
                this.domains = tmpDomain;
            }
            if (handleTypeMapTMP != null) {
                this.handleTypeMap = handleTypeMapTMP;
            }
            if (handleSubTypeMapTMP != null) {
                this.handleSubTypeMap = handleSubTypeMapTMP;
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.cleanUP();
    }

    protected void cleanUP() {
        try {
            this.lock.acquireWriteLock();
            log.fine((Object)"Clearing all maps and the cache...");
            this.userDataMap.clear();
            this.userDataMapByLoginName.clear();
            this.userProfileMap.clear();
            this.handlesByHandleID.clear();
            this.offPbxExtnMap.clear();
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public List<String> getDependentTables() {
        return Arrays.asList("csuser", "cscommprofileset", "cshandle", "csdomain", "ipt_offpbx_csp_ops", "csaddress");
    }

    protected Object getMainCollection() {
        return this.userDataMap;
    }

    protected ResultSetMapper getDomainMapper() {
        return new ResultSetMapper(){

            public Map<Long, String> mapResults(ResultSet results) throws SQLException, DMException {
                HashMap<Long, String> map = new HashMap<Long, String>();
                while (results.next()) {
                    map.put(results.getLong("id"), results.getString("domainname"));
                }
                if (!map.isEmpty()) {
                    return map;
                }
                return null;
            }
        };
    }

    protected ResultSetMapper getUserDataAttributeMapperByID() {
        return new ResultSetMapper(){

            public UserDataAttribute mapResults(ResultSet results) throws SQLException, DMException {
                UserDataAttribute tmp = null;
                while (results.next()) {
                    Long id = results.getLong("ID");
                    String loginName = results.getString("loginName");
                    tmp = new UserDataAttribute(id, loginName, results.getString("userName"), results.getLong("DEFAULTCOMMPROFILESETID"), results.getLong("TENANTID"), results.getString("DISPLAYNAMEASCII"), results.getString("SOURCE"), results.getString("DN"));
                }
                return tmp;
            }
        };
    }

    protected ResultSetMapper getExtensionListMapper() {
        return new ResultSetMapper(){

            public Map<Long, String> mapResults(ResultSet results) throws SQLException, DMException {
                HashMap<Long, String> map = new HashMap<Long, String>();
                while (results.next()) {
                    map.put(results.getLong("id"), results.getString("phonenumber"));
                }
                if (!map.isEmpty()) {
                    return map;
                }
                return null;
            }
        };
    }

    protected ResultSetMapper getUserListMapper() {
        return new ResultSetMapper(){

            public Map<Long, Long> mapResults(ResultSet results) throws SQLException, DMException {
                HashMap<Long, Long> map = new HashMap<Long, Long>();
                while (results.next()) {
                    map.put(results.getLong("id"), results.getLong("csuserid"));
                }
                if (!map.isEmpty()) {
                    return map;
                }
                return null;
            }
        };
    }

    protected ResultSetMapper getUserIdMapper() {
        return new ResultSetMapper(){

            public Long mapResults(ResultSet results) throws SQLException, DMException {
                Long id = null;
                while (results.next()) {
                    id = results.getLong("cspersonid");
                }
                return id;
            }
        };
    }

    protected String getActualNameFromType(Long id) {
        for (Map.Entry<String, Long> entry : this.handleTypeMap.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().equals(id)) continue;
            return entry.getKey();
        }
        return null;
    }

    protected String getActualNameFromSubType(Long id) {
        for (Map.Entry<String, UserHandleSubType> entry : this.handleSubTypeMap.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().getId().equals(id)) continue;
            return entry.getKey();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteUserByID(Long id) {
        UserDataAttribute oldObject = null;
        try {
            oldObject = (UserDataAttribute)this.userDataMap.get(id);
            if (oldObject == null) {
                return;
            }
            this.lock.acquireWriteLock();
            log.fine((Object)("Deleting user with id=" + id + " from cache..."));
            Set<UserCommProfile> profileIDs = oldObject.getCommProfiles();
            if (profileIDs != null) {
                for (UserCommProfile p : profileIDs) {
                    Set<Long> hids = p.getHandleIDs();
                    if (hids != null) {
                        for (Long hid : hids) {
                            UserHandleAttribute u = this.userHandleMap.get(hid);
                            if (u.getHandle().contains("@")) {
                                this.handlesByHandleID.remove(u.getHandle());
                            } else {
                                String handleToRemove = u.getHandle() + "@" + this.domains.get(u.getDomainID());
                                this.handlesByHandleID.remove(handleToRemove);
                            }
                            this.userHandleMap.remove(hid);
                        }
                    }
                    this.userProfileMap.remove(p.getProfileID());
                }
            }
            this.userDataMapByLoginName.remove(oldObject.getLoginName());
            this.userDataMap.remove(id);
            log.fine((Object)("user with id=" + id + " deleted from cache"));
            for (Long extnId : oldObject.getExtensionIdList()) {
                this.offPbxExtnMap.remove(extnId);
            }
            log.fine((Object)("user extension mapping removed for user " + id));
        }
        catch (Exception e) {
            log.error((Object)("Error while deleting user with id=" + id + " from cache : " + e.getMessage()));
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    protected void updateCache(UserDataAttribute user) {
        try {
            log.fine((Object)("Updating cache for user with login name " + user.getLoginName()));
            Set<UserCommProfile> profileIDs = user.getCommProfiles();
            if (profileIDs != null) {
                for (UserCommProfile p : profileIDs) {
                    Set<Long> hids = p.getHandleIDs();
                    if (hids != null) {
                        for (Long hid : hids) {
                            UserHandleAttribute u = this.userHandleMap.get(hid);
                            if (u.getHandle().contains("@")) {
                                this.handlesByHandleID.remove(u.getHandle());
                            } else {
                                String handleToRemove = u.getHandle() + "@" + this.domains.get(u.getDomainID());
                                this.handlesByHandleID.remove(handleToRemove);
                            }
                            this.userHandleMap.remove(hid);
                        }
                    }
                    this.userProfileMap.remove(p.getProfileID());
                }
            }
            this.userDataMapByLoginName.remove(user.getLoginName());
            List<Long> extnIdList = user.getExtensionIdList();
            for (Long extId : extnIdList) {
                if (!this.offPbxExtnMap.containsKey(extId)) continue;
                this.offPbxExtnMap.remove(extId);
                log.fine((Object)("evicted extensionId " + extId + " for User =" + user.getLoginName()));
            }
            log.fine((Object)("user with login name " + user.getLoginName() + " updated into the cache"));
        }
        catch (Exception e) {
            log.error((Object)("Error while updating user with login name=" + user.getLoginName() + " from cache : "), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCSUser(Long id, DAOReplicationEvent.OperationType operation) {
        log.fine((Object)("An update is received for csuser with an id=" + id));
        log.fine((Object)("Operation Type: " + operation));
        if (!this.userDataMap.containsKey(id)) {
            log.fine((Object)("User with id=" + id + " not present in cache."));
            return;
        }
        UserDataAttribute oldObject = null;
        UserDataAttribute newObject = null;
        try {
            if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE) && (newObject = (UserDataAttribute)this.dataSource.executeQuery(getUserDataByID, new Object[]{id}, (Object)this.getUserDataAttributeMapperByID())) == null) {
                return;
            }
            switch (operation) {
                case DELETE: {
                    this.deleteUserByID(id);
                    break;
                }
                case UPDATE: {
                    try {
                        String newDN;
                        String newSource;
                        if (newObject == null) {
                            return;
                        }
                        oldObject = (UserDataAttribute)this.userDataMap.get(id);
                        Long oldProfileID = oldObject.getDefCommProfileID();
                        String oldLoginName = oldObject.getLoginName();
                        String oldDisplayNameAscii = oldObject.getDisplayNameAscii();
                        String oldSource = oldObject.getSource();
                        String oldDN = oldObject.getDistinguishedName();
                        if (newObject.getDefCommProfileID().longValue() != oldProfileID.longValue()) {
                            log.fine((Object)("Default profile is changed from " + oldProfileID + " to " + newObject.getDefCommProfileID()));
                            oldObject.setDefCommProfileID(newObject.getDefCommProfileID());
                        }
                        if (!newObject.getLoginName().equalsIgnoreCase(oldLoginName)) {
                            log.fine((Object)("User's login name is changed from " + oldLoginName + " to " + newObject.getLoginName()));
                            oldObject.setLoginName(newObject.getLoginName());
                        }
                        if (!newObject.getDisplayNameAscii().equalsIgnoreCase(oldDisplayNameAscii)) {
                            log.fine((Object)("User's display name is changed from " + oldDisplayNameAscii + " to " + newObject.getDisplayNameAscii()));
                            oldObject.setDisplayNameAscii(newObject.getDisplayNameAscii());
                        }
                        if ((newSource = newObject.getSource()) == null || !newSource.equalsIgnoreCase(oldSource)) {
                            if (log.isFineEnabled()) {
                                log.fine((Object)("User's source is changed from " + oldSource + " to " + newSource));
                            }
                            oldObject.setSource(newSource);
                        }
                        if ((newDN = newObject.getDistinguishedName()) == null || !newDN.equalsIgnoreCase(oldDN)) {
                            if (log.isFineEnabled()) {
                                log.fine((Object)("User's DN is changed from " + oldDN + " to " + newDN));
                            }
                            oldObject.setDistinguishedName(newDN);
                        }
                        this.lock.acquireWriteLock();
                        this.userDataMapByLoginName.remove(oldLoginName);
                        this.userDataMapByLoginName.put(newObject.getLoginName(), oldObject.getId());
                        this.userDataMap.put(id, oldObject);
                        log.fine((Object)("User state changed successfully..." + oldObject));
                        break;
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                }
                case INSERT: {
                    log.fine((Object)"Don't do any thing for new entries");
                    break;
                }
                default: {
                    log.fine((Object)"This is not a DB supported operation.");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while updating cache for csuser table : ", (Throwable)e);
        }
    }

    protected ResultSetMapper getUserProfileMapper() {
        return new ResultSetMapper(){

            public UserCommProfile mapResults(ResultSet results) throws SQLException, DMException {
                if (results.next()) {
                    Long pid = results.getLong("ID");
                    String profileName = results.getString("commprofilesetname");
                    Long uid = results.getLong("csuserid");
                    return new UserCommProfile(pid, profileName, uid);
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateUserProfile(Long id, DAOReplicationEvent.OperationType operation) {
        log.fine((Object)("An update is received for cscommprofileset with an id=" + id));
        UserCommProfile oldObject = null;
        UserCommProfile newObject = null;
        try {
            newObject = (UserCommProfile)this.dataSource.executeQuery(getUserProfileByID, new Object[]{id}, (Object)this.getUserProfileMapper());
            if (newObject != null && !this.userDataMap.containsKey(newObject.getUserID())) {
                log.fine((Object)("User holding the profile with id=" + id + " not present in cache."));
                return;
            }
            switch (operation) {
                case DELETE: {
                    if (!this.userProfileMap.containsKey(id)) {
                        log.fine((Object)("User's commprofile with id " + id + " not present in cache"));
                        return;
                    }
                    try {
                        log.fine((Object)("Deleting user's comm profile with id=" + id + " from cache"));
                        oldObject = this.userProfileMap.get(id);
                        Set<Long> hids = oldObject.getHandleIDs();
                        this.lock.acquireWriteLock();
                        if (hids != null) {
                            for (Long hid : hids) {
                                UserHandleAttribute uha = this.userHandleMap.get(hid);
                                if (uha.getHandle().contains("@")) {
                                    this.handlesByHandleID.remove(uha.getHandle());
                                } else {
                                    String handleToRemove = uha.getHandle() + "@" + this.domains.get(uha.getDomainID());
                                    this.handlesByHandleID.remove(handleToRemove);
                                }
                                this.userHandleMap.remove(hid);
                            }
                        }
                        if (this.userDataMap.containsKey(oldObject.getUserID())) {
                            ((UserDataAttribute)this.userDataMap.get(oldObject.getUserID())).getCommProfiles().remove(oldObject);
                        }
                        this.userProfileMap.remove(id);
                        log.fine((Object)("User comm profile with id=" + id + " deleted successfully..."));
                        break;
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                }
                case UPDATE: {
                    if (newObject == null) {
                        return;
                    }
                    log.fine((Object)("Updating user's comm profile with id=" + id + " into the cache"));
                    oldObject = this.userProfileMap.get(id);
                    if (oldObject.equals(newObject)) {
                        return;
                    }
                    oldObject.setProfileName(newObject.getProfileName());
                    try {
                        this.lock.acquireWriteLock();
                        this.userProfileMap.put(id, oldObject);
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                    log.fine((Object)("User comm profile with id=" + id + " updated successfully..."));
                    break;
                }
                case INSERT: {
                    if (newObject == null) {
                        return;
                    }
                    try {
                        log.fine((Object)("Inserting user's comm profile with id=" + id + " into the cache"));
                        this.lock.acquireWriteLock();
                        this.userProfileMap.put(id, newObject);
                        if (this.userDataMap.containsKey(newObject.getUserID())) {
                            ((UserDataAttribute)this.userDataMap.get(newObject.getUserID())).getCommProfiles().add(newObject);
                        }
                        this.addExtensionMappingForProfile(id, newObject.getUserID());
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                    log.fine((Object)("User comm profile with id=" + id + " inserted successfully..."));
                    break;
                }
                default: {
                    log.fine((Object)"This is not a DB supported operation.");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while updating cache for cscommprofileset table : ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCSHandle(Long id, DAOReplicationEvent.OperationType operation) {
        log.fine((Object)("An update is received for cshandle table with an id=" + id));
        UserHandleAttribute oldObject = null;
        UserHandleAttribute newObject = null;
        try {
            Long profileID;
            newObject = (UserHandleAttribute)this.dataSource.executeQuery(getUserHandleByID, new Object[]{id}, (Object)this.getUserHandleAttributeMapperByID());
            if (newObject != null && !this.userProfileMap.containsKey(profileID = newObject.getCommProfileID())) {
                log.fine((Object)"User profile not found in cache.");
                return;
            }
            switch (operation) {
                case DELETE: {
                    if (!this.userHandleMap.containsKey(id)) {
                        log.fine((Object)("Handle with id " + id + " not present in cache."));
                        return;
                    }
                    try {
                        log.fine((Object)("Deleting handle with id=" + id + " from cache"));
                        oldObject = this.userHandleMap.get(id);
                        profileID = oldObject.getCommProfileID();
                        String handle = oldObject.getHandle();
                        this.lock.acquireWriteLock();
                        if (handle.contains("@")) {
                            this.handlesByHandleID.remove(handle);
                        } else {
                            String handleToRemove = handle + "@" + this.domains.get(oldObject.getDomainID());
                            this.handlesByHandleID.remove(handleToRemove);
                        }
                        this.userHandleMap.remove(id);
                        this.userProfileMap.get(profileID).getHandleIDs().remove(id);
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                    log.fine((Object)("Handle with id=" + id + " deleted from cache"));
                    break;
                }
                case UPDATE: {
                    oldObject = this.userHandleMap.get(id);
                    if (newObject == null) {
                        return;
                    }
                    log.fine((Object)("Updating handle with id=" + id + " into the cache"));
                    String oldHandle = oldObject.getHandle();
                    String handle = newObject.getHandle();
                    if (!oldHandle.equalsIgnoreCase(handle)) {
                        try {
                            this.lock.acquireWriteLock();
                            if (handle.contains("@")) {
                                this.handlesByHandleID.remove(oldHandle);
                                this.handlesByHandleID.put(handle, newObject.getId());
                            } else {
                                String handleToRemove = oldHandle + "@" + this.domains.get(oldObject.getDomainID());
                                String handleToAdd = handle + "@" + this.domains.get(newObject.getDomainID());
                                this.handlesByHandleID.remove(handleToRemove);
                                this.handlesByHandleID.put(handleToAdd, newObject.getId());
                            }
                            this.userHandleMap.put(id, newObject);
                        }
                        finally {
                            this.lock.releaseWriteLock();
                        }
                    }
                    log.fine((Object)("Handle with id=" + id + " updated"));
                    break;
                }
                case INSERT: {
                    if (newObject == null) {
                        return;
                    }
                    log.fine((Object)("Inserting handle with id=" + id + " into the cache"));
                    try {
                        this.lock.acquireWriteLock();
                        this.userHandleMap.put(id, newObject);
                        Long profileID2 = newObject.getCommProfileID();
                        if (this.userProfileMap.get(profileID2).getHandleIDs() != null) {
                            this.userProfileMap.get(profileID2).getHandleIDs().add(id);
                        } else {
                            HashSet<Long> handles = new HashSet<Long>();
                            handles.add(id);
                            this.userProfileMap.get(profileID2).setHandleIDs(handles);
                        }
                        String newhandle = newObject.getHandle();
                        if (newhandle.contains("@")) {
                            this.handlesByHandleID.put(newhandle, newObject.getId());
                        } else {
                            String handleToAdd = newhandle + "@" + this.domains.get(newObject.getDomainID());
                            this.handlesByHandleID.put(handleToAdd, newObject.getId());
                        }
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                    log.fine((Object)("Handle with id=" + id + " inserted"));
                    break;
                }
                default: {
                    log.fine((Object)"This is not a DB supported operation.");
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while updating cache for cshandle table : ", (Throwable)e);
        }
    }

    public void updateDAO(DAOTableEvent tableEvent) {
        String tableName = tableEvent.getTableName();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        Long id = tableEvent.getKey();
        if (tableName.equals("csuser")) {
            this.updateCSUser(id, operation);
            return;
        }
        if (tableName.equals("cscommprofileset")) {
            this.updateUserProfile(id, operation);
            return;
        }
        if (tableName.equals("cshandle")) {
            this.updateCSHandle(id, operation);
            return;
        }
        if (tableName.equals("csdomain")) {
            this.updateDomain(id, operation);
            return;
        }
        if (tableName.equals("ipt_offpbx_csp_ops")) {
            this.updateOffPbxStationMapId(id, operation);
            return;
        }
        if (tableName.equals("csaddress")) {
            this.updateCSAddressMapId(id, operation);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDomain(Long id, DAOReplicationEvent.OperationType operation) {
        log.fine((Object)("An update is received for csdomain table with an id=" + id));
        Map map = null;
        Map.Entry entry = null;
        try {
            if (!operation.equals((Object)DAOReplicationEvent.OperationType.DELETE) && (map = (Map)this.dataSource.executeQuery(getDomainByID, new Object[]{id}, (Object)this.getDomainMapper())) != null && !map.isEmpty()) {
                entry = (Map.Entry)map.entrySet().toArray()[0];
            }
            switch (operation) {
                case DELETE: {
                    try {
                        this.lock.acquireWriteLock();
                        this.domains.remove(id);
                        break;
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                }
                case UPDATE: 
                case INSERT: {
                    if (entry == null) {
                        return;
                    }
                    try {
                        this.lock.acquireWriteLock();
                        this.domains.put(id, (String)entry.getValue());
                        break;
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                }
                default: {
                    log.fine((Object)"Do nothing...");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while updating csdomain table : " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserDataAttribute getUser(String loginName) {
        UserDataAttribute obj = null;
        log.fine((Object)("Loading User with login name : " + loginName + " from database"));
        obj = this.loadUserFromDB(loginName);
        if (obj == null) {
            log.fine((Object)("User with login name : " + loginName + " not found in database"));
            return null;
        }
        try {
            log.fine((Object)("User with login name : " + loginName + " found in database. caching it"));
            this.lock.acquireWriteLock();
            this.userDataMap.put(obj.getId(), obj);
            this.userDataMapByLoginName.put(obj.getLoginName(), obj.getId());
        }
        finally {
            this.lock.releaseWriteLock();
        }
        Map<Long, Set<Long>> handleMap = this.loadUserHandlesFromDB(loginName);
        try {
            this.lock.acquireWriteLock();
            if (handleMap == null || handleMap.isEmpty()) {
                Set<UserCommProfile> commProfiles = obj.getCommProfiles();
                for (UserCommProfile pro : commProfiles) {
                    this.userProfileMap.put(pro.getProfileID(), pro);
                }
            } else {
                Set<UserCommProfile> commProfiles = obj.getCommProfiles();
                for (UserCommProfile pro : commProfiles) {
                    this.userProfileMap.put(pro.getProfileID(), pro);
                    if (!handleMap.containsKey(pro.getProfileID())) continue;
                    pro.setHandleIDs(handleMap.get(pro.getProfileID()));
                    this.addExtensionMappingForProfile(pro.getProfileID(), obj.getId());
                }
                this.addMobileFromCSAddressForUser(obj.getId());
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
        return obj;
    }

    protected UserDataAttribute loadUserFromDB(String loginName) {
        UserDataAttribute obj;
        block5: {
            obj = null;
            try {
                obj = (UserDataAttribute)this.dataSource.executeQuery(getUserData, new Object[]{loginName}, (Object)this.getUserDataAttributeMapper());
                if (obj == null) break block5;
                try {
                    this.lock.acquireWriteLock();
                    this.userDataMap.put(obj.getId(), obj);
                    this.userDataMapByLoginName.put(obj.getLoginName(), obj.getId());
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                log.error((Object)("Error while loading user from database " + e.getMessage()));
            }
        }
        return obj;
    }

    protected Map<Long, Set<Long>> loadUserHandlesFromDB(String loginName) {
        try {
            Map map = (Map)this.dataSource.executeQuery(getUserHandlesByLoginName, new Object[]{loginName}, (Object)this.getUserHandleAttributeMapper());
            if (map != null && !map.isEmpty()) {
                return map;
            }
        }
        catch (DMException e) {
            log.error((Object)("Error while loading user handle from database " + e.getMessage()));
        }
        return null;
    }

    protected String searchUserInDB(String phoneNumber) {
        if (phoneNumber == null || phoneNumber.equals("")) {
            return null;
        }
        log.fine((Object)("Searching user for phone number " + phoneNumber));
        if (phoneNumber.contains("@")) {
            log.fine((Object)"Phone number has domain part...");
            int index = phoneNumber.indexOf(64);
            String handlePart = phoneNumber.substring(0, index);
            String domainPart = phoneNumber.substring(index + 1);
            try {
                String loginName = (String)this.dataSource.executeQuery(getUserByPhoneNumber, new Object[]{handlePart, domainPart}, (Object)this.getUserSearchMapper());
                if (loginName != null && !loginName.isEmpty()) {
                    this.getUser(loginName);
                    return loginName;
                }
                return null;
            }
            catch (DMException e) {
                log.error((Object)("Error while searching user in database " + e.getMessage()));
            }
        } else {
            try {
                log.fine((Object)"Phone number has no domain part...");
                List users = (List)this.dataSource.executeQuery(getUserByHandleName, new Object[]{phoneNumber}, (Object)this.getUserSearchMapperByHandleName());
                if (users == null) {
                    return null;
                }
                if (users.size() > 1) {
                    throw new IllegalArgumentException("Multiple users found");
                }
                String loginName = (String)users.get(0);
                if (!this.userDataMapByLoginName.containsKey(loginName)) {
                    this.getUser(loginName);
                }
                return loginName;
            }
            catch (DMException e) {
                log.error((Object)("Error while searching user in database " + e.getMessage()));
            }
        }
        return null;
    }

    protected ResultSetMapper getUserSearchMapper() {
        return new ResultSetMapper(){

            public String mapResults(ResultSet results) throws SQLException, DMException {
                String loginName = null;
                while (results.next()) {
                    loginName = results.getString("loginName");
                }
                if (loginName != null) {
                    return loginName;
                }
                return null;
            }
        };
    }

    protected ResultSetMapper getUserSearchMapperByHandleName() {
        return new ResultSetMapper(){

            public List<String> mapResults(ResultSet results) throws SQLException, DMException {
                ArrayList<String> list = new ArrayList<String>();
                while (results.next()) {
                    list.add(results.getString("loginName"));
                }
                if (list != null && !list.isEmpty()) {
                    return list;
                }
                return null;
            }
        };
    }

    @SMConsole(description="Get all SMGR User Data")
    public Map<Long, UserDataAttribute> getAllUserData() {
        return this.userDataMap;
    }

    @SMConsole(description="Get User Data Attribute by Login Name")
    public UserDataAttribute getUserByLoginName(String loginName) {
        if (this.userDataMapByLoginName.containsKey(loginName)) {
            log.fine((Object)"User found in cache...");
            return (UserDataAttribute)this.userDataMap.get(this.userDataMapByLoginName.get(loginName));
        }
        log.fine((Object)"User not found in cache. Load it from DB");
        UserDataAttribute u = this.getUser(loginName);
        if (u != null) {
            log.fine((Object)("User loaded from DB " + loginName));
            return u;
        }
        log.fine((Object)("User not found any where..." + loginName));
        return null;
    }

    @SMConsole(description="GET Phone Number By Login Name")
    public Map<String, List<String>> getPhoneNumbersByLoginName(String loginName) {
        Map<String, List<String>> phoneNumbers = null;
        if (this.userDataMapByLoginName.containsKey(loginName)) {
            log.fine((Object)("User with login name " + loginName + " found in cache."));
            phoneNumbers = this.getPhoneNumbers(((UserDataAttribute)this.userDataMap.get(this.userDataMapByLoginName.get(loginName))).getCommProfiles());
        } else {
            UserDataAttribute u = this.getUser(loginName);
            if (u == null) {
                log.fine((Object)("User with login name " + loginName + " not found in our record."));
                return null;
            }
            phoneNumbers = this.getPhoneNumbers(u.getCommProfiles());
        }
        if (phoneNumbers != null && !phoneNumbers.isEmpty()) {
            return Collections.unmodifiableMap(phoneNumbers);
        }
        return null;
    }

    protected Map<String, List<String>> getPhoneNumbers(Set<UserCommProfile> profiles) {
        if (profiles == null || profiles.isEmpty()) {
            return null;
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (UserCommProfile p : profiles) {
            List<String> phoneNumbersByProfileID = this.getPhoneNumbers(p.getProfileID());
            if (phoneNumbersByProfileID == null || phoneNumbersByProfileID.isEmpty()) continue;
            result.put(p.getProfileName(), phoneNumbersByProfileID);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    protected List<String> getPhoneNumbers(Long profileID) {
        UserCommProfile profile;
        Set<Long> associatedHandleIDs;
        log.fine((Object)("Requesting to fetch phone numbers for profile " + profileID));
        ArrayList<String> list = new ArrayList<String>();
        if (this.userProfileMap.containsKey(profileID) && (associatedHandleIDs = (profile = this.userProfileMap.get(profileID)).getHandleIDs()) != null) {
            Iterator<Long> hids = associatedHandleIDs.iterator();
            while (hids.hasNext()) {
                UserHandleAttribute u = this.userHandleMap.get(hids.next());
                if (u.getType() == null || !u.getType().equals(this.handleTypeMap.get(AddressType.OTHER_SIP.getValue()))) continue;
                if (u.getDomainID() != 50L) {
                    String phoneToAdd;
                    if (u.getSubType() != null && u.getSubType().equals(this.handleSubTypeMap.get(AddressType.AVAYA_E164.getValue()).getId())) {
                        phoneToAdd = u.getHandle() + "@" + this.domains.get(u.getDomainID());
                        list.add(phoneToAdd);
                    }
                    phoneToAdd = u.getHandle() + "@" + this.domains.get(u.getDomainID());
                    list.add(phoneToAdd);
                    continue;
                }
                String handle = u.getHandle();
                list.add(handle);
            }
        }
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    @SMConsole(description="GET Emails by Login Name")
    public Map<String, Map<EmailType, List<String>>> getEmailsByLoginName(String loginName) {
        Map<String, Map<EmailType, List<String>>> emails = null;
        if (this.userDataMapByLoginName.containsKey(loginName)) {
            log.fine((Object)("User with login name " + loginName + " found in cache."));
            emails = this.getEmails(((UserDataAttribute)this.userDataMap.get(this.userDataMapByLoginName.get(loginName))).getCommProfiles());
        } else {
            UserDataAttribute u = this.getUser(loginName);
            if (u == null) {
                log.fine((Object)("User with login name " + loginName + " not found in our record."));
                return null;
            }
            emails = this.getEmails(u.getCommProfiles());
        }
        if (emails != null && !emails.isEmpty()) {
            return Collections.unmodifiableMap(emails);
        }
        return null;
    }

    protected Map<String, Map<EmailType, List<String>>> getEmails(Set<UserCommProfile> profiles) {
        if (profiles == null || profiles.isEmpty()) {
            return null;
        }
        HashMap<String, Map<EmailType, List<String>>> result = new HashMap<String, Map<EmailType, List<String>>>();
        for (UserCommProfile p : profiles) {
            Map<EmailType, List<String>> emailsByProfileID = this.getEmails(p.getProfileID());
            if (emailsByProfileID == null || emailsByProfileID.isEmpty()) continue;
            result.put(p.getProfileName(), emailsByProfileID);
        }
        return result;
    }

    protected Map<EmailType, List<String>> getEmails(Long profileID) {
        UserCommProfile profile;
        Set<Long> associatedHandleIDs;
        HashMap<EmailType, List<String>> map = new HashMap<EmailType, List<String>>();
        ArrayList<String> microsoftExchange = new ArrayList<String>();
        ArrayList<String> otherEmails = new ArrayList<String>();
        if (this.userProfileMap.containsKey(profileID) && (associatedHandleIDs = (profile = this.userProfileMap.get(profileID)).getHandleIDs()) != null) {
            Iterator<Long> hids = associatedHandleIDs.iterator();
            while (hids.hasNext()) {
                UserHandleAttribute u = this.userHandleMap.get(hids.next());
                if (u.getType() == null || !u.getType().equals(this.handleTypeMap.get(AddressType.OTHER_EMAIL.getValue()))) continue;
                if (u.getSubType() != null && u.getSubType().equals(this.handleSubTypeMap.get(AddressType.MICROSOFT_EXCHANGE.getValue()).getId())) {
                    microsoftExchange.add(u.getHandle());
                    continue;
                }
                otherEmails.add(u.getHandle());
            }
        }
        if (microsoftExchange.isEmpty() && otherEmails.isEmpty()) {
            log.fine((Object)"No email address is linked to this user");
            return null;
        }
        map.put(EmailType.MICROSOFT_EXCHANGE, microsoftExchange);
        map.put(EmailType.OTHER_EMAIL, otherEmails);
        return map;
    }

    @SMConsole(description="GET All Communication Address By Login Name")
    public Map<String, Map<AddressType, List<String>>> getAllCommunicationAddresses(String loginName) {
        Map<String, Map<AddressType, List<String>>> allCommAddress = null;
        if (this.userDataMapByLoginName.containsKey(loginName)) {
            log.fine((Object)("User with login name " + loginName + " found in cache."));
            allCommAddress = this.getAllCommunicationAddress(((UserDataAttribute)this.userDataMap.get(this.userDataMapByLoginName.get(loginName))).getCommProfiles());
        } else {
            UserDataAttribute u = this.getUser(loginName);
            if (u == null) {
                log.fine((Object)("User with login name " + loginName + " not found in our record."));
                return null;
            }
            allCommAddress = this.getAllCommunicationAddress(u.getCommProfiles());
        }
        if (allCommAddress != null && !allCommAddress.isEmpty()) {
            return Collections.unmodifiableMap(allCommAddress);
        }
        return null;
    }

    protected void addToMap(Map<AddressType, List<String>> map, String addName, String handle) {
        AddressType tmpAddrEnum = AddressType.getAddressNameByValue((String)addName);
        log.finest((Object)("inside addToMap for address type:" + tmpAddrEnum));
        if (map.containsKey(tmpAddrEnum)) {
            List<String> tmp = map.get(tmpAddrEnum);
            tmp.add(handle);
            map.put(tmpAddrEnum, tmp);
        } else {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add(handle);
            map.put(tmpAddrEnum, tmp);
        }
    }

    protected Map<String, Map<AddressType, List<String>>> getAllCommunicationAddress(Set<UserCommProfile> profiles) {
        if (profiles == null || profiles.isEmpty()) {
            return null;
        }
        HashMap<String, Map<AddressType, List<String>>> map = new HashMap<String, Map<AddressType, List<String>>>();
        for (UserCommProfile p : profiles) {
            Long profileID = p.getProfileID();
            Map<AddressType, List<String>> tmpMap = this.getAllCommunicationAddress(profileID);
            if (tmpMap == null || tmpMap.isEmpty()) continue;
            map.put(p.getProfileName(), tmpMap);
        }
        if (!map.isEmpty()) {
            return map;
        }
        return null;
    }

    protected Map<AddressType, List<String>> getAllCommunicationAddress(Long profileID) {
        UserCommProfile profile;
        Set<Long> associatedHandleIDs;
        if (profileID == null) {
            return null;
        }
        HashMap<AddressType, List<String>> map = new HashMap<AddressType, List<String>>();
        if (this.userProfileMap.containsKey(profileID) && (associatedHandleIDs = (profile = this.userProfileMap.get(profileID)).getHandleIDs()) != null) {
            Iterator<Long> hids = associatedHandleIDs.iterator();
            while (hids.hasNext()) {
                UserHandleAttribute u = this.userHandleMap.get(hids.next());
                String addName = this.getActualNameFromSubType(u.getSubType());
                if (addName == null || addName.isEmpty()) {
                    addName = this.getActualNameFromType(u.getType());
                }
                String phoneToAdd = this.getPhoneToAdd(u);
                if (addName == null || phoneToAdd.isEmpty()) continue;
                this.addToMap(map, addName, phoneToAdd);
            }
        }
        if (!map.isEmpty()) {
            return map;
        }
        return null;
    }

    private String getPhoneToAdd(UserHandleAttribute u) {
        String phoneToAdd = "";
        phoneToAdd = u.getDomainID() != 50L ? u.getHandle() + "@" + this.domains.get(u.getDomainID()) : u.getHandle();
        return phoneToAdd;
    }

    @SMConsole(description="GET Login Name by Phone Number")
    public String getLoginNameByPhoneNumber(String phoneNumber) {
        String loginName = null;
        if (this.handlesByHandleID.containsKey(phoneNumber)) {
            UserCommProfile pro;
            log.fine((Object)"User found in cache");
            UserHandleAttribute u = this.userHandleMap.get(this.handlesByHandleID.get(phoneNumber));
            if (u != null && (pro = this.userProfileMap.get(u.getCommProfileID())) != null) {
                loginName = ((UserDataAttribute)this.userDataMap.get(pro.getUserID())).getLoginName();
                return loginName;
            }
        }
        log.fine((Object)"User not present in cache, searching in DB");
        try {
            loginName = this.searchUserInDB(phoneNumber);
        }
        catch (IllegalArgumentException e) {
            log.fine((Object)("Multiple Users found with phone number " + phoneNumber));
            return null;
        }
        if (loginName != null && !loginName.isEmpty()) {
            return loginName;
        }
        log.fine((Object)("User Not Found with phone number " + phoneNumber));
        return null;
    }

    @SMConsole(description="GET Tenant ID by Login Name")
    public String getTenantID(String loginName) {
        if (this.userDataMapByLoginName.containsKey(loginName)) {
            log.fine((Object)("User with login name " + loginName + " found in cache."));
            return ((UserDataAttribute)this.userDataMap.get(this.userDataMapByLoginName.get(loginName))).getTenantID().toString();
        }
        UserDataAttribute u = this.getUser(loginName);
        if (u == null) {
            log.fine((Object)("User with login name " + loginName + " not found in our record."));
            return null;
        }
        return u.getTenantID().toString();
    }

    @SMConsole(description="GET MOBILE NUMBERS BY Login Name")
    public final Map<MobileType, List<String>> getMobileNumbers(String loginName) {
        UserExtnEntry temp;
        log.fine((Object)("getMobileNumbers() called with loginName " + loginName));
        HashMap<MobileType, List<String>> resultMap = new HashMap<MobileType, List<String>>();
        List<Long> extnList = null;
        List<Long> addrsList = null;
        if (this.userDataMapByLoginName.containsKey(loginName)) {
            Long csUserId = this.userDataMapByLoginName.get(loginName);
            if (this.userDataMap.containsKey(csUserId)) {
                extnList = ((UserDataAttribute)this.userDataMap.get(csUserId)).getExtensionIdList();
                addrsList = ((UserDataAttribute)this.userDataMap.get(csUserId)).getAddressIdList();
            }
        } else {
            UserDataAttribute ud;
            log.fine((Object)("user with loginName " + loginName + " not found in cache, checking the db"));
            this.getUser(loginName);
            Long userId = this.userDataMapByLoginName.get(loginName);
            if (userId != null && (ud = (UserDataAttribute)this.userDataMap.get(userId)) != null) {
                extnList = ud.getExtensionIdList();
                addrsList = ud.getAddressIdList();
            }
        }
        if (extnList != null && !extnList.isEmpty()) {
            ArrayList<String> extnValues = new ArrayList<String>();
            for (Long l : extnList) {
                temp = this.offPbxExtnMap.get(l);
                extnValues.add(temp.getMobileNumber());
            }
            resultMap.put(MobileType.EC500, extnValues);
        }
        if (addrsList != null && !addrsList.isEmpty()) {
            ArrayList<String> addrsValues = new ArrayList<String>();
            for (Long l : addrsList) {
                temp = this.csAddrsMap.get(l);
                if (temp.getMobileNumber() != null && !temp.getMobileNumber().isEmpty()) {
                    addrsValues.add(temp.getMobileNumber());
                }
                if (temp.getOtherMobile() == null || temp.getOtherMobile().isEmpty()) continue;
                addrsValues.add(temp.getOtherMobile());
            }
            resultMap.put(MobileType.MOBILE, addrsValues);
        }
        log.fine((Object)("getMobileNumbers(), final resultMap obtained " + resultMap));
        log.fine((Object)"returning from getMobileNumbers()");
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOffPbxStationMapId(Long id, DAOReplicationEvent.OperationType oper) {
        log.fine((Object)("updateOffPbxStationMapId with Id " + id + " operation " + oper));
        Map map = null;
        Map.Entry entry = null;
        try {
            if (!oper.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
                map = (Map)this.dataSource.executeQuery(getExtensionMappingById, new Object[]{id}, (Object)this.getExtensionListMapper());
                if ((map == null || map.isEmpty()) && this.offPbxExtnMap.containsKey(id)) {
                    oper = DAOReplicationEvent.OperationType.DELETE;
                }
                if (map != null && !map.isEmpty()) {
                    entry = (Map.Entry)map.entrySet().toArray()[0];
                }
            }
            switch (oper) {
                case DELETE: {
                    try {
                        this.lock.acquireWriteLock();
                        if (this.offPbxExtnMap.containsKey(id)) {
                            UserExtnEntry deletedEntry = this.offPbxExtnMap.get(id);
                            this.offPbxExtnMap.remove(id);
                            Long csuserid = deletedEntry.getCsUserId();
                            if (this.userDataMap.containsKey(csuserid)) {
                                List<Long> idList = ((UserDataAttribute)this.userDataMap.get(csuserid)).getExtensionIdList();
                                idList.remove(id);
                                ((UserDataAttribute)this.userDataMap.get(csuserid)).setExtensionIdList(idList);
                            } else {
                                log.fine((Object)("updateOffPbxStationMapId no user association found for entry " + entry));
                            }
                            log.fine((Object)("entry removed from the offPbxExtnMap. " + entry));
                        }
                        break;
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                }
                case UPDATE: {
                    if (entry == null) {
                        return;
                    }
                    if (!this.offPbxExtnMap.containsKey(entry.getKey())) break;
                    try {
                        this.lock.acquireWriteLock();
                        UserExtnEntry temp = this.offPbxExtnMap.get(entry.getKey());
                        temp.setMobileNumber((String)entry.getValue());
                        this.offPbxExtnMap.put(id, temp);
                        log.info((Object)"updateOffPbxStationMapId, update is successful");
                        break;
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                }
                case INSERT: {
                    if (entry == null) {
                        return;
                    }
                    try {
                        Map.Entry temp;
                        this.lock.acquireWriteLock();
                        Long csuserid = null;
                        Map userMap = (Map)this.dataSource.executeQuery(getUserIdByExtnId, new Object[]{id}, (Object)this.getUserListMapper());
                        if (userMap != null && !userMap.isEmpty() && this.userDataMap.containsKey(csuserid = (Long)(temp = (Map.Entry)userMap.entrySet().toArray()[0]).getValue())) {
                            List<Long> idList = ((UserDataAttribute)this.userDataMap.get(csuserid)).getExtensionIdList();
                            idList.add((Long)entry.getKey());
                            ((UserDataAttribute)this.userDataMap.get(csuserid)).setExtensionIdList(idList);
                            UserExtnEntry extnentry = new UserExtnEntry();
                            extnentry.setCsUserId(csuserid);
                            extnentry.setMobileNumber((String)entry.getValue());
                            this.offPbxExtnMap.put((Long)entry.getKey(), extnentry);
                        }
                        break;
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                }
                default: {
                    log.fine((Object)"shouldl not hit this...");
                }
            }
        }
        catch (DMException dmex) {
            log.error((Object)("updateOffPbxStationMapId error while attempting operation " + oper + "for id = " + id + ". ErrorMsg = " + dmex.getMessage()));
        }
        log.fine((Object)" exiting from updateOffPbxStationMapId");
    }

    private void updateCSAddressMapId(Long id, DAOReplicationEvent.OperationType oper) {
        log.fine((Object)("entering updateCSAddressMapId() for Id-" + id + ", operation-" + oper));
        Map map = null;
        Map.Entry entry = null;
        try {
            if (!oper.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
                map = (Map)this.dataSource.executeQuery(getMobileNumbersByCSAddrsId, new Object[]{id}, (Object)this.getMobileNumberByAddressResultMapper());
                if (map == null || map.isEmpty()) {
                    log.fine((Object)"updateCSAddressMapId() deleted id not relevant, hence do nothing");
                    return;
                }
                entry = (Map.Entry)map.entrySet().toArray()[0];
            }
            switch (oper) {
                case DELETE: {
                    this.doDelete(id, entry);
                    break;
                }
                case UPDATE: {
                    if (entry == null) {
                        return;
                    }
                    this.doUpdate(id, entry);
                    break;
                }
                case INSERT: {
                    if (entry == null) {
                        return;
                    }
                    this.doInsert(id, entry);
                    break;
                }
            }
        }
        catch (DMException dmEx) {
            log.error((Object)dmEx.getMessage());
        }
        log.fine((Object)"exiting updateCSAddressMapId()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDelete(long id, Map.Entry<Long, UserExtnEntry> entry) {
        try {
            this.lock.acquireWriteLock();
            if (this.csAddrsMap.containsKey(id)) {
                UserExtnEntry deletedEntry = this.csAddrsMap.get(id);
                this.csAddrsMap.remove(id);
                Long csuserid = deletedEntry.getCsUserId();
                if (this.userDataMap.containsKey(csuserid)) {
                    List<Long> idList = ((UserDataAttribute)this.userDataMap.get(csuserid)).getAddressIdList();
                    idList.remove(id);
                    ((UserDataAttribute)this.userDataMap.get(csuserid)).setAddressIdList(idList);
                    log.fine((Object)("updateCSAddressMapId() , Delete from cache successful for entry " + id + " , " + deletedEntry));
                } else {
                    log.fine((Object)("no user association found for entry " + entry));
                }
                log.fine((Object)("entry removed from the csAddrsMap. " + entry));
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(long id, Map.Entry<Long, UserExtnEntry> entry) {
        try {
            this.lock.acquireWriteLock();
            UserExtnEntry old = this.csAddrsMap.get(entry.getKey());
            UserExtnEntry newEntry = entry.getValue();
            if (!old.getMobileNumber().equalsIgnoreCase(newEntry.getMobileNumber()) || !old.getOtherMobile().equalsIgnoreCase(newEntry.getOtherMobile())) {
                old.setMobileNumber(entry.getValue().getMobileNumber());
                old.setOtherMobile(entry.getValue().getOtherMobile());
                this.csAddrsMap.put(id, old);
            }
            log.fine((Object)"updateCSAddressMapId() , update is successful");
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInsert(long id, Map.Entry<Long, UserExtnEntry> entry) throws DMException {
        try {
            this.lock.acquireWriteLock();
            if (this.csAddrsMap.containsKey(entry.getKey())) {
                log.fine((Object)("the entry is already added to cache, so returning. " + entry));
                return;
            }
            Long csPersonId = (Long)this.dataSource.executeQuery(getUsrIdByCSAddrsId, new Object[]{id}, (Object)this.getUserIdMapper());
            if (csPersonId != null && this.userDataMap.containsKey(csPersonId)) {
                List<Long> idList = ((UserDataAttribute)this.userDataMap.get(csPersonId)).getAddressIdList();
                idList.add(entry.getKey());
                ((UserDataAttribute)this.userDataMap.get(csPersonId)).setAddressIdList(idList);
                UserExtnEntry extnentry = new UserExtnEntry();
                extnentry.setCsUserId(csPersonId);
                extnentry.setMobileNumber(entry.getValue().getMobileNumber());
                extnentry.setOtherMobile(entry.getValue().getOtherMobile());
                log.fine((Object)("updateCSAddressMapId()  adding entry to userMobileMap. key " + entry.getKey() + ", Value = " + extnentry.toString()));
                this.csAddrsMap.put(entry.getKey(), extnentry);
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    private void addExtensionMappingForProfile(Long id, Long csuserid) {
        log.fine((Object)("entering addExtensionMappingForProfile() with id " + id + " & userId " + csuserid));
        try {
            Map map = (Map)this.dataSource.executeQuery(getUserMobileNumbersByID, new Object[]{csuserid}, (Object)this.getExtensionListMapper());
            if (map != null && !map.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    UserExtnEntry extnEntry = new UserExtnEntry();
                    extnEntry.setCsUserId(csuserid);
                    extnEntry.setMobileNumber((String)entry.getValue());
                    this.offPbxExtnMap.put((Long)entry.getKey(), extnEntry);
                    List<Long> idList = ((UserDataAttribute)this.userDataMap.get(csuserid)).getExtensionIdList();
                    idList.add((Long)entry.getKey());
                    ((UserDataAttribute)this.userDataMap.get(csuserid)).setExtensionIdList(idList);
                }
            }
        }
        catch (DMException dmex) {
            log.error((Object)("Error while trying to fetch the extension mapping for user id" + id));
            log.error((Object)dmex.getMessage());
        }
        log.fine((Object)"exiting addExtensionMappingForProfile()");
    }

    private void addMobileFromCSAddressForUser(Long userId) {
        log.fine((Object)("entering addMobileFromCSAddressForUser() with userId=" + userId));
        try {
            Map map = (Map)this.dataSource.executeQuery(getMobileNumbersByUsrId, new Object[]{userId}, (Object)this.getMobileNumberByAddressResultMapper());
            if (map != null && !map.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    ((UserExtnEntry)entry.getValue()).setCsUserId(userId);
                    this.csAddrsMap.put((Long)entry.getKey(), (UserExtnEntry)entry.getValue());
                    List<Long> idList = ((UserDataAttribute)this.userDataMap.get(userId)).getAddressIdList();
                    idList.add((Long)entry.getKey());
                    ((UserDataAttribute)this.userDataMap.get(userId)).setAddressIdList(idList);
                }
            }
        }
        catch (DMException dmEx) {
            log.error((Object)dmEx);
        }
        log.fine((Object)"exiting addMobileFromCSAddressForUser()");
    }

    @SMConsole(description="Get Login Name by Participant handle and its domain")
    public String getLoginNameByParticipant(String participantHandle, String participantDomain) {
        if (participantHandle == null) {
            return null;
        }
        String completeHandle = participantHandle + "@" + participantDomain;
        String loginName = null;
        try {
            loginName = this.getLoginNameByPhoneNumber(completeHandle);
        }
        catch (Exception e) {
            log.error((Object)("Multiple users found with participant : " + participantHandle));
            return null;
        }
        return loginName;
    }

    @SMConsole(description="Get User Profiles By User ID")
    public Set<UserCommProfile> getUserProfilesByUserID(Long userId) {
        if (userId == null) {
            return null;
        }
        if (this.userDataMap.containsKey(userId)) {
            return ((UserDataAttribute)this.userDataMap.get(userId)).getCommProfiles();
        }
        return null;
    }

    protected ResultSetMapper getUserHandleAttributeMapperByID() {
        return new RSMgetUserHandleAttributeMapperByID();
    }

    private ResultSetMapper getMobileNumberByAddressResultMapper() {
        return new RSMgetMobileNumberByAddressResultMapper();
    }

    protected ResultSetMapper getUserDataAttributeMapper() {
        return new RSMgetUserDataAttributeMapper();
    }

    protected ResultSetMapper getUserHandleAttributeMapper() {
        return new ResultSetMapper(){

            public Map<Long, Set<Long>> mapResults(ResultSet results) throws SQLException, DMException {
                HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>();
                while (results.next()) {
                    Long handleID = results.getLong("id");
                    String handle = results.getString("handle");
                    Long profileID = results.getLong("cscommprofilesetid");
                    Long domainID = results.getLong("csdomainid");
                    UserHandleAttribute uha = new UserHandleAttribute(handleID, handle, results.getLong("cshandletypeid"), results.getLong("cshandlesubtypeid"), profileID, domainID);
                    if (handle.contains("@")) {
                        UserDataDAO.this.handlesByHandleID.put(handle, handleID);
                        UserDataDAO.this.userHandleMap.put(handleID, uha);
                    } else if (domainID != null && domainID != 0L) {
                        String tmpH = handle + "@" + (String)UserDataDAO.this.domains.get(domainID);
                        UserDataDAO.this.handlesByHandleID.put(tmpH, handleID);
                        UserDataDAO.this.userHandleMap.put(handleID, uha);
                    }
                    if (map.containsKey(profileID)) {
                        ((Set)map.get(profileID)).add(handleID);
                        continue;
                    }
                    HashSet<Long> s = new HashSet<Long>();
                    s.add(handleID);
                    map.put(profileID, s);
                }
                if (!map.isEmpty()) {
                    return map;
                }
                return null;
            }
        };
    }

    public static class RSMgetMobileNumberByAddressResultMapper
    implements ResultSetMapper {
        public Map<Long, UserExtnEntry> mapResults(ResultSet results) throws SQLException, DMException {
            HashMap<Long, UserExtnEntry> entryMap = new HashMap<Long, UserExtnEntry>();
            while (results.next()) {
                UserExtnEntry entry = new UserExtnEntry();
                Long addressId = results.getLong("id");
                if (results.getString("mobilephone") != null) {
                    entry.setMobileNumber(results.getString("mobilephone"));
                }
                if (results.getString("othermobilephone") != null) {
                    entry.setOtherMobile(results.getString("othermobilephone"));
                }
                if (entry.getMobileNumber() == null && entry.getOtherMobile() == null) continue;
                entryMap.put(addressId, entry);
            }
            return entryMap;
        }
    }

    public static class RSMgetUserDataAttributeMapper
    implements ResultSetMapper {
        public UserDataAttribute mapResults(ResultSet results) throws SQLException, DMException {
            UserDataAttribute obj = null;
            HashSet<UserCommProfile> set = new HashSet<UserCommProfile>();
            while (results.next()) {
                UserCommProfile profileObj = new UserCommProfile(results.getLong("profileid"), results.getString("commprofilesetname"), results.getLong("csuserid"));
                if (results.isFirst()) {
                    obj = new UserDataAttribute(results.getLong("ID"), results.getString("loginName"), results.getString("userName"), results.getLong("DEFAULTCOMMPROFILESETID"), results.getLong("TENANTID"), results.getString("DISPLAYNAMEASCII"), results.getString("SOURCE"), results.getString("DN"));
                }
                set.add(profileObj);
            }
            if (obj != null) {
                obj.setCommProfiles(set);
                return obj;
            }
            return null;
        }
    }

    public static class RSMgetUserHandleAttributeMapperByID
    implements ResultSetMapper {
        public UserHandleAttribute mapResults(ResultSet results) throws SQLException, DMException {
            UserHandleAttribute tmp = null;
            while (results.next()) {
                Long id = results.getLong("id");
                Long profileID = results.getLong("cscommprofilesetid");
                Long domainID = results.getLong("csdomainid");
                tmp = new UserHandleAttribute(id, results.getString("handle"), results.getLong("cshandletypeid"), results.getLong("cshandlesubtypeid"), profileID, domainID);
            }
            return tmp;
        }
    }
}

