/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.MessagingServer;
import com.avaya.zephyr.platform.dal.api.objectapi.MessagingServerConnection;
import com.avaya.zephyr.platform.dal.api.objectapi.MessagingSubscriber;
import com.avaya.zephyr.platform.dao.common.exception.MultipleEntryException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class AuraMessagingDAO
extends DataAccessObject {
    private static final Logger LOGGER = Logger.getLogger(AuraMessagingDAO.class);
    protected static final String IPT_AURAMESSAGING_SUB = "ipt_auramessaging_sub";
    protected static final String IPT_MM = "ipt_mm";
    protected static final String IPT_MMCONNECTION = "ipt_mmconnection";
    protected static final String SUB_ID = "id";
    protected static final String MAILBOXNUMBER = "mailboxnumber";
    protected static final String MAILID = "mail";
    protected static final String SERVERID = "mm_id";
    protected static final String MM_ID = "id";
    protected static final String MM_NAME = "mmname";
    protected static final String MM_TYPE = "mmtype";
    protected static final String IP = "ip";
    protected static final String CONN_ID = "id";
    protected static final String DELIMETER = "@";
    private static final Long AAM_TYPE = 3L;
    protected static final String GET_AAM_SUBSCRIBERS = "SELECT id, mailboxnumber, mail, mm_id FROM ipt_auramessaging_sub";
    protected static final String GET_AAM_SUBSCRIBER_BYID = "SELECT id, mailboxnumber, mail, mm_id FROM ipt_auramessaging_sub where id = ?";
    protected static final String GET_MESSAGING_SERVERS = "SELECT mm.id, mmname, mmtype, ip FROM ipt_mm mm, ipt_mmconnection where mm.id=mm_id";
    protected static final String GET_MESSAGING_SERVER_BYID = "SELECT mm.id, mmname, mmtype, ip FROM ipt_mm mm, ipt_mmconnection where mm.id=mm_id AND mm.id = ?";
    protected static final String GET_MESSAGING_SERVER_CONNECTION_BYID = "SELECT id, ip, mm_id from ipt_mmconnection WHERE id = ?";
    private Map<Long, Object> mailBoxtoSubscriberMap;
    private Map<Long, Long> subscriberMap;
    private static Map<Long, Long> tmpSubscriberMap;
    private Map<Long, MessagingServer> serverMap;
    private static final List<DMListener> LISTENERS;

    public final List<String> getDependentTables() {
        return Arrays.asList(IPT_AURAMESSAGING_SUB, IPT_MM, IPT_MMCONNECTION);
    }

    public final void registerListener(DMListener listener) {
        LISTENERS.add(listener);
    }

    public final void removeListener(DMListener listener) {
        LISTENERS.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init() {
        Map tmpServerMap;
        Map tmpMailBoxtoSubscriberMap;
        SubscriberMapper subscriberMapper = new SubscriberMapper();
        ServerMapper serverMapper = new ServerMapper();
        try {
            tmpMailBoxtoSubscriberMap = (Map)this.dataSource.executeQuery(GET_AAM_SUBSCRIBERS, new Object[0], (Object)subscriberMapper);
            tmpServerMap = (Map)this.dataSource.executeQuery(GET_MESSAGING_SERVERS, new Object[0], (Object)serverMapper);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            LOGGER.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            return;
        }
        this.lock.acquireWriteLock();
        try {
            this.mailBoxtoSubscriberMap = tmpMailBoxtoSubscriberMap;
            this.subscriberMap = tmpSubscriberMap;
            this.serverMap = tmpServerMap;
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.setStatus(DataMgr.Status.OKAY);
        LOGGER.info((Object)"calling update from init");
        Object object = null;
        this.updateListeners(object, object);
    }

    protected final ResultSetMapper subscriberEntriesMapperById() {
        return new ResultSetMapper(){

            public MessagingSubscriber mapResults(ResultSet results) throws SQLException, DMException {
                MessagingSubscriber sub = null;
                while (results.next()) {
                    sub = new MessagingSubscriber(results.getLong("id"), results.getLong(AuraMessagingDAO.MAILBOXNUMBER), results.getString(AuraMessagingDAO.MAILID), results.getLong(AuraMessagingDAO.SERVERID));
                }
                return sub;
            }
        };
    }

    protected final ResultSetMapper serverEntriesMapperById() {
        return new ResultSetMapper(){

            public MessagingServer mapResults(ResultSet results) throws SQLException, DMException {
                MessagingServer server = null;
                while (results.next()) {
                    server = new MessagingServer(results.getLong("id"), results.getString(AuraMessagingDAO.MM_NAME), results.getLong(AuraMessagingDAO.MM_TYPE), results.getString(AuraMessagingDAO.IP));
                }
                return server;
            }
        };
    }

    protected final ResultSetMapper connectionEntriesMapperById() {
        return new ResultSetMapper(){

            public MessagingServerConnection mapResults(ResultSet results) throws SQLException, DMException {
                MessagingServerConnection serverConn = null;
                while (results.next()) {
                    serverConn = new MessagingServerConnection(results.getLong("id"), results.getString(AuraMessagingDAO.IP), results.getLong(AuraMessagingDAO.SERVERID));
                }
                return serverConn;
            }
        };
    }

    protected final MessagingSubscriber getMessagingSubscriberById(Long id) throws DMException {
        MessagingSubscriber newSubEntry = (MessagingSubscriber)this.dataSource.executeQuery(GET_AAM_SUBSCRIBER_BYID, new Object[]{id}, (Object)this.subscriberEntriesMapperById());
        return newSubEntry;
    }

    protected final MessagingServer getMessagingServerById(Long id) throws DMException {
        MessagingServer newServer = (MessagingServer)this.dataSource.executeQuery(GET_MESSAGING_SERVER_BYID, new Object[]{id}, (Object)this.serverEntriesMapperById());
        return newServer;
    }

    protected final MessagingServerConnection getMessagingServerConnectionById(Long id) throws DMException {
        MessagingServerConnection newServerConn = (MessagingServerConnection)this.dataSource.executeQuery(GET_MESSAGING_SERVER_CONNECTION_BYID, new Object[]{id}, (Object)this.connectionEntriesMapperById());
        return newServerConn;
    }

    protected final Object getMainCollection() {
        return null;
    }

    public final void updateDAO(DAOTableEvent tableEvent) {
        Long id = tableEvent.getKey();
        String tableName = tableEvent.getTableName();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        if (tableName.equalsIgnoreCase(IPT_AURAMESSAGING_SUB)) {
            if (operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
                this.addSubscriber(id);
            } else if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
                this.deleteSubscriber(id);
            } else if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
                this.deleteSubscriber(id);
                this.addSubscriber(id);
            }
        } else if (tableName.equalsIgnoreCase(IPT_MM)) {
            this.hanleMMTableUpdates(id, operation);
        } else if (tableName.endsWith(IPT_MMCONNECTION)) {
            this.handleMMConnTableUpdates(id, operation);
        }
    }

    public final Map<Long, Object> getMailBoxtoSubscriberMap() {
        return this.mailBoxtoSubscriberMap;
    }

    public final Map<Long, Long> getSubscriberMap() {
        return this.subscriberMap;
    }

    protected static final void setTmpSubscriberMap(Map<Long, Long> tmpSubscrbrMap) {
        tmpSubscriberMap = tmpSubscrbrMap;
    }

    public final Map<Long, Long> getTmpSubscriberMap() {
        return tmpSubscriberMap;
    }

    public final Map<Long, MessagingServer> getServerMap() {
        return this.serverMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addSubscriber(long id) {
        try {
            MessagingSubscriber newSubEntry = this.getMessagingSubscriberById(id);
            Long mBoxId = newSubEntry.getMailBoxNumber();
            this.lock.acquireWriteLock();
            try {
                Object entry = this.mailBoxtoSubscriberMap.get(mBoxId);
                if (entry == null) {
                    this.mailBoxtoSubscriberMap.put(mBoxId, newSubEntry);
                } else if (entry instanceof MessagingSubscriber) {
                    ArrayList<MessagingSubscriber> subList = new ArrayList<MessagingSubscriber>();
                    subList.add((MessagingSubscriber)entry);
                    subList.add(new MessagingSubscriber(id, mBoxId, newSubEntry.getMailId(), newSubEntry.getServerId()));
                    this.mailBoxtoSubscriberMap.put(mBoxId, subList);
                } else if (entry instanceof List) {
                    ((List)entry).add(new MessagingSubscriber(id, mBoxId, newSubEntry.getMailId(), newSubEntry.getServerId()));
                }
                this.subscriberMap.put(id, newSubEntry.getMailBoxNumber());
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        catch (DMException e) {
            LOGGER.error((Object)("Error while updating cache for change in table ipt_auramessaging_sub For id=" + id + " Exception:" + e.getMessage()));
            this.reinit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void deleteSubscriber(long id) {
        block9: {
            this.lock.acquireWriteLock();
            try {
                Long mboxId = this.subscriberMap.get(id);
                if (mboxId != null) {
                    Object entry = this.mailBoxtoSubscriberMap.get(mboxId);
                    if (entry instanceof MessagingSubscriber) {
                        this.mailBoxtoSubscriberMap.remove(mboxId);
                    } else if (entry instanceof List) {
                        MessagingSubscriber subscriber;
                        List list = (List)entry;
                        int index = 0;
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext() && (subscriber = (MessagingSubscriber)iterator.next()).getId() != id) {
                            ++index;
                        }
                        list.remove(index);
                        if (list.size() == 1) {
                            this.mailBoxtoSubscriberMap.put(mboxId, list.get(0));
                        }
                    }
                    this.subscriberMap.remove(id);
                    break block9;
                }
                LOGGER.error((Object)"Cache seems to be inconsistent with the database. Reinitializing the DAO");
                this.reinit();
                return;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    protected final void updateListeners(Object oldObj, Object newObj) {
        for (DMListener listener : LISTENERS) {
            try {
                listener.objectChanged(oldObj, newObj);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Exception on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                LOGGER.error((Object)"Exception is: ", (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                LOGGER.error((Object)("updateListeners NoClassDefFoundError on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                LOGGER.error((Object)"updateListeners Error is: ", (Throwable)e);
                LOGGER.error((Object)("updateListeners Unregistering the listener " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                this.removeListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void hanleMMTableUpdates(Long id, DAOReplicationEvent.OperationType operation) {
        MessagingServer oldServer = null;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.INSERT) || operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
            try {
                MessagingServer newServer = this.getMessagingServerById(id);
                if (newServer.getServerType().equals(AAM_TYPE)) {
                    this.lock.acquireWriteLock();
                    try {
                        if (this.serverMap.containsKey(id)) {
                            oldServer = this.serverMap.get(id);
                        }
                        this.serverMap.put(id, newServer);
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                    this.updateListeners(oldServer, newServer);
                    return;
                }
                if (!this.serverMap.containsKey(id)) return;
                try {
                    this.lock.acquireWriteLock();
                    oldServer = this.serverMap.remove(id);
                }
                finally {
                    this.lock.releaseWriteLock();
                }
                this.updateListeners(oldServer, null);
                return;
            }
            catch (DMException e) {
                LOGGER.error((Object)("Exception on fetching data from table ipt_mm for id: " + id));
                this.reinit();
                return;
            }
        }
        if (!operation.equals((Object)DAOReplicationEvent.OperationType.DELETE) || !this.serverMap.containsKey(id)) return;
        this.lock.acquireWriteLock();
        try {
            oldServer = this.serverMap.get(id);
            this.serverMap.remove(id);
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.updateListeners(oldServer, null);
    }

    final void handleMMConnTableUpdates(Long id, DAOReplicationEvent.OperationType operation) {
        MessagingServer oldServer = null;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
            try {
                MessagingServerConnection updatedConn = this.getMessagingServerConnectionById(id);
                Long mmId = updatedConn.getMmId();
                if (this.serverMap.containsKey(mmId) && !updatedConn.getServerIP().equalsIgnoreCase(this.serverMap.get(mmId).getServerIP())) {
                    oldServer = this.serverMap.get(mmId);
                    this.serverMap.get(mmId).setServerIP(updatedConn.getServerIP());
                    this.updateListeners(oldServer, this.serverMap.get(mmId));
                }
            }
            catch (DMException e) {
                LOGGER.error((Object)("Error while updating cache for change in table ipt_mmconnection For id=" + id + " Exception:" + e.getMessage()));
                this.reinit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SMConsole(description="Returns the Messaging server ID for the mailBox")
    public final Long getAuraMessagingServerId(Long mailBoxNumber, String domain) throws MultipleEntryException {
        Object subscribers;
        this.lock.acquireReadLock();
        try {
            subscribers = this.mailBoxtoSubscriberMap.get(mailBoxNumber);
        }
        finally {
            this.lock.releaseReadLock();
        }
        if (subscribers instanceof List) {
            if (domain == null || domain.isEmpty()) throw new MultipleEntryException("Multiple mailbox entry found.");
            for (MessagingSubscriber sub : (List)subscribers) {
                String mailIdDomain = sub.getMailId().split(DELIMETER)[1];
                if (!mailIdDomain.equalsIgnoreCase(domain)) continue;
                return sub.getServerId();
            }
            return null;
        } else {
            String mailIdDomain;
            if (!(subscribers instanceof MessagingSubscriber)) return null;
            if (domain == null || domain.isEmpty() || (mailIdDomain = ((MessagingSubscriber)subscribers).getMailId().split(DELIMETER)[1]).equalsIgnoreCase(domain)) return ((MessagingSubscriber)subscribers).getServerId();
            return null;
        }
    }

    @SMConsole(description="Returns all the Messaging servers")
    public final Map<Long, MessagingServer> getAuraMessagingServers() {
        return this.serverMap;
    }

    static {
        LISTENERS = new CopyOnWriteArrayList<DMListener>();
    }

    public static class ServerMapper
    implements ResultSetMapper {
        public final Map<Long, MessagingServer> mapResults(ResultSet results) throws SQLException, DMException {
            ConcurrentHashMap<Long, MessagingServer> map = new ConcurrentHashMap<Long, MessagingServer>();
            while (results.next()) {
                Long type = results.getLong(AuraMessagingDAO.MM_TYPE);
                if (!type.equals(AAM_TYPE)) continue;
                Long id = results.getLong("id");
                map.put(id, new MessagingServer(id, results.getString(AuraMessagingDAO.MM_NAME), type, results.getString(AuraMessagingDAO.IP)));
            }
            return map;
        }
    }

    public static class SubscriberMapper
    implements ResultSetMapper {
        public final Map<Long, Object> mapResults(ResultSet results) throws SQLException, DMException {
            ConcurrentHashMap<Long, Object> mBoxTosubscriberMap = new ConcurrentHashMap<Long, Object>();
            while (results.next()) {
                Long id = results.getLong("id");
                Long mailBoxId = results.getLong(AuraMessagingDAO.MAILBOXNUMBER);
                Object value = mBoxTosubscriberMap.get(mailBoxId);
                if (value == null) {
                    mBoxTosubscriberMap.put(mailBoxId, new MessagingSubscriber(id, mailBoxId, results.getString(AuraMessagingDAO.MAILID), results.getLong(AuraMessagingDAO.SERVERID)));
                } else if (value instanceof MessagingSubscriber) {
                    ArrayList<MessagingSubscriber> subList = new ArrayList<MessagingSubscriber>();
                    subList.add((MessagingSubscriber)value);
                    subList.add(new MessagingSubscriber(id, mailBoxId, results.getString(AuraMessagingDAO.MAILID), results.getLong(AuraMessagingDAO.SERVERID)));
                    mBoxTosubscriberMap.put(mailBoxId, subList);
                } else if (value instanceof List) {
                    ((List)value).add(new MessagingSubscriber(id, mailBoxId, results.getString(AuraMessagingDAO.MAILID), results.getLong(AuraMessagingDAO.SERVERID)));
                }
                if (tmpSubscriberMap == null) {
                    tmpSubscriberMap = new ConcurrentHashMap();
                }
                tmpSubscriberMap.put(id, mailBoxId);
            }
            return mBoxTosubscriberMap;
        }
    }
}

