/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.AusAsset;
import com.avaya.zephyr.platform.dao.AusInstanceDAO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AusAssetDAO
extends DataAccessObject {
    protected static final String SQL_ID_COLUMN = "id";
    protected static final String SQL_ASSETDEFAULTGATEWAY_COLUMN = "assetdefaultgateway";
    private static final Logger log = Logger.getLogger(AusAssetDAO.class);
    protected static final String ASSET_TABLE = "asset";
    protected static final String FIELDS = "id, assetdefaultgateway";
    protected static final String FIND_ALL_ASSET_QUERY = "SELECT id, assetdefaultgateway FROM asset";
    protected static final String FIND_ASSET_BY_ID_QUERY = "SELECT id, assetdefaultgateway FROM asset WHERE id= ? ";
    private final Map<Long, AusAsset> assetMap = new HashMap<Long, AusAsset>();

    public AusAssetDAO() {
        super(true);
    }

    @SMConsole(parameterNames={"ausAssetId"}, description="Get the Asset object for the given ID")
    public AusAsset getAusAsset(Long ausAssetId) {
        Map affectedAusAssets = new HashMap(0);
        Object[] params = new Object[]{ausAssetId};
        try {
            affectedAusAssets = (Map)this.dataSource.executeQuery(FIND_ASSET_BY_ID_QUERY, params, (Object)this.getResultSetMapper());
        }
        catch (DMException e) {
            log.error((Object)"Exception caught: e", (Throwable)e);
        }
        if (affectedAusAssets == null || affectedAusAssets.size() == 0) {
            return null;
        }
        if (affectedAusAssets.size() == 1) {
            return (AusAsset)affectedAusAssets.values().iterator().next();
        }
        throw new IllegalStateException("Database returned more than one value");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void updateDAO(DAOTableEvent tableEvent) {
        if (AusAssetDAO.log.isFinestEnabled()) {
            AusAssetDAO.log.finest((Object)("updateDAO(" + tableEvent + ")"));
        }
        tableName = tableEvent.getTableName();
        id = tableEvent.getKey();
        operationType = tableEvent.getOperation();
        oldObject = null;
        newObject = null;
        if ("asset".equals(tableName)) {
            try {
                this.lock.acquireWriteLock();
                switch (2.$SwitchMap$com$avaya$asm$datamgr$dao$replication$DAOReplicationEvent$OperationType[operationType.ordinal()]) {
                    case 1: {
                        oldObject = this.assetMap.remove(id);
                        ** break;
lbl15:
                        // 1 sources

                        break;
                    }
                    case 2: 
                    case 3: {
                        newObject = asset = this.getAusAsset(id);
                        oldObject = this.assetMap.put(asset.getId(), newObject);
                        ** break;
lbl20:
                        // 1 sources

                        break;
                    }
                    default: {
                        AusAssetDAO.log.warn((Object)("Unknown event: " + tableEvent));
                        break;
                    }
                }
            }
            finally {
                this.lock.releaseWriteLock();
            }
            if (oldObject != null || newObject != null) {
                this.updateListeners(oldObject, newObject);
            }
        }
    }

    public List<String> getDependentTables() {
        return Arrays.asList(ASSET_TABLE);
    }

    protected Object getMainCollection() {
        return new HashMap<Long, AusAsset>(this.assetMap);
    }

    public void init() {
        log.finest((Object)"enter> init()");
        Object[] params = new Object[]{};
        try {
            Map tmpMap = (Map)this.dataSource.executeQuery(FIND_ALL_ASSET_QUERY, params, (Object)this.getResultSetMapper());
            this.lock.acquireWriteLock();
            this.assetMap.clear();
            this.assetMap.putAll(tmpMap);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            log.error((Object)"Exception caught: e", (Throwable)e);
            this.setStatus(DataMgr.Status.FAIL);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @SMConsole(description="Get the Asset object for this EDP instance.")
    public AusAsset getMyAusAsset() {
        long localAssetId = this.getAusInstanceDAO().getMyAusInstance().getAssetId();
        return this.getAusAsset(localAssetId);
    }

    private ResultSetMapper getResultSetMapper() {
        return new ResultSetMapper(){

            public Map<Long, AusAsset> mapResults(ResultSet results) throws SQLException, DMException {
                ConcurrentHashMap<Long, AusAsset> tmpMap = new ConcurrentHashMap<Long, AusAsset>();
                while (results.next()) {
                    AusAsset asset = new AusAsset();
                    Long id = results.getLong(AusAssetDAO.SQL_ID_COLUMN);
                    asset.setId(id);
                    asset.setAssetDefaultGateway(results.getString(AusAssetDAO.SQL_ASSETDEFAULTGATEWAY_COLUMN));
                    tmpMap.put(id, asset);
                }
                return tmpMap;
            }
        };
    }

    protected AusInstanceDAO getAusInstanceDAO() {
        return (AusInstanceDAO)DMFactory.getInstance().getDataMgr(AusInstanceDAO.class);
    }
}

